---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-SegmentReplicationPressureService

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし。全ての主張にソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/index/SegmentReplicationPressureService.java`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ間隔30秒固定 | E-01 (L232) | ○ |
| C-02 | segrep.pressure.enabledデフォルトfalse | E-01 (L54-59) | ○ |
| C-03 | segrep.pressure.checkpoint.limitデフォルト30 | E-01 (L61-67) | ○ |
| C-04 | segrep.pressure.time.limitデフォルト5分 | E-01 (L70-75) | ○ |
| C-05 | segrep.replication.time.limitデフォルト0分（無効） | E-01 (L79-84) | ○ |
| C-06 | segrep.pressure.replica.stale.limitデフォルト0.5 | E-01 (L86-93) | ○ |
| C-07 | mustRescheduleはshouldScheduleAsyncFailTask依存 | E-01 (L241-243) | ○ |
| C-08 | shouldScheduleAsyncFailTaskはreplicationTimeLimitFailReplicaが0でないか判定 | E-01 (L317-319) | ○ |
| C-09 | 最もレプリケーション時間が長いシャードを選択 | E-01 (L262) | ○ |
| C-10 | remoteShardFailed()でレプリカ失敗 | E-01 (L276-298) | ○ |
| C-11 | GENERICスレッドプールで実行 | E-01 (L306-308) | ○ |
| C-12 | 遅延レプリカのフィルタ条件（checkpoint + time） | E-01 (L174-179) | ○ |
| C-13 | OpenSearchRejectedExecutionExceptionでバックプレッシャー | E-01 (L166-170) | ○ |
| C-14 | 設定変更時にupdateAsyncFailReplicaTaskでタスク再作成 | E-01 (L206-216) | ○ |
| C-15 | 1回の実行で1シャードIDのみ処理 | E-01 (L253-264) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] segrep.replication.time.limitのデフォルト0（無効）が意図通りか確認
- [ ] バックプレッシャー設定値がワークロードに適合するか確認
