---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-TaskCancellationMonitoringService

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  1. 特になし。全ての主張にソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/tasks/TaskCancellationMonitoringService.java`
- E-02: `server/src/main/java/org/opensearch/tasks/TaskCancellationMonitoringSettings.java`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 監視対象はSearchTaskとSearchShardTaskの2種類 | E-01 (L36) | ○ |
| C-02 | interval_millisデフォルト5000ms | E-02 (L23, L30-35) | ○ |
| C-03 | duration_millisデフォルト10000ms | E-02 (L24, L41-46) | ○ |
| C-04 | enabledデフォルトtrue | E-02 (L25, L51-56) | ○ |
| C-05 | ConcurrentHashMapでcancelledTaskTracker管理 | E-01 (L66) | ○ |
| C-06 | isEnabled && !isEmpty でスキップ条件 | E-01 (L73-75) | ○ |
| C-07 | Booleanフラグで二重カウント防止 | E-01 (L79-86) | ○ |
| C-08 | onTaskCancelledでputIfAbsent(id, false) | E-01 (L143) | ○ |
| C-09 | onTaskCompletedでremove | E-01 (L129) | ○ |
| C-10 | GENERICスレッドプールで実行 | E-01 (L99) | ○ |
| C-11 | DEBUGログで例外出力 | E-01 (L97) | ○ |
| C-12 | duration_millisとenabledがDynamic設定 | E-02 (L44, L54) | ○ |
| C-13 | getCancellationStartTimeNanos()で経過時間計算 | E-01 (L170-173) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] duration_millis（10秒）が長時間実行タスクの検出閾値として適切か確認
- [ ] interval_millis（5秒）の監視間隔が十分か確認
