---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：27-WorkloadGroupService

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **タスクキャンセルの具体的な処理内容**：WorkloadGroupTaskCancellationServiceの内部実装は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/wlm/WorkloadGroupService.java`
- E-02: `server/src/main/java/org/opensearch/wlm/WorkloadManagementSettings.java`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @opensearch.experimentalとして実験的機能 | E-01 (L46) | ○ |
| C-02 | wlm.workload_group.modeデフォルトmonitor_only | E-02 (L31, L78-84) | ○ |
| C-03 | enforcement_intervalデフォルト1000ms、最小1000ms | E-02 (L26, L60-66) | ○ |
| C-04 | duress_streakデフォルト3、最小3 | E-02 (L43-49) | ○ |
| C-05 | CPU拒否閾値デフォルト0.8 | E-02 (L24) | ○ |
| C-06 | CPU取消閾値デフォルト0.9 | E-02 (L25) | ○ |
| C-07 | メモリ拒否閾値デフォルト0.8 | E-02 (L22) | ○ |
| C-08 | メモリ取消閾値デフォルト0.9 | E-02 (L23) | ○ |
| C-09 | DISABLEDモードでdoRunスキップ | E-01 (L126-128) | ○ |
| C-10 | GENERICスレッドプールで実行 | E-01 (L144) | ○ |
| C-11 | ClusterStateListenerでワークロードグループの追加/削除検出 | E-01 (L158-188) | ○ |
| C-12 | SOFTモードはノード逼迫時のみ拒否 | E-01 (L274-276) | ○ |
| C-13 | OpenSearchRejectedExecutionExceptionでリクエスト拒否 | E-01 (L308) | ○ |
| C-14 | shouldSBPHandle()でSBPとの分担 | E-01 (L337-345) | ○ |
| C-15 | DEBUGログで例外出力 | E-01 (L142) | ○ |
| C-16 | cancelTasks内部のタスクキャンセル処理詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16：WorkloadGroupTaskCancellationService.cancelTasks()の具体的な実装（どのようにリソース使用量を評価しキャンセル対象を決定するか）は、当該クラスのソースコードを直接確認していない
  - 候補：WorkloadGroupTaskCancellationService.java

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - タスクキャンセルの具体的なロジックは委譲先クラスに依存しており、未確認

## 6) レビュアーチェックリスト（最小）
- [ ] WorkloadGroupTaskCancellationServiceのキャンセルロジック確認
- [ ] 拒否/取消閾値のデフォルト値が運用要件に適合するか確認
- [ ] WlmModeの各モード（disabled/monitor_only/enabled）の動作差異確認
