---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-SearchBackpressureService

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし。全ての主張にソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/search/backpressure/SearchBackpressureService.java`
- E-02: `server/src/main/java/org/opensearch/search/backpressure/settings/SearchBackpressureSettings.java`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | interval_millisデフォルト1000ms | E-02 (L23, L35-40) | ○ |
| C-02 | modeデフォルトmonitor_only | E-02 (L24, L46-52) | ○ |
| C-03 | cancellation_ratioデフォルト0.1 | E-02 (L26, L61-75) | ○ |
| C-04 | cancellation_rateデフォルト0.003 | E-02 (L27, L84-95) | ○ |
| C-05 | cancellation_burstデフォルト10.0 | E-02 (L28, L103-110) | ○ |
| C-06 | DISABLEDモードでスキップ | E-01 (L186-189) | ○ |
| C-07 | ノード逼迫判定でスキップ | E-01 (L191-193) | ○ |
| C-08 | CPU/ヒープ/経過時間の3トラッカー | E-01 (L71-78, L370-400) | ○ |
| C-09 | CPUトラッカーはCPU逼迫時のみ適用 | E-01 (L72-73) | ○ |
| C-10 | ヒープトラッカーはメモリ逼迫時のみ+isHeapTrackingSupported | E-01 (L74-75) | ○ |
| C-11 | 経過時間トラッカーは常時適用 | E-01 (L76-77) | ○ |
| C-12 | mergeTaskCancellationsで重複除去 | E-01 (L227, L311-320) | ○ |
| C-13 | rateLimiterとratioLimiterの二重制限 | E-01 (L248-252) | ○ |
| C-14 | monitor_onlyではログのみ、enforcedでキャンセル実行 | E-01 (L232-240) | ○ |
| C-15 | GENERICスレッドプールで実行 | E-01 (L439) | ○ |
| C-16 | shouldSBPHandle()でワークロード管理との分担 | E-01 (L355) | ○ |
| C-17 | タスク完了時にトラッカー更新 | E-01 (L419-428) | ○ |
| C-18 | Deprecated設定がSearchShardTaskSettingsに移行 | E-02 (L58-60, L81-83, L100-102) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] monitor_onlyモードからenforcedモードへの切り替え影響確認
- [ ] cancellation_ratio/rate/burstの設定値が運用要件に適合するか確認
- [ ] ワークロード管理（WLM）との連携動作確認
