---
generated_at: 2026-02-03 10:02:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：3-AsyncReplicationTask

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **セグメントレプリケーションの詳細な動作説明**：replicatorの具体的な実装が外部注入のため詳細不明

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/index/IndexService.java` (AsyncReplicationTask内部クラス, L1561-L1586)
- E-02: `server/src/main/java/org/opensearch/index/IndexService.java` (maybeSyncSegments, L1588-L1600)
- E-03: `server/src/main/java/org/opensearch/index/IndexService.java` (BaseAsyncTask, L1483-L1503)
- E-04: `server/src/main/java/org/opensearch/index/IndexService.java` (replicatorフィールド, L206)
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (No.3の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リフレッシュ間隔と同じ間隔で実行 | E-01 (super: indexService.getRefreshInterval()) | ○ |
| C-02 | GENERICスレッドプールで実行 | E-01 (ThreadPool.Names.GENERIC) | ○ |
| C-03 | isSegRepEnabledOrRemoteNode条件 | E-01 (mustReschedule, L1584) | ○ |
| C-04 | search-onlyかつactiveなシャードが対象 | E-02 (shard.routingEntry().isSearchOnly() && active()) | ○ |
| C-05 | replicator.accept(shard)を呼び出し | E-02 (replicator.accept(shard)) | ○ |
| C-06 | IndexShardClosedException/AlreadyClosedExceptionをキャッチ | E-02 (catch句) | ○ |
| C-07 | リフレッシュ間隔が0ms以上の場合のみ実行 | E-02 (getRefreshInterval().millis() > 0) | ○ |
| C-08 | forceパラメータでの強制実行 | E-02 (maybeSyncSegments(boolean force)) | ○ |
| C-09 | toString()は"replication"を返す | E-01 (L1579) | ○ |
| C-10 | セグレプ無効時にタスク自動停止 | E-01 (mustReschedule: isSegRepEnabledOrRemoteNode) | ○ |
| C-11 | コンストラクタでインデックス初期化時に生成 | E-04 | ○ |
| C-12 | Consumer<IndexShard>型のreplicatorで処理 | E-04 | ○ |
| C-13 | レプリカへのセグメントコピーの詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: replicatorの具体的な実装はIndexService外部から注入される（Consumer<IndexShard>型）。実際のセグメントレプリケーション処理の詳細はreplicatorの実装に依存する。
  - 候補：replicatorの注入元コード / SegmentReplication関連クラス

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - replicatorの実装詳細が外部注入のため、レプリケーション動作の具体的な記述は推定に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] search-only判定条件がmaybeSyncSegments()の実装と一致しているか
- [ ] isSegRepEnabledOrRemoteNode()の条件がmustReschedule()と一致しているか
- [ ] replicatorの実装がセグメントレプリケーションの説明と矛盾しないか
