---
generated_at: 2026-02-03 10:03:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：4-AsyncPublishReferencedSegmentsTask

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **publishReferencedSegmentsIntervalのデフォルト値**：IndexSettingsでの定義値を未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/index/IndexService.java` (AsyncPublishReferencedSegmentsTask, L1607-L1640)
- E-02: `server/src/main/java/org/opensearch/index/IndexService.java` (maybePublishReferencedSegments, L1642-L1654)
- E-03: `server/src/main/java/org/opensearch/index/IndexService.java` (BaseAsyncTask, L1483-L1503)
- E-04: `server/src/main/java/org/opensearch/index/IndexSettings.java` (getPublishReferencedSegmentsInterval, L1728)
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (No.4の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GENERICスレッドプールで実行 | E-01 (ThreadPool.Names.GENERIC) | ○ |
| C-02 | isSegRepEnabledOrRemoteNode条件でmustReschedule | E-01 (L1632) | ○ |
| C-03 | shouldRunでisSegRepLocalEnabled/isRemoteStoreEnabledを確認 | E-01 (L1637) | ○ |
| C-04 | isMergedSegmentReplicationWarmerEnabledを確認 | E-01 (L1638) | ○ |
| C-05 | isPrimaryMode()かつactiveなシャードが対象 | E-02 (shard.isPrimaryMode() && shard.routingEntry().active()) | ○ |
| C-06 | shard.publishReferencedSegments()を呼び出し | E-02 (L1648) | ○ |
| C-07 | IOExceptionで警告ログ出力 | E-02 (catch IOException, logger.warn) | ○ |
| C-08 | toString()は"publish_primary_referenced_segments"を返す | E-01 (L1628) | ○ |
| C-09 | レプリカが不要なマージ中セグメントをクリーンアップ | E-02 (コメント L1646-L1647) | ○ |
| C-10 | shouldRunメソッドはテスト用に可視性設定 | E-01 (L1635: "visible for tests") | ○ |
| C-11 | getPublishReferencedSegmentsIntervalで間隔取得 | E-01, E-04 | ○ |
| C-12 | セグレプ無効時にタスク自動停止 | E-01 (mustReschedule) | ○ |
| C-13 | AsyncReplicationTaskとの連携 | E-05, E-01 | ○ |
| C-14 | publishReferencedSegmentsIntervalのデフォルト値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: INDEX_PUBLISH_REFERENCED_SEGMENTS_INTERVAL_SETTINGのデフォルト値はIndexSettings.javaで定義されているが、本調査では具体的なデフォルト値を確認していない。
  - 候補：`IndexSettings.java`のINDEX_PUBLISH_REFERENCED_SEGMENTS_INTERVAL_SETTING定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接根拠が取得できる主張がほとんど

## 6) レビュアーチェックリスト（最小）
- [ ] shouldRun()の条件がソースコードと一致しているか
- [ ] プライマリシャード判定条件がmaybePublishReferencedSegments()と一致しているか
- [ ] publishReferencedSegmentsIntervalのデフォルト値を確認
