---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：6-AsyncGlobalCheckpointTask

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **グローバルチェックポイント同期の詳細な内部動作**：maybeSyncGlobalCheckpointの完全な実装詳細を未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/index/IndexService.java` (AsyncGlobalCheckpointTask, L1709-L1730)
- E-02: `server/src/main/java/org/opensearch/index/IndexService.java` (maybeSyncGlobalCheckpoints, L1428-L1429)
- E-03: `server/src/main/java/org/opensearch/index/IndexService.java` (sync, L1436-L1460)
- E-04: `server/src/main/java/org/opensearch/index/IndexService.java` (GLOBAL_CHECKPOINT_SYNC_INTERVAL_SETTING, L1689-L1695)
- E-05: `server/src/main/java/org/opensearch/index/IndexService.java` (コンストラクタ, L342-L344)
- E-06: `server/src/main/java/org/opensearch/index/seqno/GlobalCheckpointSyncAction.java`
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (No.6の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト間隔は30秒 | E-04 (new TimeValue(30, TimeUnit.SECONDS)) | ○ |
| C-02 | GENERICスレッドプールで実行 | E-01 (ThreadPool.Names.GENERIC) | ○ |
| C-03 | maybeSyncGlobalCheckpoint("background")を呼び出し | E-02 | ○ |
| C-04 | activeかつprimaryかつSTARTEDのシャードが対象 | E-03 (L1438, L1447) | ○ |
| C-05 | インジェスションソースでは無効化 | E-05 (useIngestionSource条件) | ○ |
| C-06 | 正式に登録されたSettingではない | E-04 (コメント "intentionally not registered") | ○ |
| C-07 | mustRescheduleで標準条件チェック | E-01 (BaseAsyncTask継承) | ○ |
| C-08 | toString()は"global_checkpoint_sync"を返す | E-01 (L1728) | ○ |
| C-09 | トランスログトリムとの関連 | E-07 | ○ |
| C-10 | GlobalCheckpointSyncActionが実際の同期を実装 | E-06 | ○ |
| C-11 | sync()ヘルパーメソッドでシャード状態を確認 | E-03 | ○ |
| C-12 | CLOSED/CREATED/RECOVERING状態はスキップ | E-03 (switch文) | ○ |
| C-13 | POST_RECOVERY状態はassert false | E-03 (L1445) | ○ |
| C-14 | グローバルチェックポイントの同期によりトランスログのトリム範囲が決定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: グローバルチェックポイントとトランスログトリムの直接的な関係は、GlobalCheckpointSyncActionやReplicationTracker内の実装に依存する。IndexService内のソースコードには直接的な記述はない。
  - 候補：`GlobalCheckpointSyncAction.java`の詳細実装 / OpenSearch公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接根拠が取得できる主張がほとんど

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルト30秒がGLOBAL_CHECKPOINT_SYNC_INTERVAL_SETTINGと一致しているか
- [ ] sync()ヘルパーメソッドのシャード状態条件が正確か
- [ ] インジェスションソースの無効化条件が正確か
