---
generated_at: 2026-02-03 10:07:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：8-AsyncShardRefreshTask

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **AsyncRefreshTaskとの排他関係の詳細**：shardLevelRefreshEnabledフラグの切り替えロジック全体を未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/index/shard/IndexShard.java` (AsyncShardRefreshTask, L5848-L5880)
- E-02: `server/src/main/java/org/opensearch/index/shard/IndexShard.java` (startRefreshTask/stopRefreshTask, L5882-L5895)
- E-03: `server/src/main/java/org/opensearch/index/shard/IndexShard.java` (refreshTaskフィールド, L395)
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (No.8の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | REFRESHスレッドプールで実行 | E-01 (ThreadPool.Names.REFRESH) | ○ |
| C-02 | @ExperimentalApiアノテーション付与 | E-01 (L5847) | ○ |
| C-03 | シャードがCLOSED以外で再スケジュール | E-01 (mustReschedule, L5862) | ○ |
| C-04 | IndexMetadata.State.OPEN条件 | E-01 (L5863) | ○ |
| C-05 | indexShard.scheduledRefresh()を呼び出し | E-01 (L5868) | ○ |
| C-06 | toString()は"shard_refresh"を返す | E-01 (L5878) | ○ |
| C-07 | startRefreshTask()で開始 | E-02 (L5882-L5887) | ○ |
| C-08 | stopRefreshTask()で停止 | E-02 (L5889-L5894) | ○ |
| C-09 | refreshMutex排他制御下で開始/停止 | E-02 (assert Thread.holdsLock(refreshMutex)) | ○ |
| C-10 | fixedRefreshIntervalSchedulingEnabled対応 | E-01 (L5854) | ○ |
| C-11 | IndexShard内の内部クラスとして実装 | E-01, E-03 | ○ |
| C-12 | AsyncRefreshTaskとの排他的動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: shardLevelRefreshEnabledフラグの切り替えロジックはIndexService側に実装されているが、AsyncRefreshTaskとの排他的な切り替えの全体的なフローは本調査で完全に確認していない。
  - 候補：`IndexService.java`のシャードレベルリフレッシュ切り替えロジック

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Experimental機能のため、今後のバージョンで変更される可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] @ExperimentalApiの注記が正確か
- [ ] refreshMutexの排他制御記述がソースコードと一致しているか
- [ ] AsyncRefreshTaskとの排他関係の記述を確認
