---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 128
  claims_with_evidence: 122
  claims_without_evidence: 6
confidence_derived: 0.95
---

# 根拠レポート：client-rest-high-level 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：122 / 128、根拠なし：6
- 優先レビュー（高）
  1. **UT-RHL-015/016 ping応答**: サーバー応答時のtrue/false挙動はRestHighLevelClient内部のconvertExistsResponseに依存するが、その実装詳細まで確認していない
  2. **UT-RHL-036/037 bulk変換のNDJSON生成**: 実際のNDJSON出力フォーマットの詳細はソースコードで確認済みだが、全パターンの網羅性は要確認
  3. **UT-RHL-068 URLエンコード**: EndpointBuilder内のエンコード処理の詳細実装を完全には確認していない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `client/rest-high-level/src/main/java/org/opensearch/client/RestHighLevelClient.java` - メインクライアントクラス（コンストラクタ、CRUD操作、検索、サブクライアントアクセサ）
- E-02: `client/rest-high-level/src/main/java/org/opensearch/client/RequestConverters.java` - HTTPリクエスト変換（delete, info, bulk, get, exists, index, ping, update, search, count, explain, fieldCaps, reindex, rethrottle, searchTemplate等）
- E-03: `client/rest-high-level/src/main/java/org/opensearch/client/ValidationException.java` - バリデーション例外（withError, withErrors, addValidationError, addValidationErrors, getMessage）
- E-04: `client/rest-high-level/src/main/java/org/opensearch/client/Validatable.java` - バリデーションインターフェース（validate default実装）
- E-05: `client/rest-high-level/src/main/java/org/opensearch/client/TimedRequest.java` - タイムアウト付きリクエスト基底クラス（setTimeout, setClusterManagerTimeout, デフォルト値）
- E-06: `client/rest-high-level/src/main/java/org/opensearch/client/RethrottleRequest.java` - リスロットルリクエスト（コンストラクタ、バリデーション）
- E-07: `client/rest-high-level/src/main/java/org/opensearch/client/tasks/TaskId.java` - タスクID（コンストラクタ、文字列パース、isSet、equals、hashCode）
- E-08: `client/rest-high-level/src/main/java/org/opensearch/client/tasks/GetTaskRequest.java` - タスク取得リクエスト（validate、waitForCompletion/timeout整合性チェック）
- E-09: `client/rest-high-level/src/main/java/org/opensearch/client/core/GetSourceRequest.java` - ソース取得リクエスト（コンストラクタ、from、routing空文字→null変換）
- E-10: `client/rest-high-level/src/main/java/org/opensearch/client/core/PageParams.java` - ページングパラメータ（コンストラクタ、equals、toXContent）
- E-11: `client/rest-high-level/src/main/java/org/opensearch/client/NodesResponseHeader.java` - ノードレスポンスヘッダ（コンストラクタ、null→空リスト変換、hasFailures）
- E-12: `client/rest-high-level/src/main/java/org/opensearch/client/GetAliasesResponse.java` - エイリアスレスポンス（fromXContent、ステータス/エラー/例外パース）
- E-13: `client/rest-high-level/src/main/java/org/opensearch/client/IndicesRequestConverters.java` - インデックスリクエスト変換（putDataStream, deleteDataStream, getDataStreams）
- E-14: `client/rest-high-level/src/main/java/org/opensearch/client/core/CountRequest.java` - カウントリクエスト（コンストラクタ）
- E-15: `client/rest-high-level/src/main/java/org/opensearch/client/core/TermVectorsRequest.java` - TermVectorsリクエスト（コンストラクタ）
- E-16: `client/rest-high-level/src/main/java/org/opensearch/client/indices/CreateIndexRequest.java` - インデックス作成リクエスト（コンストラクタ、デフォルト設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-RHL-001: RestClientBuilderでインスタンスが生成される | E-01 (L279-281) | ○ |
| C-02 | UT-RHL-002: RestClient+doClose+namedXContentで生成可能 | E-01 (L298-310) | ○ |
| C-03 | UT-RHL-003: restClient=nullでNPE | E-01 (L303: Objects.requireNonNull) | ○ |
| C-04 | UT-RHL-004: doClose=nullでNPE | E-01 (L304: Objects.requireNonNull) | ○ |
| C-05 | UT-RHL-005: getLowLevelClientがRestClient返却 | E-01 (L315-317) | ○ |
| C-06 | UT-RHL-006: closeでdoCloseが呼び出される | E-01 (L320-322) | ○ |
| C-07 | UT-RHL-007: close時IOException伝播 | E-01 (L320-322: throws IOException) | ○ |
| C-08 | UT-RHL-008~013: サブクライアント返却 | E-01 (L268-273, L328-362) | ○ |
| C-09 | UT-RHL-014: bulk正常実行 | E-01 (L370-372) | ○ |
| C-10 | UT-RHL-015: ping成功時true | E-01 (L687-695: convertExistsResponse) | ○ |
| C-11 | UT-RHL-016: ping失敗時false | E-01 (L687-695) | △ |
| C-12 | UT-RHL-017: info正常実行 | E-01 (L702-710) | ○ |
| C-13 | UT-RHL-018: get正常実行 | E-01 (L719-721) | ○ |
| C-14 | UT-RHL-019: get 404ハンドリング | E-01 (L720: singleton(404)) | ○ |
| C-15 | UT-RHL-020/021: exists true/false | E-01 (L816-818) | ○ |
| C-16 | UT-RHL-022: mget正常実行 | E-01 (L762-770) | ○ |
| C-17 | UT-RHL-023: index正常実行 | E-01 (L968-969) | ○ |
| C-18 | UT-RHL-024: update正常実行 | E-01 (L1028-1029) | ○ |
| C-19 | UT-RHL-025: delete正常実行 | E-01 (L1058-1066) | ○ |
| C-20 | UT-RHL-026: search正常実行 | E-01 (L1094-1099) | ○ |
| C-21 | UT-RHL-027: count正常実行 | E-01 (L998-999) | ○ |
| C-22 | UT-RHL-028: reindex正常実行 | E-01 (L398-406) | ○ |
| C-23 | UT-RHL-029: updateByQuery正常実行 | E-01 (L453-461) | ○ |
| C-24 | UT-RHL-030: deleteByQuery正常実行 | E-01 (L511-519) | ○ |
| C-25 | UT-RHL-031: existsSource正常 | E-01 (L888-896) | ○ |
| C-26 | UT-RHL-032: getSource正常 | E-01 (L928-936) | ○ |
| C-27 | UT-RHL-033: delete変換 | E-02 (L128-143) | ○ |
| C-28 | UT-RHL-034: deleteパラメータ変換 | E-02 (L132-141) | ○ |
| C-29 | UT-RHL-035: info変換 | E-02 (L145-147) | ○ |
| C-30 | UT-RHL-036/037: bulk変換 | E-02 (L149-292) | ○ |
| C-31 | UT-RHL-038: 空bulk変換 | E-02 (L149-292) | △ |
| C-32 | UT-RHL-039: get変換 | E-02 (L298-316) | ○ |
| C-33 | UT-RHL-040: exists変換 | E-02 (L294-296) | ○ |
| C-34 | UT-RHL-041/042: index PUT/POST | E-02 (L352-381) | ○ |
| C-35 | UT-RHL-043: index CREATE | E-02 (L356-358) | ○ |
| C-36 | UT-RHL-044: ping変換 | E-02 (L383-385) | ○ |
| C-37 | UT-RHL-045: update変換 | E-02 (L387-432) | ○ |
| C-38 | UT-RHL-046: update ContentType不一致 | E-02 (L413-420) | ○ |
| C-39 | UT-RHL-047/048: search変換 | E-02 (L440-451) | ○ |
| C-40 | UT-RHL-049: searchScroll変換 | E-02 (L486-490) | ○ |
| C-41 | UT-RHL-050: clearScroll変換 | E-02 (L492-496) | ○ |
| C-42 | UT-RHL-051: createPit変換 | E-02 (L498-507) | ○ |
| C-43 | UT-RHL-052: deletePit変換 | E-02 (L509-513) | ○ |
| C-44 | UT-RHL-053: deleteAllPits変換 | E-02 (L515-517) | ○ |
| C-45 | UT-RHL-054: getAllPits変換 | E-02 (L519-521) | ○ |
| C-46 | UT-RHL-055: multiSearch変換 | E-02 (L523-537) | ○ |
| C-47 | UT-RHL-056: count変換 | E-02 (L574-589) | ○ |
| C-48 | UT-RHL-057: explain変換 | E-02 (L591-603) | ○ |
| C-49 | UT-RHL-058/059: fieldCaps GET/POST | E-02 (L605-617) | ○ |
| C-50 | UT-RHL-060: reindex変換 | E-02 (L630-632) | ○ |
| C-51 | UT-RHL-061: rethrottleReindex変換 | E-02 (L731-735) | ○ |
| C-52 | UT-RHL-062/063: searchTemplate変換 | E-02 (L539-556) | ○ |
| C-53 | UT-RHL-064/065/066: Paramsメソッド | E-02 (L897以降) | ○ |
| C-54 | UT-RHL-067/068: EndpointBuilder | E-02 (L1284以降) | △ |
| C-55 | UT-RHL-069~075: ValidationException | E-03 (全体) | ○ |
| C-56 | UT-RHL-076: Validatable.validate | E-04 (L51-53) | ○ |
| C-57 | UT-RHL-077~080: TimedRequest | E-05 (全体) | ○ |
| C-58 | UT-RHL-081~085: RethrottleRequest | E-06 (全体) | ○ |
| C-59 | UT-RHL-086~096: TaskId | E-07 (全体) | ○ |
| C-60 | UT-RHL-097~099: GetTaskRequest.validate | E-08 (L91-100) | ○ |
| C-61 | UT-RHL-100~105: GetSourceRequest | E-09 (全体) | ○ |
| C-62 | UT-RHL-106~111: PageParams | E-10 (全体) | ○ |
| C-63 | UT-RHL-112~115: NodesResponseHeader | E-11 (全体) | ○ |
| C-64 | UT-RHL-116~120: GetAliasesResponse | E-12 (全体) | ○ |
| C-65 | UT-RHL-121~123: IndicesRequestConverters | E-13 (L85-100) | ○ |
| C-66 | UT-RHL-124/125: CountRequest | E-14 (L66-73) | ○ |
| C-67 | UT-RHL-126: TermVectorsRequest | E-15 (L71-75) | ○ |
| C-68 | UT-RHL-127/128: CreateIndexRequest | E-16 (L70-79) | ○ |
| C-69 | slmパッケージ(SnapshotLifecycle系)のテスト不足 | **根拠なし** | △ |
| C-70 | clusterサブパッケージ(RemoteConnectionInfo等)のテスト不足 | **根拠なし** | △ |
| C-71 | indicesサブパッケージの一部Request/Responseクラスのテスト不足 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- slmパッケージ（Snapshot Lifecycle Management）関連の16クラスについてテストケースが未作成
  - 候補：SnapshotLifecyclePolicy / SnapshotRetentionConfiguration / SnapshotLifecycleStats
- clusterサブパッケージのRemoteConnectionInfo, ProxyModeInfo, SniffModeInfo等のテストが未作成
  - 候補：RemoteConnectionInfo.fromXContent / ProxyModeInfo / SniffModeInfo
- indicesサブパッケージの一部（rollover, resize, analyze等の詳細なRequest/Responseクラス）のテストケースが限定的
  - 候補：RolloverRequest / ResizeRequest / AnalyzeRequest / AnalyzeResponse

## 5) リスクフラグ（レビュー観点）
- 0: RestHighLevelClient, RequestConverters, ValidationException, TaskId - ソースコードを直接確認し主要メソッドを網羅
- 1: slm/cluster/indicesサブパッケージ - 一部クラスのテストケースが不足しているが、これらは主に薄いラッパーやデータ保持クラス
- 0: バリデーションロジック（RethrottleRequest, GetTaskRequest, GetSourceRequest） - ソースコードの条件分岐を直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] RestHighLevelClientの各API呼び出しメソッドのテストケースが、モック対象（performRequestAndParseEntity）を適切にテストしているか
- [ ] RequestConvertersの各変換メソッドについて、HTTPメソッド・エンドポイント・パラメータが正しいか
- [ ] ValidationException/Validatableのテストケースがバリデーションフレームワーク全体をカバーしているか
- [ ] RethrottleRequestの境界値テスト（requestsPerSecond=0, 負数, Infinity）が正しく設計されているか
- [ ] TaskIdの文字列パーステストが全パターン（正常、null、不正フォーマット、非数値）をカバーしているか
- [ ] slm/cluster/indicesサブパッケージの不足テストケースを追加する必要があるか検討
- [ ] GetAliasesResponse.fromXContentのエラーハンドリングパターン（status/error文字列/exception）が十分にテストされているか
