---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 190
  claims_with_evidence: 186
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート：client-rest 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：186 / 190、根拠なし：4
- 優先レビュー（高）
  1. **C-016/C-017 (RestClient.isRunning)**: HttpAsyncClientのステータス確認ロジックはソースコードで確認できるが、IOReactorStatusの全状態遷移パターンの網羅性が要確認
  2. **C-163/C-164 (HeapBufferedAsyncResponseConsumer.buildResult)**: buildResultメソッドのlocale処理やContent-Encoding処理の詳細な条件分岐のテストケース網羅性が要確認
  3. **C-183/C-184 (StreamingResponse.getBody/getStatusLine)**: Reactive Streamsベースの非同期処理のテストケースは、実際のPublisher/Subscriber動作のモック方法に依存するため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `client/rest/src/main/java/org/opensearch/client/RestClient.java` - RestClientクラスの実装（builder, setNodes, selectNodes, buildUri, performRequest, close等）
- E-02: `client/rest/src/main/java/org/opensearch/client/RestClientBuilder.java` - RestClientBuilderクラスの実装（コンストラクタ, setter群, cleanPathPrefix, build等）
- E-03: `client/rest/src/main/java/org/opensearch/client/Request.java` - Requestクラスの実装（コンストラクタ, addParameter, setEntity, setJsonEntity等）
- E-04: `client/rest/src/main/java/org/opensearch/client/RequestOptions.java` - RequestOptionsクラスとBuilderの実装
- E-05: `client/rest/src/main/java/org/opensearch/client/Response.java` - Responseクラスの実装
- E-06: `client/rest/src/main/java/org/opensearch/client/Node.java` - NodeクラスとRolesの実装
- E-07: `client/rest/src/main/java/org/opensearch/client/DeadHostState.java` - DeadHostStateクラスの実装
- E-08: `client/rest/src/main/java/org/opensearch/client/Cancellable.java` - Cancellableクラスの実装
- E-09: `client/rest/src/main/java/org/opensearch/client/HasAttributeNodeSelector.java` - HasAttributeNodeSelectorの実装
- E-10: `client/rest/src/main/java/org/opensearch/client/PreferHasAttributeNodeSelector.java` - PreferHasAttributeNodeSelectorの実装
- E-11: `client/rest/src/main/java/org/opensearch/client/ResponseException.java` - ResponseExceptionの実装
- E-12: `client/rest/src/main/java/org/opensearch/client/WarningFailureException.java` - WarningFailureExceptionの実装
- E-13: `client/rest/src/main/java/org/opensearch/client/WarningsHandler.java` - WarningsHandlerインターフェースの実装
- E-14: `client/rest/src/main/java/org/opensearch/client/NodeSelector.java` - NodeSelectorインターフェースの実装（ANY, SKIP_DEDICATED_CLUSTER_MANAGERS）
- E-15: `client/rest/src/main/java/org/opensearch/client/HttpAsyncResponseConsumerFactory.java` - HttpAsyncResponseConsumerFactoryとHeapBufferedResponseConsumerFactoryの実装
- E-16: `client/rest/src/main/java/org/opensearch/client/nio/HeapBufferedAsyncEntityConsumer.java` - HeapBufferedAsyncEntityConsumerの実装
- E-17: `client/rest/src/main/java/org/opensearch/client/nio/HeapBufferedAsyncResponseConsumer.java` - HeapBufferedAsyncResponseConsumerの実装
- E-18: `client/rest/src/main/java/org/opensearch/client/nio/HttpEntityAsyncEntityProducer.java` - HttpEntityAsyncEntityProducerの実装
- E-19: `client/rest/src/main/java/org/opensearch/client/http/HttpUriRequestProducer.java` - HttpUriRequestProducerの実装
- E-20: `client/rest/src/main/java/org/opensearch/client/http/ReactiveHttpUriRequestProducer.java` - ReactiveHttpUriRequestProducerの実装
- E-21: `client/rest/src/main/java/org/opensearch/client/ResponseWarningsExtractor.java` - ResponseWarningsExtractorの実装
- E-22: `client/rest/src/main/java/org/opensearch/client/StreamingRequest.java` - StreamingRequestの実装
- E-23: `client/rest/src/main/java/org/opensearch/client/StreamingResponse.java` - StreamingResponseの実装
- E-24: `client/rest/src/main/java/org/opensearch/client/RequestLogger.java` - RequestLoggerの実装
- E-25: `client/rest/src/main/java/org/opensearch/client/ResponseListener.java` - ResponseListenerインターフェース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | builder(String)で有効なcloudIdからRestClientBuilderが生成される | E-01 (L209-243) | ○ |
| C-002 | builder(String)でポート番号付きcloudIdが処理される | E-01 (L231-239) | ○ |
| C-003 | builder(String)でポートなしの場合デフォルト443が使用される | E-01 (L237-238) | ○ |
| C-004 | builder(String)でコロン後が空の場合IllegalStateException | E-01 (L212-213) | ○ |
| C-005 | builder(String)で3パートでないcloudIdでIllegalStateException | E-01 (L222-224) | ○ |
| C-006 | builder(String)で不正ポート番号でIllegalStateException | E-01 (L233-235) | ○ |
| C-007 | builder(HttpHost...)で有効なhostsからビルダー生成 | E-01 (L268-274) | ○ |
| C-008 | builder(HttpHost...)でnull hostsにIllegalArgumentException | E-01 (L269-270) | ○ |
| C-009 | builder(HttpHost...)で空配列にIllegalArgumentException | E-01 (L269-270) | ○ |
| C-010 | builder(Node...)で有効なNodesからビルダー生成 | E-01 (L254-256) | ○ |
| C-011 | setNodesで有効なノードが設定される | E-01 (L281-296) | ○ |
| C-012 | setNodesでnull nodesにIllegalArgumentException | E-01 (L282-283) | ○ |
| C-013 | setNodesで空nodesにIllegalArgumentException | E-01 (L282-283) | ○ |
| C-014 | setNodesでnull要素にNullPointerException | E-01 (L289) | ○ |
| C-015 | getNodesで不変リストが返却される | E-01 (L302-304) | ○ |
| C-016 | isRunningでACTIVE時にtrue | E-01 (L310-312) | △ |
| C-017 | isRunningで非ACTIVE時にfalse | E-01 (L310-312) | △ |
| C-018 | closeが正常に実行される | E-01 (L759-761) | ○ |
| C-019 | selectNodesでラウンドロビン選択 | E-01 (L653-716) | ○ |
| C-020 | selectNodesでdenylistフィルタリング | E-01 (L664-671) | ○ |
| C-021 | selectNodesでdeadノードリバイバル | E-01 (L700-712) | ○ |
| C-022 | selectNodesで全ノード拒否時IOException | E-01 (L713-715) | ○ |
| C-023 | buildUriでpathPrefixなしの基本URI構築 | E-01 (L824-853) | ○ |
| C-024 | buildUriでpathPrefix付きURI構築 | E-01 (L828-835) | ○ |
| C-025 | buildUriでスラッシュ重複排除 | E-01 (L829-830) | ○ |
| C-026 | buildUriでクエリパラメータ付きURI | E-01 (L840-843) | ○ |
| C-027 | buildUriでnull pathにNullPointerException | E-01 (L825) | ○ |
| C-028 | buildUriでスラッシュ自動追加 | E-01 (L833-834) | ○ |
| C-029 | ContentCompressingEntityでgzipエンコーディング | E-01 (L1370-1373) | ○ |
| C-030 | ContentCompressingEntityでgzip圧縮InputStream | E-01 (L1389-1396) | ○ |
| C-031 | ContentCompressingEntityでchunked=trueの場合 | E-01 (L1403-1406) | ○ |
| C-032 | ContentCompressingEntityでchunked=falseの場合 | E-01 (L1403-1406) | ○ |
| C-033 | ContentCompressingEntityでchunked=true時getContentLength=-1 | E-01 (L1414-1417) | ○ |
| C-034 | ContentCompressingEntityでchunked=false時の実サイズ | E-01 (L1418-1432) | ○ |
| C-035 | ContentCompressingEntityでgzip書き出し | E-01 (L1444-1452) | ○ |
| C-036 | ContentCompressingEntity.writeToでnull outStreamにNPE | E-01 (L1446) | ○ |
| C-037 | ContentHttpEntityでchunked=true | E-01 (L1488-1491) | ○ |
| C-038 | ContentHttpEntityでデフォルトchunked | E-01 (L1488-1491) | ○ |
| C-039 | FailureTrackingResponseListenerのonSuccess | E-01 (L871-872) | ○ |
| C-040 | FailureTrackingResponseListenerのonDefinitiveFailure | E-01 (L878-881) | ○ |
| C-041 | FailureTrackingResponseListenerのtrackFailure | E-01 (L886-889) | ○ |
| C-042 | RestClientBuilderコンストラクタで有効なnodes | E-02 (L106-117) | ○ |
| C-043 | RestClientBuilderコンストラクタでnull nodes | E-02 (L107-108) | ○ |
| C-044 | RestClientBuilderコンストラクタで空nodes | E-02 (L107-108) | ○ |
| C-045 | RestClientBuilderコンストラクタでnull要素 | E-02 (L110-113) | ○ |
| C-046 | setDefaultHeadersで正常設定 | E-02 (L127-134) | ○ |
| C-047 | setDefaultHeadersでnullにNPE | E-02 (L128) | ○ |
| C-048 | setDefaultHeadersでnull要素にNPE | E-02 (L130) | ○ |
| C-049 | setFailureListenerで正常設定 | E-02 (L142-146) | ○ |
| C-050 | setFailureListenerでnullにNPE | E-02 (L143) | ○ |
| C-051 | setHttpClientConfigCallbackで正常設定 | E-02 (L154-158) | ○ |
| C-052 | setHttpClientConfigCallbackでnullにNPE | E-02 (L155) | ○ |
| C-053 | setRequestConfigCallbackで正常設定 | E-02 (L166-170) | ○ |
| C-054 | setRequestConfigCallbackでnullにNPE | E-02 (L167) | ○ |
| C-055 | cleanPathPrefixで先頭スラッシュ追加 | E-02 (L206-207) | ○ |
| C-056 | cleanPathPrefixで末尾スラッシュ除去 | E-02 (L211-213) | ○ |
| C-057 | cleanPathPrefixで空文字にIAE | E-02 (L201-203) | ○ |
| C-058 | cleanPathPrefixでnullにNPE | E-02 (L199) | ○ |
| C-059 | cleanPathPrefixで複数末尾スラッシュにIAE | E-02 (L214-215) | ○ |
| C-060 | setNodeSelectorで正常設定 | E-02 (L227-231) | ○ |
| C-061 | setNodeSelectorでnullにNPE | E-02 (L228) | ○ |
| C-062 | setCompressionEnabledで正常設定 | E-02 (L250-253) | ○ |
| C-063 | buildでRestClient生成 | E-02 (L268-305) | ○ |
| C-064 | buildでデフォルトFailureListener | E-02 (L269-271) | ○ |
| C-065 | Requestコンストラクタで正常生成 | E-03 (L61-64) | ○ |
| C-066 | Requestコンストラクタでnull methodにNPE | E-03 (L62) | ○ |
| C-067 | Requestコンストラクタでnull endpointにNPE | E-03 (L63) | ○ |
| C-068 | addParameterで正常追加 | E-03 (L88-95) | ○ |
| C-069 | addParameterでnull nameにNPE | E-03 (L89) | ○ |
| C-070 | addParameterで重複にIAE | E-03 (L90-91) | ○ |
| C-071 | addParametersで一括追加 | E-03 (L103-105) | ○ |
| C-072 | getParametersで不変Map返却 | E-03 (L112-120) | ○ |
| C-073 | getParametersでoptionsパラメータマージ | E-03 (L113-118) | ○ |
| C-074 | setEntityで設定 | E-03 (L128-130) | ○ |
| C-075 | setJsonEntityでJSON設定 | E-03 (L141-143) | ○ |
| C-076 | setJsonEntityでnull | E-03 (L142) | ○ |
| C-077 | setOptions(RequestOptions)で設定 | E-03 (L160-163) | ○ |
| C-078 | setOptions(RequestOptions)でnullにNPE | E-03 (L161) | ○ |
| C-079 | equals正常系 | E-03 (L209-223) | ○ |
| C-080 | equals非等値 | E-03 (L209-223) | ○ |
| C-081 | hashCode一致 | E-03 (L229-231) | ○ |
| C-082 | RequestOptions.DEFAULT | E-04 (L57-63) | ○ |
| C-083 | toBuilderでBuilder生成 | E-04 (L82-84) | ○ |
| C-084 | Builder.addHeaderで追加 | E-04 (L246-251) | ○ |
| C-085 | Builder.addHeaderでnull nameにNPE | E-04 (L247) | ○ |
| C-086 | Builder.addHeaderでnull valueにNPE | E-04 (L248) | ○ |
| C-087 | Builder.addParameterで追加 | E-04 (L261-266) | ○ |
| C-088 | Builder.addParameterでnull nameにNPE | E-04 (L262) | ○ |
| C-089 | Builder.setHttpAsyncResponseConsumerFactoryで設定 | E-04 (L277-282) | ○ |
| C-090 | Builder.setHttpAsyncResponseConsumerFactoryでnullにNPE | E-04 (L278-281) | ○ |
| C-091 | Builder.setRequestConfigで設定 | E-04 (L313-316) | ○ |
| C-092 | RequestOptions.equals | E-04 (L182-196) | ○ |
| C-093 | ReqHeader.equals | E-04 (L330-338) | ○ |
| C-094 | Responseコンストラクタ正常 | E-05 (L56-63) | ○ |
| C-095 | Responseコンストラクタnull requestLineにNPE | E-05 (L57) | ○ |
| C-096 | Responseコンストラクタnull hostにNPE | E-05 (L58) | ○ |
| C-097 | Responseコンストラクタnull responseにNPE | E-05 (L59) | ○ |
| C-098 | getStatusLine | E-05 (L82-84) | ○ |
| C-099 | getHeader存在する場合 | E-05 (L100-106) | ○ |
| C-100 | getHeader存在しない場合null | E-05 (L101-103) | ○ |
| C-101 | getWarnings | E-05 (L119-121) | ○ |
| C-102 | hasWarnings true | E-05 (L127-130) | ○ |
| C-103 | hasWarnings false | E-05 (L127-130) | ○ |
| C-104 | Node(HttpHost)コンストラクタ | E-06 (L105-107) | ○ |
| C-105 | Node全パラメータコンストラクタ | E-06 (L88-98) | ○ |
| C-106 | Nodeコンストラクタnull hostにIAE | E-06 (L89-91) | ○ |
| C-107 | Node.equals正常系 | E-06 (L185-196) | ○ |
| C-108 | Node.equals非等値 | E-06 (L185-196) | ○ |
| C-109 | Roles.isClusterManagerEligible master | E-06 (L226-227) | ○ |
| C-110 | Roles.isClusterManagerEligible cluster_manager | E-06 (L226-227) | ○ |
| C-111 | Roles.isClusterManagerEligible非該当 | E-06 (L226-227) | ○ |
| C-112 | Roles.isData | E-06 (L233-234) | ○ |
| C-113 | Roles.isIngest | E-06 (L240-241) | ○ |
| C-114 | Roles.isSearch | E-06 (L247-248) | ○ |
| C-115 | Roles.equals | E-06 (L263-269) | ○ |
| C-116 | DeadHostState初回コンストラクタ | E-07 (L59-63) | ○ |
| C-117 | DeadHostState累積コンストラクタ | E-07 (L73-81) | ○ |
| C-118 | DeadHostState MAX超過しない | E-07 (L74-76) | ○ |
| C-119 | shallBeRetried true | E-07 (L88-90) | ○ |
| C-120 | shallBeRetried false | E-07 (L88-90) | ○ |
| C-121 | compareTo正常 | E-07 (L105-112) | ○ |
| C-122 | compareTo異なるtimeSupplierにIAE | E-07 (L106-109) | ○ |
| C-123 | HasAttributeNodeSelector.select正常 | E-09 (L65-75) | ○ |
| C-124 | HasAttributeNodeSelector.selectでnull属性スキップ | E-09 (L69) | ○ |
| C-125 | HasAttributeNodeSelector.selectで全ノード属性null | E-09 (L69) | ○ |
| C-126 | HasAttributeNodeSelector.equals | E-09 (L82-91) | ○ |
| C-127 | PreferHasAttributeNodeSelector.select該当あり | E-10 (L66-103) | ○ |
| C-128 | PreferHasAttributeNodeSelector.select該当なしフォールバック | E-10 (L88) | ○ |
| C-129 | PreferHasAttributeNodeSelector.equals | E-10 (L111-119) | ○ |
| C-130 | Cancellable.cancel | E-08 (L77-79) | ○ |
| C-131 | Cancellable.runIfNotCancelled未キャンセル | E-08 (L93-98) | ○ |
| C-132 | Cancellable.runIfNotCancelledキャンセル済み | E-08 (L94-96) | ○ |
| C-133 | Cancellable.callIfNotCancelled未キャンセル | E-08 (L112-123) | ○ |
| C-134 | Cancellable.callIfNotCancelledキャンセル済み | E-08 (L113-115) | ○ |
| C-135 | Cancellable.callIfNotCancelledでIOException透過 | E-08 (L118-119) | ○ |
| C-136 | Cancellable.callIfNotCancelledで非IOException→IOExceptionラップ | E-08 (L120-121) | ○ |
| C-137 | Cancellable.NO_OP.cancelでUnsupportedOperationException | E-08 (L53-55) | ○ |
| C-138 | ResponseExceptionコンストラクタ | E-11 (L56-59) | ○ |
| C-139 | ResponseException警告付き | E-11 (L71-73) | ○ |
| C-140 | ResponseException.getResponse | E-11 (L93-95) | ○ |
| C-141 | WarningFailureExceptionコンストラクタ | E-12 (L56-59) | ○ |
| C-142 | WarningFailureException.getResponse | E-12 (L76-78) | ○ |
| C-143 | WarningsHandler.PERMISSIVE | E-13 (L54-58) | ○ |
| C-144 | WarningsHandler.STRICT警告あり | E-13 (L69-73) | ○ |
| C-145 | WarningsHandler.STRICT警告なし | E-13 (L69-73) | ○ |
| C-146 | NodeSelector.ANY | E-14 (L69-73) | ○ |
| C-147 | NodeSelector.SKIP_DEDICATED_CLUSTER_MANAGERS除外 | E-14 (L86-97) | ○ |
| C-148 | SKIP_DEDICATED_CLUSTER_MANAGERSでnull roles | E-14 (L91) | ○ |
| C-149 | SKIP_DEDICATED_CLUSTER_MANAGERSで兼用ノード非除外 | E-14 (L92-95) | ○ |
| C-150 | HeapBufferedResponseConsumerFactory.createHttpAsyncResponseConsumer | E-15 (L82-85) | ○ |
| C-151 | HeapBufferedResponseConsumerFactoryコンストラクタ | E-15 (L75-77) | ○ |
| C-152 | HeapBufferedAsyncEntityConsumerコンストラクタ正常 | E-16 (L44-49) | ○ |
| C-153 | HeapBufferedAsyncEntityConsumerコンストラクタ不正値 | E-16 (L45-47) | ○ |
| C-154 | HeapBufferedAsyncEntityConsumerコンストラクタ最小値 | E-16 (L45-47) | ○ |
| C-155 | HeapBufferedAsyncEntityConsumer.data正常 | E-16 (L84-118) | ○ |
| C-156 | HeapBufferedAsyncEntityConsumer.data null src | E-16 (L85-87) | ○ |
| C-157 | HeapBufferedAsyncEntityConsumer.dataバッファリミット超過 | E-16 (L92-96) | ○ |
| C-158 | HeapBufferedAsyncEntityConsumer.data累積超過 | E-16 (L106-110) | ○ |
| C-159 | HeapBufferedAsyncEntityConsumer.generateContent正常 | E-16 (L127-130) | ○ |
| C-160 | HeapBufferedAsyncEntityConsumer.generateContent空バッファ | E-16 (L129) | ○ |
| C-161 | HeapBufferedAsyncEntityConsumer.releaseResources | E-16 (L136-142) | ○ |
| C-162 | HeapBufferedAsyncResponseConsumerコンストラクタ | E-17 (L67-70) | ○ |
| C-163 | HeapBufferedAsyncResponseConsumer.buildResult正常 | E-17 (L96-122) | △ |
| C-164 | HeapBufferedAsyncResponseConsumer.buildResult entity null | E-17 (L105) | △ |
| C-165 | HttpEntityAsyncEntityProducerコンストラクタ(bufferSize) | E-18 (L43-49) | ○ |
| C-166 | HttpEntityAsyncEntityProducerコンストラクタ(default) | E-18 (L55-57) | ○ |
| C-167 | HttpEntityAsyncEntityProducer.isRepeatable | E-18 (L64-66) | ○ |
| C-168 | HttpEntityAsyncEntityProducer.getContentType | E-18 (L73-74) | ○ |
| C-169 | HttpEntityAsyncEntityProducer.releaseResources | E-18 (L170-181) | ○ |
| C-170 | HttpUriRequestProducer.create エンティティあり | E-19 (L45-61) | ○ |
| C-171 | HttpUriRequestProducer.create エンティティなし | E-19 (L53-54) | ○ |
| C-172 | ReactiveHttpUriRequestProducer.create | E-20 (L51-73) | ○ |
| C-173 | ReactiveHttpUriRequestProducer.create デフォルトContent-Type | E-20 (L63-66) | ○ |
| C-174 | ResponseWarningsExtractor.getWarnings OpenSearchプレフィックス | E-21 (L49-60) | ○ |
| C-175 | ResponseWarningsExtractor.getWarnings 非OpenSearch | E-21 (L55-57) | ○ |
| C-176 | ResponseWarningsExtractor.getWarnings 空 | E-21 (L49-51) | ○ |
| C-177 | StreamingRequestコンストラクタ | E-22 (L36-40) | ○ |
| C-178 | StreamingRequest.addParameter | E-22 (L112-119) | ○ |
| C-179 | StreamingRequest.addParameter重複 | E-22 (L114-115) | ○ |
| C-180 | StreamingRequest.setOptions | E-22 (L87-90) | ○ |
| C-181 | StreamingRequest.setOptions null | E-22 (L88) | ○ |
| C-182 | StreamingResponseコンストラクタ | E-23 (L37-42) | ○ |
| C-183 | StreamingResponse.getBody | E-23 (L72-74) | ○ |
| C-184 | StreamingResponse.getStatusLine | E-23 (L79-85) | ○ |
| C-185 | StreamingResponse.getHeader存在 | E-23 (L115-121) | ○ |
| C-186 | StreamingResponse.getHeader存在しない | E-23 (L115-121) | ○ |
| C-187 | RequestLogger.buildWarningMessage | E-24 (L119-134) | ○ |
| C-188 | RequestLogger.buildTraceRequest基本 | E-24 (L139-155) | ○ |
| C-189 | RequestLogger.buildTraceRequestエンティティ付き | E-24 (L141-153) | ○ |
| C-190 | RequestLogger.buildTraceResponse | E-24 (L160-186) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-016/C-017: IOReactorStatusの状態遷移についてはApache HttpClient 5の内部仕様に依存しており、全パターンのテストカバレッジは外部ライブラリのモック方法に依存する
  - 候補：Apache HttpClient 5ドキュメント / IOReactorStatusのJavadoc / 既存テストコード
- C-163/C-164: buildResultメソッドのlocaleやContent-Encodingの処理はHttpExceptionハンドリングを含むため、例外発生パターンの詳細は要確認
  - 候補：Apache HttpClient 5のHttpResponseインターフェース仕様 / 既存テストコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストケースの大部分はソースコードのpublicメソッドの実装から直接導出されており、根拠は明確
- 0: 低リスク - テストID命名規則（UT-RST-xxx）は一貫しており、CSVフォーマットも要件に準拠
- 1: 中リスク - performRequest/performRequestAsync/streamRequestのテストケースは意図的に除外している（これらはHTTPクライアントの統合的な動作であり、モック化が必要な統合テスト寄りのテスト対象）。ただし、RestClient.selectNodesやbuildUriなどのstatic/package-privateメソッドは単体テスト可能であり、カバーしている

## 6) レビュアーチェックリスト（最小）
- [ ] 全てのpublicメソッドに対してテストケースが存在するか確認
- [ ] 正常系・異常系・境界値の観点が各クラスで網羅されているか確認
- [ ] テストケースの前提条件・入力値・期待結果がソースコードの実装と整合しているか確認
- [ ] performRequest/performRequestAsyncなどの統合テスト的なメソッドについて、別途統合テストケースの必要性を検討
- [ ] StreamingRequest/StreamingResponseのReactive Streamsベースのテストについて、テスト実行可能性を確認
