---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 72
  claims_with_evidence: 70
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：client-sniffer 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：70 / 72、根拠なし：2
- 優先レビュー（高）
  1. **C-69 (UT-SNF-069)**：build()のデフォルトNodesSniffer生成はコードで確認可能だが、内部状態のテスト方法が要検討
  2. **C-71 (UT-SNF-071)**：デフォルト値の検証は定数で確認可能だが、Snifferの内部フィールドがpackage-privateのためテスト手段の検討が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `client/sniffer/src/main/java/org/opensearch/client/sniff/OpenSearchNodesSniffer.java`
- E-02: `client/sniffer/src/main/java/org/opensearch/client/sniff/SniffOnFailureListener.java`
- E-03: `client/sniffer/src/main/java/org/opensearch/client/sniff/Sniffer.java`
- E-04: `client/sniffer/src/main/java/org/opensearch/client/sniff/SnifferBuilder.java`
- E-05: `client/sniffer/src/main/java/org/opensearch/client/sniff/NodesSniffer.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-SNF-001: デフォルトコンストラクタでHTTPとDEFAULT_SNIFF_REQUEST_TIMEOUTが使用される | E-01 (L92-94) | ○ |
| C-02 | UT-SNF-002: 3引数コンストラクタでカスタム設定が可能 | E-01 (L107-115) | ○ |
| C-03 | UT-SNF-003: restClient=nullでNullPointerException | E-01 (L108: Objects.requireNonNull) | ○ |
| C-04 | UT-SNF-004: sniffRequestTimeoutMillis<0でIllegalArgumentException | E-01 (L109-111) | ○ |
| C-05 | UT-SNF-005: scheme=nullでNullPointerException | E-01 (L114: Objects.requireNonNull) | ○ |
| C-06 | UT-SNF-006: sniffRequestTimeoutMillis=0は許容される | E-01 (L109: 条件は < 0) | ○ |
| C-07 | UT-SNF-007: sniff()がNodeリストを返す | E-01 (L121-124) | ○ |
| C-08 | UT-SNF-008: RestClientのIOExceptionが伝播する | E-01 (L122: performRequest) | ○ |
| C-09 | UT-SNF-009: HTTPスキームでの単一ノードパース | E-01 (L126-152) | ○ |
| C-10 | UT-SNF-010: HTTPSスキームでの複数ノードパース | E-01 (L126-152) | ○ |
| C-11 | UT-SNF-011: cname/ip:port形式のパース | E-01 (L188-191) | ○ |
| C-12 | UT-SNF-012: ip:port形式のパース | E-01 (L192-194) | ○ |
| C-13 | UT-SNF-013: bound_addressのパース | E-01 (L197-203) | ○ |
| C-14 | UT-SNF-014: attributesのパース | E-01 (L208-218) | ○ |
| C-15 | UT-SNF-015: 配列形式属性値のリスト変換 | E-01 (L247-251) | ○ |
| C-16 | UT-SNF-016: rolesのパース | E-01 (L222-227) | ○ |
| C-17 | UT-SNF-017: name/versionのパース | E-01 (L231-236) | ○ |
| C-18 | UT-SNF-018: httpセクションなしノードのスキップ | E-01 (L240-243) | ○ |
| C-19 | UT-SNF-019: JSON先頭がオブジェクトでない場合のIOException | E-01 (L129-131) | ○ |
| C-20 | UT-SNF-020: 重複属性キーでIOException | E-01 (L211-213) | ○ |
| C-21 | UT-SNF-021: nodesセクションが空の場合 | E-01 (L133-151) | ○ |
| C-22 | UT-SNF-022: Scheme.HTTP.toString()が"http" | E-01 (L270, L284-286) | ○ |
| C-23 | UT-SNF-023: Scheme.HTTPS.toString()が"https" | E-01 (L275, L284-286) | ○ |
| C-24 | UT-SNF-024: SniffOnFailureListenerのコンストラクタ | E-02 (L56-58) | ○ |
| C-25 | UT-SNF-025: setSnifferの正常設定 | E-02 (L66-73) | ○ |
| C-26 | UT-SNF-026: setSniffer(null)でNullPointerException | E-02 (L67) | ○ |
| C-27 | UT-SNF-027: setSniffer二重呼び出しでIllegalStateException | E-02 (L68-72) | ○ |
| C-28 | UT-SNF-028: onFailureでsniffOnFailure()呼び出し | E-02 (L76-81) | ○ |
| C-29 | UT-SNF-029: sniffer未設定時のonFailureでIllegalStateException | E-02 (L77-78) | ○ |
| C-30 | UT-SNF-030: Snifferの4引数コンストラクタ | E-03 (L78-79, L82-104) | ○ |
| C-31 | UT-SNF-031: sniffOnFailureのタスクスケジュール | E-03 (L110-127) | ○ |
| C-32 | UT-SNF-032: 初期化未完了時のsniffOnFailure無動作 | E-03 (L112) | ○ |
| C-33 | UT-SNF-033: 既実行中タスクの重複防止 | E-03 (L118) | ○ |
| C-34 | UT-SNF-034: sniff()でsetNodes呼び出し | E-03 (L222-232) | ○ |
| C-35 | UT-SNF-035: 空リスト時setNodes非呼び出し | E-03 (L227-229) | ○ |
| C-36 | UT-SNF-036: sniff()のIOException伝播 | E-03 (L223) | ○ |
| C-37 | UT-SNF-037: close()でscheduler.shutdown() | E-03 (L235-240) | ○ |
| C-38 | UT-SNF-038: 初期化前close()の動作 | E-03 (L236-237) | ○ |
| C-39 | UT-SNF-039: builder()の返却値 | E-03 (L249-251) | ○ |
| C-40 | UT-SNF-040: Taskのrun()基本フロー | E-03 (L144-166) | ○ |
| C-41 | UT-SNF-041: SKIPPED状態タスクの非実行 | E-03 (L150) | ○ |
| C-42 | UT-SNF-042: STARTED状態タスクの再実行防止 | E-03 (L150) | ○ |
| C-43 | UT-SNF-043: 例外時の次タスクスケジュール | E-03 (L153-165: try-catch-finally) | ○ |
| C-44 | UT-SNF-044: hasStarted()でSTARTED=true | E-03 (L171-173) | ○ |
| C-45 | UT-SNF-045: hasStarted()でWAITING=false | E-03 (L171-173) | ○ |
| C-46 | UT-SNF-046: skip()でWAITING→SKIPPED | E-03 (L178-186) | ○ |
| C-47 | UT-SNF-047: skip()でSTARTED→false | E-03 (L185) | ○ |
| C-48 | UT-SNF-048: isSkipped()でSKIPPED=true | E-03 (L191-193) | ○ |
| C-49 | UT-SNF-049: isSkipped()でWAITING=false | E-03 (L191-193) | ○ |
| C-50 | UT-SNF-050: ScheduledTask.skip()の動作 | E-03 (L210-219) | ○ |
| C-51 | UT-SNF-051: DefaultScheduler.schedule() | E-03 (L290-292) | ○ |
| C-52 | UT-SNF-052: DefaultScheduler.shutdown()正常 | E-03 (L295-306) | ○ |
| C-53 | UT-SNF-053: shutdown()タイムアウト時のshutdownNow | E-03 (L298-301) | ○ |
| C-54 | UT-SNF-054: InterruptedException時の割り込みフラグ | E-03 (L302-304) | ○ |
| C-55 | UT-SNF-055: SnifferThreadFactoryのスレッド名とデーモン | E-03 (L325-335) | ○ |
| C-56 | UT-SNF-056: スレッド番号のインクリメント | E-03 (L310, L330) | ○ |
| C-57 | UT-SNF-057: SnifferBuilderの正常生成 | E-04 (L63-66) | ○ |
| C-58 | UT-SNF-058: SnifferBuilder(null)でNullPointerException | E-04 (L64) | ○ |
| C-59 | UT-SNF-059: setSniffIntervalMillisの正常設定 | E-04 (L75-81) | ○ |
| C-60 | UT-SNF-060: setSniffIntervalMillis(0)でIllegalArgumentException | E-04 (L76-78) | ○ |
| C-61 | UT-SNF-061: setSniffIntervalMillis(-1)でIllegalArgumentException | E-04 (L76-78) | ○ |
| C-62 | UT-SNF-062: setSniffIntervalMillis(1)の正常設定 | E-04 (L76: 条件は <= 0) | ○ |
| C-63 | UT-SNF-063: setSniffAfterFailureDelayMillisの正常設定 | E-04 (L88-94) | ○ |
| C-64 | UT-SNF-064: setSniffAfterFailureDelayMillis(0)でIllegalArgumentException | E-04 (L89-91) | ○ |
| C-65 | UT-SNF-065: setSniffAfterFailureDelayMillis(-1)でIllegalArgumentException | E-04 (L89-91) | ○ |
| C-66 | UT-SNF-066: setSniffAfterFailureDelayMillis(1)の正常設定 | E-04 (L89: 条件は <= 0) | ○ |
| C-67 | UT-SNF-067: setNodesSnifferの正常設定 | E-04 (L103-107) | ○ |
| C-68 | UT-SNF-068: setNodesSniffer(null)でNullPointerException | E-04 (L104) | ○ |
| C-69 | UT-SNF-069: build()でデフォルトOpenSearchNodesSnifferが生成 | E-04 (L113-114) | ○ |
| C-70 | UT-SNF-070: build()でカスタムNodesSnifferが使用 | E-04 (L113-116) | ○ |
| C-71 | UT-SNF-071: デフォルト値の確認 | E-04 (L48, L53) | △ |
| C-72 | UT-SNF-072: 全パラメータカスタム設定 | E-04 (L75-116) | △ |

## 4) 不足情報（Unknown / Missing）
- C-71, C-72: Snifferの内部フィールド（sniffIntervalMillis, sniffAfterFailureDelayMillis）がpackage-privateであるため、build後のSnifferインスタンスから設定値を直接検証する手段が限定される。テスト時にはリフレクションまたはpackage-private可視性を利用したテストクラス配置が必要。
  - 候補：リフレクションによるフィールドアクセス / テストクラスを同一パッケージに配置 / Schedulerのモック注入による間接検証

## 5) リスクフラグ（レビュー観点）
- 0: OpenSearchNodesSniffer, SniffOnFailureListener, SnifferBuilder の各メソッドのテストケースはソースコードと直接対応しており低リスク
- 1: Snifferの並行処理関連テスト（sniffOnFailure, Task状態遷移）はタイミング依存のため中リスク。テスト実装時にはSchedulerのモック注入を推奨
- 0: JSONパース関連テスト（readHosts, readNode）はstatic/package-privateメソッドとして直接テスト可能であり低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 全72テストケースが対象モジュールの5つのソースファイル（package-info.java, NodesSniffer.javaインタフェースを除く4クラス）を網羅しているか
- [ ] OpenSearchNodesSniffer.readHostsのJSONパースパターン（cname/ip:port形式、属性配列、roles等）が実際のOpenSearchレスポンス形式と一致するか
- [ ] Snifferの並行処理テスト（Task状態遷移、sniffOnFailure）の前提条件が実現可能か
- [ ] SnifferBuilderのbuild()で生成されるSnifferの内部状態検証方法が妥当か
- [ ] NodesSniffer インタフェースのsniff()メソッドは実装クラス側でテストされているため、インタフェース自体のテストケースが不要であることの妥当性を確認
