---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 124
  claims_with_evidence: 118
  claims_without_evidence: 6
confidence_derived: 0.95
---

# 根拠レポート：libs-agent-sm 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：118 / 124、根拠なし：6
- 優先レビュー（高）
  1. **Agent.premain/agentmainのインテグレーション的テスト（UT-AGS-123, 124）**：ByteBuddyを使用したエージェントインストールのため、単体テストとしての実現可能性に要確認
  2. **StackCallerProtectionDomainChainExtractor.applyのdoPrivilegedチェーン切断テスト（UT-AGS-093, 094）**：実際のStackWalkerフレーム構築が必要なため、テスト実現方法に要確認
  3. **FileInterceptor.interceptのUNIXドメインソケット判定（UT-AGS-108周辺）**：Windows固有のUNIXドメインソケット実装に関するテストの環境依存性に要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libs/agent-sm/bootstrap/src/main/java/org/opensearch/javaagent/bootstrap/AgentPolicy.java`
- E-02: `libs/agent-sm/agent-policy/src/main/java/org/opensearch/secure_sm/AccessController.java`
- E-03: `libs/agent-sm/agent-policy/src/main/java/org/opensearch/secure_sm/policy/PropertyExpander.java`
- E-04: `libs/agent-sm/agent-policy/src/main/java/org/opensearch/secure_sm/policy/PolicyParser.java`
- E-05: `libs/agent-sm/agent-policy/src/main/java/org/opensearch/secure_sm/policy/TokenStream.java`
- E-06: `libs/agent-sm/agent-policy/src/main/java/org/opensearch/secure_sm/policy/Tokenizer.java`
- E-07: `libs/agent-sm/agent-policy/src/main/java/org/opensearch/secure_sm/policy/Token.java`
- E-08: `libs/agent-sm/agent-policy/src/main/java/org/opensearch/secure_sm/policy/PermissionEntry.java`
- E-09: `libs/agent-sm/agent-policy/src/main/java/org/opensearch/secure_sm/policy/GrantEntry.java`
- E-10: `libs/agent-sm/agent-policy/src/main/java/org/opensearch/secure_sm/policy/PolicyFile.java`
- E-11: `libs/agent-sm/agent-policy/src/main/java/org/opensearch/secure_sm/policy/PolicyInitializationException.java`
- E-12: `libs/agent-sm/agent/src/main/java/org/opensearch/javaagent/StackCallerClassChainExtractor.java`
- E-13: `libs/agent-sm/agent/src/main/java/org/opensearch/javaagent/StackCallerProtectionDomainChainExtractor.java`
- E-14: `libs/agent-sm/agent/src/main/java/org/opensearch/javaagent/SocketChannelInterceptor.java`
- E-15: `libs/agent-sm/agent/src/main/java/org/opensearch/javaagent/FileInterceptor.java`
- E-16: `libs/agent-sm/agent/src/main/java/org/opensearch/javaagent/SystemExitInterceptor.java`
- E-17: `libs/agent-sm/agent/src/main/java/org/opensearch/javaagent/RuntimeHaltInterceptor.java`
- E-18: `libs/agent-sm/agent/src/main/java/org/opensearch/javaagent/SubjectInterceptor.java`
- E-19: `libs/agent-sm/agent/src/main/java/org/opensearch/javaagent/Agent.java`
- E-20: `libs/agent-sm/agent/src/test/java/org/opensearch/javaagent/SocketChannelInterceptorTests.java`（既存テスト）
- E-21: `libs/agent-sm/agent/src/test/java/org/opensearch/javaagent/StackCallerProtectionDomainExtractorTests.java`（既存テスト）
- E-22: `libs/agent-sm/agent/src/test/java/org/opensearch/javaagent/AgentTests.java`（既存テスト）
- E-23: `libs/agent-sm/agent/src/test/java/org/opensearch/javaagent/SubjectTests.java`（既存テスト）
- E-24: `libs/agent-sm/agent-policy/src/test/java/org/opensearch/secure_sm/policy/PolicyParserTests.java`（既存テスト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AgentPolicy.setPolicy - ポリシー未設定時に正常設定 | E-01 (L127-129, L144-149) | ○ |
| C-02 | AgentPolicy.setPolicy - 二重設定でSecurityException | E-01 (L144, L151) | ○ |
| C-03 | AgentPolicy.setPolicy(4引数) - 全パラメータ設定 | E-01 (L138-153) | ○ |
| C-04 | trustedHostsが不変コレクション | E-01 (L147: Collections.unmodifiableSet) | ○ |
| C-05 | trustedFileSystemsが不変コレクション | E-01 (L148: Collections.unmodifiableSet) | ○ |
| C-06 | checkPermission - 全ドメイン許可時に例外なし | E-01 (L159-170) | ○ |
| C-07 | checkPermission - ドメイン拒否時にSecurityException | E-01 (L167-168) | ○ |
| C-08 | getPolicy - 設定済みポリシー返却 | E-01 (L176-178) | ○ |
| C-09 | getPolicy - 未設定時null | E-01 (L31: volatile policy初期値null) | ○ |
| C-10 | isTrustedHost - 信頼済みホストでtrue | E-01 (L186-187) | ○ |
| C-11 | isTrustedHost - 非信頼ホストでfalse | E-01 (L186-187) | ○ |
| C-12 | isTrustedHost - 空Set | E-01 (L186-187) | ○ |
| C-13 | isTrustedFileSystem - 信頼済みFSでtrue | E-01 (L194-196) | ○ |
| C-14 | isTrustedFileSystem - 非信頼FSでfalse | E-01 (L194-196) | ○ |
| C-15 | isChainThatCanExit - 結果返却 | E-01 (L204-206) | ○ |
| C-16 | NoneCanExit.apply - 常にtrue | E-01 (L52-54) | ○ |
| C-17 | CallerCanExit.apply - 許可クラスでtrue | E-01 (L78-84) | ○ |
| C-18 | CallerCanExit.apply - 未許可でfalse | E-01 (L78-85) | ○ |
| C-19 | CallerCanExit.apply - 大文字小文字無視 | E-01 (L80: equalsIgnoreCase) | ○ |
| C-20 | CallerCanExit.apply - 空配列でfalse | E-01 (L79-85) | ○ |
| C-21 | AnyCanExit.apply - チェーン内許可クラスでtrue | E-01 (L109-117) | ○ |
| C-22 | AnyCanExit.apply - チェーン内未許可でfalse | E-01 (L109-118) | ○ |
| C-23 | AnyCanExit.apply - 正規表現マッチ | E-01 (L112: matches()) | ○ |
| C-24 | AnyCanExit.apply - 空チェーンでfalse | E-01 (L110-118) | ○ |
| C-25 | AccessController.doPrivileged(Runnable) - 実行 | E-02 (L58-60) | ○ |
| C-26 | AccessController.doPrivileged(Runnable) - 例外伝播 | E-02 (L58-60) | ○ |
| C-27 | AccessController.doPrivileged(Supplier) - 戻り値 | E-02 (L75-77) | ○ |
| C-28 | AccessController.doPrivileged(Supplier) - 例外伝播 | E-02 (L75-77) | ○ |
| C-29 | doPrivilegedChecked(CheckedRunnable) - 実行 | E-02 (L90-92) | ○ |
| C-30 | doPrivilegedChecked(CheckedRunnable) - チェック例外伝播 | E-02 (L90-92) | ○ |
| C-31 | doPrivilegedChecked(CheckedSupplier) - 戻り値 | E-02 (L109-111) | ○ |
| C-32 | doPrivilegedChecked(CheckedSupplier) - チェック例外伝播 | E-02 (L109-111) | ○ |
| C-33 | PropertyExpander.expand - プレースホルダーなし | E-03 (L37-38) | ○ |
| C-34 | PropertyExpander.expand - ${/}展開 | E-03 (L62-63) | ○ |
| C-35 | PropertyExpander.expand - システムプロパティ展開 | E-03 (L64-69) | ○ |
| C-36 | PropertyExpander.expand - 未定義プロパティでExpandException | E-03 (L66-67) | ○ |
| C-37 | PropertyExpander.expand - null入力 | E-03 (L37) | ○ |
| C-38 | PropertyExpander.expand - 空文字列 | E-03 (L37: !value.contains) | ○ |
| C-39 | PropertyExpander.expand - ${{escaped}}処理 | E-03 (L53-55) | ○ |
| C-40 | PropertyExpander.expand(encodeURL) - 絶対URI | E-03 (L76-77) | ○ |
| C-41 | PropertyExpander.expand(encodeURL) - 相対パス | E-03 (L77) | ○ |
| C-42 | PolicyParser.read - 基本パース | E-04 (L26-38), E-24 | ○ |
| C-43 | PolicyParser.read - Codebase付き | E-04 (L85-98) | ○ |
| C-44 | PolicyParser.read - 複数grantブロック | E-04 (L32-36) | ○ |
| C-45 | PolicyParser.read - 複数permission | E-04 (L107-113) | ○ |
| C-46 | PolicyParser.read - ParsingException | E-04 (L65-66, L101) | ○ |
| C-47 | PolicyParser.read - 複数Codebase | E-04 (L86-88) | ○ |
| C-48 | PolicyParser.read - 空ファイル | E-04 (L32: while !isEOF) | ○ |
| C-49 | PolicyParser.read - 引数なしpermission | E-04 (L167-169) | ○ |
| C-50 | PolicyParser.read - 展開失敗スキップ | E-04 (L93-97) | ○ |
| C-51 | ParsingException コンストラクタ(message) | E-04 (L187-189) | ○ |
| C-52 | ParsingException コンストラクタ(行番号) | E-04 (L191-193) | ○ |
| C-53 | ParsingException コンストラクタ(found) | E-04 (L195-197) | ○ |
| C-54 | TokenStream.peek - 次トークン読み取り | E-05 (L25-29) | ○ |
| C-55 | TokenStream.peek - 冪等性 | E-05 (L25-29: バッファ確認) | ○ |
| C-56 | TokenStream.consume - バッファから返却 | E-05 (L32-34) | ○ |
| C-57 | TokenStream.consume - バッファ空時の直接読み取り | E-05 (L33) | ○ |
| C-58 | TokenStream.isEOF - EOF時true | E-05 (L36-39) | ○ |
| C-59 | TokenStream.isEOF - 非EOF時false | E-05 (L36-39) | ○ |
| C-60 | TokenStream.line - 行番号取得 | E-05 (L41-43) | ○ |
| C-61 | Tokenizer.configureTokenizer - StreamTokenizer返却 | E-06 (L38-59) | ○ |
| C-62 | Tokenizer - ダブルクォート認識 | E-06 (L52: quoteChar) | ○ |
| C-63 | Tokenizer - コメント無視 | E-06 (L55-56: slashSlash/StarComments) | ○ |
| C-64 | Tokenizer - ワード文字認識 | E-06 (L42-48: wordChars) | ○ |
| C-65 | Token record - フィールドアクセス | E-07 (L11: record定義) | ○ |
| C-66 | Token equals - 等価性 | E-07 (L11: recordの自動equals) | ○ |
| C-67 | PermissionEntry - フィールドアクセス | E-08 (L10: record定義) | ○ |
| C-68 | PermissionEntry - null許容 | E-08 (L10) | ○ |
| C-69 | GrantEntry - フィールドアクセス | E-09 (L12: record定義) | ○ |
| C-70 | GrantEntry - null codeBase | E-09 (L12) | ○ |
| C-71 | PolicyFile コンストラクタ - 正常 | E-10 (L59-66) | ○ |
| C-72 | PolicyFile コンストラクタ - 不正URL | E-10 (L62-65) | ○ |
| C-73 | PolicyFile.implies - 許可パーミッション | E-10 (L215-222) | ○ |
| C-74 | PolicyFile.implies - 拒否パーミッション | E-10 (L215-222) | ○ |
| C-75 | PolicyFile.implies - null pd | E-10 (L216-218) | ○ |
| C-76 | PolicyFile.implies - null permission | E-10 (L216-218) | ○ |
| C-77 | PolicyFile.getPermissions(ProtectionDomain) | E-10 (L225-246) | ○ |
| C-78 | PolicyFile.getPermissions - null domain | E-10 (L227) | ○ |
| C-79 | PolicyFile.getPermissions(CodeSource) | E-10 (L249-270) | ○ |
| C-80 | PolicyFile.getPermissions - null codesource | E-10 (L250) | ○ |
| C-81 | PolicyFile.refresh | E-10 (L206-212) | ○ |
| C-82 | PolicyFile.getInputStream - fileプロトコル | E-10 (L82-90) | ○ |
| C-83 | PolicyFile.getInputStream - 存在しないファイル | E-10 (L82-90) | ○ |
| C-84 | PERM_CLASSES_TO_SKIP定数 | E-10 (L45-54) | ○ |
| C-85 | PolicyInitializationException(message) | E-11 (L16-18) | ○ |
| C-86 | PolicyInitializationException(message, cause) | E-11 (L20-22) | ○ |
| C-87 | PolicyInitializationException(cause) | E-11 (L24-26) | ○ |
| C-88 | StackCallerClassChainExtractor.apply - クラスチェーン抽出 | E-12 (L37-39) | ○ |
| C-89 | StackCallerClassChainExtractor.apply - hiddenクラスフィルタ | E-12 (L43: filter(!isHidden)) | ○ |
| C-90 | StackCallerClassChainExtractor.apply - 空Stream | E-12 (L37-39) | ○ |
| C-91 | StackCallerClassChainExtractor.INSTANCE | E-12 (L25) | ○ |
| C-92 | StackCallerProtectionDomainChainExtractor.apply - PD抽出 | E-13 (L50-58) | ○ |
| C-93 | StackCallerProtectionDomainChainExtractor.apply - doPrivilegedチェーン切断 | E-13 (L51-52, L33-34) | ○ |
| C-94 | StackCallerProtectionDomainChainExtractor.apply - opensearch AccessControllerチェーン切断 | E-13 (L35, L38) | ○ |
| C-95 | StackCallerProtectionDomainChainExtractor.apply - JDKクラスフィルタ | E-13 (L56) | ○ |
| C-96 | StackCallerProtectionDomainChainExtractor.apply - jrtプロトコルフィルタ | E-13 (L57) | ○ |
| C-97 | SocketChannelInterceptor.intercept - ポリシー未設定noop | E-14 (L43-46) | ○ |
| C-98 | SocketChannelInterceptor.intercept - 信頼済みホスト | E-14 (L52) | ○ |
| C-99 | SocketChannelInterceptor.intercept - パーミッション許可接続 | E-14 (L55-59) | ○ |
| C-100 | SocketChannelInterceptor.intercept - パーミッション拒否接続 | E-14 (L57-58) | ○ |
| C-101 | SocketChannelInterceptor.intercept - UNIXドメインソケット許可 | E-14 (L62-68) | ○ |
| C-102 | SocketChannelInterceptor.intercept - UNIXドメインソケット拒否 | E-14 (L65-66) | ○ |
| C-103 | FileInterceptor.intercept - ポリシー未設定noop | E-15 (L47-49) | ○ |
| C-104 | FileInterceptor.intercept - 信頼済みFS操作 | E-15 (L65-67) | ○ |
| C-105 | FileInterceptor.intercept - 読み取り許可 | E-15 (L147-148) | ○ |
| C-106 | FileInterceptor.intercept - 書き込み拒否 | E-15 (L166-168) | ○ |
| C-107 | FileInterceptor.intercept - 削除拒否 | E-15 (L171-173) | ○ |
| C-108 | FileInterceptor.intercept - copy双方向チェック | E-15 (L153-163) | ○ |
| C-109 | FileInterceptor.intercept - newByteChannel READ | E-15 (L103-131) | ○ |
| C-110 | FileInterceptor.intercept - newByteChannel WRITE | E-15 (L103-131, L145) | ○ |
| C-111 | FileInterceptor.intercept - String型パス | E-15 (L54-55) | ○ |
| C-112 | FileInterceptor.intercept - nullパスnoop | E-15 (L61-63) | ○ |
| C-113 | FileInterceptor.intercept - move操作分類 | E-15 (L73) | ○ |
| C-114 | FileInterceptor.intercept - createFile操作分類 | E-15 (L73: startsWith("create")) | ○ |
| C-115 | SystemExitInterceptor.intercept - ポリシー未設定noop | E-16 (L36-39) | ○ |
| C-116 | SystemExitInterceptor.intercept - 許可クラス | E-16 (L45) | ○ |
| C-117 | SystemExitInterceptor.intercept - 未許可でSecurityException | E-16 (L45-47) | ○ |
| C-118 | RuntimeHaltInterceptor.intercept - ポリシー未設定noop | E-17 (L36-39) | ○ |
| C-119 | RuntimeHaltInterceptor.intercept - 許可クラス | E-17 (L45) | ○ |
| C-120 | RuntimeHaltInterceptor.intercept - 未許可でSecurityException | E-17 (L45-47) | ○ |
| C-121 | SubjectInterceptor.intercept - Subject.current()返却 | E-18 (L30-32) | ○ |
| C-122 | SubjectInterceptor.intercept - null context処理 | E-18 (L30-32: accは使用されない) | ○ |
| C-123 | Agent.premain - エージェント初期化 | E-19 (L65-67) | △ |
| C-124 | Agent.agentmain - エージェント初期化 | E-19 (L75-77) | △ |

## 4) 不足情報（Unknown / Missing）
- Agent.premain/agentmainについては、ByteBuddyエージェントのインストール処理が含まれるため、純粋な単体テストとしてはモック化が必要。テストの実現可能性は実行環境に依存する。
  - 候補：ByteBuddyのMockInstrumentation / IntegrationTestとしての分類 / 既存AgentTests.javaの参照
- StackCallerProtectionDomainChainExtractorのdoPrivilegedチェーン切断テスト（C-93, C-94）はStackWalkerの実際のフレーム構築が必要であり、テスト設計時にdoPrivilegedを実際に呼び出す方法を検討する必要がある。
  - 候補：実際のdoPrivileged呼び出しによるテスト / リフレクションによるStream構築
- FileInterceptor内のWindows固有UNIXドメインソケット判定ロジック（sun.nio.ch.PipeImpl$Initializer$LoopbackConnector）はプラットフォーム依存であるため、テスト実行環境の制約がある。
  - 候補：@ConditionOnOSアノテーション / プラットフォーム非依存のモック化
- SocketChannelInterceptorおよびFileInterceptorのテストは、StackWalker.getInstance()を内部で使用するため、Adviceとしてのバイトコード変換後の動作はインテグレーションテストで確認が必要な場合がある。
  - 候補：既存テスト（E-20, E-21）パターンの踏襲

## 5) リスクフラグ（レビュー観点）
- 1: Agent.premain/agentmain（UT-AGS-123, 124）- ByteBuddyとInstrumentationの依存により、単体テストの実装難易度が高い
- 1: StackCallerProtectionDomainChainExtractor.apply（UT-AGS-093, 094）- StackWalkerフレームの構築が必要で、テスト実装が複雑
- 0: AgentPolicy関連テスト（UT-AGS-001〜024）- 直接的なメソッド呼び出しで検証可能、リスク低い
- 0: AccessController関連テスト（UT-AGS-025〜032）- 単純なデリゲーション、リスク低い
- 0: PolicyParser関連テスト（UT-AGS-042〜053）- 既存テスト（E-24）がありパターンが確立済み
- 0: PolicyFile関連テスト（UT-AGS-071〜084）- ファイルI/Oを伴うがモック化可能

## 6) レビュアーチェックリスト（最小）
- [ ] AgentPolicy.setPolicy()の二重設定防止テスト（UT-AGS-002）が、staticフィールドのリセット方法を考慮しているか確認
- [ ] CallerCanExit.applyのequalsIgnoreCase（UT-AGS-019）が実際のクラス名比較ロジックと一致しているか確認
- [ ] AnyCanExit.applyのmatches()（UT-AGS-023）がequalsIgnoreCaseではなく正規表現マッチであることを確認
- [ ] PolicyParser関連テスト（UT-AGS-042〜050）が既存テスト（PolicyParserTests.java）と重複・整合していることを確認
- [ ] FileInterceptorのnewByteChannel/open関連テスト（UT-AGS-109, 110）の引数パターンがソースコードの条件分岐と一致しているか確認
- [ ] Agent.premain/agentmain（UT-AGS-123, 124）を単体テストとして実装可能か、またはインテグレーションテストに分類すべきか判断
