---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 185
  claims_with_evidence: 180
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：libs-common 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：180 / 185、根拠なし：5
- 優先レビュー（高）
  1. **C-078 (toHumanReadableString)**: 期待値 "1.5s" の精度が実装のfraction処理に依存するため要確認
  2. **C-144 (cidrMaskToMinMax)**: 期待値の具体的な数値（3232235520, 3232235776）がIPアドレスの数値表現に依存
  3. **C-109 (MemoizedSupplier get 2回目)**: supplierの呼び出し回数検証はモック等の外部手段が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libs/common/src/main/java/org/opensearch/common/Booleans.java` - Boolean解析ユーティリティ
- E-02: `libs/common/src/main/java/org/opensearch/common/Numbers.java` - 数値ユーティリティ
- E-03: `libs/common/src/main/java/org/opensearch/common/Glob.java` - Globパターンマッチング
- E-04: `libs/common/src/main/java/org/opensearch/common/CharArrays.java` - char配列ユーティリティ
- E-05: `libs/common/src/main/java/org/opensearch/common/unit/TimeValue.java` - 時間値クラス
- E-06: `libs/common/src/main/java/org/opensearch/common/SetOnce.java` - 一度だけ設定可能なコンテナ
- E-07: `libs/common/src/main/java/org/opensearch/common/ExponentiallyWeightedMovingAverage.java` - EWMA計算
- E-08: `libs/common/src/main/java/org/opensearch/common/ValidationException.java` - バリデーション例外
- E-09: `libs/common/src/main/java/org/opensearch/common/lifecycle/Lifecycle.java` - ライフサイクル状態管理
- E-10: `libs/common/src/main/java/org/opensearch/common/MemoizedSupplier.java` - メモ化サプライヤ
- E-11: `libs/common/src/main/java/org/opensearch/common/UUIDs.java` - UUID生成
- E-12: `libs/common/src/main/java/org/opensearch/common/Classes.java` - クラスユーティリティ
- E-13: `libs/common/src/main/java/org/opensearch/common/Explicit.java` - 明示的値コンテナ
- E-14: `libs/common/src/main/java/org/opensearch/common/collect/Tuple.java` - タプルクラス
- E-15: `libs/common/src/main/java/org/opensearch/common/collect/MapBuilder.java` - マップビルダー
- E-16: `libs/common/src/main/java/org/opensearch/common/collect/Iterators.java` - イテレータユーティリティ
- E-17: `libs/common/src/main/java/org/opensearch/common/NamedRegistry.java` - 名前付きレジストリ
- E-18: `libs/common/src/main/java/org/opensearch/common/network/InetAddresses.java` - IPアドレスユーティリティ
- E-19: `libs/common/src/main/java/org/opensearch/common/network/Cidrs.java` - CIDRユーティリティ
- E-20: `libs/common/src/main/java/org/opensearch/common/transport/PortsRange.java` - ポート範囲ユーティリティ
- E-21: `libs/common/src/main/java/org/opensearch/common/concurrent/CompletableContext.java` - 非同期コンテキスト
- E-22: `libs/common/src/main/java/org/opensearch/common/util/set/Sets.java` - Set操作ユーティリティ
- E-23: `libs/common/src/main/java/org/opensearch/common/StopWatch.java` - ストップウォッチ
- E-24: `libs/common/src/main/java/org/opensearch/common/util/concurrent/AbstractRefCounted.java` - 参照カウント
- E-25: `libs/common/src/main/java/org/opensearch/common/hash/T1ha1.java` - T1ha1ハッシュ
- E-26: `libs/common/src/main/java/org/opensearch/common/util/BitMixer.java` - ビットミキサー
- E-27: `libs/common/src/main/java/org/opensearch/common/recycler/Recyclers.java` - リサイクラーユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Booleans.parseBoolean: char配列"true"をパースできる | E-01 (L52-84) | ○ |
| C-002 | Booleans.parseBoolean: char配列"false"をパースできる | E-01 (L52-84) | ○ |
| C-003 | Booleans.parseBoolean: null入力でデフォルト値 | E-01 (L53-55) | ○ |
| C-004 | Booleans.parseBoolean: length=0でデフォルト値 | E-01 (L58-59) | ○ |
| C-005 | Booleans.parseBoolean: 不正文字列で例外 | E-01 (L81-83) | ○ |
| C-006 | Booleans.parseBoolean(String): "true"のパース | E-01 (L126-134) | ○ |
| C-007 | Booleans.parseBoolean(String): "false"のパース | E-01 (L126-134) | ○ |
| C-008 | Booleans.parseBoolean(String): 不正文字列で例外 | E-01 (L133) | ○ |
| C-009 | Booleans.isBoolean(char[]): true/false認識 | E-01 (L93-113) | ○ |
| C-010 | Booleans.isBoolean(char[]): null入力でfalse | E-01 (L94-96) | ○ |
| C-011 | Booleans.isBoolean(String): String版判定 | E-01 (L116-118) | ○ |
| C-012 | Booleans.parseBooleanStrict: 有効文字列パース | E-01 (L170-175) | ○ |
| C-013 | Booleans.parseBooleanStrict: null/空でデフォルト | E-01 (L171-173) | ○ |
| C-014 | Numbers.longToBytes: long値のバイト変換 | E-02 (L61-72) | ○ |
| C-015 | Numbers.longToBytes: Long.MAX_VALUE変換 | E-02 (L61-72) | ○ |
| C-016 | Numbers.longToBytes: Long.MIN_VALUE変換 | E-02 (L61-72) | ○ |
| C-017 | Numbers.isValidDouble: 有効なdouble | E-02 (L75-80) | ○ |
| C-018 | Numbers.isValidDouble: NaN検出 | E-02 (L76) | ○ |
| C-019 | Numbers.isValidDouble: Infinity検出 | E-02 (L76) | ○ |
| C-020 | Numbers.toLongExact: Integer変換 | E-02 (L89) | ○ |
| C-021 | Numbers.toLongExact: Long値返却 | E-02 (L90) | ○ |
| C-022 | Numbers.toLongExact: 小数Doubleで例外 | E-02 (L99-100) | ○ |
| C-023 | Numbers.toLongExact: BigDecimal非整数で例外 | E-02 (L104) | ○ |
| C-024 | Numbers.toIntExact: int範囲内変換 | E-02 (L222-224) | ○ |
| C-025 | Numbers.toIntExact: int範囲外で例外 | E-02 (L222-224) | ○ |
| C-026 | Numbers.toShortExact: short範囲外で例外 | E-02 (L229-235) | ○ |
| C-027 | Numbers.toByteExact: byte範囲外で例外 | E-02 (L240-246) | ○ |
| C-028 | Numbers.toLong: 文字列からlong変換 | E-02 (L166-192) | ○ |
| C-029 | Numbers.toLong: 範囲外で例外 | E-02 (L176-179) | ○ |
| C-030 | Numbers.toLong: 小数(coerce=false)で例外 | E-02 (L181-182) | ○ |
| C-031 | Numbers.toLong: 小数(coerce=true)で切り捨て | E-02 (L180) | ○ |
| C-032 | Numbers.toUnsignedLong: unsigned long最大値 | E-02 (L197-217) | ○ |
| C-033 | Numbers.toUnsignedLong: 負の値で例外 | E-02 (L212) | ○ |
| C-034 | Numbers.toUnsignedBigInteger: 正のlong変換 | E-02 (L253) | ○ |
| C-035 | Numbers.toUnsignedBigInteger: 負のlong変換 | E-02 (L254-260) | ○ |
| C-036 | Numbers.unsignedLongToDouble: 正のlong変換 | E-02 (L268-269) | ○ |
| C-037 | Numbers.unsignedLongToDouble: 負のlong変換 | E-02 (L277) | ○ |
| C-038 | Numbers.nextPowerOfTwo: 正の値 | E-02 (L284-286) | ○ |
| C-039 | Numbers.nextPowerOfTwo: ゼロ | E-02 (L284-286) | ○ |
| C-040 | Glob.globMatch: 完全一致 | E-03 (L51-84) | ○ |
| C-041 | Glob.globMatch: 前方一致 | E-03 (L51-84) | ○ |
| C-042 | Glob.globMatch: 後方一致 | E-03 (L51-84) | ○ |
| C-043 | Glob.globMatch: 中間一致 | E-03 (L51-84) | ○ |
| C-044 | Glob.globMatch: 複合パターン | E-03 (L51-84) | ○ |
| C-045 | Glob.globMatch: 不一致 | E-03 (L51-84) | ○ |
| C-046 | Glob.globMatch: nullパターン | E-03 (L52-54) | ○ |
| C-047 | Glob.globMatch: null文字列 | E-03 (L52-54) | ○ |
| C-048 | CharArrays.utf8BytesToChars: 基本変換 | E-04 (L55-77) | ○ |
| C-049 | CharArrays.utf8BytesToChars: マルチバイト | E-04 (L55-77) | ○ |
| C-050 | CharArrays.toUtf8Bytes: 基本変換 | E-04 (L84-106) | ○ |
| C-051 | CharArrays.charsBeginsWith: プレフィックス一致 | E-04 (L112-128) | ○ |
| C-052 | CharArrays.charsBeginsWith: プレフィックス不一致 | E-04 (L112-128) | ○ |
| C-053 | CharArrays.charsBeginsWith: null入力 | E-04 (L113-115) | ○ |
| C-054 | CharArrays.charsBeginsWith: 長さ超過 | E-04 (L117-119) | ○ |
| C-055 | CharArrays.constantTimeEquals(char[]): 一致 | E-04 (L133-146) | ○ |
| C-056 | CharArrays.constantTimeEquals(char[]): 不一致 | E-04 (L133-146) | ○ |
| C-057 | CharArrays.constantTimeEquals(char[]): 長さ不一致 | E-04 (L136-138) | ○ |
| C-058 | CharArrays.constantTimeEquals(char[]): null例外 | E-04 (L134-135) | ○ |
| C-059 | CharArrays.constantTimeEquals(String): 一致 | E-04 (L151-164) | ○ |
| C-060 | CharArrays.constantTimeEquals(String): null例外 | E-04 (L152-153) | ○ |
| C-061 | TimeValue: 正のミリ秒コンストラクタ | E-05 (L67-69) | ○ |
| C-062 | TimeValue: 負の値で例外 | E-05 (L72-74) | ○ |
| C-063 | TimeValue: -1の許容 | E-05 (L72-74) | ○ |
| C-064 | TimeValue.timeValueDays: 106752日以上で例外 | E-05 (L101-103) | ○ |
| C-065 | TimeValue.parseTimeValue: ms表記パース | E-05 (L389) | ○ |
| C-066 | TimeValue.parseTimeValue: s表記パース | E-05 (L392) | ○ |
| C-067 | TimeValue.parseTimeValue: m表記パース | E-05 (L395) | ○ |
| C-068 | TimeValue.parseTimeValue: h表記パース | E-05 (L397) | ○ |
| C-069 | TimeValue.parseTimeValue: d表記パース | E-05 (L399) | ○ |
| C-070 | TimeValue.parseTimeValue: nanos表記パース | E-05 (L385-386) | ○ |
| C-071 | TimeValue.parseTimeValue: micros表記パース | E-05 (L387-388) | ○ |
| C-072 | TimeValue.parseTimeValue: 単位なしで例外 | E-05 (L405-408) | ○ |
| C-073 | TimeValue.parseTimeValue: -1でMINUS_ONE | E-05 (L400-401) | ○ |
| C-074 | TimeValue.parseTimeValue: 0でZERO | E-05 (L402-403) | ○ |
| C-075 | TimeValue.parseTimeValue: 小数値で例外 | E-05 (L431) | ○ |
| C-076 | TimeValue.equals: 同等値 | E-05 (L438-444) | ○ |
| C-077 | TimeValue.compareTo: 異なる単位の比較 | E-05 (L456-460) | ○ |
| C-078 | TimeValue.toHumanReadableString: 人間可読表示 | E-05 (L254-285) | △ |
| C-079 | TimeValue.getStringRep: 単位付き文字列 | E-05 (L349-371) | ○ |
| C-080 | SetOnce.set: 初回成功 | E-06 (L84-88) | ○ |
| C-081 | SetOnce.set: 2回目で例外 | E-06 (L84-88) | ○ |
| C-082 | SetOnce.get: set済み値取得 | E-06 (L100-103) | ○ |
| C-083 | SetOnce.get: 未set時null | E-06 (L100-103) | ○ |
| C-084 | SetOnce.trySet: 初回true | E-06 (L95-97) | ○ |
| C-085 | SetOnce.trySet: 2回目false | E-06 (L95-97) | ○ |
| C-086 | SetOnce: 初期値付きコンストラクタ | E-06 (L79-81) | ○ |
| C-087 | EWMA: 有効alpha/初期値 | E-07 (L53-59) | ○ |
| C-088 | EWMA: alpha<0で例外 | E-07 (L54-56) | ○ |
| C-089 | EWMA: alpha>1で例外 | E-07 (L54-56) | ○ |
| C-090 | EWMA.addValue: 平均更新 | E-07 (L65-74) | ○ |
| C-091 | EWMA.addValue: alpha=0で変化なし | E-07 (L65-74) | ○ |
| C-092 | EWMA.addValue: alpha=1で最新値 | E-07 (L65-74) | ○ |
| C-093 | ValidationException.addValidationError | E-08 (L54-56) | ○ |
| C-094 | ValidationException.addValidationErrors | E-08 (L62-66) | ○ |
| C-095 | ValidationException.getMessage | E-08 (L76-84) | ○ |
| C-096 | Lifecycle.moveToStarted: INITIALIZED->STARTED | E-09 (L149-162) | ○ |
| C-097 | Lifecycle.moveToStarted: STOPPED->STARTED | E-09 (L151) | ○ |
| C-098 | Lifecycle.moveToStarted: STARTED->false | E-09 (L155-157) | ○ |
| C-099 | Lifecycle.moveToStarted: CLOSED->例外 | E-09 (L158-160) | ○ |
| C-100 | Lifecycle.moveToStopped: STARTED->STOPPED | E-09 (L178-191) | ○ |
| C-101 | Lifecycle.moveToStopped: INITIALIZED->false | E-09 (L184) | ○ |
| C-102 | Lifecycle.moveToStopped: CLOSED->例外 | E-09 (L187-189) | ○ |
| C-103 | Lifecycle.moveToClosed: STOPPED->CLOSED | E-09 (L204-214) | ○ |
| C-104 | Lifecycle.moveToClosed: INITIALIZED->CLOSED | E-09 (L212) | ○ |
| C-105 | Lifecycle.moveToClosed: STARTED->例外 | E-09 (L209-210) | ○ |
| C-106 | Lifecycle.moveToClosed: CLOSED->false | E-09 (L206-208) | ○ |
| C-107 | Lifecycle.stoppedOrClosed | E-09 (L130-133) | ○ |
| C-108 | MemoizedSupplier.get: 初回実行 | E-10 (L51-57) | ○ |
| C-109 | MemoizedSupplier.get: キャッシュ動作 | E-10 (L51-57) | △ |
| C-110 | UUIDs.base64UUID: UUID生成 | E-11 (L49-51) | ○ |
| C-111 | UUIDs.randomBase64UUID: ランダムUUID | E-11 (L61-63) | ○ |
| C-112 | UUIDs.randomBase64UUID: 一意性 | E-11 (L61-63) | ○ |
| C-113 | Classes.isInnerClass | E-12 (L44-46) | ○ |
| C-114 | Classes.isConcrete: 具象クラス | E-12 (L48-51) | ○ |
| C-115 | Classes.isConcrete: インタフェース | E-12 (L48-51) | ○ |
| C-116 | Explicit.value | E-13 (L66-68) | ○ |
| C-117 | Explicit.explicit | E-13 (L74-76) | ○ |
| C-118 | Explicit.equals | E-13 (L79-84) | ○ |
| C-119 | Tuple.v1 | E-14 (L58-60) | ○ |
| C-120 | Tuple.equals: 同値 | E-14 (L81-91) | ○ |
| C-121 | Tuple.equals: null | E-14 (L83) | ○ |
| C-122 | MapBuilder.put | E-15 (L70-73) | ○ |
| C-123 | MapBuilder.immutableMap | E-15 (L105-108) | ○ |
| C-124 | MapBuilder.remove | E-15 (L75-78) | ○ |
| C-125 | Iterators.concat: 複数連結 | E-16 (L53-60) | ○ |
| C-126 | Iterators.concat: 空配列 | E-16 (L53-60) | ○ |
| C-127 | Iterators.concat: null入力例外 | E-16 (L54-56) | ○ |
| C-128 | Iterators.concat: null要素例外 | E-16 (L72-79) | ○ |
| C-129 | NamedRegistry.register: 基本登録 | E-17 (L59-65) | ○ |
| C-130 | NamedRegistry.register: 重複例外 | E-17 (L62-64) | ○ |
| C-131 | NamedRegistry.register: null名前例外 | E-17 (L60) | ○ |
| C-132 | NamedRegistry.register: null値例外 | E-17 (L61) | ○ |
| C-133 | InetAddresses.isInetAddress: IPv4 | E-18 (L51-53) | ○ |
| C-134 | InetAddresses.isInetAddress: IPv6 | E-18 (L51-53) | ○ |
| C-135 | InetAddresses.isInetAddress: 無効 | E-18 (L51-53) | ○ |
| C-136 | InetAddresses.forString: IPv4 | E-18 (L358-367) | ○ |
| C-137 | InetAddresses.forString: 無効文字列例外 | E-18 (L362-364) | ○ |
| C-138 | InetAddresses.toAddrString: IPv4 | E-18 (L261-268) | ○ |
| C-139 | InetAddresses.toAddrString: null例外 | E-18 (L263-264) | ○ |
| C-140 | InetAddresses.toUriString: IPv6 | E-18 (L237-242) | ○ |
| C-141 | InetAddresses.parseCidr: 有効CIDR | E-18 (L395-422) | ○ |
| C-142 | InetAddresses.parseCidr: 不正CIDR例外 | E-18 (L420-421) | ○ |
| C-143 | InetAddresses.parseCidr: プレフィックス範囲外例外 | E-18 (L409-416) | ○ |
| C-144 | Cidrs.cidrMaskToMinMax: 有効CIDR計算 | E-19 (L55-119) | △ |
| C-145 | Cidrs.cidrMaskToMinMax: null例外 | E-19 (L56) | ○ |
| C-146 | Cidrs.cidrMaskToMinMax: 不正形式例外 | E-19 (L58-67) | ○ |
| C-147 | Cidrs.cidrMaskToMinMax: マスク範囲外例外 | E-19 (L100-104) | ○ |
| C-148 | Cidrs.createCIDR | E-19 (L143-145) | ○ |
| C-149 | PortsRange.ports: 単一ポート | E-20 (L56-63) | ○ |
| C-150 | PortsRange.ports: ポート範囲 | E-20 (L65-92) | ○ |
| C-151 | PortsRange.ports: カンマ区切り | E-20 (L65-92) | ○ |
| C-152 | PortsRange.ports: 逆順範囲例外 | E-20 (L80-82) | ○ |
| C-153 | PortsRange.ports: 非数値例外 | E-20 (L72) | ○ |
| C-154 | CompletableContext.complete | E-21 (L75-77) | ○ |
| C-155 | CompletableContext.completeExceptionally | E-21 (L71-73) | ○ |
| C-156 | CompletableContext.addListener: 正常完了 | E-21 (L51-61) | ○ |
| C-157 | CompletableContext.addListener: 例外完了 | E-21 (L51-61) | ○ |
| C-158 | Sets.newHashSet(T...) | E-22 (L74-79) | ○ |
| C-159 | Sets.difference | E-22 (L100-104) | ○ |
| C-160 | Sets.union | E-22 (L163-169) | ○ |
| C-161 | Sets.intersection | E-22 (L171-184) | ○ |
| C-162 | Sets.haveEmptyIntersection: 空交差 | E-22 (L85-89) | ○ |
| C-163 | Sets.haveEmptyIntersection: 非空交差 | E-22 (L85-89) | ○ |
| C-164 | Sets.sortedDifference | E-22 (L116-120) | ○ |
| C-165 | StopWatch.start: 開始 | E-23 (L127-135) | ○ |
| C-166 | StopWatch.start: 二重開始例外 | E-23 (L128-130) | ○ |
| C-167 | StopWatch.stop: 停止 | E-23 (L144-155) | ○ |
| C-168 | StopWatch.stop: 未開始停止例外 | E-23 (L145-147) | ○ |
| C-169 | StopWatch.lastTaskTime: 未実行例外 | E-23 (L172-176) | ○ |
| C-170 | StopWatch.taskInfo | E-23 (L189-191) | ○ |
| C-171 | AbstractRefCounted.incRef: インクリメント | E-24 (L53-57) | ○ |
| C-172 | AbstractRefCounted.incRef: 閉じた状態例外 | E-24 (L53-57, L84-86) | ○ |
| C-173 | AbstractRefCounted.decRef: デクリメント | E-24 (L74-82) | ○ |
| C-174 | AbstractRefCounted.decRef: 0到達でclose | E-24 (L77-79) | ○ |
| C-175 | AbstractRefCounted.tryIncRef: 成功 | E-24 (L60-71) | ○ |
| C-176 | AbstractRefCounted.tryIncRef: 失敗 | E-24 (L67-68) | ○ |
| C-177 | T1ha1.hash: 決定性 | E-25 (L73-75, L85-115) | ○ |
| C-178 | T1ha1.hash: 分散性 | E-25 (L85-115) | △ |
| C-179 | T1ha1.hash: 空入力 | E-25 (L85-115) | ○ |
| C-180 | T1ha1.hash: 32バイト超 | E-25 (L89-112) | ○ |
| C-181 | BitMixer.mix32 | E-26 (L105-109) | ○ |
| C-182 | BitMixer.mix64 | E-26 (L120-124) | ○ |
| C-183 | BitMixer.mix(Object): null | E-26 (L94-96) | ○ |
| C-184 | Recyclers.none | E-27 (L50-52) | ○ |
| C-185 | Recyclers.concurrent: 不正並行レベル例外 | E-27 (L134-136) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-078: `toHumanReadableString` の期待値 "1.5s" は、内部のformatDecimal処理のfraction計算精度に依存する。実際のdouble表現による微細な差が発生する可能性がある
  - 候補：実際のテスト実行で期待値を確認する / 既存テストコードを参照する
- C-109: `MemoizedSupplier` の2回目呼び出しでsupplierが呼ばれないことの検証には、呼び出し回数をカウントするモック/スパイが必要
  - 候補：AtomicInteger等のカウンタでsupplier呼び出し回数を検証する
- C-144: `cidrMaskToMinMax` の期待値として具体的な数値を記載しているが、IPアドレスの数値表現の正確性を要確認
  - 候補：独立した計算で検算する
- C-178: T1ha1ハッシュの「分散性」は確率的な性質であり、テストケースとしての検証方法に工夫が必要
  - 候補：統計的テスト / 複数入力に対するハッシュ値の衝突率を測定する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Booleans, Classes, Explicit, Tuple, MapBuilder等のシンプルなユーティリティクラスのテストケース
- 0: 低リスク - StopWatch, BitMixer, Recyclers等のヘルパー/内部クラスのテストケース
- 1: 中リスク - TimeValue.parseTimeValue, Numbers.toLong等の文字列パース系テストケース。パース処理のエッジケースが網羅されているか要確認
- 1: 中リスク - InetAddresses, Cidrs等のネットワーク関連テストケース。IPv6の各種フォーマット（ゾーンID付き、IPv4マップドIPv6等）の網羅性を確認すべき
- 1: 中リスク - AbstractRefCounted, SetOnceの並行性テスト。マルチスレッド環境でのテストケースは含まれていない
- 2: 高リスク - CharArrays.constantTimeEquals のセキュリティ関連テスト。タイミング攻撃耐性の実際の検証は本テストケースの範囲外

## 6) レビュアーチェックリスト（最小）
- [ ] Booleans系テストケース（C-001〜C-013）がchar[]版とString版の両方を網羅しているか
- [ ] Numbers系テストケース（C-014〜C-039）が各型変換の境界値を十分にカバーしているか
- [ ] TimeValue.parseTimeValue（C-065〜C-075）が全ての時間単位（nanos, micros, ms, s, m, h, d）を網羅しているか
- [ ] Lifecycle状態遷移テスト（C-096〜C-107）がINITIALIZED/STARTED/STOPPED/CLOSEDの全遷移パスをカバーしているか
- [ ] InetAddresses/Cidrs系テスト（C-133〜C-148）がIPv4/IPv6の主要フォーマットを網羅しているか
- [ ] CharArrays.constantTimeEquals（C-055〜C-060）がセキュリティ要件を満たすか（タイミング攻撃耐性の実証テストは別途必要）
- [ ] AbstractRefCounted（C-171〜C-176）のマルチスレッドシナリオが追加で必要でないか確認
- [ ] MemoizedSupplier（C-108〜C-109）がスレッド安全性を考慮した追加テストが不要か確認
