---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 78
  claims_with_evidence: 76
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：libs-dissect 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：76 / 78、根拠なし：2
- 優先レビュー（高）
  1. **UT-DIS-025（マルチバイト文字対応）**：ソースコード上UTF-8処理は確認できるが、マルチバイト文字での動作保証の明示的な根拠なし
  2. **UT-DIS-065（getResults冪等性）**：results.clear()が呼ばれることはコードから確認できるが、冪等性の設計意図は明示されていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libs/dissect/src/main/java/org/opensearch/dissect/DissectParser.java` - メインパーサークラス（コンストラクタ、parse()メソッド、DissectPair内部クラス）
- E-02: `libs/dissect/src/main/java/org/opensearch/dissect/DissectKey.java` - キーモデルクラス（コンストラクタ、Modifier enum、ゲッター群）
- E-03: `libs/dissect/src/main/java/org/opensearch/dissect/DissectMatch.java` - マッチ結果クラス（add()、fullyMatched()、isValid()、getResults()、内部クラス群）
- E-04: `libs/dissect/src/main/java/org/opensearch/dissect/DissectException.java` - 例外クラス階層（PatternParse、KeyParse、FindMatch）
- E-05: `libs/dissect/src/test/java/org/opensearch/dissect/DissectParserTests.java` - 既存テストクラス（参考）
- E-06: `libs/dissect/src/test/java/org/opensearch/dissect/DissectKeyTests.java` - 既存テストクラス（参考）
- E-07: `libs/dissect/src/test/java/org/opensearch/dissect/DissectMatchTests.java` - 既存テストクラス（参考）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-DIS-001: 有効なパターンでインスタンス生成 | E-01 (L129-187) | ○ |
| C-02 | UT-DIS-002: appendSeparator null時の空文字変換 | E-01 (L131) | ○ |
| C-03 | UT-DIS-003: 先頭デリミタの認識 | E-01 (L132-135) | ○ |
| C-04 | UT-DIS-004: キーなしパターンでPatternParse例外 | E-01 (L147-149) | ○ |
| C-05 | UT-DIS-005: 空パターンでPatternParse例外 | E-01 (L147-149) | ○ |
| C-06 | UT-DIS-006: *修飾子ペア不足でPatternParse例外 | E-01 (L174-183) | ○ |
| C-07 | UT-DIS-007: 非修飾キーのAPPEND自動変換 | E-01 (L152-167) | ○ |
| C-08 | UT-DIS-008: 基本2キーパース | E-01 (L196-312) | ○ |
| C-09 | UT-DIS-009: 3キー異なるデリミタパース | E-01 (L196-312) | ○ |
| C-10 | UT-DIS-010: 先頭デリミタ付きパース | E-01 (L220-222) | ○ |
| C-11 | UT-DIS-011: 末尾デリミタなし時の残り値取得 | E-01 (L300-304) | ○ |
| C-12 | UT-DIS-012: ->修飾子で連続デリミタスキップ | E-01 (L266) | ○ |
| C-13 | UT-DIS-013: 連続デリミタで空値設定 | E-01 (L254-279) | ○ |
| C-14 | UT-DIS-014: +修飾子でappend操作 | E-01, E-03 (L90-91) | ○ |
| C-15 | UT-DIS-015: appendSeparator使用 | E-01 (L127), E-03 (L156) | ○ |
| C-16 | UT-DIS-016: /修飾子で順序付きappend | E-01, E-02 (L107-113), E-03 (L93-95) | ○ |
| C-17 | UT-DIS-017: *と&修飾子で参照操作 | E-01, E-03 (L97-101) | ○ |
| C-18 | UT-DIS-018: ?修飾子でスキップ | E-02 (L78-84), E-03 (L83-84) | ○ |
| C-19 | UT-DIS-019: 空キー名でスキップ | E-02 (L67, L76) | ○ |
| C-20 | UT-DIS-020: null入力でFindMatch例外 | E-01 (L220, L308-310) | ○ |
| C-21 | UT-DIS-021: 不一致入力でFindMatch例外 | E-01 (L308-310) | ○ |
| C-22 | UT-DIS-022: 空文字列入力でFindMatch例外 | E-01 (L220-222, L308-310) | ○ |
| C-23 | UT-DIS-023: 先頭デリミタ不一致でFindMatch例外 | E-01 (L222) | ○ |
| C-24 | UT-DIS-024: 先頭デリミタ同長入力でFindMatch例外 | E-01 (L221) | ○ |
| C-25 | UT-DIS-025: マルチバイト文字パース | E-01 (L223, L35) | △ |
| C-26 | UT-DIS-026: 修飾子なしキーのパース | E-02 (L70-77) | ○ |
| C-27 | UT-DIS-027: ->修飾子付きキーパース | E-02 (L53, L71-74) | ○ |
| C-28 | UT-DIS-028: +修飾子(APPEND)キーパース | E-02 (L86-92) | ○ |
| C-29 | UT-DIS-029: +と->の組合せパース | E-02 (L86-92) | ○ |
| C-30 | UT-DIS-030: +と/(APPEND_WITH_ORDER)パース | E-02 (L107-113) | ○ |
| C-31 | UT-DIS-031: *修飾子(FIELD_NAME)パース | E-02 (L93-98) | ○ |
| C-32 | UT-DIS-032: &修飾子(FIELD_VALUE)パース | E-02 (L100-106) | ○ |
| C-33 | UT-DIS-033: ?修飾子(NAMED_SKIP)パース | E-02 (L78-84) | ○ |
| C-34 | UT-DIS-034: 空キーでskip=true | E-02 (L67) | ○ |
| C-35 | UT-DIS-035: nullキーでskip=true | E-02 (L67) | ○ |
| C-36 | UT-DIS-036: 複数修飾子で例外 | E-02 (L209-211) | ○ |
| C-37 | UT-DIS-037: コピーコンストラクタの修飾子オーバーライド | E-02 (L127-133) | ○ |
| C-38 | UT-DIS-038: コピーコンストラクタの属性継承 | E-02 (L128-132) | ○ |
| C-39 | UT-DIS-039: toString出力 | E-02 (L157-169) | ○ |
| C-40 | UT-DIS-040: getModifierの動作 | E-02 (L135-137) | ○ |
| C-41 | UT-DIS-041: skip()の動作 | E-02 (L139-141) | ○ |
| C-42 | UT-DIS-042: skipRightPadding()の動作 | E-02 (L143-145) | ○ |
| C-43 | UT-DIS-043: getAppendPosition()の動作 | E-02 (L147-149) | ○ |
| C-44 | UT-DIS-044: getName()の動作 | E-02 (L151-153) | ○ |
| C-45 | UT-DIS-045: fromString有効値 | E-02 (L193-198) | ○ |
| C-46 | UT-DIS-046: fromString全修飾子変換 | E-02 (L193-198) | ○ |
| C-47 | UT-DIS-047: fromString無効値で例外 | E-02 (L198) | ○ |
| C-48 | UT-DIS-048: Modifier.toString()の動作 | E-02 (L183-186) | ○ |
| C-49 | UT-DIS-049: DissectMatchコンストラクタ正常 | E-03 (L60-73) | ○ |
| C-50 | UT-DIS-050: maxMatches=0で例外 | E-03 (L61-63) | ○ |
| C-51 | UT-DIS-051: maxResults=0で例外 | E-03 (L61-63) | ○ |
| C-52 | UT-DIS-052: NONE修飾子でsimpleResultsに追加 | E-03 (L87-88) | ○ |
| C-53 | UT-DIS-053: APPEND修飾子でappendResultsに追加 | E-03 (L90-91) | ○ |
| C-54 | UT-DIS-054: APPEND_WITH_ORDERで順序append | E-03 (L93-95) | ○ |
| C-55 | UT-DIS-055: FIELD_NAMEでreferenceキー設定 | E-03 (L97-98) | ○ |
| C-56 | UT-DIS-056: FIELD_VALUEでreference値設定 | E-03 (L100-101) | ○ |
| C-57 | UT-DIS-057: skipキーで結果に追加されない | E-03 (L82-84) | ○ |
| C-58 | UT-DIS-058: fullyMatchedでtrue | E-03 (L106-108) | ○ |
| C-59 | UT-DIS-059: fullyMatchedでfalse | E-03 (L106-108) | ○ |
| C-60 | UT-DIS-060: isValidでtrue | E-03 (L115-117) | ○ |
| C-61 | UT-DIS-061: isValidでfalse | E-03 (L115-117) | ○ |
| C-62 | UT-DIS-062: getResults統合結果 | E-03 (L124-137) | ○ |
| C-63 | UT-DIS-063: reference結果のMap変換 | E-03 (L130) | ○ |
| C-64 | UT-DIS-064: appendセパレータ結合 | E-03 (L133, L154-157) | ○ |
| C-65 | UT-DIS-065: getResults冪等性 | E-03 (L125) | △ |
| C-66 | UT-DIS-066: PatternParse例外メッセージ | E-04 (L47-49) | ○ |
| C-67 | UT-DIS-067: KeyParse例外メッセージ | E-04 (L55-58) | ○ |
| C-68 | UT-DIS-068: FindMatch例外メッセージ | E-04 (L64-68) | ○ |
| C-69 | UT-DIS-069: DissectExceptionの継承関係 | E-04 (L38) | ○ |
| C-70 | UT-DIS-070: PatternParseの継承関係 | E-04 (L46) | ○ |
| C-71 | UT-DIS-071: 1キーパターンのパース | E-01 (L196-312) | ○ |
| C-72 | UT-DIS-072: 1文字入力のパース | E-01 (L196-312) | ○ |
| C-73 | UT-DIS-073: 1文字デリミタのパース | E-01 (L196-312) | ○ |
| C-74 | UT-DIS-074: 複数文字デリミタのパース | E-01 (L240-248) | ○ |
| C-75 | UT-DIS-075: appendPosition=0のパース | E-02 (L107-113) | ○ |
| C-76 | UT-DIS-076: appendCount=0でnull初期化 | E-03 (L73) | ○ |
| C-77 | UT-DIS-077: referenceCount=0でnull初期化 | E-03 (L72) | ○ |
| C-78 | UT-DIS-078: maxMatches=1で正常動作 | E-03 (L60-73) | ○ |

## 4) 不足情報（Unknown / Missing）
- UT-DIS-025（マルチバイト文字対応）：ソースコードではStandardCharsets.UTF_8を使用してバイト配列に変換しているため、UTF-8マルチバイト文字は処理可能と推測されるが、明示的なマルチバイト文字対応のテストや設計ドキュメントは確認できなかった
  - 候補：既存テスト DissectParserTests.java / Javadocコメント / 設計ドキュメント
- UT-DIS-065（getResults冪等性）：results.clear()が呼ばれることはコードから確認できるが、複数回呼び出しの設計意図は明示されていない
  - 候補：DissectMatchの設計仕様 / 使用箇所の分析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 例外クラスのテストケース（UT-DIS-066〜070）は単純なメッセージフォーマットの確認であり、リスクは低い
- 1: 中リスク - DissectMatchの内部クラス（AppendResult, AppendValue, ReferenceResult）はprivateであり、直接テストできないため、DissectParser経由の統合的なテストが必要
- 0: 低リスク - DissectKeyのゲッターメソッド（UT-DIS-040〜044）は単純なフィールド返却であり、コンストラクタのテストで間接的にカバーされる

## 6) レビュアーチェックリスト（最小）
- [ ] DissectParserのparse()メソッドに対するテストケースが主要な修飾子（+, /, *, &, ?, ->）を全てカバーしているか
- [ ] 連続デリミタの処理（->修飾子あり/なし）が正しくテストされているか
- [ ] DissectKeyの各Modifier enumに対応するキーパースのテストが網羅されているか
- [ ] DissectMatchの内部状態管理（simpleResults, appendResults, referenceResults）のテストが十分か
- [ ] 例外系テスト（PatternParse, KeyParse, FindMatch）がエッジケースを含んでいるか
- [ ] マルチバイト文字対応のテストケース（UT-DIS-025）の期待結果が実際の動作と一致するか確認
