---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 132
  claims_with_evidence: 130
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：libs-geo 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：130 / 132、根拠なし：2
- 優先レビュー（高）
  1. **C-107（Geohash ラウンドトリップ精度）**：座標の近似一致の許容範囲が実装から直接読み取れない
  2. **C-108/C-109（Geohash getNeighbor 境界動作）**：level=1でのnull返却条件の正確なBase32文字マッピングが複雑

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libs/geo/src/main/java/org/opensearch/geometry/Circle.java`
- E-02: `libs/geo/src/main/java/org/opensearch/geometry/Point.java`
- E-03: `libs/geo/src/main/java/org/opensearch/geometry/Line.java`
- E-04: `libs/geo/src/main/java/org/opensearch/geometry/LinearRing.java`
- E-05: `libs/geo/src/main/java/org/opensearch/geometry/Polygon.java`
- E-06: `libs/geo/src/main/java/org/opensearch/geometry/Rectangle.java`
- E-07: `libs/geo/src/main/java/org/opensearch/geometry/GeometryCollection.java`
- E-08: `libs/geo/src/main/java/org/opensearch/geometry/MultiPoint.java`
- E-09: `libs/geo/src/main/java/org/opensearch/geometry/MultiLine.java`
- E-10: `libs/geo/src/main/java/org/opensearch/geometry/MultiPolygon.java`
- E-11: `libs/geo/src/main/java/org/opensearch/geometry/ShapeType.java`
- E-12: `libs/geo/src/main/java/org/opensearch/geometry/Geometry.java`
- E-13: `libs/geo/src/main/java/org/opensearch/geometry/GeometryVisitor.java`
- E-14: `libs/geo/src/main/java/org/opensearch/geometry/utils/BitUtil.java`
- E-15: `libs/geo/src/main/java/org/opensearch/geometry/utils/GeographyValidator.java`
- E-16: `libs/geo/src/main/java/org/opensearch/geometry/utils/Geohash.java`
- E-17: `libs/geo/src/main/java/org/opensearch/geometry/utils/GeometryValidator.java`
- E-18: `libs/geo/src/main/java/org/opensearch/geometry/utils/StandardValidator.java`
- E-19: `libs/geo/src/main/java/org/opensearch/geometry/utils/WellKnownText.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Circle: 高度なしで正常生成 | E-01 (L68-70) | ○ |
| C-02 | Circle: 高度付きで正常生成 | E-01 (L79-87) | ○ |
| C-03 | Circle: 負の半径でIllegalArgumentException | E-01 (L84-86) | ○ |
| C-04 | Circle: EMPTYでisEmpty=true | E-01 (L55-60, L199-201) | ○ |
| C-05 | Circle: 有効CircleでisEmpty=false | E-01 (L199-201) | ○ |
| C-06 | Circle: type=CIRCLE | E-01 (L93-95) | ○ |
| C-07 | Circle: equals同一 | E-01 (L152-161) | ○ |
| C-08 | Circle: equals異なる | E-01 (L152-161) | ○ |
| C-09 | Circle: null比較 | E-01 (L154) | ○ |
| C-10 | Circle: hashCode一致 | E-01 (L167-179) | ○ |
| C-11 | Circle: getLat/getLon/getAlt | E-01 (L128-144) | ○ |
| C-12 | Circle: visit | E-01 (L191-193), E-13 | ○ |
| C-13 | Point: 2D生成 | E-02 (L55-57) | ○ |
| C-14 | Point: 3D生成 | E-02 (L59-64) | ○ |
| C-15 | Point: EMPTYでisEmpty=true | E-02 (L48-53, L126-128) | ○ |
| C-16 | Point: type=POINT | E-02 (L67-69) | ○ |
| C-17 | Point: equals同一座標 | E-02 (L96-105) | ○ |
| C-18 | Point: EMPTYと非EMPTYの区別 | E-02 (L101) | ○ |
| C-19 | Line: 2D生成 | E-03 (L54-56) | ○ |
| C-20 | Line: 3D生成 | E-03 (L58-77) | ○ |
| C-21 | Line: y=nullでエラー | E-03 (L62-64) | ○ |
| C-22 | Line: x=nullでエラー | E-03 (L65-67) | ○ |
| C-23 | Line: x,y長さ不一致でエラー | E-03 (L68-70) | ○ |
| C-24 | Line: 1ポイントでエラー | E-03 (L71-73) | ○ |
| C-25 | Line: z長さ不一致でエラー | E-03 (L74-76) | ○ |
| C-26 | Line: getX/Y/Zがclone返却 | E-03 (L99-109) | ○ |
| C-27 | Line: z=nullでNaN返却 | E-03 (L91-97) | ○ |
| C-28 | Line: EMPTYでisEmpty=true | E-03 (L150-152) | ○ |
| C-29 | Line: type=LINESTRING | E-03 (L140-142) | ○ |
| C-30 | LinearRing: 閉じたリング正常生成 | E-04 (L47-49) | ○ |
| C-31 | LinearRing: 未閉環でエラー | E-04 (L57-74) | ○ |
| C-32 | LinearRing: 1ポイントでエラー | E-04 (L53-54), E-03 (L71-73) | ○ |
| C-33 | LinearRing: z未閉環でエラー | E-04 (L57) | ○ |
| C-34 | Polygon: 穴なし正常生成 | E-05 (L77-79) | ○ |
| C-35 | Polygon: 穴付き正常生成 | E-05 (L57-72) | ○ |
| C-36 | Polygon: holes=nullでエラー | E-05 (L60-62) | ○ |
| C-37 | Polygon: 外殻と穴の次元不一致でエラー | E-05 (L66-68) | ○ |
| C-38 | Polygon: 4点未満でエラー | E-05 (L86-89) | ○ |
| C-39 | Polygon: getHole範囲外でエラー | E-05 (L101-104) | ○ |
| C-40 | Polygon: EMPTYでisEmpty=true | E-05 (L112-115) | ○ |
| C-41 | Polygon: type=POLYGON | E-05 (L82-84) | ○ |
| C-42 | Rectangle: 2D正常生成 | E-06 (L82-84) | ○ |
| C-43 | Rectangle: 3D正常生成 | E-06 (L89-103) | ○ |
| C-44 | Rectangle: maxY<minYでエラー | E-06 (L97-99) | ○ |
| C-45 | Rectangle: 片方z指定でエラー | E-06 (L100-102) | ○ |
| C-46 | Rectangle: EMPTYでisEmpty=true | E-06 (L204-206) | ○ |
| C-47 | Rectangle: type=ENVELOPE | E-06 (L154-156) | ○ |
| C-48 | Rectangle: エイリアスメソッド | E-06 (L129-151) | ○ |
| C-49 | Rectangle: equals | E-06 (L164-177) | ○ |
| C-50 | GeometryCollection: 空コレクション | E-07 (L51-53) | ○ |
| C-51 | GeometryCollection: リスト付き生成 | E-07 (L55-66) | ○ |
| C-52 | GeometryCollection: null listでエラー | E-07 (L56-58) | ○ |
| C-53 | GeometryCollection: 空listでエラー | E-07 (L56-58) | ○ |
| C-54 | GeometryCollection: 次元混在でエラー | E-07 (L60-63) | ○ |
| C-55 | GeometryCollection: get | E-07 (L87-89) | ○ |
| C-56 | GeometryCollection: iterator | E-07 (L114-116) | ○ |
| C-57 | GeometryCollection: type | E-07 (L69-71) | ○ |
| C-58 | MultiPoint: 正常生成 | E-08 (L45-47) | ○ |
| C-59 | MultiPoint: type | E-08 (L50-52) | ○ |
| C-60 | MultiLine: 正常生成 | E-09 (L45-47) | ○ |
| C-61 | MultiPolygon: 正常生成 | E-10 (L45-47) | ○ |
| C-62 | ShapeType: forName小文字 | E-11 (L52-54) | ○ |
| C-63 | ShapeType: forName大文字 | E-11 (L52-54) | ○ |
| C-64 | ShapeType: forName不正名 | E-11 (L53) | ○ |
| C-65 | BitUtil: interleave 0,0 | E-14 (L54-69) | ○ |
| C-66 | BitUtil: interleave 1,1 | E-14 (L54-69) | ○ |
| C-67 | BitUtil: deinterleave | E-14 (L74-82) | ○ |
| C-68 | BitUtil: flipFlop | E-14 (L87-89) | ○ |
| C-69 | BitUtil: 境界値 | E-14 (L54-82) | ○ |
| C-70 | GeographyValidator: 有効座標通過 | E-15 (L111-193) | ○ |
| C-71 | GeographyValidator: 緯度>90でエラー | E-15 (L83-89) | ○ |
| C-72 | GeographyValidator: 緯度<-90でエラー | E-15 (L83-89) | ○ |
| C-73 | GeographyValidator: 緯度=90通過 | E-15 (L84) | ○ |
| C-74 | GeographyValidator: 緯度=-90通過 | E-15 (L84) | ○ |
| C-75 | GeographyValidator: 経度>180でエラー | E-15 (L94-100) | ○ |
| C-76 | GeographyValidator: 経度<-180でエラー | E-15 (L94-100) | ○ |
| C-77 | GeographyValidator: 経度=180通過 | E-15 (L95) | ○ |
| C-78 | GeographyValidator: 経度=-180通過 | E-15 (L95) | ○ |
| C-79 | GeographyValidator: 緯度NaNでエラー | E-15 (L84) | ○ |
| C-80 | GeographyValidator: ignoreZValue=true | E-15 (L102-108) | ○ |
| C-81 | GeographyValidator: ignoreZValue=false | E-15 (L102-108) | ○ |
| C-82 | GeographyValidator: Line全座標検証 | E-15 (L131-138) | ○ |
| C-83 | GeographyValidator: Polygon+穴検証 | E-15 (L174-180) | ○ |
| C-84 | GeographyValidator: コレクション検証 | E-15 (L123-128) | ○ |
| C-85 | GeographyValidator: Rectangle座標検証 | E-15 (L183-191) | ○ |
| C-86 | StandardValidator: ignoreZ=true通過 | E-18 (L68-140) | ○ |
| C-87 | StandardValidator: ignoreZ=falseでエラー | E-18 (L59-65) | ○ |
| C-88 | StandardValidator: z=NaN通過 | E-18 (L60) | ○ |
| C-89 | StandardValidator: ignoreZ=trueでスキップ | E-18 (L69) | ○ |
| C-90 | Geohash: stringEncode基本 | E-16 (L289-291) | ○ |
| C-91 | Geohash: stringEncode精度指定 | E-16 (L296-302) | ○ |
| C-92 | Geohash: toPoint | E-16 (L118-121) | ○ |
| C-93 | Geohash: mortonEncode | E-16 (L345-364) | ○ |
| C-94 | Geohash: mortonEncode空文字 | E-16 (L346-348) | ○ |
| C-95 | Geohash: mortonEncode不正文字 | E-16 (L354-356) | ○ |
| C-96 | Geohash: toBoundingBox | E-16 (L129-154) | ○ |
| C-97 | Geohash: getSubGeohashes | E-16 (L157-164) | ○ |
| C-98 | Geohash: getNeighbors | E-16 (L172-214) | ○ |
| C-99 | Geohash: longEncode(double,double,int) | E-16 (L280-284) | ○ |
| C-100 | Geohash: encodeLatitude | E-16 (L384-390) | ○ |
| C-101 | Geohash: encodeLatitude境界90 | E-16 (L386-388) | ○ |
| C-102 | Geohash: encodeLongitude境界180 | E-16 (L394-398) | ○ |
| C-103 | Geohash: decodeLatitude(String) | E-16 (L402-404) | ○ |
| C-104 | Geohash: decodeLongitude(String) | E-16 (L407-409) | ○ |
| C-105 | Geohash: lonWidthInDegrees | E-16 (L367-369) | ○ |
| C-106 | Geohash: latHeightInDegrees | E-16 (L372-374) | ○ |
| C-107 | Geohash: エンコード/デコード往復一致 | E-16 | △ |
| C-108 | Geohash: 南端隣接null | E-16 (L241-249) | ○ |
| C-109 | Geohash: 北端隣接null | E-16 (L245-246) | △ |
| C-110 | WKT: Point WKTシリアライズ | E-19 (L179-188) | ○ |
| C-111 | WKT: 空Point EMPTY | E-19 (L95-96) | ○ |
| C-112 | WKT: Line WKT | E-19 (L130-140) | ○ |
| C-113 | WKT: Polygon WKT | E-19 (L212-222) | ○ |
| C-114 | WKT: Circle WKT | E-19 (L100-111) | ○ |
| C-115 | WKT: Rectangle WKT | E-19 (L225-248) | ○ |
| C-116 | WKT: LinearRing非対応 | E-19 (L143-145) | ○ |
| C-117 | WKT: fromWKT Point | E-19 (L373-387) | ○ |
| C-118 | WKT: fromWKT Line | E-19 (L429-443) | ○ |
| C-119 | WKT: fromWKT Polygon | E-19 (L472-497) | ○ |
| C-120 | WKT: fromWKT MultiPoint | E-19 (L409-427) | ○ |
| C-121 | WKT: fromWKT GeometryCollection | E-19 (L317-371) | ○ |
| C-122 | WKT: fromWKT EMPTY | E-19 (L374-376) | ○ |
| C-123 | WKT: 不正ジオメトリ型 | E-19 (L314) | ○ |
| C-124 | WKT: fromWKT BBOX | E-19 (L531-545) | ○ |
| C-125 | WKT: fromWKT Circle | E-19 (L547-561) | ○ |
| C-126 | WKT: 自動閉環 | E-19 (L503-516) | ○ |
| C-127 | WKT: 3DPointパース | E-19 (L380-382) | ○ |
| C-128 | WKT: MultiLineStringパース | E-19 (L445-456) | ○ |
| C-129 | WKT: MultiPolygonパース | E-19 (L518-529) | ○ |
| C-130 | WKT: ラウンドトリップ | E-19 | ○ |
| C-131 | WKT: ネスト深度制約 | E-19 (L350-354) | ○ |
| C-132 | WKT: 不正数値パース | E-19 (L586-594) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-107: Geohashのエンコード/デコードラウンドトリップにおける近似一致の精度許容範囲が、ソースコードの数値定数（LAT_DECODE, LON_DECODE等）から計算可能だが、期待結果の具体的な許容誤差を明示的に定義していない
  - 候補：既存テストコード / Geohash精度仕様書 / Luceneのドキュメント
- C-109: "z"がy=3のグループに属するかどうかのBase32テーブルからの判定が複雑で、入力値"z"で北端隣接がnullになるかの確認にはBase32マッピングの詳細検証が必要
  - 候補：Geohash仕様書 / 既存テストコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ジオメトリクラスのコンストラクタ・getter・equals/hashCodeテスト（C-01〜C-61）はソースコードと直接対応
- 0: 低リスク - ShapeType enumテスト（C-62〜C-64）は単純な列挙型テスト
- 0: 低リスク - BitUtilテスト（C-65〜C-69）はビット演算の確認でソースコードと直接対応
- 1: 中リスク - GeographyValidator/StandardValidatorテスト（C-70〜C-89）は複数ジオメトリ型のバリデーションを含むため組み合わせが必要
- 1: 中リスク - Geohashテスト（C-90〜C-109）はエンコーディング精度と境界条件に注意が必要
- 0: 低リスク - WellKnownTextテスト（C-110〜C-132）はWKTシリアライズ/デシリアライズの標準的テスト

## 6) レビュアーチェックリスト（最小）
- [ ] GeographyValidatorの境界値テスト（C-73, C-74, C-77, C-78）が正しく閉区間（<=, >=）で判定されているか確認
- [ ] Geohashのラウンドトリップテスト（C-107）で許容誤差が適切に設定されているか確認
- [ ] GeohashのgetNeighborテスト（C-108, C-109）で使用するBase32文字が境界条件を正しく表しているか確認
- [ ] WellKnownTextのネスト深度テスト（C-131）が実行時間の観点で妥当か確認
- [ ] LinearRingのバリデーションテスト（C-31〜C-33）で3D座標の閉環条件が漏れなくカバーされているか確認
- [ ] Polygonの4点未満テスト（C-38）がLinearRing（最低2点制約）との関係で正しい入力値を使用しているか確認
