---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 76
  claims_with_evidence: 74
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：libs-grok 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：74 / 76、根拠なし：2
- 優先レビュー（高）
  1. **C-22 (UT-GRK-022)**: MAX_TO_REGEX_ITERATIONS超過時のテストケース - 実際に100,000回の反復を発生させるパターン構成の実現可能性が要確認
  2. **C-27 (UT-GRK-027)**: captureAllMatches=trueで同名キャプチャのリスト化テスト - 実際のGrokパターンで同名キャプチャが複数発生するケースの構成方法が要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libs/grok/src/main/java/org/opensearch/grok/Grok.java` - メインGrokクラス（コンストラクタ、match、captures、toRegex、validatePatternBank、BUILTIN_PATTERNS）
- E-02: `libs/grok/src/main/java/org/opensearch/grok/GrokCaptureConfig.java` - キャプチャ設定クラス（name、type、objectExtracter、nativeExtracter、NativeExtracterMap）
- E-03: `libs/grok/src/main/java/org/opensearch/grok/GrokCaptureExtracter.java` - キャプチャ抽出クラス（MapExtracter、extract、result）
- E-04: `libs/grok/src/main/java/org/opensearch/grok/GrokCaptureType.java` - キャプチャ型列挙（STRING、INTEGER、LONG、FLOAT、DOUBLE、BOOLEAN、fromString、rawExtracter）
- E-05: `libs/grok/src/main/java/org/opensearch/grok/MatcherWatchdog.java` - マッチャー監視インターフェース（Noop、Default、register、unregister、interruptLongRunningExecutions）
- E-06: `libs/grok/src/main/java/org/opensearch/grok/FloatConsumer.java` - FloatConsumer関数インターフェース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Grokコンストラクタで有効なパターンバンクとgrokパターンからインスタンス生成 | E-01 (L104-157) | ○ |
| C-02 | 存在しないパターン参照でIllegalArgumentException | E-01 (L325-327) | ○ |
| C-03 | 循環参照パターンでIllegalArgumentException | E-01 (L177-243, L261-276) | ○ |
| C-04 | 自己参照パターンでIllegalArgumentException | E-01 (L215-216, L328-329) | ○ |
| C-05 | 閉じ括弧なしの不正構文でIllegalArgumentException | E-01 (L206-208) | ○ |
| C-06 | match()がマッチするテキストにtrueを返す | E-01 (L358-368) | ○ |
| C-07 | match()がマッチしないテキストにfalseを返す | E-01 (L358-368) | ○ |
| C-08 | match()が空文字列を適切に処理 | E-01 (L358-368) | ○ |
| C-09 | captures()がマッチ結果をMapで返す | E-01 (L376-383) | ○ |
| C-10 | captures()が複数キャプチャを抽出 | E-01 (L376-383), E-03 | ○ |
| C-11 | captures()がマッチ失敗時にnullを返す | E-01 (L382) | ○ |
| C-12 | 型指定(int)キャプチャの型変換 | E-01, E-04 (L52-56) | ○ |
| C-13 | 型指定(float)キャプチャの型変換 | E-01, E-04 (L64-68) | ○ |
| C-14 | byte配列版match()でマッチしてtrue | E-01 (L394-413) | ○ |
| C-15 | byte配列版match()でマッチ失敗しfalse | E-01 (L408-409) | ○ |
| C-16 | タイムアウト時RuntimeException | E-01 (L403-406) | ○ |
| C-17 | captureConfig()がリストを返す | E-01 (L418-420) | ○ |
| C-18 | 名前付きキャプチャなしで空リスト | E-01 (L152-156) | ○ |
| C-19 | toRegex()がgrokパターンを正規表現に変換 | E-01 (L299-350) | ○ |
| C-20 | namedCaptures=trueでサブネームなしは非キャプチャグループ | E-01 (L334-335) | ○ |
| C-21 | namedCaptures=falseでパターン名_位置のグループ名 | E-01 (L336-337) | ○ |
| C-22 | MAX_TO_REGEX_ITERATIONS超過でIllegalArgumentException | E-01 (L301, L349) | △ |
| C-23 | BUILTIN_PATTERNSが正常にロード | E-01 (L69, L425-458) | ○ |
| C-24 | BUILTIN_PATTERNSにNUMBERが含まれる | E-01 (L425-458) | ○ |
| C-25 | BUILTIN_PATTERNSが不変 | E-01 (L457) | ○ |
| C-26 | パターン深度500超過でIllegalArgumentException | E-01 (L239-241) | ○ |
| C-27 | captureAllMatches=trueで同名キャプチャがリスト化 | E-01 (L132, L137), E-03 (L62-74) | △ |
| C-28 | GrokCaptureConfig.name()がフィールド名を返す | E-02 (L53-55, L63-65) | ○ |
| C-29 | サブネームなしでパターン名が返る | E-02 (L55) | ○ |
| C-30 | 型指定ありで正しいGrokCaptureType | E-02 (L56) | ○ |
| C-31 | 型指定なしでSTRINGが返る | E-02 (L56) | ○ |
| C-32 | objectExtracterでString値がConsumerに渡る | E-02 (L83-85) | ○ |
| C-33 | objectExtracterでInteger値がボクシングされる | E-02 (L88-90) | ○ |
| C-34 | objectExtracterでLong値がボクシングされる | E-02 (L93-95) | ○ |
| C-35 | objectExtracterでFloat値がボクシングされる | E-02 (L98-100) | ○ |
| C-36 | objectExtracterでDouble値がボクシングされる | E-02 (L103-105) | ○ |
| C-37 | objectExtracterでBoolean値が渡される | E-02 (L108-110) | ○ |
| C-38 | nativeExtracterが型に応じたメソッドを呼ぶ | E-02 (L132-134) | ○ |
| C-39 | fromString("string")でSTRING | E-04 (L87-88) | ○ |
| C-40 | fromString("int")でINTEGER | E-04 (L89-90) | ○ |
| C-41 | fromString("long")でLONG | E-04 (L91-92) | ○ |
| C-42 | fromString("float")でFLOAT | E-04 (L93-94) | ○ |
| C-43 | fromString("double")でDOUBLE | E-04 (L95-96) | ○ |
| C-44 | fromString("boolean")でBOOLEAN | E-04 (L97-98) | ○ |
| C-45 | 未知の型文字列でSTRINGフォールバック | E-04 (L99-101) | ○ |
| C-46 | rawExtracterがマッチ領域からString抽出 | E-04 (L104-121) | ○ |
| C-47 | captureAllMatches=falseで最初のマッチのみ | E-04 (L114-116) | ○ |
| C-48 | captureAllMatches=trueで全マッチ | E-04 (L113-116) | ○ |
| C-49 | region.getBeg < 0でemit呼ばれない | E-04 (L109) | ○ |
| C-50 | INTEGER.nativeExtracterで文字列をInteger変換 | E-04 (L54-55) | ○ |
| C-51 | INTEGER変換でNumberFormatException | E-04 (L55) | ○ |
| C-52 | FLOAT.nativeExtracterで文字列をFloat変換 | E-04 (L66-67) | ○ |
| C-53 | BOOLEAN.nativeExtracterで文字列をBoolean変換 | E-04 (L79) | ○ |
| C-54 | 空captureConfigで空Map初期化 | E-03 (L57) | ○ |
| C-55 | captureConfigに基づいてfieldExtracter生成 | E-03 (L58-76) | ○ |
| C-56 | extract()でresultマップに格納 | E-03 (L80-84) | ○ |
| C-57 | 同名フィールド複数キャプチャでList変換 | E-03 (L62-74) | ○ |
| C-58 | result()が抽出後Mapを返す | E-03 (L86-88) | ○ |
| C-59 | MatcherWatchdog.noop()がNoopを返す | E-05 (L98-100) | ○ |
| C-60 | Noop.register()が何も行わない | E-05 (L109) | ○ |
| C-61 | Noop.unregister()が何も行わない | E-05 (L116) | ○ |
| C-62 | Noop.maxExecutionTimeInMillis()がLong.MAX_VALUE | E-05 (L112-113) | ○ |
| C-63 | newInstance()でDefaultインスタンス生成 | E-05 (L86-93) | ○ |
| C-64 | Default.register()でregistryに登録 | E-05 (L137-144) | ○ |
| C-65 | 初回register時にスケジューラ起動 | E-05 (L140-141) | ○ |
| C-66 | Default.unregister()でregistryから削除 | E-05 (L151-155) | ○ |
| C-67 | Default.maxExecutionTimeInMillis()が設定値を返す | E-05 (L147-149) | ○ |
| C-68 | 実行時間超過Matcherがinterruptされる | E-05 (L157-164) | ○ |
| C-69 | 実行時間内Matcherはinterruptされない | E-05 (L160) | ○ |
| C-70 | 登録0件でrunningがfalseに設定 | E-05 (L165-168) | ○ |
| C-71 | 登録残存時にスケジューラ再スケジュール | E-05 (L165-166) | ○ |
| C-72 | FloatConsumer.accept()でfloat値消費 | E-06 (L45) | ○ |
| C-73 | UTF-8マルチバイト文字のマッチ処理 | E-01 (L359) | ○ |
| C-74 | 型指定(long)キャプチャの変換 | E-04 (L58-62) | ○ |
| C-75 | 型指定(double)キャプチャの変換 | E-04 (L70-74) | ○ |
| C-76 | 型指定(boolean)キャプチャの変換 | E-04 (L76-80) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-22: MAX_TO_REGEX_ITERATIONS(100,000回)を実際に超過させるパターンの構成は理論上可能だが、テストで再現可能かは要確認。コード上の定数(L95)とループ条件(L301)から例外発生のロジックは確認済み。
  - 候補：極端に深いネストパターン / 自己展開しないが繰り返し参照されるパターン
- C-27: captureAllMatches=trueでの同名フィールドのリスト化は、MapExtracter内のロジック(E-03 L62-74)で確認済みだが、同名キャプチャを複数生成するGrokパターンの具体例は要確認。
  - 候補：同名のサブネームを持つ複数のGrokパターンを組み合わせるケース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - FloatConsumer(関数インターフェースのみで実質テスト不要に近い)
- 0: 低リスク - Noop実装(処理なしのため誤動作リスクが低い)
- 1: 中リスク - GrokCaptureType.fromString()のデフォルト戻り値がSTRINGである点(未知の型を黙って受け入れる)
- 1: 中リスク - rawExtracterでoffset計算がregion.getBeg()の値に依存する点(オフセット計算の正確性)
- 2: 高リスク - MatcherWatchdog.Defaultのスレッド安全性(ConcurrentHashMapとAtomicBooleanの組み合わせに競合条件がないか)

## 6) レビュアーチェックリスト（最小）
- [ ] GrokCaptureType.fromString()の未知型文字列に対するSTRINGフォールバックが意図通りか確認
- [ ] MatcherWatchdog.Default.register/unregisterのスレッド安全性が十分か確認
- [ ] validatePatternBankの循環参照検出アルゴリズムが全ケースをカバーしているか確認
- [ ] MAX_TO_REGEX_ITERATIONS(100,000)の上限値が実用上適切か確認
- [ ] MAX_PATTERN_DEPTH_SIZE(500)の深度制限が実用上適切か確認
- [ ] captureAllMatches=trueの場合の同名キャプチャリスト化の挙動が期待通りか確認
