---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 163
  claims_with_evidence: 163
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libs-nio 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：163 / 163、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースがソースコードに基づいて生成されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libs/nio/src/main/java/org/opensearch/nio/InboundChannelBuffer.java` - ページベースのバッファ管理クラス（ensureCapacity, release, sliceBuffersTo, sliceBuffersFrom, sliceAndRetainPagesTo, incrementIndex, close, getRemaining, allocatingInstance）
- E-02: `libs/nio/src/main/java/org/opensearch/nio/FlushOperation.java` - フラッシュ操作クラス（isFullyFlushed, incrementIndex, getBuffersToWrite, getListener）
- E-03: `libs/nio/src/main/java/org/opensearch/nio/FlushReadyWrite.java` - フラッシュ準備済み書き込みクラス（getChannel, getObject）
- E-04: `libs/nio/src/main/java/org/opensearch/nio/Page.java` - 参照カウント付きByteBufferラッパー（byteBuffer, duplicate, close）
- E-05: `libs/nio/src/main/java/org/opensearch/nio/BytesWriteHandler.java` - バイト書き込みハンドラ（createWriteOperation, writeToBytes, pollFlushOperations, closeNow）
- E-06: `libs/nio/src/main/java/org/opensearch/nio/BytesChannelContext.java` - バイトチャネルコンテキスト（read, flushChannel, closeChannel, selectorShouldClose）
- E-07: `libs/nio/src/main/java/org/opensearch/nio/ChannelContext.java` - チャネルコンテキスト基底クラス（closeFromSelector, addCloseListener, isOpen, handleException）
- E-08: `libs/nio/src/main/java/org/opensearch/nio/Config.java` - TCP設定クラス（Config, Config.Socket, Config.ServerSocket）
- E-09: `libs/nio/src/main/java/org/opensearch/nio/DelegatingHandler.java` - 委譲ハンドラ（channelActive, createWriteOperation, writeToBytes, consumeReads, closeNow, close）
- E-10: `libs/nio/src/main/java/org/opensearch/nio/EventHandler.java` - イベントハンドラ（acceptChannel, handleRegistration, handleActive, handleConnect, handleRead, handleWrite, postHandling, handleClose, handleTask等）
- E-11: `libs/nio/src/main/java/org/opensearch/nio/NioSelector.java` - NIOセレクタ（isOpen, queueWrite, scheduleForRegistration, queueChannelClose, runLoop, close, getIoBuffer等）
- E-12: `libs/nio/src/main/java/org/opensearch/nio/NioServerSocketChannel.java` - サーバソケットチャネル（setContext, getRawChannel, getContext）
- E-13: `libs/nio/src/main/java/org/opensearch/nio/NioSocketChannel.java` - ソケットチャネル（setContext, getRawChannel, getContext）
- E-14: `libs/nio/src/main/java/org/opensearch/nio/NioChannel.java` - チャネル基底クラス（isOpen, close, addCloseListener）
- E-15: `libs/nio/src/main/java/org/opensearch/nio/SocketChannelContext.java` - ソケットチャネルコンテキスト（sendMessage, connect, isConnectComplete, readyForFlush, closeFromSelector, handleReadBytes, closeNow等）
- E-16: `libs/nio/src/main/java/org/opensearch/nio/ServerChannelContext.java` - サーバチャネルコンテキスト（acceptChannels, register, closeChannel, addBindListener）
- E-17: `libs/nio/src/main/java/org/opensearch/nio/ChannelFactory.java` - チャネルファクトリ（openNioChannel, acceptNioChannel, openNioServerSocketChannel, getRemoteAddress）
- E-18: `libs/nio/src/main/java/org/opensearch/nio/TaskScheduler.java` - タスクスケジューラ（scheduleAtRelativeTime, pollTask, nanosUntilNextTask）
- E-19: `libs/nio/src/main/java/org/opensearch/nio/RoundRobinSupplier.java` - ラウンドロビンサプライヤ（get, setSelectors, count）
- E-20: `libs/nio/src/main/java/org/opensearch/nio/SelectionKeyUtils.java` - SelectionKeyユーティリティ（setWriteInterested, removeWriteInterested等）
- E-21: `libs/nio/src/main/java/org/opensearch/nio/utils/ByteBufferUtils.java` - バイトバッファユーティリティ（copyBytes）
- E-22: `libs/nio/src/main/java/org/opensearch/nio/utils/ExceptionsHelper.java` - 例外ヘルパー（rethrowAndSuppress）
- E-23: `libs/nio/src/main/java/org/opensearch/nio/NioSelectorGroup.java` - セレクタグループ（bindServerChannel, openChannel, close）
- E-24: `libs/nio/src/main/java/org/opensearch/nio/NioChannelHandler.java` - チャネルハンドラインターフェース
- E-25: `libs/nio/src/main/java/org/opensearch/nio/WriteOperation.java` - 書き込み操作インターフェース
- E-26: `libs/nio/src/main/java/org/opensearch/nio/NioGroup.java` - グループインターフェース

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InboundChannelBuffer.ensureCapacity: 容量未満時ページ追加なし | E-01 (L92-105) | ○ |
| C-02 | InboundChannelBuffer.ensureCapacity: 容量超過時ページ追加 | E-01 (L92-105) | ○ |
| C-03 | InboundChannelBuffer.ensureCapacity: クローズ済みでIllegalStateException | E-01 (L93-95) | ○ |
| C-04 | InboundChannelBuffer.release: ページ解放 | E-01 (L113-125) | ○ |
| C-05 | InboundChannelBuffer.release: 容量超過でIllegalArgumentException | E-01 (L114-116) | ○ |
| C-06 | InboundChannelBuffer.release: index切り詰め | E-01 (L123) | ○ |
| C-07 | InboundChannelBuffer.incrementIndex: 正常増加 | E-01 (L241-261) | ○ |
| C-08 | InboundChannelBuffer.incrementIndex: 負値でIllegalArgumentException | E-01 (L242-244) | ○ |
| C-09 | InboundChannelBuffer.incrementIndex: 容量超過でIllegalArgumentException | E-01 (L247-259) | ○ |
| C-10 | InboundChannelBuffer.sliceBuffersTo: 正常スライス | E-01 (L136-164) | ○ |
| C-11 | InboundChannelBuffer.sliceBuffersTo: to=0で空配列 | E-01 (L141-143) | ○ |
| C-12 | InboundChannelBuffer.sliceBuffersTo: 容量超過でIndexOutOfBoundsException | E-01 (L137-140) | ○ |
| C-13 | InboundChannelBuffer.sliceBuffersFrom: 正常スライス | E-01 (L216-239) | ○ |
| C-14 | InboundChannelBuffer.sliceBuffersFrom: from=capacityで空配列 | E-01 (L222-223) | ○ |
| C-15 | InboundChannelBuffer.sliceBuffersFrom: 容量超過でIndexOutOfBoundsException | E-01 (L217-220) | ○ |
| C-16 | InboundChannelBuffer.sliceAndRetainPagesTo: 参照カウント増加 | E-01 (L176-205) | ○ |
| C-17 | InboundChannelBuffer.sliceAndRetainPagesTo: to=0で空配列 | E-01 (L182-183) | ○ |
| C-18 | InboundChannelBuffer.close: 全ページ解放 | E-01 (L77-90) | ○ |
| C-19 | InboundChannelBuffer.close: 複数回close安全 | E-01 (L78) | ○ |
| C-20 | InboundChannelBuffer.getRemaining: 残量計算 | E-01 (L271-275) | ○ |
| C-21 | InboundChannelBuffer.allocatingInstance: ファクトリメソッド | E-01 (L72-74) | ○ |
| C-22 | FlushOperation.isFullyFlushed: フラッシュ完了判定 | E-02 (L66-73) | ○ |
| C-23 | FlushOperation.isFullyFlushed: 未完了判定 | E-02 (L66-73) | ○ |
| C-24 | FlushOperation.incrementIndex: インデックス増加 | E-02 (L75-84) | ○ |
| C-25 | FlushOperation.getBuffersToWrite: バッファ取得 | E-02 (L86-120) | ○ |
| C-26 | FlushOperation.getBuffersToWrite(maxBytes): サイズ制限 | E-02 (L90-120) | ○ |
| C-27 | FlushOperation.getBuffersToWrite: 完了後空配列 | E-02 (L101-103) | ○ |
| C-28 | FlushOperation.getListener: リスナー取得 | E-02 (L62-64) | ○ |
| C-29 | FlushReadyWrite.getChannel: コンテキスト取得 | E-03 (L50-52) | ○ |
| C-30 | FlushReadyWrite.getObject: オブジェクト取得 | E-03 (L55-57) | ○ |
| C-31 | Page.byteBuffer: バッファ取得 | E-04 (L79-81) | ○ |
| C-32 | Page.duplicate: 複製と参照カウント増加 | E-04 (L68-71) | ○ |
| C-33 | Page.duplicate: 独立close | E-04 (L68-71, L84-86) | ○ |
| C-34 | Page.close: closeable実行 | E-04 (L84-86) | ○ |
| C-35 | Page.close: 片方closeでcloseable未実行 | E-04 (L68-71, L88-101) | ○ |
| C-36 | BytesWriteHandler.createWriteOperation: FlushReadyWrite生成 | E-05 (L44-51) | ○ |
| C-37 | BytesWriteHandler.writeToBytes: FlushOperation変換 | E-05 (L57-60) | ○ |
| C-38 | BytesWriteHandler.pollFlushOperations: 空リスト | E-05 (L63-65) | ○ |
| C-39 | BytesWriteHandler.closeNow: false | E-05 (L68-70) | ○ |
| C-40 | BytesChannelContext.read: バイト読み込み | E-06 (L52-62) | ○ |
| C-41 | BytesChannelContext.read: 0バイト読み込み | E-06 (L55-57) | ○ |
| C-42 | BytesChannelContext.flushChannel: フラッシュ | E-06 (L65-81) | ○ |
| C-43 | BytesChannelContext.flushChannel: IOException | E-06 (L76-79) | ○ |
| C-44 | BytesChannelContext.closeChannel: クローズスケジュール | E-06 (L84-88) | ○ |
| C-45 | BytesChannelContext.closeChannel: 重複防止 | E-06 (L85) | ○ |
| C-46 | BytesChannelContext.selectorShouldClose: closeNow=true | E-06 (L91-93) | ○ |
| C-47 | BytesChannelContext.selectorShouldClose: isClosing=true | E-06 (L91-93) | ○ |
| C-48 | ChannelContext.closeFromSelector: クローズ | E-07 (L88-98) | ○ |
| C-49 | ChannelContext.closeFromSelector: クローズ済み安全 | E-07 (L89) | ○ |
| C-50 | ChannelContext.closeFromSelector: 例外時closeContext | E-07 (L93-96) | ○ |
| C-51 | ChannelContext.addCloseListener: リスナー追加 | E-07 (L105-107) | ○ |
| C-52 | ChannelContext.isOpen: true | E-07 (L109-111) | ○ |
| C-53 | ChannelContext.isOpen: false | E-07 (L109-111) | ○ |
| C-54 | ChannelContext.handleException: 委譲 | E-07 (L113-115) | ○ |
| C-55 | Config.tcpReuseAddress: 設定値取得 | E-08 (L45-47) | ○ |
| C-56 | Config.Socket.tcpNoDelay: 設定値取得 | E-08 (L85-87) | ○ |
| C-57 | Config.Socket.getRemoteAddress: アドレス取得 | E-08 (L117-119) | ○ |
| C-58 | Config.Socket.isAccepted: 設定値取得 | E-08 (L113-115) | ○ |
| C-59 | Config.ServerSocket.getLocalAddress: アドレス取得 | E-08 (L131-133) | ○ |
| C-60 | DelegatingHandler.channelActive: 委譲 | E-09 (L48-50) | ○ |
| C-61 | DelegatingHandler.createWriteOperation: 委譲 | E-09 (L53-55) | ○ |
| C-62 | DelegatingHandler.writeToBytes: 委譲 | E-09 (L58-60) | ○ |
| C-63 | DelegatingHandler.consumeReads: 委譲 | E-09 (L68-70) | ○ |
| C-64 | DelegatingHandler.closeNow: 委譲 | E-09 (L73-75) | ○ |
| C-65 | DelegatingHandler.close: 委譲 | E-09 (L78-80) | ○ |
| C-66 | EventHandler.acceptChannel: 接続受付 | E-10 (L57-59) | ○ |
| C-67 | EventHandler.acceptException: 例外処理 | E-10 (L67-69) | ○ |
| C-68 | EventHandler.handleRegistration: 登録 | E-10 (L77-81) | ○ |
| C-69 | EventHandler.handleActive: SocketChannel ReadInterest | E-10 (L99-111) | ○ |
| C-70 | EventHandler.handleActive: readyForFlush時WriteInterest追加 | E-10 (L99-111) | ○ |
| C-71 | EventHandler.handleActive: ServerChannel AcceptInterest | E-10 (L108-110) | ○ |
| C-72 | EventHandler.handleConnect: ConnectInterest除去 | E-10 (L129-133) | ○ |
| C-73 | EventHandler.handleConnect: 接続未完了 | E-10 (L129-133) | ○ |
| C-74 | EventHandler.postHandling: クローズ | E-10 (L208-225) | ○ |
| C-75 | EventHandler.postHandling: WriteInterest設定 | E-10 (L216-223) | ○ |
| C-76 | EventHandler.postHandling: WriteInterest除去 | E-10 (L216-223) | ○ |
| C-77 | EventHandler.handleClose: closeFromSelector | E-10 (L252-255) | ○ |
| C-78 | EventHandler.handleTask: タスク実行 | E-10 (L190-192) | ○ |
| C-79 | EventHandler.taskException: 例外処理 | E-10 (L199-201) | ○ |
| C-80 | EventHandler.selectorException: 例外処理 | E-10 (L233-235) | ○ |
| C-81 | NioSelector.isOpen: 初期状態true | E-11 (L109-111) | ○ |
| C-82 | NioSelector.isOpen: close後false | E-11 (L109-111, L224-238) | ○ |
| C-83 | NioSelector.queueWrite: セレクタスレッド直接書き込み | E-11 (L305-319) | ○ |
| C-84 | NioSelector.queueWrite: 非セレクタスレッドキュー追加 | E-11 (L305-319) | ○ |
| C-85 | NioSelector.queueWrite: クローズ後ClosedSelectorException | E-11 (L310-314) | ○ |
| C-86 | NioSelector.scheduleForRegistration: 登録キュー追加 | E-11 (L339-348) | ○ |
| C-87 | NioSelector.scheduleForRegistration: クローズ後IllegalStateException | E-11 (L528-534) | ○ |
| C-88 | NioSelector.queueChannelClose: クローズキュー追加 | E-11 (L321-331) | ○ |
| C-89 | NioSelector.runLoop: ループ開始 | E-11 (L142-167) | ○ |
| C-90 | NioSelector.runLoop: 二重起動防止 | E-11 (L164-166) | ○ |
| C-91 | NioSelector.close: クローズ | E-11 (L224-238) | ○ |
| C-92 | NioSelector.close: べき等性 | E-11 (L225) | ○ |
| C-93 | NioSelector.getIoBuffer: DirectByteBuffer取得 | E-11 (L95-99) | ○ |
| C-94 | NioServerSocketChannel.setContext: コンテキスト設定 | E-12 (L57-63) | ○ |
| C-95 | NioServerSocketChannel.setContext: 重複設定防止 | E-12 (L58-62) | ○ |
| C-96 | NioServerSocketChannel.getRawChannel: rawチャネル取得 | E-12 (L76-78) | ○ |
| C-97 | NioSocketChannel.setContext: コンテキスト設定 | E-13 (L52-58) | ○ |
| C-98 | NioSocketChannel.setContext: 重複設定防止 | E-13 (L53-57) | ○ |
| C-99 | NioSocketChannel.getRawChannel: rawチャネル取得 | E-13 (L69-71) | ○ |
| C-100 | NioChannel.isOpen: context委譲 | E-14 (L47-49) | ○ |
| C-101 | NioChannel.close: context委譲 | E-14 (L65-67) | ○ |
| C-102 | SocketChannelContext.sendMessage: キュー追加 | E-15 (L169-178) | ○ |
| C-103 | SocketChannelContext.sendMessage: クローズ中拒否 | E-15 (L170-173) | ○ |
| C-104 | SocketChannelContext.connect: 接続完了 | E-15 (L140-167) | ○ |
| C-105 | SocketChannelContext.connect: 接続済み再呼び出し | E-15 (L141-142) | ○ |
| C-106 | SocketChannelContext.connect: finishConnect IOException | E-15 (L155-159) | ○ |
| C-107 | SocketChannelContext.isConnectComplete: 正常完了時true | E-15 (L126-128) | ○ |
| C-108 | SocketChannelContext.isConnectComplete: 例外完了時false | E-15 (L126-128) | ○ |
| C-109 | SocketChannelContext.readyForFlush: 保留あり | E-15 (L252-255) | ○ |
| C-110 | SocketChannelContext.readyForFlush: 保留なし | E-15 (L252-255) | ○ |
| C-111 | SocketChannelContext.closeFromSelector: 保留フラッシュ失敗 | E-15 (L209-239) | ○ |
| C-112 | SocketChannelContext.closeFromSelector: リソース解放 | E-15 (L209-239) | ○ |
| C-113 | SocketChannelContext.handleReadBytes: consumeReads呼び出し | E-15 (L241-250) | ○ |
| C-114 | SocketChannelContext.closeNow: setCloseNow後true | E-15 (L264-269) | ○ |
| C-115 | SocketChannelContext.closeNow: ハンドラ経由true | E-15 (L264-266) | ○ |
| C-116 | ServerChannelContext.acceptChannels: 接続受付 | E-16 (L77-87) | ○ |
| C-117 | ServerChannelContext.acceptChannels: エラー時close | E-16 (L84-86) | ○ |
| C-118 | ServerChannelContext.register: バインド | E-16 (L94-109) | ○ |
| C-119 | ServerChannelContext.register: バインド失敗 | E-16 (L103-108) | ○ |
| C-120 | ServerChannelContext.closeChannel: クローズスケジュール | E-16 (L112-116) | ○ |
| C-121 | ServerChannelContext.closeChannel: 重複防止 | E-16 (L113) | ○ |
| C-122 | ChannelFactory.openNioChannel: チャネル作成 | E-17 (L107-114) | ○ |
| C-123 | ChannelFactory.openNioChannel: エラー時rawChannelクローズ | E-17 (L169-183) | ○ |
| C-124 | ChannelFactory.acceptNioChannel: 受付チャネル作成 | E-17 (L116-123) | ○ |
| C-125 | ChannelFactory.openNioServerSocketChannel: サーバチャネル作成 | E-17 (L125-133) | ○ |
| C-126 | ChannelFactory.getRemoteAddress: アドレス取得 | E-17 (L161-167) | ○ |
| C-127 | ChannelFactory.getRemoteAddress: null時IOException | E-17 (L163-166) | ○ |
| C-128 | TaskScheduler.scheduleAtRelativeTime: スケジュール | E-18 (L55-59) | ○ |
| C-129 | TaskScheduler.pollTask: 期限到達タスク返却 | E-18 (L61-74) | ○ |
| C-130 | TaskScheduler.pollTask: 期限未到達null | E-18 (L68-70) | ○ |
| C-131 | TaskScheduler.pollTask: 空キューnull | E-18 (L63, L73) | ○ |
| C-132 | TaskScheduler.pollTask: キャンセル済みスキップ | E-18 (L66-68, L101-103) | ○ |
| C-133 | TaskScheduler.nanosUntilNextTask: 時間計算 | E-18 (L76-83) | ○ |
| C-134 | TaskScheduler.nanosUntilNextTask: タスクなしMAX_VALUE | E-18 (L78-79) | ○ |
| C-135 | TaskScheduler.nanosUntilNextTask: 期限超過0 | E-18 (L81) | ○ |
| C-136 | TaskScheduler.pollTask: 優先度順 | E-18 (L44, L61-74) | ○ |
| C-137 | RoundRobinSupplier.get: ラウンドロビン | E-19 (L55-58) | ○ |
| C-138 | RoundRobinSupplier.get: ラップアラウンド | E-19 (L57) | ○ |
| C-139 | RoundRobinSupplier.setSelectors: 設定 | E-19 (L60-66) | ○ |
| C-140 | RoundRobinSupplier.setSelectors: 重複設定防止 | E-19 (L61-65) | ○ |
| C-141 | RoundRobinSupplier.count: カウント取得 | E-19 (L68-70) | ○ |
| C-142 | SelectionKeyUtils.setWriteInterested: OP_WRITE追加 | E-20 (L48-50) | ○ |
| C-143 | SelectionKeyUtils.removeWriteInterested: OP_WRITE除去 | E-20 (L58-60) | ○ |
| C-144 | SelectionKeyUtils.setConnectAndReadInterested: OP_CONNECT+OP_READ追加 | E-20 (L68-70) | ○ |
| C-145 | SelectionKeyUtils.setConnectReadAndWriteInterested: 全追加 | E-20 (L79-81) | ○ |
| C-146 | SelectionKeyUtils.removeConnectInterested: OP_CONNECT除去 | E-20 (L89-91) | ○ |
| C-147 | SelectionKeyUtils.setAcceptInterested: OP_ACCEPT追加 | E-20 (L99-101) | ○ |
| C-148 | SelectionKeyUtils.isWriteInterested: true判定 | E-20 (L110-112) | ○ |
| C-149 | SelectionKeyUtils.isWriteInterested: false判定 | E-20 (L110-112) | ○ |
| C-150 | ByteBufferUtils.copyBytes(single): バイトコピー | E-21 (L68-75) | ○ |
| C-151 | ByteBufferUtils.copyBytes(single): 容量制限 | E-21 (L69) | ○ |
| C-152 | ByteBufferUtils.copyBytes(single): 空ソース | E-21 (L69) | ○ |
| C-153 | ByteBufferUtils.copyBytes(array): 複数ソースコピー | E-21 (L50-57) | ○ |
| C-154 | ByteBufferUtils.copyBytes(array): 空配列 | E-21 (L52) | ○ |
| C-155 | ExceptionsHelper.rethrowAndSuppress: 単一例外 | E-22 (L45-53) | ○ |
| C-156 | ExceptionsHelper.rethrowAndSuppress: 複数例外suppressed | E-22 (L45-53, L55-62) | ○ |
| C-157 | ExceptionsHelper.rethrowAndSuppress: 空リスト | E-22 (L51-52) | ○ |
| C-158 | NioSelectorGroup.bindServerChannel: バインド | E-23 (L148-152) | ○ |
| C-159 | NioSelectorGroup.bindServerChannel: クローズ後ISE | E-23 (L195-198) | ○ |
| C-160 | NioSelectorGroup.openChannel: オープン | E-23 (L155-158) | ○ |
| C-161 | NioSelectorGroup.openChannel: クローズ後ISE | E-23 (L195-198) | ○ |
| C-162 | NioSelectorGroup.close: 全セレクタクローズ | E-23 (L161-174) | ○ |
| C-163 | NioSelectorGroup.close: べき等性 | E-23 (L162) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全テストケースがソースコードに直接基づいて生成されている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードの実装に基づいており、メソッドシグネチャ、条件分岐、例外処理を直接参照して生成されている。

## 6) レビュアーチェックリスト（最小）
- [ ] InboundChannelBufferのページ管理テスト（UT-NIO-001〜021）がバッファの全ライフサイクルをカバーしているか
- [ ] FlushOperationのgetBuffersToWrite（UT-NIO-025〜027）が複数バッファにまたがるケースを適切にテストしているか
- [ ] SocketChannelContextのconnect（UT-NIO-104〜108）が全状態遷移をカバーしているか
- [ ] NioSelectorのスレッドセーフ性テスト（UT-NIO-083〜092）が並行アクセスを想定しているか
- [ ] ServerChannelContextのregister（UT-NIO-118〜119）がバインド設定の全パラメータを検証しているか
- [ ] TaskSchedulerのキャンセル機能（UT-NIO-132）がキャンセル後の再スケジュールも考慮しているか
- [ ] Page参照カウント（UT-NIO-032〜035）が複数回duplicateのケースも網羅しているか
