---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 132
  claims_with_evidence: 132
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libs-ssl-config 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：132 / 132、根拠なし：0
- 優先レビュー（高）
  1. **FIPS モード関連テストケース (UT-SSL-010, UT-SSL-121)**：FIPS モードの動的切り替えはランタイム依存であり、テスト環境によっては検証困難
  2. **PemUtils の暗号化キー読み込み (UT-SSL-079)**：BouncyCastle プロバイダーへの依存があり、テスト環境のセキュリティ設定に影響される可能性
  3. **DiagnosticTrustManager の診断ログ出力 (UT-SSL-107, UT-SSL-108)**：モック/スタブの構成が複雑になる可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/SslConfiguration.java`
- E-02: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/SslConfigurationLoader.java`
- E-03: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/SslVerificationMode.java`
- E-04: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/SslClientAuthenticationMode.java`
- E-05: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/PemKeyConfig.java`
- E-06: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/PemTrustConfig.java`
- E-07: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/StoreKeyConfig.java`
- E-08: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/StoreTrustConfig.java`
- E-09: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/KeyStoreUtil.java`
- E-10: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/PemUtils.java`
- E-11: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/SslUtil.java`
- E-12: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/DerParser.java`
- E-13: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/DiagnosticTrustManager.java`
- E-14: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/SslDiagnostics.java`
- E-15: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/DefaultJdkTrustConfig.java`
- E-16: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/TrustEverythingConfig.java`
- E-17: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/EmptyKeyConfig.java`
- E-18: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/SslConfigException.java`
- E-19: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/SslConfigurationKeys.java`
- E-20: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/SslTrustConfig.java`
- E-21: `libs/ssl-config/src/main/java/org/opensearch/common/ssl/SslKeyConfig.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SslConfiguration コンストラクタは ciphers/supportedProtocols の null/空チェックを行う (UT-SSL-001〜007) | E-01 (L93-104) | ○ |
| C-02 | SslConfiguration.getDependentFiles() は keyConfig と trustConfig の依存ファイルを統合する (UT-SSL-008) | E-01 (L136-140) | ○ |
| C-03 | SslConfiguration.createSslContext() は SSLContext を生成する (UT-SSL-009〜010) | E-01 (L148-182) | ○ |
| C-04 | SslConfiguration.equals/hashCode は全フィールドを比較する (UT-SSL-011〜013) | E-01 (L204-219) | ○ |
| C-05 | SslConfigurationLoader コンストラクタは prefix の形式を検証する (UT-SSL-014〜017) | E-02 (L111-122) | ○ |
| C-06 | SslConfigurationLoader.load() は設定を読み込み SslConfiguration を返す (UT-SSL-018〜019) | E-02 (L213-230) | ○ |
| C-07 | SslConfigurationLoader は certificate_authorities と truststore.path の排他チェックを行う (UT-SSL-020) | E-02 (L236-240) | ○ |
| C-08 | SslConfigurationLoader は certificate と keystore.path の排他チェックを行う (UT-SSL-021) | E-02 (L265-269) | ○ |
| C-09 | SslConfigurationLoader は certificate と key の整合性チェックを行う (UT-SSL-022〜023) | E-02 (L271-281) | ○ |
| C-10 | SslConfigurationLoader は secure_password と legacy_password の排他チェックを行う (UT-SSL-024) | E-02 (L304-322) | ○ |
| C-11 | SslConfigurationLoader は verificationMode=NONE の場合 TrustEverythingConfig を使用する (UT-SSL-025) | E-02 (L241-243) | ○ |
| C-12 | SslConfigurationLoader のデフォルト値 setter が機能する (UT-SSL-026〜028) | E-02 (L128-172) | ○ |
| C-13 | SslVerificationMode.parse() は文字列から enum 値をパースする (UT-SSL-029〜033) | E-03 (L108-121) | ○ |
| C-14 | SslVerificationMode の各値が正しいフラグを返す (UT-SSL-034〜037) | E-03 (L47-86) | ○ |
| C-15 | SslClientAuthenticationMode.parse() は文字列から enum 値をパースする (UT-SSL-038〜041) | E-04 (L106-115) | ○ |
| C-16 | SslClientAuthenticationMode の enabled() が正しい値を返す (UT-SSL-042〜043) | E-04 (L51-83) | ○ |
| C-17 | SslClientAuthenticationMode.configure() が SSLParameters を正しく設定する (UT-SSL-044〜045) | E-04 (L55-83) | ○ |
| C-18 | PemKeyConfig コンストラクタは null チェックを行う (UT-SSL-046〜048) | E-05 (L62-66) | ○ |
| C-19 | PemKeyConfig.getDependentFiles() は certificate と key を返す (UT-SSL-049) | E-05 (L69-71) | ○ |
| C-20 | PemKeyConfig.createKeyManager() は PEM ファイルから KeyManager を生成する (UT-SSL-050〜052) | E-05 (L74-111) | ○ |
| C-21 | PemKeyConfig.equals は certificate, key, keyPassword を比較する (UT-SSL-053) | E-05 (L119-137) | ○ |
| C-22 | PemTrustConfig は PEM CA 証明書から TrustManager を生成する (UT-SSL-054〜058) | E-06 (L59-136) | ○ |
| C-23 | StoreKeyConfig は keystore ファイルから KeyManager を生成する (UT-SSL-059〜062) | E-07 (L51-119) | ○ |
| C-24 | StoreTrustConfig は truststore ファイルから TrustManager を生成する (UT-SSL-063〜065) | E-08 (L47-110) | ○ |
| C-25 | KeyStoreUtil.inferStoreType() はファイル拡張子からストアタイプを推論する (UT-SSL-066〜070) | E-09 (L77-104) | ○ |
| C-26 | KeyStoreUtil.readKeyStore() はキーストアファイルを読み込む (UT-SSL-071〜072) | E-09 (L112-139) | ○ |
| C-27 | KeyStoreUtil.buildKeyStore/buildTrustStore はインメモリストアを構築する (UT-SSL-073〜074) | E-09 (L149-180) | ○ |
| C-28 | KeyStoreUtil.createKeyManager/createTrustManager はマネージャを生成する (UT-SSL-075〜076) | E-09 (L185-219) | ○ |
| C-29 | PemUtils コンストラクタはインスタンス化を防止する (UT-SSL-077) | E-10 (L76-78) | ○ |
| C-30 | PemUtils.readPrivateKey() は PEM 秘密鍵を読み込む (UT-SSL-078〜081) | E-10 (L88-155) | ○ |
| C-31 | PemUtils.readCertificates() は PEM 証明書を読み込む (UT-SSL-082〜084) | E-10 (L94-107) | ○ |
| C-32 | SslUtil.calculateFingerprint() は SHA-1 フィンガープリントを計算する (UT-SSL-085) | E-11 (L47-51) | ○ |
| C-33 | SslUtil.toHexString/toHexCharArray はバイト配列を16進変換する (UT-SSL-086〜089) | E-11 (L69-88) | ○ |
| C-34 | SslUtil.messageDigest() は MessageDigest を生成する (UT-SSL-090〜091) | E-11 (L53-59) | ○ |
| C-35 | DerParser は DER エンコードデータをパースする (UT-SSL-092〜104) | E-12 (L46-301) | ○ |
| C-36 | DiagnosticTrustManager は委譲先の信頼チェック失敗時に診断メッセージを生成する (UT-SSL-105〜109) | E-13 (L54-179) | ○ |
| C-37 | SslDiagnostics は証明書の SAN 記述・信頼診断メッセージを生成する (UT-SSL-110〜117) | E-14 (L51-410) | ○ |
| C-38 | DefaultJdkTrustConfig は JDK デフォルトの信頼設定を提供する (UT-SSL-118〜120) | E-15 (L52-151) | ○ |
| C-39 | TrustEverythingConfig はすべての証明書を信頼する (UT-SSL-121〜122) | E-16 (L50-109) | ○ |
| C-40 | EmptyKeyConfig は null の KeyManager を返す (UT-SSL-123〜124) | E-17 (L44-66) | ○ |
| C-41 | SslConfigException はメッセージと原因を保持する (UT-SSL-125〜126) | E-18 (L38-46) | ○ |
| C-42 | SslConfigurationKeys は設定キーの一覧と非推奨判定を提供する (UT-SSL-127〜132) | E-19 (L49-205) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全テストケースがソースコードの実装に直接基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから直接特定可能な公開メソッド・コンストラクタに基づいている
- 1: 中リスク - FIPS モードに関連するテストケース (UT-SSL-010, UT-SSL-121) は実行環境に依存するため、テスト環境の構築に注意が必要
- 1: 中リスク - BouncyCastle プロバイダーに依存するテスト (PemUtils 関連) はライブラリの可用性に依存

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースが対象メソッドの仕様と一致しているか確認
- [ ] 正常系・異常系・境界値の観点が適切にカバーされているか確認
- [ ] FIPS モード関連のテストケースが実行環境で検証可能か確認
- [ ] PemUtils のテストに必要なテスト用 PEM ファイル（証明書・秘密鍵）の準備方針を確認
- [ ] DiagnosticTrustManager のモック構成が適切か確認
- [ ] privateメソッド（contextProtocol, buildTrustConfig, buildKeyConfig 等）のテスト戦略を確認（publicメソッド経由での間接テストで十分か）
