---
generated_at: 2026-02-03 00:00:00
metrics:
  claims_total: 62
  claims_with_evidence: 60
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：libs-task-commons 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：60 / 62、根拠なし：2
- 優先レビュー（高）
  1. **C-59 (UT-TSK-059)**: pageSize=0の境界値テストにおけるバリデーション有無が不明
  2. **C-60 (UT-TSK-060)**: pageSize=-1の境界値テストにおけるバリデーション有無が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libs/task-commons/src/main/java/org/opensearch/task/commons/task/TaskId.java` - TaskIdクラス定義（コンストラクタ、getValue、equals、hashCode）
- E-02: `libs/task-commons/src/main/java/org/opensearch/task/commons/task/TaskStatus.java` - TaskStatus enum定義（UNASSIGNED, ASSIGNED, ACTIVE, SUCCESS, FAILED, CANCELLED）
- E-03: `libs/task-commons/src/main/java/org/opensearch/task/commons/task/TaskType.java` - TaskType enum定義（MERGE, SNAPSHOT）
- E-04: `libs/task-commons/src/main/java/org/opensearch/task/commons/task/TaskParams.java` - TaskParams抽象クラス定義
- E-05: `libs/task-commons/src/main/java/org/opensearch/task/commons/task/Task.java` - Taskクラス定義（コンストラクタ、アクセサ、Builderパターン）
- E-06: `libs/task-commons/src/main/java/org/opensearch/task/commons/worker/WorkerNode.java` - WorkerNodeクラス定義（ファクトリメソッド、アクセサ、equals、hashCode）
- E-07: `libs/task-commons/src/main/java/org/opensearch/task/commons/clients/TaskListRequest.java` - TaskListRequestクラス定義（Fluent APIパターン）
- E-08: `libs/task-commons/src/main/java/org/opensearch/task/commons/clients/TaskWorkerClient.java` - TaskWorkerClientインターフェース定義
- E-09: `libs/task-commons/src/main/java/org/opensearch/task/commons/clients/TaskProducerClient.java` - TaskProducerClientインターフェース定義
- E-10: `libs/task-commons/src/main/java/org/opensearch/task/commons/clients/TaskManagerClient.java` - TaskManagerClientインターフェース定義
- E-11: `libs/task-commons/src/main/java/org/opensearch/task/commons/worker/TaskWorker.java` - TaskWorkerインターフェース定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-TSK-001: TaskIdコンストラクタで有効なIDが設定される | E-01 | ○ |
| C-02 | UT-TSK-002: getValueでID文字列が取得できる | E-01 | ○ |
| C-03 | UT-TSK-003: 同一IDのTaskIdがequalsでtrue | E-01 | ○ |
| C-04 | UT-TSK-004: 異なるIDのTaskIdがequalsでfalse | E-01 | ○ |
| C-05 | UT-TSK-005: nullとの比較でfalse | E-01 | ○ |
| C-06 | UT-TSK-006: 異なるクラスとの比較でfalse | E-01 | ○ |
| C-07 | UT-TSK-007: 同一IDで同じhashCode | E-01 | ○ |
| C-08 | UT-TSK-008: 異なるIDで異なるhashCode | E-01 | ○ |
| C-09 | UT-TSK-009: null入力時にidがnullとなる | E-01 | ○ |
| C-10 | UT-TSK-010: 空文字列でTaskIdが生成される | E-01 | ○ |
| C-11 | UT-TSK-011: TaskStatus enumに6つの値が定義されている | E-02 | ○ |
| C-12 | UT-TSK-012: valueOfで文字列からTaskStatusに変換できる | E-02 | ○ |
| C-13 | UT-TSK-013: 不正文字列でIllegalArgumentException | E-02 | ○ |
| C-14 | UT-TSK-014: TaskType enumに2つの値が定義されている | E-03 | ○ |
| C-15 | UT-TSK-015: valueOfで文字列からTaskTypeに変換できる | E-03 | ○ |
| C-16 | UT-TSK-016: 不正文字列でIllegalArgumentException | E-03 | ○ |
| C-17 | UT-TSK-017: Taskコンストラクタで全フィールドが設定される | E-05 | ○ |
| C-18 | UT-TSK-018: getTaskIdが正しく値を返す | E-05 | ○ |
| C-19 | UT-TSK-019: getTaskStatusが正しく値を返す | E-05 | ○ |
| C-20 | UT-TSK-020: getParamsが正しく値を返す | E-05 | ○ |
| C-21 | UT-TSK-021: getTaskTypeが正しく値を返す | E-05 | ○ |
| C-22 | UT-TSK-022: getCreatedAtが正しく値を返す | E-05 | ○ |
| C-23 | UT-TSK-023: getAssignedAtが正しく値を返す | E-05 | ○ |
| C-24 | UT-TSK-024: getStartedAtが正しく値を返す | E-05 | ○ |
| C-25 | UT-TSK-025: getCompletedAtが正しく値を返す | E-05 | ○ |
| C-26 | UT-TSK-026: getLastHeartbeatAtが正しく値を返す | E-05 | ○ |
| C-27 | UT-TSK-027: getAssignedNodeが正しく値を返す | E-05 | ○ |
| C-28 | UT-TSK-028: assignedNode=nullでnullが返る | E-05 | ○ |
| C-29 | UT-TSK-029: builder(Task)で既存TaskからBuilderが生成される | E-05 | ○ |
| C-30 | UT-TSK-030: builder(個別パラメータ)でBuilderが生成される | E-05 | ○ |
| C-31 | UT-TSK-031: build()でTaskが正しく構築される | E-05 | ○ |
| C-32 | UT-TSK-032: Builder.assignedAtで割当日時が設定できる | E-05 | ○ |
| C-33 | UT-TSK-033: Builder.startedAtで開始日時が設定できる | E-05 | ○ |
| C-34 | UT-TSK-034: Builder.completedAtで完了日時が設定できる | E-05 | ○ |
| C-35 | UT-TSK-035: Builder.lastHeartbeatAtで最終HB日時が設定できる | E-05 | ○ |
| C-36 | UT-TSK-036: Builder.taskStatusでステータスが更新できる | E-05 | ○ |
| C-37 | UT-TSK-037: Builder.assignedNodeでノードが設定できる | E-05 | ○ |
| C-38 | UT-TSK-038: Builder.assignedNode(null)でnullが設定できる | E-05 | ○ |
| C-39 | UT-TSK-039: Task -> Builder -> Taskの往復変換で値が保持される | E-05 | ○ |
| C-40 | UT-TSK-040: createWorkerNodeでWorkerNodeが生成される | E-06 | ○ |
| C-41 | UT-TSK-041: getIdが正しく値を返す | E-06 | ○ |
| C-42 | UT-TSK-042: getNameが正しく値を返す | E-06 | ○ |
| C-43 | UT-TSK-043: getIpが正しく値を返す | E-06 | ○ |
| C-44 | UT-TSK-044: 同一パラメータでequalsがtrue | E-06 | ○ |
| C-45 | UT-TSK-045: ID不一致でequalsがfalse | E-06 | ○ |
| C-46 | UT-TSK-046: 名前不一致でequalsがfalse | E-06 | ○ |
| C-47 | UT-TSK-047: IP不一致でequalsがfalse | E-06 | ○ |
| C-48 | UT-TSK-048: 同一インスタンスでequalsがtrue | E-06 | ○ |
| C-49 | UT-TSK-049: nullとの比較でequalsがfalse | E-06 | ○ |
| C-50 | UT-TSK-050: 異なるクラスとの比較でequalsがfalse | E-06 | ○ |
| C-51 | UT-TSK-051: 同一パラメータで同じhashCode | E-06 | ○ |
| C-52 | UT-TSK-052: nullパラメータでWorkerNodeが生成される | E-06 | ○ |
| C-53 | UT-TSK-053: 空文字列でWorkerNodeが生成される | E-06 | ○ |
| C-54 | UT-TSK-054: デフォルトコンストラクタでTaskListRequestが生成される | E-07 | ○ |
| C-55 | UT-TSK-055: taskType(TaskType...)でフィルターが設定できる | E-07 | ○ |
| C-56 | UT-TSK-056: taskType(TaskStatus...)でフィルターが設定できる | E-07 | ○ |
| C-57 | UT-TSK-057: startPageNumberが設定できる | E-07 | ○ |
| C-58 | UT-TSK-058: pageSizeが設定できる | E-07 | ○ |
| C-59 | UT-TSK-059: pageSize=0のときの挙動 | **根拠なし** | △ |
| C-60 | UT-TSK-060: pageSize=-1のときの挙動 | **根拠なし** | △ |
| C-61 | UT-TSK-061: startPageNumber=0のときの挙動 | E-07 | ○ |
| C-62 | UT-TSK-062: メソッドチェーンで複数フィルター設定 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- TaskListRequestクラスにはバリデーションロジックが存在しないため、pageSize=0や負数を設定した場合の期待動作がソースコードから確定できない
  - 候補：実装側のバリデーション仕様書 / TaskManagerClientの実装クラス / 統合テストの仕様
- TaskWorkerClient, TaskProducerClient, TaskManagerClient, TaskWorkerはインターフェースのため単体テストケースの対象外とした。これらの実装クラスが存在する場合は別途テストが必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本モジュールはデータモデルとインターフェース定義が中心であり、複雑なビジネスロジックは含まれない
- 0: 低リスク - TaskId.equalsでidがnullの場合にNullPointerExceptionが発生しうるが、これはTaskId自体のバリデーション不在に起因する（C-09で確認済み）
- 1: 中リスク - TaskListRequestのtaskType(TaskStatus...)メソッド名がtaskType(TaskType...)と同名のオーバーロードになっており、混乱を招く可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] TaskIdにnullを渡した場合のequals呼び出し時のNullPointerExceptionの発生が許容されるか確認
- [ ] TaskListRequestのpageSize/startPageNumberにバリデーションが不要であることを確認
- [ ] TaskListRequestのtaskType(TaskStatus...)メソッド名がtaskType(TaskType...)と同名オーバーロードであることが意図的か確認
- [ ] インターフェース（TaskWorkerClient, TaskProducerClient, TaskManagerClient, TaskWorker）の実装クラスが別モジュールに存在し、そちらでテストされることを確認
- [ ] TaskParamsが抽象クラスであり、具体的なサブクラスが別モジュールに存在することを確認
