---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 110
  claims_with_evidence: 110
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libs-telemetry 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：110 / 110、根拠なし：0
- 優先レビュー（高）
  1. **DefaultTracer**: 複数のスパン管理ロジックを含む中核クラス。startSpanの親スパン解決ロジックは特に重要
  2. **DefaultSpanScope**: ThreadLocalを使ったスコープ管理。ネスト時の復元動作の確認が必要
  3. **TraceableRunnable**: 例外発生時のScopedSpanクローズ保証の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `libs/telemetry/src/main/java/org/opensearch/telemetry/Telemetry.java`
- E-02: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/DefaultTracer.java`
- E-03: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/DefaultScopedSpan.java`
- E-04: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/DefaultSpanScope.java`
- E-05: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/AbstractSpan.java`
- E-06: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/Span.java`
- E-07: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/SpanContext.java`
- E-08: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/SpanCreationContext.java`
- E-09: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/SpanKind.java`
- E-10: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/SpanReference.java`
- E-11: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/SpanScope.java`
- E-12: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/ScopedSpan.java`
- E-13: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/Tracer.java`
- E-14: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/TracerContextStorage.java`
- E-15: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/TracingContextPropagator.java`
- E-16: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/TracingTelemetry.java`
- E-17: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/runnable/TraceableRunnable.java`
- E-18: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/transport/TransportTracer.java`
- E-19: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/attributes/Attributes.java`
- E-20: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/noop/NoopTracer.java`
- E-21: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/noop/NoopSpan.java`
- E-22: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/noop/NoopSpanScope.java`
- E-23: `libs/telemetry/src/main/java/org/opensearch/telemetry/tracing/noop/NoopScopedSpan.java`
- E-24: `libs/telemetry/src/main/java/org/opensearch/telemetry/metrics/DefaultMetricsRegistry.java`
- E-25: `libs/telemetry/src/main/java/org/opensearch/telemetry/metrics/MetricsRegistry.java`
- E-26: `libs/telemetry/src/main/java/org/opensearch/telemetry/metrics/MetricsTelemetry.java`
- E-27: `libs/telemetry/src/main/java/org/opensearch/telemetry/metrics/Counter.java`
- E-28: `libs/telemetry/src/main/java/org/opensearch/telemetry/metrics/Histogram.java`
- E-29: `libs/telemetry/src/main/java/org/opensearch/telemetry/metrics/TaggedMeasurement.java`
- E-30: `libs/telemetry/src/main/java/org/opensearch/telemetry/metrics/tags/Tags.java`
- E-31: `libs/telemetry/src/main/java/org/opensearch/telemetry/metrics/noop/NoopCounter.java`
- E-32: `libs/telemetry/src/main/java/org/opensearch/telemetry/metrics/noop/NoopHistogram.java`
- E-33: `libs/telemetry/src/main/java/org/opensearch/telemetry/metrics/noop/NoopMetricsRegistry.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DefaultTracer.startSpan: 親Spanなしでスパンが作成される | E-02 (L48-58: parentSpan解決ロジック) | ○ |
| C-02 | DefaultTracer.startSpan: 親Span指定でスパンが作成される | E-02 (L50-51: context.getParent()チェック) | ○ |
| C-03 | DefaultTracer.startSpan: ストレージからcurrent_spanが親として使用される | E-02 (L53: getCurrentSpanInternal()) | ○ |
| C-04 | DefaultTracer.startSpan: thread.name属性が自動追加される | E-02 (L100-102: addDefaultAttributes) | ○ |
| C-05 | DefaultTracer.startSpan(headers): HTTPヘッダーからコンテキスト伝播 | E-02 (L105-108: extractFromHeaders) | ○ |
| C-06 | DefaultTracer.startSpan(headers): ヘッダーにトレーシング情報がない場合 | E-02 (L107: Optional.empty分岐) | ○ |
| C-07 | DefaultTracer.getCurrentSpan: 現在のスパンが取得できる | E-02 (L70-73: getCurrentSpan) | ○ |
| C-08 | DefaultTracer.getCurrentSpan: スパンが存在しない場合null | E-02 (L72: null判定) | ○ |
| C-09 | DefaultTracer.startScopedSpan: ScopedSpanが作成される | E-02 (L76-80: startScopedSpan) | ○ |
| C-10 | DefaultTracer.withSpanInScope: SpanScopeが作成される | E-02 (L83-85: withSpanInScope) | ○ |
| C-11 | DefaultTracer.isRecording: trueが返る | E-02 (L88-90: return true) | ○ |
| C-12 | DefaultTracer.close: TracingTelemetryのcloseが呼ばれる | E-02 (L61-63: close) | ○ |
| C-13 | DefaultScopedSpan: コンストラクタでSpanとSpanScopeを受ける | E-03 (L33-36: コンストラクタ) | ○ |
| C-14 | DefaultScopedSpan: spanがnullでNPE | E-03 (L34: Objects.requireNonNull(span)) | ○ |
| C-15 | DefaultScopedSpan: spanScopeがnullでNPE | E-03 (L35: Objects.requireNonNull(spanScope)) | ○ |
| C-16 | DefaultScopedSpan.addAttribute(String,String): Spanに委譲 | E-03 (L39-41) | ○ |
| C-17 | DefaultScopedSpan.addAttribute(String,long): Spanに委譲 | E-03 (L44-46) | ○ |
| C-18 | DefaultScopedSpan.addAttribute(String,double): Spanに委譲 | E-03 (L49-51) | ○ |
| C-19 | DefaultScopedSpan.addAttribute(String,boolean): Spanに委譲 | E-03 (L54-56) | ○ |
| C-20 | DefaultScopedSpan.addEvent: Spanに委譲 | E-03 (L59-61) | ○ |
| C-21 | DefaultScopedSpan.setError: Spanに委譲 | E-03 (L64-66) | ○ |
| C-22 | DefaultScopedSpan.close: endSpanとspanScope.closeが呼ばれる | E-03 (L72-75: close) | ○ |
| C-23 | DefaultScopedSpan.getSpan: Spanが返る | E-03 (L81-83) | ○ |
| C-24 | DefaultScopedSpan.getSpanScope: SpanScopeが返る | E-03 (L89-91) | ○ |
| C-25 | DefaultSpanScope.create: SpanScopeが作成される | E-04 (L51-56: create) | ○ |
| C-26 | DefaultSpanScope.attach: current_spanに設定される | E-04 (L64-68: attach) | ○ |
| C-27 | DefaultSpanScope.attach: ThreadLocalに設定される | E-04 (L65: spanScopeThreadLocal.set) | ○ |
| C-28 | DefaultSpanScope.close: 前のSpanScopeが復元される | E-04 (L70-77: detach) | ○ |
| C-29 | DefaultSpanScope.close: beforeSpanがnullの場合null設定 | E-04 (L75: put null) | ○ |
| C-30 | DefaultSpanScope.close: beforeSpanが存在する場合復元 | E-04 (L73: put beforeSpan) | ○ |
| C-31 | DefaultSpanScope.getSpan: Spanが返る | E-04 (L80-82) | ○ |
| C-32 | DefaultSpanScope: ネストされたスコープ管理 | E-04 (全体構造: previousSpanScope, beforeSpan) | ○ |
| C-33 | SpanCreationContext.server: SpanKind.SERVER | E-08 (L35-39) | ○ |
| C-34 | SpanCreationContext.client: SpanKind.CLIENT | E-08 (L45-49) | ○ |
| C-35 | SpanCreationContext.internal: SpanKind.INTERNAL | E-08 (L55-59) | ○ |
| C-36 | SpanCreationContext.name: スパン名設定 | E-08 (L66-69) | ○ |
| C-37 | SpanCreationContext.attributes: 属性設定 | E-08 (L76-79) | ○ |
| C-38 | SpanCreationContext.parent: 親SpanContext設定 | E-08 (L86-89) | ○ |
| C-39 | SpanCreationContext.parent: null許容 | E-08 (L86-89: nullチェックなし) | ○ |
| C-40 | SpanCreationContext: メソッドチェーン | E-08 (各メソッドがthisを返す設計) | ○ |
| C-41 | SpanContext: コンストラクタでSpanを受ける | E-07 (L27-29) | ○ |
| C-42 | SpanContext.getSpan: Spanが返る | E-07 (L31-33) | ○ |
| C-43 | SpanContext.setError: Spanに委譲 | E-07 (L39-41) | ○ |
| C-44 | SpanContext.endSpan: Spanに委譲 | E-07 (L46-48) | ○ |
| C-45 | SpanReference: コンストラクタ | E-10 (L27-29) | ○ |
| C-46 | SpanReference.getSpan | E-10 (L35-37) | ○ |
| C-47 | SpanReference.setSpan | E-10 (L43-45) | ○ |
| C-48 | SpanReference.setSpan: null設定可能 | E-10 (nullチェックなし) | ○ |
| C-49 | AbstractSpan.getSpanName | E-05 (L45-48) | ○ |
| C-50 | AbstractSpan.getParentSpan | E-05 (L41-43) | ○ |
| C-51 | AbstractSpan: parentSpanがnull可能 | E-05 (L35-38: nullチェックなし) | ○ |
| C-52 | TraceableRunnable.run: トレースコンテキスト内実行 | E-17 (L36-39: try-with-resources) | ○ |
| C-53 | TraceableRunnable.run: ScopedSpan自動クローズ | E-17 (L37: try-with-resources) | ○ |
| C-54 | TraceableRunnable.run: 例外時もクローズ | E-17 (L37: try-with-resources保証) | ○ |
| C-55 | Attributes.create: 空のインスタンス作成 | E-19 (L35-37) | ○ |
| C-56 | Attributes.EMPTY: 空の不変定数 | E-19 (L29: Collections.emptyMap()) | ○ |
| C-57 | Attributes.addAttribute(String,String) | E-19 (L52-56) | ○ |
| C-58 | Attributes.addAttribute(String,String): nullでNPE | E-19 (L53: Objects.requireNonNull) | ○ |
| C-59 | Attributes.addAttribute(String,long) | E-19 (L64-67) | ○ |
| C-60 | Attributes.addAttribute(String,double) | E-19 (L75-78) | ○ |
| C-61 | Attributes.addAttribute(String,boolean) | E-19 (L86-89) | ○ |
| C-62 | Attributes: メソッドチェーン | E-19 (各メソッドがthisを返す設計) | ○ |
| C-63 | Attributes.getAttributesMap: 不変Map | E-19 (L96: Collections.unmodifiableMap) | ○ |
| C-64 | Attributes: キー重複時上書き | E-19 (HashMap.putの標準動作) | ○ |
| C-65 | DefaultMetricsRegistry.createCounter: 委譲 | E-24 (L32-34) | ○ |
| C-66 | DefaultMetricsRegistry.createUpDownCounter: 委譲 | E-24 (L37-39) | ○ |
| C-67 | DefaultMetricsRegistry.createHistogram: 委譲 | E-24 (L42-44) | ○ |
| C-68 | DefaultMetricsRegistry.createGauge(Double): 委譲 | E-24 (L47-49) | ○ |
| C-69 | DefaultMetricsRegistry.createGauge(TaggedMeasurement): 委譲 | E-24 (L52-54) | ○ |
| C-70 | DefaultMetricsRegistry.close: 委譲 | E-24 (L57-59) | ○ |
| C-71 | TaggedMeasurement.create | E-29 (L29-31) | ○ |
| C-72 | TaggedMeasurement.getValue | E-29 (L42-44) | ○ |
| C-73 | TaggedMeasurement.getTags | E-29 (L50-52) | ○ |
| C-74 | Tags.create | E-30 (L35-37) | ○ |
| C-75 | Tags.EMPTY | E-30 (L29: Collections.emptyMap()) | ○ |
| C-76 | Tags.addTag(String,String) | E-30 (L52-56) | ○ |
| C-77 | Tags.addTag(String,String): nullでNPE | E-30 (L53: Objects.requireNonNull) | ○ |
| C-78 | Tags.addTag(String,long) | E-30 (L64-67) | ○ |
| C-79 | Tags.addTag(String,double) | E-30 (L75-78) | ○ |
| C-80 | Tags.addTag(String,boolean) | E-30 (L86-89) | ○ |
| C-81 | Tags: メソッドチェーン | E-30 (各メソッドがthisを返す設計) | ○ |
| C-82 | Tags.getTagsMap: 不変Map | E-30 (L96: Collections.unmodifiableMap) | ○ |
| C-83 | Tags: キー重複時上書き | E-30 (HashMap.putの標準動作) | ○ |
| C-84 | NoopTracer.startSpan: NoopSpan返却 | E-20 (L38-40) | ○ |
| C-85 | NoopTracer.getCurrentSpan: SpanContext(NoopSpan)返却 | E-20 (L43-45) | ○ |
| C-86 | NoopTracer.startScopedSpan: NO_OP返却 | E-20 (L48-50) | ○ |
| C-87 | NoopTracer.withSpanInScope: NO_OP返却 | E-20 (L53-55) | ○ |
| C-88 | NoopTracer.isRecording: false返却 | E-20 (L58-60) | ○ |
| C-89 | NoopTracer.startSpan(headers): NoopSpan返却 | E-20 (L68-70) | ○ |
| C-90 | NoopTracer.close: 例外なし | E-20 (L63-65: 空メソッド) | ○ |
| C-91 | NoopSpan.INSTANCE: シングルトン | E-21 (L25) | ○ |
| C-92 | NoopSpan.getSpanName: noop-span | E-21 (L43-44) | ○ |
| C-93 | NoopSpan.getParentSpan: null | E-21 (L38-39) | ○ |
| C-94 | NoopSpan.getTraceId: noop-trace-id | E-21 (L77-78) | ○ |
| C-95 | NoopSpan.getSpanId: noop-span-id | E-21 (L82-83) | ○ |
| C-96 | NoopSpan: 各メソッドが例外なし | E-21 (空メソッド群) | ○ |
| C-97 | NoopSpanScope.attach: this返却 | E-22 (L35-37) | ○ |
| C-98 | NoopSpanScope.getSpan: NoopSpan返却 | E-22 (L40-42) | ○ |
| C-99 | NoopSpanScope.close: 例外なし | E-22 (L30-32: 空メソッド) | ○ |
| C-100 | NoopScopedSpan: 全メソッドが例外なし | E-23 (空メソッド群) | ○ |
| C-101 | NoopCounter.INSTANCE: シングルトン | E-31 (L25) | ○ |
| C-102 | NoopCounter.add: 例外なし | E-31 (L30-37: 空メソッド) | ○ |
| C-103 | NoopHistogram.INSTANCE: シングルトン | E-32 (L25) | ○ |
| C-104 | NoopHistogram.record: 例外なし | E-32 (L30-37: 空メソッド) | ○ |
| C-105 | NoopMetricsRegistry.createCounter: NoopCounter返却 | E-33 (L37-39) | ○ |
| C-106 | NoopMetricsRegistry.createUpDownCounter: NoopCounter返却 | E-33 (L42-44) | ○ |
| C-107 | NoopMetricsRegistry.createHistogram: NoopHistogram返却 | E-33 (L47-49) | ○ |
| C-108 | NoopMetricsRegistry.createGauge(Double): Closeable返却 | E-33 (L52-54) | ○ |
| C-109 | NoopMetricsRegistry.createGauge(TaggedMeasurement): Closeable返却 | E-33 (L57-59) | ○ |
| C-110 | NoopMetricsRegistry.close: 例外なし | E-33 (L62-64: 空メソッド) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全テストケースはソースコードの実装に基づいて生成されており、根拠が確認できています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - No-op実装のテストケース（C-84～C-110）は実装が自明であり、テストの網羅性に大きな影響はない
- 1: 中リスク - DefaultSpanScopeのThreadLocal操作（C-25～C-32）はマルチスレッド環境でのテスト設計に注意が必要
- 1: 中リスク - DefaultTracer.startSpan（C-01～C-06）の親スパン解決ロジックは条件分岐が複雑で、テスト漏れに注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] DefaultTracer.startSpanの親スパン解決（context.getParent() vs getCurrentSpanInternal()）の分岐が十分にテストされているか
- [ ] DefaultSpanScopeのattach/detachによるThreadLocalとTracerContextStorageの状態遷移が正しくテストされているか
- [ ] TraceableRunnableの例外発生時のScopedSpanクローズ保証が確認されているか
- [ ] Attributes/Tagsのnullチェック（String型のみObjects.requireNonNull、他の型はチェックなし）が適切にテストされているか
- [ ] DefaultMetricsRegistryの各メソッドがMetricsTelemetryに正しく委譲されていることが検証されているか
