---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 143
  claims_with_evidence: 140
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：libs-x-content 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：140 / 143、根拠なし：3
- 優先レビュー（高）
  1. **C-003 (UT-XCT-003)**: jsonBuilder(null)の挙動はソースコード上で明示的にnullチェックされていないため、実際の挙動は実行時依存
  2. **C-039 (UT-XCT-039)**: FIELD_NAMEトークンがreadValueに渡された場合のフォールバック動作は暗黙的
  3. **C-070 (UT-XCT-070)**: writeRawFieldの不正InputStreamに対するIllegalArgumentExceptionは、MediaTypeRegistry.xContentType()がnullを返す前提

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libs/x-content/src/main/java/org/opensearch/common/xcontent/XContentFactory.java` - XContentFactory全メソッド定義
- E-02: `libs/x-content/src/main/java/org/opensearch/common/xcontent/XContentType.java` - XContentType enum定義（JSON/SMILE/YAML/CBOR）
- E-03: `libs/x-content/src/main/java/org/opensearch/common/xcontent/XContentUtils.java` - readValueメソッド定義
- E-04: `libs/x-content/src/main/java/org/opensearch/common/xcontent/XContentContraints.java` - 制約定数定義
- E-05: `libs/x-content/src/main/java/org/opensearch/common/xcontent/json/JsonXContent.java` - JsonXContentクラス定義
- E-06: `libs/x-content/src/main/java/org/opensearch/common/xcontent/json/JsonXContentGenerator.java` - JsonXContentGeneratorクラス定義
- E-07: `libs/x-content/src/main/java/org/opensearch/common/xcontent/json/JsonXContentParser.java` - JsonXContentParserクラス定義
- E-08: `libs/x-content/src/main/java/org/opensearch/common/xcontent/cbor/CborXContent.java` - CborXContentクラス定義
- E-09: `libs/x-content/src/main/java/org/opensearch/common/xcontent/cbor/CborXContentGenerator.java` - CborXContentGeneratorクラス定義
- E-10: `libs/x-content/src/main/java/org/opensearch/common/xcontent/cbor/CborXContentParser.java` - CborXContentParserクラス定義
- E-11: `libs/x-content/src/main/java/org/opensearch/common/xcontent/smile/SmileXContent.java` - SmileXContentクラス定義
- E-12: `libs/x-content/src/main/java/org/opensearch/common/xcontent/smile/SmileXContentGenerator.java` - SmileXContentGeneratorクラス定義
- E-13: `libs/x-content/src/main/java/org/opensearch/common/xcontent/smile/SmileXContentParser.java` - SmileXContentParserクラス定義
- E-14: `libs/x-content/src/main/java/org/opensearch/common/xcontent/yaml/YamlXContent.java` - YamlXContentクラス定義
- E-15: `libs/x-content/src/main/java/org/opensearch/common/xcontent/yaml/YamlXContentGenerator.java` - YamlXContentGeneratorクラス定義
- E-16: `libs/x-content/src/main/java/org/opensearch/common/xcontent/yaml/YamlXContentParser.java` - YamlXContentParserクラス定義
- E-17: `libs/x-content/src/main/java/org/opensearch/common/xcontent/spi/XContentProvider.java` - XContentProviderクラス定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | XContentFactory.jsonBuilder()がJSON形式のXContentBuilderを返す | E-01 (L53-55) | ○ |
| C-002 | XContentFactory.jsonBuilder(OutputStream)がOutputStream付きビルダーを返す | E-01 (L60-62) | ○ |
| C-003 | jsonBuilder(null)でNullPointerExceptionがスローされる | **根拠不足** | △ |
| C-004 | XContentFactory.smileBuilder()がSMILE形式のXContentBuilderを返す | E-01 (L67-69) | ○ |
| C-005 | XContentFactory.smileBuilder(OutputStream)がOutputStream付きビルダーを返す | E-01 (L74-76) | ○ |
| C-006 | XContentFactory.yamlBuilder()がYAML形式のXContentBuilderを返す | E-01 (L81-83) | ○ |
| C-007 | XContentFactory.yamlBuilder(OutputStream)がOutputStream付きビルダーを返す | E-01 (L87-90) | ○ |
| C-008 | XContentFactory.cborBuilder()がCBOR形式のXContentBuilderを返す | E-01 (L95-97) | ○ |
| C-009 | XContentType.JSON.mediaTypeWithoutParameters()が"application/json"を返す | E-02 (L63-65) | ○ |
| C-010 | XContentType.JSON.mediaType()が"application/json; charset=UTF-8"を返す | E-02 (L68-70) | ○ |
| C-011 | 各XContentTypeのsubtype()が正しい値を返す | E-02 (L73-75, L113, L158, L197) | ○ |
| C-012 | 各XContentTypeのxContent()が正しいインスタンスを返す | E-02 (L78-80, L117-119, L162-164, L201-203) | ○ |
| C-013 | JSON形式のバイト配列が'{'で検出される | E-02 (L83-85) | ○ |
| C-014 | SMILE形式のバイト配列がヘッダーバイトで検出される | E-02 (L122-127) | ○ |
| C-015 | YAML形式のバイト配列が'---'で検出される | E-02 (L167-168) | ○ |
| C-016 | CBOR形式のバイト配列が検出される | E-02 (L206-223) | ○ |
| C-017 | SMILE検出でlength<=2の場合falseが返る | E-02 (L123) | ○ |
| C-018 | YAML検出でlength<=2の場合falseが返る | E-02 (L167) | ○ |
| C-019 | JSON形式のCharSequenceが'{'で検出される | E-02 (L88-90) | ○ |
| C-020 | CBOR形式のCharSequence検出は常にfalseを返す | E-02 (L226-228) | ○ |
| C-021 | 各enum定数のindex値が正しい | E-02 (L61, L105, L150, L189) | ○ |
| C-022 | type()が"application"を返す | E-02 (L252-254) | ○ |
| C-023 | format()がsubtype()と同一値を返す | E-02 (L257-259) | ○ |
| C-024 | writeTo()がmediaType()の値をwriteStringで書き込む | E-02 (L262-264) | ○ |
| C-025 | 各enumからcontentBuilder()でXContentBuilderが生成される | E-02 (L92-95, L138-140, L177-179, L231-233) | ○ |
| C-026 | OutputStream指定でcontentBuilder()が動作する | E-02 (L97-100, L143-145, L182-184, L236-238) | ○ |
| C-027 | CBOR自己記述タグが検出される | E-02 (L212-215) | ○ |
| C-028 | CBOR MAJOR_TYPE_OBJECTバイトが検出される | E-02 (L219-221) | ○ |
| C-029 | readValueでVALUE_NULLがnullを返す | E-03 (L47-48) | ○ |
| C-030 | readValueでVALUE_STRINGが文字列を返す | E-03 (L49-50) | ○ |
| C-031 | readValueでVALUE_NUMBER(INT)が整数を返す | E-03 (L51-54) | ○ |
| C-032 | readValueでVALUE_NUMBER(LONG)がlongを返す | E-03 (L55-56) | ○ |
| C-033 | readValueでVALUE_NUMBER(FLOAT)がfloatを返す | E-03 (L57-58) | ○ |
| C-034 | readValueでVALUE_NUMBER(DOUBLE)がdoubleを返す | E-03 (L59-60) | ○ |
| C-035 | readValueでVALUE_BOOLEANがbooleanを返す | E-03 (L62-63) | ○ |
| C-036 | readValueでSTART_OBJECTがMapを返す | E-03 (L64-65) | ○ |
| C-037 | readValueでSTART_ARRAYがListを返す | E-03 (L66-67) | ○ |
| C-038 | readValueでVALUE_EMBEDDED_OBJECTがbinaryValueを返す | E-03 (L68-69) | ○ |
| C-039 | readValueで未処理トークンがnullを返す | **根拠不足** | △ |
| C-040 | JsonXContent.contentBuilder()がXContentBuilderを返す | E-05 (L65-67) | ○ |
| C-041 | JsonXContent.mediaType()がXContentType.JSONを返す | E-05 (L97-100) | ○ |
| C-042 | JsonXContent.streamSeparator()が'\n'を返す | E-05 (L103-105) | ○ |
| C-043 | JsonXContent.createGenerator()がJsonXContentGeneratorを返す | E-05 (L108-110) | ○ |
| C-044 | JsonXContent.createParser(String)がJsonXContentParserを返す | E-05 (L113-116) | ○ |
| C-045 | JsonXContent.createParser(InputStream)がJsonXContentParserを返す | E-05 (L119-122) | ○ |
| C-046 | JsonXContent.createParser(byte[])がJsonXContentParserを返す | E-05 (L125-128) | ○ |
| C-047 | JsonXContent.createParser(byte[], offset, length)がJsonXContentParserを返す | E-05 (L131-139) | ○ |
| C-048 | JsonXContent.createParser(Reader)がJsonXContentParserを返す | E-05 (L142-145) | ○ |
| C-049 | JsonXContentGeneratorがフィルタなしで生成される | E-06 (L91-129) | ○ |
| C-050 | JsonXContentGeneratorがincludeフィルタ付きで生成される | E-06 (L113-121) | ○ |
| C-051 | JsonXContentGeneratorがexcludeフィルタ付きで生成される | E-06 (L103-111) | ○ |
| C-052 | includes=nullでNullPointerExceptionがスローされる | E-06 (L92) | ○ |
| C-053 | excludes=nullでNullPointerExceptionがスローされる | E-06 (L93) | ○ |
| C-054 | JsonXContentGenerator.contentType()がJSONを返す | E-06 (L132-134) | ○ |
| C-055 | usePrettyPrint()でprettyPrintが有効化される | E-06 (L137-140) | ○ |
| C-056 | isPrettyPrint()のデフォルトがfalse | E-06 (L89) | ○ |
| C-057 | writeStartObject/writeEndObjectが正常動作する | E-06 (L175-194) | ○ |
| C-058 | フィルタ付きでルートオブジェクトが低レベルジェネレータで書き込まれる | E-06 (L176-181) | ○ |
| C-059 | writeStartArray/writeEndArrayが正常動作する | E-06 (L197-204) | ○ |
| C-060 | writeFieldNameが正常動作する | E-06 (L207-209) | ○ |
| C-061 | writeNullが正常動作する | E-06 (L212-214) | ○ |
| C-062 | writeBooleanFieldが正常動作する | E-06 (L222-224) | ○ |
| C-063 | writeNumberField(double)が正常動作する | E-06 (L232-234) | ○ |
| C-064 | writeNumberField(int)が正常動作する | E-06 (L252-254) | ○ |
| C-065 | writeNumberField(long)が正常動作する | E-06 (L275-277) | ○ |
| C-066 | writeNumberField(BigInteger)がフィールド名と値を書き込む | E-06 (L257-262) | ○ |
| C-067 | writeStringFieldが正常動作する | E-06 (L300-302) | ○ |
| C-068 | writeBinaryFieldが正常動作する | E-06 (L320-322) | ○ |
| C-069 | writeRawField(String, InputStream)が正常動作する | E-06 (L349-359) | ○ |
| C-070 | writeRawFieldで不正InputStreamがIllegalArgumentExceptionをスローする | E-06 (L355-357) | △ |
| C-071 | writeRawField(String, InputStream, MediaType)が正常動作する | E-06 (L365-385) | ○ |
| C-072 | 異なるメディアタイプのrawフィールドがパース・再書き込みされる | E-06 (L366-378) | ○ |
| C-073 | writeRawValueが正常動作する | E-06 (L391-403) | ○ |
| C-074 | copyCurrentStructureがJsonXContentParserで動作する | E-06 (L448-458) | ○ |
| C-075 | copyCurrentStructureが非Jsonパーサーで動作する | E-06 (L455-457, L463-491) | ○ |
| C-076 | close()が正常にクローズする | E-06 (L499-513) | ○ |
| C-077 | 未閉じ構造でclose()がIOExceptionをスローする | E-06 (L504-506) | ○ |
| C-078 | writeLineFeedAtEnd有効時にクローズ時改行が追加される | E-06 (L507-511) | ○ |
| C-079 | 二重クローズが安全に動作する | E-06 (L500-502) | ○ |
| C-080 | isClosed()が正しい状態を返す | E-06 (L516-518) | ○ |
| C-081 | flush()が正常動作する | E-06 (L494-496) | ○ |
| C-082 | JsonXContentParser.contentType()がJSONを返す | E-07 (L60-62) | ○ |
| C-083 | nextToken()がJSONトークンを正しく変換する | E-07 (L65-67, L239-268) | ○ |
| C-084 | currentToken()が現在のトークンを返す | E-07 (L75-77) | ○ |
| C-085 | text()がVALUE_STRINGで文字列を返す | E-07 (L95-100) | ○ |
| C-086 | text()が非VALUE系トークンでIllegalStateExceptionをスローする | E-07 (L96-99) | ○ |
| C-087 | objectText()がVALUE_STRINGで文字列を返す | E-07 (L109-111) | ○ |
| C-088 | objectText()がVALUE_NUMBER_INTで数値を返す | E-07 (L112-113) | ○ |
| C-089 | objectText()がVALUE_TRUEでBoolean.TRUEを返す | E-07 (L114-115) | ○ |
| C-090 | objectText()がVALUE_FALSEでBoolean.FALSEを返す | E-07 (L116-117) | ○ |
| C-091 | objectText()がVALUE_NULLでnullを返す | E-07 (L118-119) | ○ |
| C-092 | objectBytes()がVALUE_STRINGでCharBufferを返す | E-07 (L128-129) | ○ |
| C-093 | objectBytes()がVALUE_NULLでnullを返す | E-07 (L136-137) | ○ |
| C-094 | numberType()がINTを正しく変換する | E-07 (L221-224) | ○ |
| C-095 | numberType()がLONGを正しく変換する | E-07 (L227-228) | ○ |
| C-096 | numberType()がFLOATを正しく変換する | E-07 (L229-230) | ○ |
| C-097 | numberType()がDOUBLEを正しく変換する | E-07 (L231-232) | ○ |
| C-098 | numberType()がBIG_INTEGERを正しく変換する | E-07 (L225-226) | ○ |
| C-099 | numberType()がBIG_DECIMALを正しく変換する | E-07 (L233-234) | ○ |
| C-100 | doBigIntegerValue()がVALUE_NUMBER_FLOATからBigIntegerに変換する | E-07 (L195-196) | ○ |
| C-101 | doBigIntegerValue()がVALUE_NUMBER_INTからBigIntegerを取得する | E-07 (L197-198) | ○ |
| C-102 | getTokenLocation()がXContentLocationを返す | E-07 (L208-214) | ○ |
| C-103 | getTokenLocation()がnull位置でnullを返す | E-07 (L210-211) | ○ |
| C-104 | close()がパーサーをクローズする | E-07 (L217-219) | ○ |
| C-105 | isClosed()が正しい状態を返す | E-07 (L271-273) | ○ |
| C-106 | convertTokenが全JsonTokenを正しく変換する | E-07 (L239-268) | ○ |
| C-107 | convertTokenがnullでnullを返す | E-07 (L240-242) | ○ |
| C-108 | skipChildren()が子要素をスキップする | E-07 (L70-72) | ○ |
| C-109 | CborXContent.contentBuilder()がCBOR XContentBuilderを返す | E-08 (L65-67) | ○ |
| C-110 | CborXContent.mediaType()がXContentType.CBORを返す | E-08 (L95-97) | ○ |
| C-111 | CborXContent.streamSeparator()がXContentParseExceptionをスローする | E-08 (L100-102) | ○ |
| C-112 | CborXContent.createGenerator()がCborXContentGeneratorを返す | E-08 (L105-107) | ○ |
| C-113 | CborXContent.createParser(String)がCborXContentParserを返す | E-08 (L110-113) | ○ |
| C-114 | CborXContentGenerator.contentType()がCBORを返す | E-09 (L49-52) | ○ |
| C-115 | CborXContentGenerator.usePrintLineFeedAtEnd()がno-op | E-09 (L55-57) | ○ |
| C-116 | CborXContentGenerator.supportsRawWrites()がfalseを返す | E-09 (L60-62) | ○ |
| C-117 | CborXContentParser.contentType()がCBORを返す | E-10 (L48-51) | ○ |
| C-118 | SmileXContent.contentBuilder()がSMILE XContentBuilderを返す | E-11 (L65-67) | ○ |
| C-119 | SmileXContent.mediaType()がXContentType.SMILEを返す | E-11 (L97-99) | ○ |
| C-120 | SmileXContent.streamSeparator()が0xFFを返す | E-11 (L102-104) | ○ |
| C-121 | SmileXContent.createGenerator()がSmileXContentGeneratorを返す | E-11 (L107-109) | ○ |
| C-122 | SmileXContent.createParser(String)がSmileXContentParserを返す | E-11 (L112-115) | ○ |
| C-123 | SmileXContentGenerator.contentType()がSMILEを返す | E-12 (L49-52) | ○ |
| C-124 | SmileXContentGenerator.usePrintLineFeedAtEnd()がno-op | E-12 (L55-57) | ○ |
| C-125 | SmileXContentGenerator.supportsRawWrites()がfalseを返す | E-12 (L60-62) | ○ |
| C-126 | SmileXContentParser.contentType()がSMILEを返す | E-13 (L48-51) | ○ |
| C-127 | YamlXContent.contentBuilder()がYAML XContentBuilderを返す | E-14 (L65-67) | ○ |
| C-128 | YamlXContent.mediaType()がXContentType.YAMLを返す | E-14 (L92-94) | ○ |
| C-129 | YamlXContent.streamSeparator()がUnsupportedOperationExceptionをスローする | E-14 (L97-99) | ○ |
| C-130 | YamlXContent.createGenerator()がYamlXContentGeneratorを返す | E-14 (L102-104) | ○ |
| C-131 | YamlXContent.createParser(String)がYamlXContentParserを返す | E-14 (L107-110) | ○ |
| C-132 | YamlXContentGenerator.contentType()がYAMLを返す | E-15 (L49-52) | ○ |
| C-133 | YamlXContentGenerator.usePrintLineFeedAtEnd()がno-op | E-15 (L55-57) | ○ |
| C-134 | YamlXContentGenerator.supportsRawWrites()がfalseを返す | E-15 (L60-62) | ○ |
| C-135 | YamlXContentParser.contentType()がYAMLを返す | E-16 (L48-51) | ○ |
| C-136 | XContentProvider.getMediaTypes()が全XContentType値を返す | E-17 (L26-28) | ○ |
| C-137 | XContentProvider.getAdditionalMediaTypes()が追加マッピングを返す | E-17 (L32-34) | ○ |
| C-138 | application/*がJSONにマッピングされる | E-17 (L33) | ○ |
| C-139 | application/x-ndjsonがJSONにマッピングされる | E-17 (L33) | ○ |
| C-140 | DEFAULT_MAX_STRING_LENのデフォルト値が50000000 | E-04 (L27) | ○ |
| C-141 | DEFAULT_MAX_NAME_LENのデフォルト値が50000 | E-04 (L29-31) | ○ |
| C-142 | DEFAULT_MAX_DEPTHのデフォルト値が1000 | E-04 (L33-35) | ○ |
| C-143 | DEFAULT_CODEPOINT_LIMITのデフォルト値が52428800 | E-04 (L37) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-003: XContentFactory.jsonBuilder(null)の挙動について、XContentBuilderコンストラクタの実装がlibs-coreモジュールに存在するため、当モジュール内のソースコードだけでは正確な例外型を断定できない
  - 候補：XContentBuilderのコンストラクタ実装 / Jackson JsonFactoryのcreateGenerator(null)挙動
- C-039: readValueメソッドにFIELD_NAMEなどの未処理トークンが渡された場合、明示的なハンドリングはなくメソッド末尾でnullが返却される。この動作は意図的かどうかコメントが無い
  - 候補：readValueの呼び出し元での事前バリデーション確認
- C-070: MediaTypeRegistry.xContentType()がnullを返す条件は、libs-coreモジュールの実装に依存する
  - 候補：MediaTypeRegistry.xContentType()の実装確認

## 5) リスクフラグ（レビュー観点）
- 0: XContentFactory, XContentType, XContentProvider - ソースコードから直接読み取れるテストケース（低リスク）
- 0: JsonXContent, SmileXContent, YamlXContent, CborXContent - createParser/createGeneratorの正常系（低リスク）
- 1: JsonXContentGenerator.writeRawField/writeRawValue - メディアタイプ判定とフィルタリングの複合条件（中リスク）
- 1: JsonXContentParser.convertToken/convertNumberType - 全パターンの網羅性（中リスク）
- 0: XContentContraints - 定数値の確認のみ（低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] C-003: jsonBuilder(null)の実際の挙動をXContentBuilderコンストラクタの実装と照合する
- [ ] C-039: readValueメソッドのフォールバック動作が意図的かどうか確認する
- [ ] C-070: MediaTypeRegistry.xContentType()がnullを返す条件を確認し、IllegalArgumentExceptionの期待結果が正しいか検証する
- [ ] JsonXContentGeneratorのフィルタリング関連テストケース（C-050, C-051, C-058, C-072）が十分に詳細か確認する
- [ ] XContentContraintsのデフォルト値がシステムプロパティで上書き可能であることのテストケースの追加を検討する
