---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 131
  claims_with_evidence: 127
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：modules-aggs-matrix-stats 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：127 / 131、根拠なし：4
- 優先レビュー（高）
  1. **C-010（RunningStats addArrays 複数回追加の期待結果具体値）**：統計計算の正確な期待値は手動計算による検証が必要
  2. **C-073（InternalMatrixStats doXContentBody JSON構造）**：XContent出力の詳細構造はランタイム依存
  3. **C-089（MatrixStatsAggregator getLeafCollector内部のincludeDocumentロジック）**：LeafBucketCollectorの内部匿名クラスの動作はインテグレーション的検証が必要
  4. **C-097（ParsedMatrixStats fromXContent）**：ObjectParser経由のパース結果の正確性はXContentの内容に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/RunningStats.java`
- E-02: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStatsResults.java`
- E-03: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/InternalMatrixStats.java`
- E-04: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStatsAggregator.java`
- E-05: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStatsAggregationBuilder.java`
- E-06: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStats.java`
- E-07: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/ParsedMatrixStats.java`
- E-08: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStatsParser.java`
- E-09: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixAggregationInspectionHelper.java`
- E-10: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStatsAggregatorFactory.java`
- E-11: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/support/ArrayValuesSource.java`
- E-12: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/support/ArrayValuesSourceParser.java`
- E-13: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/support/ArrayValuesSourceAggregationBuilder.java`
- E-14: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/support/ArrayValuesSourceAggregatorFactory.java`
- E-15: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/MatrixAggregationModulePlugin.java`
- E-16: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/spi/MatrixStatsNamedXContentProvider.java`
- E-17: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/MatrixStatsAggregationBuilders.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | RunningStats(String[])でfieldNames非nullなら配列モードで初期化 | E-01 (L98-101, L111-131) | ○ |
| C-002 | RunningStats(String[])でfieldNames=nullならマップモードで初期化 | E-01 (L100, L111-120) | ○ |
| C-003 | RunningStats(String[], double[])で初期値付き初期化 | E-01 (L103-109) | ○ |
| C-004 | fieldVals=nullの場合は初期化されない | E-01 (L105) | ○ |
| C-005 | fieldVals=空配列の場合は初期化されない | E-01 (L105) | ○ |
| C-006 | add()で統計値が更新される | E-01 (L271-280) | ○ |
| C-007 | add()でfieldVals=nullならIllegalArgumentException | E-01 (L272-274) | ○ |
| C-008 | addArrays()でサイズ不一致ならIllegalArgumentException | E-01 (L283-285) | ○ |
| C-009 | addArrays()でdocCount=1のとき平均=値そのもの | E-01 (L303-304) | ○ |
| C-010 | addArrays()で複数回追加の統計モーメント計算 | E-01 (L287-322) | △ |
| C-011 | addMaps()でfieldNames=nullならIllegalArgumentException | E-01 (L326-327) | ○ |
| C-012 | addMaps()でサイズ不一致ならIllegalArgumentException | E-01 (L328-330) | ○ |
| C-013 | addMaps()でマップモード統計更新 | E-01 (L325-375) | ○ |
| C-014 | merge()で配列ベースマージ | E-01 (L419-434, L436-503) | ○ |
| C-015 | merge()でother=nullなら何もしない | E-01 (L420-422) | ○ |
| C-016 | merge()でdocCount=0ならotherをコピー | E-01 (L441-451) | ○ |
| C-017 | merge()で配列モードのfieldNames不一致ならIllegalArgumentException | E-01 (L439-440) | ○ |
| C-018 | merge()で混合モードの場合にマップモードに統一 | E-01 (L428-433) | ○ |
| C-019 | switchToMaps()で配列からマップへ変換 | E-01 (L133-144) | ○ |
| C-020 | switchToMaps()で既にマップモードなら何もしない | E-01 (L135) | ○ |
| C-021 | switchToArrays()でマップから配列へ変換 | E-01 (L146-157) | ○ |
| C-022 | switchToArrays()でfieldNames=nullならIllegalArgumentException | E-01 (L148) | ○ |
| C-023 | RunningStatsのシリアライズ/デシリアライズ | E-01 (L161-268) | ○ |
| C-024 | RunningStats clone()が正しく動作 | E-01 (L613-619) | ○ |
| C-025 | RunningStats equals/hashCode（同一データ） | E-01 (L626-666) | ○ |
| C-026 | RunningStats equals/hashCode（異なるデータ） | E-01 (L626-666) | ○ |
| C-027 | convertDoubleArrayToMap変換 | E-01 (L212-218) | ○ |
| C-028 | convertLongArrayToMap変換 | E-01 (L220-226) | ○ |
| C-029 | convertNestedDoubleArrayToMap変換 | E-01 (L228-238) | ○ |
| C-030 | MatrixStatsResults(RunningStats)で最終結果計算 | E-02 (L62-66, L224-263) | ○ |
| C-031 | getDocCount() | E-02 (L89-91) | ○ |
| C-032 | getFieldCount(存在フィールド) | E-02 (L94-108) | ○ |
| C-033 | getFieldCount(不在フィールド)=0 | E-02 (L104-106) | ○ |
| C-034 | getMean(正常) | E-02 (L123-127) | ○ |
| C-035 | getMean(不在フィールド)でIllegalArgumentException | E-02 (L214-221) | ○ |
| C-036 | getMean(null)でIllegalArgumentException | E-02 (L215-217) | ○ |
| C-037 | getVariance(正常) | E-02 (L135-139) | ○ |
| C-038 | getSkewness(正常) | E-02 (L147-151) | ○ |
| C-039 | getKurtosis(正常) | E-02 (L159-163) | ○ |
| C-040 | getCovariance(異なるフィールド) | E-02 (L171-178) | ○ |
| C-041 | getCovariance(同一フィールド)=variance | E-02 (L173-176) | ○ |
| C-042 | getCorrelation(同一フィールド)=1.0 | E-02 (L187-189) | ○ |
| C-043 | getCorrelation(異なるフィールド) | E-02 (L186-191) | ○ |
| C-044 | getCorrelation(分散0)=NaN | E-02 (L252-253) | ○ |
| C-045 | getValFromUpperTriangularMatrix(fieldXが行キー) | E-02 (L194-212) | ○ |
| C-046 | getValFromUpperTriangularMatrix(fieldYが行キー) | E-02 (L207-209) | ○ |
| C-047 | getValFromUpperTriangularMatrix(両フィールド不在)でIllegalArgumentException | E-02 (L196-197) | ○ |
| C-048 | MatrixStatsResultsシリアライズ/デシリアライズ | E-02 (L70-86) | ○ |
| C-049 | MatrixStatsResults equals/hashCode | E-02 (L266-276) | ○ |
| C-050 | InternalMatrixStats getDocCount(stats有) | E-03 (L103-108) | ○ |
| C-051 | InternalMatrixStats getDocCount(stats=null)=0 | E-03 (L104-106) | ○ |
| C-052 | InternalMatrixStats getFieldCount(results有) | E-03 (L112-117) | ○ |
| C-053 | InternalMatrixStats getFieldCount(results=null)=0 | E-03 (L113-115) | ○ |
| C-054 | InternalMatrixStats getMean(results有) | E-03 (L121-126) | ○ |
| C-055 | InternalMatrixStats getMean(results=null)=NaN | E-03 (L122-124) | ○ |
| C-056 | InternalMatrixStats getVariance(results=null)=NaN | E-03 (L131-133) | ○ |
| C-057 | InternalMatrixStats getSkewness(results=null)=NaN | E-03 (L140-142) | ○ |
| C-058 | InternalMatrixStats getKurtosis(results=null)=NaN | E-03 (L149-151) | ○ |
| C-059 | InternalMatrixStats getCovariance(results=null)=NaN | E-03 (L158-160) | ○ |
| C-060 | InternalMatrixStats getCorrelation(results=null)=NaN | E-03 (L167-169) | ○ |
| C-061 | reduce(isFinalReduce=true)でMatrixStatsResults計算 | E-03 (L264-284) | ○ |
| C-062 | reduce(isFinalReduce=false)でresults=null | E-03 (L283) | ○ |
| C-063 | reduce(全stats=null)で空結果 | E-03 (L270-271) | ○ |
| C-064 | getProperty(path=[])=this | E-03 (L233-234) | ○ |
| C-065 | getProperty(path=["counts"]) | E-03 (L241-242) | ○ |
| C-066 | getProperty(path=["means"]) | E-03 (L243-244) | ○ |
| C-067 | getProperty(不正パス)でIllegalArgumentException | E-03 (L256) | ○ |
| C-068 | getProperty(パス長>1)でIllegalArgumentException | E-03 (L258-260) | ○ |
| C-069 | getProperty(results=null)でemptyMap | E-03 (L237-239) | ○ |
| C-070 | InternalMatrixStatsシリアライズ/デシリアライズ | E-03 (L76-94) | ○ |
| C-071 | getWriteableName()="matrix_stats" | E-03 (L97-99) | ○ |
| C-072 | mustReduceOnSingleInternalAgg()=true | E-03 (L287-289) | ○ |
| C-073 | doXContentBody JSON構造 | E-03 (L194-229) | △ |
| C-074 | doXContentBody(results=null)でfields未出力 | E-03 (L196) | ○ |
| C-075 | InternalMatrixStats equals/hashCode | E-03 (L292-304) | ○ |
| C-076 | MatrixStatsAggregationBuilder(String) | E-05 (L56-58) | ○ |
| C-077 | multiValueMode setter/getter | E-05 (L93-100) | ○ |
| C-078 | multiValueModeデフォルト=AVG | E-05 (L54) | ○ |
| C-079 | getType()="matrix_stats" | E-05 (L119-121) | ○ |
| C-080 | shallowCopyでmultiValueMode保持 | E-05 (L60-67, L70-72) | ○ |
| C-081 | MatrixStatsAggregationBuilder equals/hashCode | E-05 (L124-135) | ○ |
| C-082 | MatrixStatsAggregationBuilderシリアライズ/デシリアライズ | E-05 (L77-91) | ○ |
| C-083 | MatrixStatsAggregator(valuesSources=null) | E-04 (L74-79) | ○ |
| C-084 | MatrixStatsAggregator(空TreeMap) | E-04 (L74) | ○ |
| C-085 | scoreMode(valuesSources=null)=COMPLETE_NO_SCORES | E-04 (L83-85) | ○ |
| C-086 | buildEmptyAggregation | E-04 (L160-162) | ○ |
| C-087 | buildAggregation(valuesSources=null) | E-04 (L153-155) | ○ |
| C-088 | buildAggregation(bucket>=stats.size()) | E-04 (L153) | ○ |
| C-089 | getLeafCollector(valuesSources=null)=NO_OP_COLLECTOR | E-04 (L89-91) | △ |
| C-090 | ParsedMatrixStats getDocCount | E-07 (L69-71) | ○ |
| C-091 | ParsedMatrixStats getFieldCount(存在) | E-07 (L74-79) | ○ |
| C-092 | ParsedMatrixStats getFieldCount(不在)=0 | E-07 (L75-77) | ○ |
| C-093 | ParsedMatrixStats getMean(null)でIllegalArgumentException | E-07 (L157-165) | ○ |
| C-094 | ParsedMatrixStats getMean(不在)でIllegalArgumentException | E-07 (L161-163) | ○ |
| C-095 | ParsedMatrixStats getCovariance(同一フィールド)=variance | E-07 (L103-104) | ○ |
| C-096 | ParsedMatrixStats getCorrelation(同一フィールド)=1.0 | E-07 (L111-112) | ○ |
| C-097 | ParsedMatrixStats fromXContent | E-07 (L167-193) | △ |
| C-098 | ParsedMatrixStats getType()="matrix_stats" | E-07 (L60-62) | ○ |
| C-099 | mapValueAsDouble(Double) | E-07 (L244-246) | ○ |
| C-100 | mapValueAsDouble(String) | E-07 (L247) | ○ |
| C-101 | MatrixStatsParser() formattable=true | E-08 (L47-49) | ○ |
| C-102 | MatrixStatsParser token(mode) | E-08 (L52-66) | ○ |
| C-103 | MatrixStatsParser token(unknown)=false | E-08 (L52-66) | ○ |
| C-104 | createFactory(mode有) | E-08 (L69-81) | ○ |
| C-105 | createFactory(mode無)=AVG | E-08 (L75-80) | ○ |
| C-106 | hasValue(results!=null)=true | E-09 (L39-41) | ○ |
| C-107 | hasValue(results=null)=false | E-09 (L39-41) | ○ |
| C-108 | createUnmapped | E-10 (L68-69) | ○ |
| C-109 | doCreateInternal(Numeric) | E-10 (L73-91) | ○ |
| C-110 | doCreateInternal(非Numeric)でAggregationExecutionException | E-10 (L86-88) | ○ |
| C-111 | supportsConcurrentSegmentSearch()=true | E-10 (L95-97) | ○ |
| C-112 | NumericArrayValuesSourceコンストラクタ | E-11 (L49-57) | ○ |
| C-113 | NumericArrayValuesSource(null)=空配列 | E-11 (L52-56) | ○ |
| C-114 | getField(正常ordinal) | E-11 (L59-63) | ○ |
| C-115 | getField(範囲外)でIndexOutOfBoundsException | E-11 (L60-61) | ○ |
| C-116 | needsScores()=false | E-11 (L92-98) | ○ |
| C-117 | fieldNames()ソート順 | E-11 (L103-105, L85-90) | ○ |
| C-118 | fields(List)設定 | E-13 (L153-160) | ○ |
| C-119 | fields(null)でIllegalArgumentException | E-13 (L155-157) | ○ |
| C-120 | format設定 | E-13 (L173-179) | ○ |
| C-121 | format(null)でIllegalArgumentException | E-13 (L174-176) | ○ |
| C-122 | missingMap設定 | E-13 (L193-199) | ○ |
| C-123 | missingMap(null)でIllegalArgumentException | E-13 (L194-196) | ○ |
| C-124 | LeafOnly.subAggregationsでAggregationInitializationException | E-13 (L82-86) | ○ |
| C-125 | LeafOnly.bucketCardinality()=NONE | E-13 (L89-91) | ○ |
| C-126 | ArrayValuesSourceAggregationBuilder equals/hashCode | E-13 (L269-283) | ○ |
| C-127 | createInternal(hasValues=true)でdoCreateInternal | E-14 (L63-81) | ○ |
| C-128 | createInternal(hasValues=false)でcreateUnmapped | E-14 (L77-79) | ○ |
| C-129 | MatrixAggregationModulePlugin getAggregations | E-15 (L46-53) | ○ |
| C-130 | MatrixStatsNamedXContentProvider getNamedXContentParsers | E-16 (L47-54) | ○ |
| C-131 | MatrixStatsAggregationBuilders.matrixStats() | E-17 (L41-43) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-010：RunningStatsの逐次統計計算（mean, variance, skewness, kurtosis）の数値的正確性は、アルゴリズム（Sandia論文ベース）に基づく手動計算または既存テストとの照合が必要
  - 候補：既存テストコード / 統計計算の参照実装 / Sandia論文の数式
- C-073：doXContentBodyが生成するJSON構造の詳細は、XContentBuilderの振る舞いに依存するため、実行時の出力確認が推奨される
  - 候補：既存のXContent出力テスト / InternalMatrixStatsTests
- C-089：getLeafCollectorのNO_OP_COLLECTOR返却はコード上明確だが、内部匿名クラスのincludeDocumentロジック（Double.NEGATIVE_INFINITYの除外等）はインテグレーションテストが適切
  - 候補：MatrixStatsAggregatorTests / インテグレーションテスト
- C-097：fromXContentのパース結果の正確性検証には、ObjectParserの振る舞いに依存するため完全な正確性確認はXContent入力のバリエーションテストが必要
  - 候補：ParsedMatrixStatsTests / InternalMatrixStatsTests

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全体として、テストケースはソースコード上の分岐・バリデーション・戻り値に基づいており、ほぼ全て根拠がある
- 1（中リスク）：統計計算（モーメント計算、マージ計算）の期待値の数値的正確性は手動検証が必要。特にRunningStatsのmerge()、MatrixStatsResultsのcompute()における数学的正確性
- 0（低リスク）：シリアライズ/デシリアライズのテストケースは、Writeable/StreamInputインターフェースの標準パターンに基づく

## 6) レビュアーチェックリスト（最小）
- [ ] RunningStatsの統計計算テスト（C-010）の期待値が数学的に正しいか確認する
- [ ] InternalMatrixStats.reduce()のテストケースが全分岐（全null、中間reduce、最終reduce）をカバーしているか確認する
- [ ] MatrixStatsAggregatorのLeafBucketCollector内部ロジック（NEGATIVE_INFINITY除外）に対するテストの十分性を検討する
- [ ] シリアライズ/デシリアライズテストがバージョン互換性（ARRAY_IMPL_VERSION前後）を十分にカバーしているか確認する
- [ ] ArrayValuesSourceのgetFieldにおけるordinal境界チェック（>ではなく>=が正しいか）をレビューする
