---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 150
  claims_with_evidence: 146
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：modules-analysis-common 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：146 / 150、根拠なし：4
- 優先レビュー（高）
  1. **C-072 (buildSynonymAnalyzer - カスタムシノニムアナライザ)**: AnalysisRegistryの内部挙動に依存し、実際の統合テストでの確認が望ましい
  2. **C-067 (getRulesFromSettings - ファイル同義語)**: ファイルI/Oの動作は実行環境に依存
  3. **C-077 (MultiplexerTokenFilterFactory - IDENTITY_FILTER)**: IDENTITY_FILTERの定義はTokenFilterFactoryインターフェースに存在するため間接根拠
  4. **C-106 (AnalysisPredicateScript.Token - getPosition)**: ポジション計算ロジックの初期値-1からの推移の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/CommonAnalysisModulePlugin.java`
- E-02: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/CharMatcher.java`
- E-03: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/PatternAnalyzer.java`
- E-04: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/FingerprintAnalyzer.java`
- E-05: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/SnowballAnalyzer.java`
- E-06: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/NGramTokenizerFactory.java`
- E-07: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/NGramTokenFilterFactory.java`
- E-08: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/EdgeNGramTokenFilterFactory.java`
- E-09: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/CharGroupTokenizerFactory.java`
- E-10: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/SynonymTokenFilterFactory.java`
- E-11: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/MultiplexerTokenFilterFactory.java`
- E-12: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/ScriptedConditionTokenFilterFactory.java`
- E-13: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/EnglishPluralStemFilter.java`
- E-14: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/UniqueTokenFilter.java`
- E-15: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/AnalysisPredicateScript.java`
- E-16: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/MappingCharFilterFactory.java`
- E-17: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/WordDelimiterTokenFilterFactory.java`
- E-18: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/StemmerTokenFilterFactory.java`
- E-19: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/LengthTokenFilterFactory.java`
- E-20: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/ConcatenateGraphTokenFilterFactory.java`
- E-21: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/DelimitedPayloadTokenFilterFactory.java`
- E-22: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/KeywordMarkerTokenFilterFactory.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | getAnalyzersが全アナライザを返却する | E-01 (L204-248) | ○ |
| C-002 | getTokenFiltersが全トークンフィルタを返却する | E-01 (L251-367) | ○ |
| C-003 | getTokenizersが全トークナイザを返却する | E-01 (L379-438) | ○ |
| C-004 | getCharFiltersがチャーフィルタを返却する | E-01 (L370-376) | ○ |
| C-005 | getPreConfiguredTokenFiltersが事前設定フィルタを返却する | E-01 (L513-646) | ○ |
| C-006 | getPreConfiguredTokenizersが事前設定トークナイザを返却する | E-01 (L649-713) | ○ |
| C-007 | V3.0以降でedgeNGramフィルタ名がエラーになる | E-01 (L275-289) | ○ |
| C-008 | V3.0以降でnGramトークナイザ名がエラーになる | E-01 (L384-398) | ○ |
| C-009 | getContextsがAnalysisPredicateScript.CONTEXTを返却する | E-01 (L199-201) | ○ |
| C-010 | createComponentsがscriptServiceをセットする | E-01 (L181-196) | ○ |
| C-011 | CharMatcher.Basic.LETTERが英字にマッチする | E-02 (L62-67) | ○ |
| C-012 | CharMatcher.Basic.LETTERが数字にマッチしない | E-02 (L62-67) | ○ |
| C-013 | CharMatcher.Basic.DIGITが数字にマッチする | E-02 (L68-73) | ○ |
| C-014 | CharMatcher.Basic.WHITESPACEが空白にマッチする | E-02 (L74-79) | ○ |
| C-015 | CharMatcher.Basic.PUNCTUATIONが句読点にマッチする | E-02 (L80-96) | ○ |
| C-016 | CharMatcher.Basic.SYMBOLが記号にマッチする | E-02 (L97-111) | ○ |
| C-017 | ByUnicodeCategoryが指定カテゴリ文字にマッチする | E-02 (L43-59) | ○ |
| C-018 | ByUnicodeCategoryが非一致文字にマッチしない | E-02 (L43-59) | ○ |
| C-019 | Builder空でfalseを返すCharMatcherが生成される | E-02 (L126-133) | ○ |
| C-020 | Builder1件でそのマッチャーが返却される | E-02 (L134-135) | ○ |
| C-021 | Builder複数件でOR結合が行われる | E-02 (L136-148) | ○ |
| C-022 | PatternAnalyzer.createComponentsがパターン分割する | E-03 (L58-68) | ○ |
| C-023 | lowercase=falseでLowerCaseFilter適用されない | E-03 (L61-63) | ○ |
| C-024 | stopWordsでStopFilter適用される | E-03 (L64-66) | ○ |
| C-025 | stopWords=nullでStopFilter適用されない | E-03 (L64-66) | ○ |
| C-026 | PatternAnalyzer.normalizeが小文字変換する | E-03 (L71-77) | ○ |
| C-027 | FingerprintAnalyzerのフィルタチェーンが正しい | E-04 (L58-66) | ○ |
| C-028 | FingerprintAnalyzerのカスタムセパレータ | E-04 (L51-55) | ○ |
| C-029 | SnowballAnalyzer EnglishでEnglishPossessiveFilter | E-05 (L79) | ○ |
| C-030 | SnowballAnalyzer TurkishでTurkishLowerCaseFilter | E-05 (L81) | ○ |
| C-031 | SnowballAnalyzer stopWordsありでStopFilter | E-05 (L83) | ○ |
| C-032 | SnowballAnalyzer stopWordsnullでStopFilterなし | E-05 (L83) | ○ |
| C-033 | NGramTokenizerFactoryデフォルト設定 | E-06 (L129-130) | ○ |
| C-034 | NGramTokenizerFactoryカスタム設定 | E-06 (L129-130) | ○ |
| C-035 | NGramTokenizerFactory差分超過エラー | E-06 (L131-143) | ○ |
| C-036 | parseTokenCharsがletterに対しLETTER返却 | E-06 (L87-124) | ○ |
| C-037 | parseTokenCharsが複数指定でOR結合 | E-06 (L87-124) | ○ |
| C-038 | parseTokenCharsが空リストでnull返却 | E-06 (L88-91) | ○ |
| C-039 | parseTokenCharsが不明タイプでエラー | E-06 (L96-106) | ○ |
| C-040 | parseTokenCharsがcustomで動作する | E-06 (L107-119) | ○ |
| C-041 | parseTokenCharsがcustomでcustom_token_chars未設定エラー | E-06 (L108-109) | ○ |
| C-042 | NGramTokenizerFactory.createでmatcher=null | E-06 (L147-158) | ○ |
| C-043 | NGramTokenizerFactory.createでmatcher設定済み | E-06 (L147-158) | ○ |
| C-044 | NGramTokenFilterFactoryデフォルト設定 | E-07 (L49-67) | ○ |
| C-045 | NGramTokenFilterFactory差分超過エラー | E-07 (L54-65) | ○ |
| C-046 | NGramTokenFilterFactory.createがNGramTokenFilter返却 | E-07 (L70-72) | ○ |
| C-047 | NGramTokenFilterFactory.getSynonymFilterがエラー | E-07 (L75-77) | ○ |
| C-048 | EdgeNGramTokenFilterFactory.parseSide front | E-08 (L63-72) | ○ |
| C-049 | EdgeNGramTokenFilterFactory.parseSide back | E-08 (L63-72) | ○ |
| C-050 | EdgeNGramTokenFilterFactory.parseSide invalid | E-08 (L63-72) | ○ |
| C-051 | EdgeNGramTokenFilterFactory.create side=front | E-08 (L75-91) | ○ |
| C-052 | EdgeNGramTokenFilterFactory.create side=back | E-08 (L75-91) | ○ |
| C-053 | EdgeNGramTokenFilterFactory.getSynonymFilter | E-08 (L99-101) | ○ |
| C-054 | CharGroupTokenizerFactory単一文字 | E-09 (L63-93) | ○ |
| C-055 | CharGroupTokenizerFactoryクラス名whitespace | E-09 (L73-88) | ○ |
| C-056 | CharGroupTokenizerFactoryエスケープ文字 | E-09 (L96-126) | ○ |
| C-057 | CharGroupTokenizerFactory Unicodeエスケープ | E-09 (L115-119) | ○ |
| C-058 | CharGroupTokenizerFactory空文字エラー | E-09 (L64-66) | ○ |
| C-059 | CharGroupTokenizerFactory不正クラス名エラー | E-09 (L89-91) | ○ |
| C-060 | CharGroupTokenizerFactory不正エスケープエラー | E-09 (L120-121) | ○ |
| C-061 | CharGroupTokenizerFactory.createでTokenizer生成 | E-09 (L129-151) | ○ |
| C-062 | CharGroupTokenizerFactory.createでmax_token_length適用 | E-09 (L61, L130) | ○ |
| C-063 | SynonymTokenFilterFactoryデフォルト設定 | E-10 (L72-98) | ○ |
| C-064 | SynonymTokenFilterFactory updateable=true | E-10 (L93-94) | ○ |
| C-065 | SynonymTokenFilterFactory.createが直接呼び出しでエラー | E-10 (L106-108) | ○ |
| C-066 | getRulesFromSettingsがsynonymsから読み込む | E-10 (L187-202) | ○ |
| C-067 | getRulesFromSettingsがsynonyms_pathから読み込む | E-10 (L196-197) | △ |
| C-068 | getRulesFromSettingsがsynonyms未設定でエラー | E-10 (L198-200) | ○ |
| C-069 | buildSynonymsがSolr形式で動作する | E-10 (L170-185) | ○ |
| C-070 | buildSynonymsがWordNet形式で動作する | E-10 (L173-176) | ○ |
| C-071 | buildSynonymsが不正ルールでエラー | E-10 (L181-184) | ○ |
| C-072 | buildSynonymAnalyzerがカスタムアナライザ返却 | E-10 (L146-168) | △ |
| C-073 | buildSynonymAnalyzerがCustomAnalyzer生成 | E-10 (L163-168) | ○ |
| C-074 | MultiplexerTokenFilterFactory基本初期化 | E-11 (L59-63) | ○ |
| C-075 | MultiplexerTokenFilterFactory.createエラー | E-11 (L66-68) | ○ |
| C-076 | MultiplexerTokenFilterFactory.getSynonymFilterエラー | E-11 (L71-73) | ○ |
| C-077 | getChainAwareTokenFilterFactoryでIDENTITY_FILTER先頭 | E-11 (L82-84) | △ |
| C-078 | getChainAwareTokenFilterFactoryで不正フィルタ名エラー | E-11 (L154-161) | ○ |
| C-079 | ScriptedConditionTokenFilterFactory基本初期化 | E-12 (L61-75) | ○ |
| C-080 | ScriptedConditionTokenFilterFactoryストアドスクリプト禁止 | E-12 (L66-68) | ○ |
| C-081 | ScriptedConditionTokenFilterFactory空フィルタリストエラー | E-12 (L72-74) | ○ |
| C-082 | ScriptedConditionTokenFilterFactory.createエラー | E-12 (L78-80) | ○ |
| C-083 | getChainAwareTokenFilterFactoryで不正フィルタ参照エラー | E-12 (L92-97) | ○ |
| C-084 | EnglishPluralStemFilter基本ステミング | E-13 (L53-63) | ○ |
| C-085 | EnglishPluralStemFilterキーワード保護 | E-13 (L55) | ○ |
| C-086 | EnglishPluralStemmer基本s除去 | E-13 (L103-158) | ○ |
| C-087 | EnglishPluralStemmer ies->y変換 | E-13 (L115-118) | ○ |
| C-088 | EnglishPluralStemmer短いies保持 | E-13 (L115) | ○ |
| C-089 | EnglishPluralStemmer xes->x変換 | E-13 (L123-125) | ○ |
| C-090 | EnglishPluralStemmer sses->ss変換 | E-13 (L136-139) | ○ |
| C-091 | EnglishPluralStemmer shes->sh変換 | E-13 (L136-139) | ○ |
| C-092 | EnglishPluralStemmer tches->tch変換 | E-13 (L142-151) | ○ |
| C-093 | EnglishPluralStemmer oes->o変換 | E-13 (L127-134) | ○ |
| C-094 | EnglishPluralStemmer oes例外(shoes) | E-13 (L88, L128-131) | ○ |
| C-095 | EnglishPluralStemmer ches例外(cliches) | E-13 (L90-100, L143-151) | ○ |
| C-096 | EnglishPluralStemmer 3文字未満で変更なし | E-13 (L104) | ○ |
| C-097 | EnglishPluralStemmer 非s末尾で変更なし | E-13 (L104) | ○ |
| C-098 | EnglishPluralStemmer us末尾で変更なし | E-13 (L107-109) | ○ |
| C-099 | EnglishPluralStemmer ss末尾で変更なし | E-13 (L108-109) | ○ |
| C-100 | UniqueTokenFilter重複除去 | E-14 (L65-92) | ○ |
| C-101 | UniqueTokenFilter onlyOnSamePosition=trueで同一位置のみ | E-14 (L71-78) | ○ |
| C-102 | UniqueTokenFilter onlyOnSamePosition=falseで全位置 | E-14 (L79) | ○ |
| C-103 | UniqueTokenFilter.resetでpreviousクリア | E-14 (L95-98) | ○ |
| C-104 | UniqueTokenFilter空入力 | E-14 (L66) | ○ |
| C-105 | AnalysisPredicateScript.Token.getTerm | E-15 (L85-87) | ○ |
| C-106 | AnalysisPredicateScript.Token.getPosition | E-15 (L81-83, L93-95) | △ |
| C-107 | AnalysisPredicateScript.Token.reset | E-15 (L77-79) | ○ |
| C-108 | AnalysisPredicateScript.Token.updatePosition | E-15 (L81-83) | ○ |
| C-109 | MappingCharFilterFactoryマッピング初期化 | E-16 (L54-65) | ○ |
| C-110 | MappingCharFilterFactoryマッピング未設定エラー | E-16 (L58-59) | ○ |
| C-111 | MappingCharFilterFactory.parseルール解析 | E-16 (L75-81) | ○ |
| C-112 | MappingCharFilterFactory.parse不正ルールエラー | E-16 (L77) | ○ |
| C-113 | MappingCharFilterFactory.parseStringエスケープ変換 | E-16 (L86-124) | ○ |
| C-114 | MappingCharFilterFactory.parseString Unicodeエスケープ | E-16 (L114-118) | ○ |
| C-115 | MappingCharFilterFactory.parseString不正エスケープエラー | E-16 (L93) | ○ |
| C-116 | MappingCharFilterFactory.createでフィルタ生成 | E-16 (L68-70) | ○ |
| C-117 | WordDelimiterTokenFilterFactoryデフォルトフラグ | E-17 (L91-113) | ○ |
| C-118 | WordDelimiterTokenFilterFactory.getFlag true | E-17 (L126-131) | ○ |
| C-119 | WordDelimiterTokenFilterFactory.getFlag false | E-17 (L126-131) | ○ |
| C-120 | WordDelimiterTokenFilterFactory.parse正常 | E-17 (L136-144) | ○ |
| C-121 | WordDelimiterTokenFilterFactory.parse不正ルール | E-17 (L138) | ○ |
| C-122 | WordDelimiterTokenFilterFactory.parse複数文字エラー | E-17 (L141) | ○ |
| C-123 | WordDelimiterTokenFilterFactory.parse不正タイプエラー | E-17 (L142) | ○ |
| C-124 | WordDelimiterTokenFilterFactory.parseTypes | E-17 (L149-162) | ○ |
| C-125 | WordDelimiterTokenFilterFactory.getSynonymFilter | E-17 (L122-124) | ○ |
| C-126 | WordDelimiterTokenFilterFactory.breaksFastVectorHighlighter | E-17 (L216-218) | ○ |
| C-127 | StemmerTokenFilterFactory englishでPorterStemFilter | E-18 (L137-138) | ○ |
| C-128 | StemmerTokenFilterFactory porterでPorterStemFilter | E-18 (L143-144) | ○ |
| C-129 | StemmerTokenFilterFactory plural_englishでEnglishPluralStemFilter | E-18 (L149-150) | ○ |
| C-130 | StemmerTokenFilterFactory arabicでArabicStemFilter | E-18 (L115-116) | ○ |
| C-131 | StemmerTokenFilterFactory未知言語でSnowballFilterフォールバック | E-18 (L276) | ○ |
| C-132 | StemmerTokenFilterFactoryデフォルトporter | E-18 (L108) | ○ |
| C-133 | LengthTokenFilterFactoryデフォルト設定 | E-19 (L52-53) | ○ |
| C-134 | LengthTokenFilterFactoryカスタム設定 | E-19 (L52-53) | ○ |
| C-135 | LengthTokenFilterFactory enable_position_incrementsエラー | E-19 (L54-56) | ○ |
| C-136 | LengthTokenFilterFactory.createでLengthFilter生成 | E-19 (L60-62) | ○ |
| C-137 | ConcatenateGraphTokenFilterFactoryデフォルト設定 | E-20 (L45-63) | ○ |
| C-138 | ConcatenateGraphTokenFilterFactory空セパレータでnull | E-20 (L60) | ○ |
| C-139 | ConcatenateGraphTokenFilterFactory 2文字セパレータエラー | E-20 (L57-58) | ○ |
| C-140 | DelimitedPayloadTokenFilterFactoryデフォルト設定 | E-21 (L57-79) | ○ |
| C-141 | DelimitedPayloadTokenFilterFactory float encoding | E-21 (L67-68) | ○ |
| C-142 | DelimitedPayloadTokenFilterFactory int encoding | E-21 (L69-70) | ○ |
| C-143 | DelimitedPayloadTokenFilterFactory identity encoding | E-21 (L71-72) | ○ |
| C-144 | DelimitedPayloadTokenFilterFactoryカスタムデリミタ | E-21 (L59-64) | ○ |
| C-145 | KeywordMarkerTokenFilterFactoryキーワードリスト | E-22 (L68-92) | ○ |
| C-146 | KeywordMarkerTokenFilterFactoryパターン指定 | E-22 (L73-80) | ○ |
| C-147 | KeywordMarkerTokenFilterFactory排他設定エラー | E-22 (L76-78) | ○ |
| C-148 | KeywordMarkerTokenFilterFactory設定不足エラー | E-22 (L82-87) | ○ |
| C-149 | KeywordMarkerTokenFilterFactory.createパターンフィルタ | E-22 (L95-101) | ○ |
| C-150 | KeywordMarkerTokenFilterFactory.createセットフィルタ | E-22 (L95-101) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-067: synonyms_pathによるファイル読み込みはAnalysis.getReaderFromFileに委譲しており、実際のファイルI/O動作は環境依存
  - 候補：統合テストで検証 / Analysisクラスのソースコード確認
- C-072: AnalysisRegistry.getAnalyzerの戻り値がnullでない場合のカスタムアナライザ返却パスは、AnalysisRegistryの実装に依存
  - 候補：AnalysisRegistryのソースコード確認 / 統合テストで検証
- C-077: IDENTITY_FILTERはTokenFilterFactoryインターフェースで定義されるため、直接的なソースコード根拠がこのモジュール内にない
  - 候補：TokenFilterFactoryインターフェースのソースコード確認
- C-106: AnalysisPredicateScript.Token.getPositionのポジション計算ロジック（初期値-1, posIncAttの加算推移）の複合的な挙動は実行時テストでの検証が望ましい
  - 候補：AnalysisPredicateScript.Tokenの単体テストで検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CharMatcher, PatternAnalyzer, FingerprintAnalyzer等の単純なファクトリクラスは根拠が明確でリスク低
- 0: 低リスク - EnglishPluralStemmerのステミングロジックはソースコード内にアルゴリズムが完全に記述されている
- 1: 中リスク - SynonymTokenFilterFactoryはAnalysisRegistry等の外部依存があり、統合的な動作確認が必要
- 1: 中リスク - MultiplexerTokenFilterFactory, ScriptedConditionTokenFilterFactoryはチェーン構成が複雑で統合テストが望ましい
- 0: 低リスク - CommonAnalysisModulePluginのアナライザ/フィルタ登録は宣言的でリスク低

## 6) レビュアーチェックリスト（最小）
- [ ] EnglishPluralStemmerの例外語リスト（oesExceptions, chesExceptions）が期待通りの挙動を示すか確認
- [ ] SynonymTokenFilterFactoryのsynonym_analyzerパスで、AnalysisRegistryがnullを返すケースの挙動を確認
- [ ] MultiplexerTokenFilterFactoryのフィルタチェーン構成が、カンマ区切りサブフィルタの場合に正しく動作するか確認
- [ ] NGramTokenizerFactoryのMATCHERS静的マップにUnicodeカテゴリが正しく登録されているか確認
- [ ] CommonAnalysisModulePluginの非推奨名（edgeNGram, nGram, PathHierarchy）のバージョン境界処理を確認
