---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 85
  claims_with_evidence: 82
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：modules-autotagging-commons 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：82 / 85、根拠なし：3
- 優先レビュー（高）
  1. **C-09 (UT-ATC-009)**: 空リストでのevaluateLabel挙動 - FeatureValueResolverの内部実装に依存
  2. **C-34 (UT-ATC-034)**: loadExtensionsの内部動作 - ExtensionLoaderのモック動作が不確定
  3. **C-60 (UT-ATC-060)**: RestCreateRuleAction不正JSONの例外型 - XContentParserの具体的な例外型が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/autotagging-commons/src/main/java/org/opensearch/rule/InMemoryRuleProcessingService.java`
- E-02: `modules/autotagging-commons/src/main/java/org/opensearch/rule/RuleFrameworkPlugin.java`
- E-03: `modules/autotagging-commons/src/main/java/org/opensearch/rule/RulePersistenceServiceRegistry.java`
- E-04: `modules/autotagging-commons/src/main/java/org/opensearch/rule/RuleRoutingServiceRegistry.java`
- E-05: `modules/autotagging-commons/src/main/java/org/opensearch/rule/labelresolver/FeatureValueResolver.java`
- E-06: `modules/autotagging-commons/src/main/java/org/opensearch/rule/action/CreateRuleAction.java`
- E-07: `modules/autotagging-commons/src/main/java/org/opensearch/rule/action/DeleteRuleAction.java`
- E-08: `modules/autotagging-commons/src/main/java/org/opensearch/rule/action/GetRuleAction.java`
- E-09: `modules/autotagging-commons/src/main/java/org/opensearch/rule/action/UpdateRuleAction.java`
- E-10: `modules/autotagging-commons/src/main/java/org/opensearch/rule/action/TransportCreateRuleAction.java`
- E-11: `modules/autotagging-commons/src/main/java/org/opensearch/rule/action/TransportDeleteRuleAction.java`
- E-12: `modules/autotagging-commons/src/main/java/org/opensearch/rule/action/TransportGetRuleAction.java`
- E-13: `modules/autotagging-commons/src/main/java/org/opensearch/rule/action/TransportUpdateRuleAction.java`
- E-14: `modules/autotagging-commons/src/main/java/org/opensearch/rule/rest/RestCreateRuleAction.java`
- E-15: `modules/autotagging-commons/src/main/java/org/opensearch/rule/rest/RestDeleteRuleAction.java`
- E-16: `modules/autotagging-commons/src/main/java/org/opensearch/rule/rest/RestGetRuleAction.java`
- E-17: `modules/autotagging-commons/src/main/java/org/opensearch/rule/rest/RestUpdateRuleAction.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InMemoryRuleProcessingServiceコンストラクタの正常生成 | E-01 (L48-54) | ○ |
| C-02 | add: 有効なRuleでAttributeValueStore.putが呼ばれる | E-01 (L60-61, L91-96) | ○ |
| C-03 | add: 属性マップにない属性は空文字でput | E-01 (L73-81) | ○ |
| C-04 | add: ワイルドカード除去 | E-01 (L94, WILDCARD定数 L35) | ○ |
| C-05 | remove: AttributeValueStore.removeが呼ばれる | E-01 (L68-69, L84-89) | ○ |
| C-06 | remove: ワイルドカード除去 | E-01 (L87) | ○ |
| C-07 | evaluateLabel: 単一マッチで正しいラベル返却 | E-01 (L102-108), E-05 (L57-83) | ○ |
| C-08 | evaluateLabel: 優先度順ソート | E-01 (L103-105) | ○ |
| C-09 | evaluateLabel: 空リストでOptional.empty | E-01 (L102-108), E-05 (L57-76) | △ |
| C-10 | evaluateLabel: マッチなしでOptional.empty | E-05 (L69-71, L74-76) | ○ |
| C-11 | RulePersistenceServiceRegistry.register正常 | E-03 (L32-36) | ○ |
| C-12 | RulePersistenceServiceRegistry.register重複 | E-03 (L33-35) | ○ |
| C-13 | getRulePersistenceService正常 | E-03 (L42-47) | ○ |
| C-14 | getRulePersistenceService未登録 | E-03 (L43-45) | ○ |
| C-15 | RuleRoutingServiceRegistry.register正常 | E-04 (L32-36) | ○ |
| C-16 | RuleRoutingServiceRegistry.register重複 | E-04 (L33-35) | ○ |
| C-17 | getRuleRoutingService正常 | E-04 (L42-47) | ○ |
| C-18 | getRuleRoutingService未登録 | E-04 (L43-45) | ○ |
| C-19 | FeatureValueResolverコンストラクタ正常 | E-05 (L47-50) | ○ |
| C-20 | resolve: 単一Extractorで一意マッチ | E-05 (L57-80) | ○ |
| C-21 | resolve: 複数Extractorの交差が1件 | E-05 (L64-80) | ○ |
| C-22 | resolve: 空Extractorリスト | E-05 (L74-76) | ○ |
| C-23 | resolve: 交差集合が空 | E-05 (L69-71) | ○ |
| C-24 | resolve: 交差複数でbreakTie | E-05 (L77-83) | ○ |
| C-25 | breakTie: 最高スコアで一意解決 | E-05 (L89-100, L106-123) | ○ |
| C-26 | breakTie: 解決不可でOptional.empty | E-05 (L89-99) | ○ |
| C-27 | belongsToTopScoringGroup: EPSILON未満で同一グループ | E-05 (L138-140, L40) | ○ |
| C-28 | belongsToTopScoringGroup: EPSILON以上で別グループ | E-05 (L138-140) | ○ |
| C-29 | getTopScoringMatches: 未登録属性で空Set | E-05 (L108-111) | ○ |
| C-30 | getActions: 4つのActionHandler | E-02 (L80-89) | ○ |
| C-31 | getRestHandlers: 4つのRestHandler | E-02 (L91-102) | ○ |
| C-32 | getExecutorBuilders: FixedExecutorBuilder | E-02 (L105-107) | ○ |
| C-33 | createGuiceModules: バインディング | E-02 (L110-115) | ○ |
| C-34 | loadExtensions: 拡張ロード | E-02 (L118-125) | △ |
| C-35 | loadExtensions: 属性伝播 | E-02 (L121-124) | ○ |
| C-36 | consumeFrameworkExtension: FeatureType登録 | E-02 (L127-133) | ○ |
| C-37 | consumeFrameworkExtension: PersistenceService登録 | E-02 (L130) | ○ |
| C-38 | consumeFrameworkExtension: RoutingService登録 | E-02 (L131) | ○ |
| C-39 | CreateRuleAction.INSTANCEがnon-null | E-06 (L22) | ○ |
| C-40 | CreateRuleAction.NAME値 | E-06 (L27) | ○ |
| C-41 | DeleteRuleAction.INSTANCEがnon-null | E-07 (L22) | ○ |
| C-42 | DeleteRuleAction.NAME値 | E-07 (L27) | ○ |
| C-43 | GetRuleAction.INSTANCEがnon-null | E-08 (L22) | ○ |
| C-44 | GetRuleAction.NAME値 | E-08 (L27) | ○ |
| C-45 | UpdateRuleAction.INSTANCEがnon-null | E-09 (L22) | ○ |
| C-46 | UpdateRuleAction.NAME値 | E-09 (L27) | ○ |
| C-47 | TransportCreateRuleAction.doExecute: ルーティング委譲 | E-10 (L87-89) | ○ |
| C-48 | TransportCreateRuleAction.executeLocally: スレッドプール | E-10 (L96-103) | ○ |
| C-49 | TransportCreateRuleAction: 正常レスポンス送信 | E-10 (L63-80) | ○ |
| C-50 | TransportCreateRuleAction: IOException時TransportException | E-10 (L69-72, L75-78) | ○ |
| C-51 | TransportDeleteRuleAction.doExecute: deleteRule呼び出し | E-11 (L47-50) | ○ |
| C-52 | TransportDeleteRuleAction: 未登録FeatureType | E-11 (L48), E-03 (L43-45) | ○ |
| C-53 | TransportGetRuleAction.doExecute: GETプール | E-12 (L50-57) | ○ |
| C-54 | TransportUpdateRuleAction.doExecute: ルーティング委譲 | E-13 (L87-89) | ○ |
| C-55 | TransportUpdateRuleAction.executeLocally: スレッドプール | E-13 (L96-103) | ○ |
| C-56 | TransportUpdateRuleAction: IOException時TransportException | E-13 (L69-72, L75-78) | ○ |
| C-57 | RestCreateRuleAction.getName | E-14 (L47-48) | ○ |
| C-58 | RestCreateRuleAction.routes | E-14 (L51-53) | ○ |
| C-59 | RestCreateRuleAction.prepareRequest正常 | E-14 (L56-63) | ○ |
| C-60 | RestCreateRuleAction.prepareRequest不正JSON | E-14 (L58-60) | △ |
| C-61 | RestDeleteRuleAction.getName | E-15 (L44-45) | ○ |
| C-62 | RestDeleteRuleAction.routes | E-15 (L49-51) | ○ |
| C-63 | RestDeleteRuleAction.prepareRequest正常 | E-15 (L54-59) | ○ |
| C-64 | RestGetRuleAction.getName | E-16 (L57-59) | ○ |
| C-65 | RestGetRuleAction.routes: 2つのルート | E-16 (L63-65) | ○ |
| C-66 | RestGetRuleAction.prepareRequest: 個別取得 | E-16 (L68-91) | ○ |
| C-67 | RestGetRuleAction.prepareRequest: 属性フィルタ | E-16 (L76-84) | ○ |
| C-68 | RestGetRuleAction.prepareRequest: search_after | E-16 (L87) | ○ |
| C-69 | RestGetRuleAction.prepareRequest: featureType未指定 | E-16 (L71-73) | ○ |
| C-70 | parseAttributeValues: カンマ区切り正常 | E-16 (L98-118) | ○ |
| C-71 | parseAttributeValues: 上限超過 | E-16 (L101-105) | ○ |
| C-72 | parseAttributeValues: 空文字列 | E-16 (L106-115) | ○ |
| C-73 | parseAttributeValues: 文字数上限 | E-16 (L107) | ○ |
| C-74 | parseAttributeValues: 1件のみ | E-16 (L99, L117) | ○ |
| C-75 | RestUpdateRuleAction.getName | E-17 (L48-49) | ○ |
| C-76 | RestUpdateRuleAction.routes | E-17 (L53-55) | ○ |
| C-77 | RestUpdateRuleAction.prepareRequest正常 | E-17 (L58-70) | ○ |
| C-78 | RestUpdateRuleAction.prepareRequest: パラメータ正確性 | E-17 (L62-68) | ○ |
| C-79 | RestUpdateRuleAction.prepareRequest不正JSON | E-17 (L60-61) | ○ |
| C-80 | RULE_THREAD_POOL_NAME定数値 | E-02 (L60) | ○ |
| C-81 | RULE_THREAD_COUNT定数値 | E-02 (L64) | ○ |
| C-82 | RULE_QUEUE_SIZE定数値 | E-02 (L68) | ○ |
| C-83 | RulePersistenceServiceRegistry: 複数FeatureType管理 | E-03 (L32-47) | ○ |
| C-84 | RuleRoutingServiceRegistry: 複数FeatureType管理 | E-04 (L32-47) | ○ |
| C-85 | add/remove: 空属性マップの処理 | E-01 (L73-81) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-09**: 空のattributeExtractorsリストを渡した場合のevaluateLabel挙動は、FeatureValueResolver.resolve()のorderedExtractorsが空の場合にintersectionがnullのまま残り、L74の条件でOptional.empty()が返る推定だが、FeatureValueResolverの内部状態に依存するため直接的な根拠が弱い
  - 候補：FeatureValueResolverの単体テスト / 統合テストで確認
- **C-34**: loadExtensionsの内部動作はExtensionLoaderインターフェースの具体的な実装に依存し、モック設計が不確定
  - 候補：ExtensionLoader実装クラス / 既存テストコード
- **C-60**: 不正JSONでのパースエラーの具体的な例外型（XContentParseException等）がソースコード上では明示されていない
  - 候補：XContentParser実装 / OpenSearch共通例外ハンドリングのドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: RulePersistenceServiceRegistry / RuleRoutingServiceRegistry のテストケースは、ソースコード上のロジックが明確で低リスク
- 0: ActionType系（CreateRuleAction等）は定数値とシングルトンのみで低リスク
- 1: FeatureValueResolverのbreakTie/belongsToTopScoringGroupは浮動小数点比較を含み、EPSILON値の妥当性について中リスク
- 1: TransportAction系のmessageReceived内のエラーハンドリングパスはIOExceptionの発生条件が外部依存のため中リスク
- 0: RestAction系はBaseRestHandlerの標準パターンに従っており低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] FeatureValueResolverのEPSILON値(1e-6f)が業務要件に対して適切か確認
- [ ] 空のattributeExtractorsリストを渡した場合の実際の挙動をデバッグ確認
- [ ] TransportCreateRuleAction / TransportUpdateRuleActionのexecuteLocallyにおけるスレッドプール枯渇時の挙動を確認
- [ ] RestGetRuleAction.parseAttributeValuesのバリデーションがFeatureTypeの設定値と整合しているか確認
- [ ] loadExtensionsのAttributesExtension伝播が全RuleFrameworkExtensionに対して行われることを統合テストで確認
