---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 88
  claims_with_evidence: 85
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：modules-cache-common 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：85 / 88、根拠なし：3
- 優先レビュー（高）
  1. **C-26（UT-CAC-026）**：ポリシー拒否時にcomputeIfAbsentが値を返すがキャッシュしない動作の検証は、コードの複雑なフロー（compute内のwasRejectedByPolicyフラグ）から推定しており、全ての並行パターンでの動作は確認困難
  2. **C-78（UT-CAC-078）**：removeDimensionsがon_heapとdiskの両方を削除する動作は、親クラスのremoveDimensionsHelper実装に依存するため完全な根拠が本モジュール内にない
  3. **C-87（UT-CAC-087）**：getSettingsが各CacheTypeにつき8つの設定を返すという数値は、コードのforループ内の8つのadd呼び出しから推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/cache-common/src/main/java/org/opensearch/cache/common/policy/TookTimePolicy.java`（TookTimePolicyクラス全体、88行）
- E-02: `modules/cache-common/src/main/java/org/opensearch/cache/common/tier/TieredSpilloverCache.java`（TieredSpilloverCacheクラス全体、1056行）
- E-03: `modules/cache-common/src/main/java/org/opensearch/cache/common/tier/TieredSpilloverCacheStatsHolder.java`（StatsHolderクラス全体、185行）
- E-04: `modules/cache-common/src/main/java/org/opensearch/cache/common/tier/TieredSpilloverCacheSettings.java`（設定クラス全体、214行）
- E-05: `modules/cache-common/src/main/java/org/opensearch/cache/common/tier/TieredSpilloverCachePlugin.java`（プラグインクラス全体、84行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TookTimePolicyコンストラクタが閾値0以上で正常にインスタンスを生成する | E-01 (L49-61: コンストラクタでthreshold.compareTo(TimeValue.ZERO) < 0をチェック) | ○ |
| C-02 | TookTimePolicyコンストラクタが負の閾値でIllegalArgumentExceptionをスローする | E-01 (L55-57: 負の値で明示的にthrow) | ○ |
| C-03 | TookTimePolicyコンストラクタが閾値ZERO で正常に生成される | E-01 (L55: compareTo(ZERO) < 0 の条件、0は通過する) | ○ |
| C-04 | test()が閾値0の場合にtrueを返す | E-01 (L73-76: threshold.equals(ZERO)でreturn true) | ○ |
| C-05 | test()がtook time >= 閾値でtrueを返す | E-01 (L86: tookTime.compareTo(threshold) >= 0) | ○ |
| C-06 | test()がtook time > 閾値でtrueを返す | E-01 (L86: compareTo >= 0) | ○ |
| C-07 | test()がtook time < 閾値でfalseを返す | E-01 (L86: compareTo >= 0 が成立しない) | ○ |
| C-08 | test()がパース例外時にfalseを返す | E-01 (L80-83: catch(Exception) で return false) | ○ |
| C-09 | test()が閾値-1nsでfalseを返す（境界値） | E-01 (L86: compareTo) | ○ |
| C-10 | TieredSpilloverCacheコンストラクタが正常に動作する | E-02 (L98-130: コンストラクタ) | ○ |
| C-11 | cacheConfigがnullでNPEをスロー | E-02 (L99: Objects.requireNonNull) | ○ |
| C-12 | settingsがnullでNPEをスロー | E-02 (L100: Objects.requireNonNull) | ○ |
| C-13 | numberOfSegments<=0でIllegalArgumentException | E-02 (L101-103: 条件チェックとthrow) | ○ |
| C-14 | onHeapCachePerSegmentSize<=0でIllegalArgumentException | E-02 (L111-113) | ○ |
| C-15 | diskCachePerSegmentSize<=0でIllegalArgumentException | E-02 (L114-116) | ○ |
| C-16 | get()が存在するキーの値を返す | E-02 (L633-636, L252-258: getValueFromTieredCacheの呼び出し) | ○ |
| C-17 | get()が存在しないキーでnullを返す | E-02 (L254-255: cacheValueTuple == nullの場合return null) | ○ |
| C-18 | put()が新規キーをonHeapに格納する | E-02 (L261-281: cacheValueTuple==nullの場合onHeapCache.put) | ○ |
| C-19 | put()が既存キーを同じティアで更新する | E-02 (L272-279: cacheValueTuple!=nullの場合、同じティアでput) | ○ |
| C-20 | put()がポリシー違反でキャッシュしない | E-02 (L264: evaluatePoliciesList) | ○ |
| C-21 | computeIfAbsent()がローダーから値をロードする | E-02 (L285-338: computeIfAbsentの実装) | ○ |
| C-22 | computeIfAbsent()がonHeapヒットを返す | E-02 (L328-330: TIER_DIMENSION_VALUE_ON_HEAPの場合) | ○ |
| C-23 | computeIfAbsent()がdiskヒットを返す | E-02 (L331-334: TIER_DIMENSION_VALUE_DISKの場合) | ○ |
| C-24 | computeIfAbsent()がnullロード時にExecutionException | E-02 (L390-393: NullPointerExceptionでcompleteExceptionally) | ○ |
| C-25 | computeIfAbsent()がローダー例外時にExecutionException | E-02 (L386-389: catch(Exception)でcompleteExceptionally) | ○ |
| C-26 | computeIfAbsent()がポリシー拒否時に値を返しキャッシュしない | E-02 (L395-397: wasRejectedByPolicyフラグ) | △ |
| C-27 | invalidate()が全ティアからキーを削除する | E-02 (L412-421: forループで全cacheのinvalidate) | ○ |
| C-28 | invalidate()がdropStatsForDimensions時にstats削除 | E-02 (L413-414: getDropStatsForDimensionsチェック) | ○ |
| C-29 | invalidateAll()が全キーを削除しstatsリセット | E-02 (L425-432: forループ + statsHolder.reset()) | ○ |
| C-30 | keys()が全ティアのキーを結合して返す | E-02 (L667-676: ConcatenatedIterablesで結合) | ○ |
| C-31 | keys()が空キャッシュで空Iterableを返す | E-02 (L667-676: 空のイテラブルがConcatenatedIterablesで結合) | ○ |
| C-32 | count()が合計エントリ数を返す | E-02 (L679-683: statsHolder.count()) | ○ |
| C-33 | count()が空キャッシュで0を返す | E-02 (L682: statsHolder.count()は初期値0) | ○ |
| C-34 | refresh()が全セグメントで呼ばれる | E-02 (L686-690: forループで各セグメントrefresh) | ○ |
| C-35 | close()が全セグメントで呼ばれる | E-02 (L693-697: forループで各セグメントclose) | ○ |
| C-36 | stats()がImmutableCacheStatsHolderを返す | E-02 (L700-702: statsHolder.getImmutableCacheStatsHolder) | ○ |
| C-37 | enableDisableDiskCache()が全セグメントに反映 | E-02 (L612-617: forループで各セグメント処理) | ○ |
| C-38 | enableDisableDiskCache()の再有効化 | E-02 (L612-617, L244-249: TierInfoの更新) | ○ |
| C-39 | getSegmentNumber()がhashCodeベースで算出 | E-02 (L624-626: key.hashCode() & (numberOfSegments-1)) | ○ |
| C-40 | handleRemovalFromHeapTierがディスクにスピルオーバー | E-02 (L472-500: canCacheOnDisk条件とdiskCache.put) | ○ |
| C-41 | ディスク無効時にremovalListener呼び出し | E-02 (L477-478, L493-498: canCacheOnDiskがfalseの場合) | ○ |
| C-42 | ディスクput例外時にremovalListener呼び出し | E-02 (L483-487, L493-498: exceptionOccurredOnDiskCachePut) | ○ |
| C-43 | diskPolicies拒否時にスピルオーバーしない | E-02 (L479: evaluatePoliciesList(notification.getValue(), diskPolicies)) | ○ |
| C-44 | EVICTED以外でスピルオーバーしない | E-02 (L474: SPILLOVER_REMOVAL_REASONS.contains, L77: EVICTEDとCAPACITYのみ) | ○ |
| C-45 | handleRemovalFromDiskTierがremovalListener呼び出し | E-02 (L540-545: removalListener.onRemoval) | ○ |
| C-46 | ディスクティアエビクション時の統計更新 | E-02 (L543-544: updateStatsOnRemoval) | ○ |
| C-47 | evaluatePoliciesList全通過でtrue | E-02 (L502-509: forループで全ポリシーチェック) | ○ |
| C-48 | evaluatePoliciesList部分拒否でfalse | E-02 (L504: !policy.test(value)でreturn false) | ○ |
| C-49 | evaluatePoliciesList空リストでtrue | E-02 (L502-509: forループが回らずreturn true) | ○ |
| C-50 | ConcatenatedIterablesが複数Iterableを結合 | E-02 (L749-766: iteratorメソッド) | ○ |
| C-51 | ConcatenatedIterator.hasNext()が要素ありでtrue | E-02 (L779-787: whileループ) | ○ |
| C-52 | 空イテレータのスキップ | E-02 (L780-786: whileループで次のイテレータへ) | ○ |
| C-53 | 全空イテレータでfalse | E-02 (L782-783: currentIteratorIndex == lengthでreturn false) | ○ |
| C-54 | next()が空でNoSuchElementException | E-02 (L792-793: !hasNext()でthrow) | ○ |
| C-55 | TieredSpilloverCacheFactory.create()の正常動作 | E-02 (L834-905: createメソッド全体) | ○ |
| C-56 | onHeapCacheStoreNameが見つからない場合の例外 | E-02 (L841-845: !containsKeyでthrow) | ○ |
| C-57 | diskCacheStoreNameが見つからない場合の例外 | E-02 (L852-856: !containsKeyでthrow) | ○ |
| C-58 | cachedResultParserがnullの場合のNPE | E-02 (L861-864: Objects.requireNonNull) | ○ |
| C-59 | 不正なセグメント数の場合の例外 | E-02 (L868-872: !VALID_SEGMENT_COUNT_VALUES.containsでthrow) | ○ |
| C-60 | getCacheName()がtiered_spilloverを返す | E-02 (L908-910: return TIERED_SPILLOVER_CACHE_NAME, L827: 定数定義) | ○ |
| C-61 | Builder.build()が正常動作 | E-02 (L1051-1053: return new TieredSpilloverCache<>(this)) | ○ |
| C-62 | Builder.addPolicy()がポリシーを追加 | E-02 (L1002-1005: policies.add) | ○ |
| C-63 | Builder.addDiskPolicy()がディスクポリシーを追加 | E-02 (L1012-1015: diskPolicies.add) | ○ |
| C-64 | StatsHolderコンストラクタがtierをdimensionに追加 | E-03 (L53-59, L61-65: getDimensionNamesWithTier) | ○ |
| C-65 | getDimensionsWithTierValueがtier値を追加 | E-03 (L70-74: result.add(tierValue)) | ○ |
| C-66 | incrementHits()の正常動作 | E-03 (L84-88: super.incrementHits) | ○ |
| C-67 | incrementMisses()のon_heap+ディスク有効時の動作 | E-03 (L91-108: tierValue.equals(ON_HEAP) && diskCacheEnabled条件) | ○ |
| C-68 | incrementMisses()のdisk時の動作 | E-03 (L102-104: else節で全ノードインクリメント) | ○ |
| C-69 | incrementMisses()のon_heap+ディスク無効時の動作 | E-03 (L96, L102-104: diskCacheEnabled=falseでelse節) | ○ |
| C-70 | incrementEvictions(1引数)がUnsupportedOperationException | E-03 (L117-121: throw new UnsupportedOperationException) | ○ |
| C-71 | incrementEvictions(2引数)のincludeInTotal=true時 | E-03 (L128-137: includeInTotal条件) | ○ |
| C-72 | incrementEvictions(2引数)のincludeInTotal=false時 | E-03 (L132: isAtLowestLevel()の条件) | ○ |
| C-73 | incrementSizeInBytes()の正常動作 | E-03 (L140-144: super.incrementSizeInBytes) | ○ |
| C-74 | decrementSizeInBytes()の正常動作 | E-03 (L149-153: super.decrementSizeInBytes) | ○ |
| C-75 | incrementItems()の正常動作 | E-03 (L156-160: super.incrementItems) | ○ |
| C-76 | decrementItems()の正常動作 | E-03 (L163-167: super.decrementItems) | ○ |
| C-77 | setDiskCacheEnabled()の正常動作 | E-03 (L169-171: this.diskCacheEnabled = diskCacheEnabled) | ○ |
| C-78 | removeDimensions()が両ティアのノードを削除 | E-03 (L174-184: removeDimensionsHelper呼び出し、親クラスの実装に依存) | △ |
| C-79 | defaultSegments()が2の冪乗を返す | E-04 (L197-208: VALID_SEGMENT_COUNT_VALUESから選択) | ○ |
| C-80 | defaultSegments()が有効値を返す | E-04 (L202-204: forループでVALID_SEGMENT_COUNT_VALUESから選択) | ○ |
| C-81 | TOOK_TIME_POLICY_CONCRETE_SETTINGS_MAPの初期化 | E-04 (L170-191: staticブロック) | ○ |
| C-82 | DISK_CACHE_ENABLED_SETTING_MAPの初期化 | E-04 (L183-186: staticブロック) | ○ |
| C-83 | DEFAULT_DISK_CACHE_SIZE_IN_BYTESが1GB | E-04 (L34: 1073741824L) | ○ |
| C-84 | MIN_DISK_CACHE_SIZE_IN_BYTESが10MB | E-04 (L39: 10485760L) | ○ |
| C-85 | TieredSpilloverCachePluginコンストラクタの正常動作 | E-05 (L42-44: コンストラクタ) | ○ |
| C-86 | getCacheFactoryMap()がtiered_spilloverキーを含むMapを返す | E-05 (L47-52: Map.of(TIERED_SPILLOVER_CACHE_NAME, ...)) | ○ |
| C-87 | getSettings()が各CacheTypeにつき8つの設定を返す | E-05 (L55-78: forループ内の8つのadd) | △ |
| C-88 | getName()がtieredSpilloverCachePluginを返す | E-05 (L82-83: return TIERED_CACHE_SPILLOVER_PLUGIN_NAME, L34: 定数定義) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-26**: computeIfAbsentのポリシー拒否時の動作は、compute()メソッド内のwasRejectedByPolicyフラグの伝播と並行実行パターンに依存する。単一スレッドでの動作は確認できるが、複数スレッドでの全パターンは本ソースコードのみでは完全には検証不可。
  - 候補：統合テスト / 並行テストの既存テストコード
- **C-78**: removeDimensionsの動作はDefaultCacheStatsHolder（親クラス）のremoveDimensionsHelper実装に依存する。本モジュール内にその実装がないため、完全な根拠が不足。
  - 候補：`server/src/main/java/org/opensearch/common/cache/stats/DefaultCacheStatsHolder.java`
- **C-87**: getSettingsの設定数「8つ」は、forループ内のadd呼び出し回数を数えたもの。CacheType.values()の数やフレームワークの動的な挙動によっては変動する可能性がある。
  - 候補：CacheType enumの定義 / 実行時テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - TookTimePolicyのテストケース（C-01〜C-09）はコードが単純で根拠が明確
- 0: 低リスク - ConcatenatedIterator/ConcatenatedIterablesのテストケース（C-50〜C-54）は標準的なイテレータパターン
- 1: 中リスク - TieredSpilloverCacheの並行処理関連テストケース（C-21〜C-26）は、CompletableFutureを使った並行制御が含まれ、全パターンの網羅が難しい
- 1: 中リスク - StatsHolderのミス/エビクション集計ロジック（C-67〜C-72）は、diskCacheEnabledフラグとtier値の組み合わせにより動作が変わるため、テストケースの条件設定に注意が必要
- 0: 低リスク - Settingsと定数のテストケース（C-79〜C-84）は静的な値の確認

## 6) レビュアーチェックリスト（最小）
- [ ] TookTimePolicy.test()の閾値境界テスト（C-05, C-09）が正しいナノ秒単位で記述されているか確認
- [ ] computeIfAbsentの並行処理テスト（C-21〜C-26）で、CompletableFutureの完了/例外パターンが十分にカバーされているか確認
- [ ] handleRemovalFromHeapTierのスピルオーバーテスト（C-40〜C-44）で、SPILLOVER_REMOVAL_REASONS（EVICTEDとCAPACITY）の両方がテストされているか確認
- [ ] StatsHolderのincrementMissesテスト（C-67〜C-69）で、diskCacheEnabled状態とtier値の全組み合わせがカバーされているか確認
- [ ] removeDimensionsのテスト（C-78）で、親クラスDefaultCacheStatsHolderの動作も含めて検証されているか確認
