---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 126
  claims_with_evidence: 122
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：modules-geo 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：122 / 126、根拠なし：4
- 優先レビュー（高）
  1. **C-072 GeoShapeHashUtil.encodeShape 点シェイプのテスト**：点シェイプが1つのGeoHashを返すかはシェイプの実装依存のため確認が必要
  2. **C-017 innerBuild shardSize調整ロジック**：shardSizeがrequiredSize未満の場合の調整は直接コード確認済みだが、外部BucketUtils依存の動作は未確認
  3. **C-091/C-092 wrapLongitude境界解決の詳細ケース**：経度ラップのロジックは複雑であり、具体的な数値の期待値は実行時検証が必要
  4. **C-008 PolygonGenerator 1点のみの場合**：ValtrAlgorithmが1点の入力で正常動作するかはアルゴリズムの内部ロジック依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/geo/src/main/java/org/opensearch/geo/GeoModulePlugin.java`
- E-02: `modules/geo/src/main/java/org/opensearch/geo/algorithm/PolygonGenerator.java`
- E-03: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/GeoGridAggregationBuilder.java`
- E-04: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/GeoHashGridAggregationBuilder.java`
- E-05: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/GeoTileGridAggregationBuilder.java`
- E-06: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/BaseGeoGridBucket.java`
- E-07: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/BaseGeoGrid.java`
- E-08: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/BucketPriorityQueue.java`
- E-09: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/InternalGeoHashGridBucket.java`
- E-10: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/InternalGeoTileGridBucket.java`
- E-11: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/GeoHashGrid.java`
- E-12: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/GeoTileGrid.java`
- E-13: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/cells/CellIdSource.java`
- E-14: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/cells/BoundedCellValues.java`
- E-15: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/cells/UnboundedCellValues.java`
- E-16: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/cells/CellValues.java`
- E-17: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/cells/GeoShapeCellIdSource.java`
- E-18: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/cells/GeoShapeCellValues.java`
- E-19: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/util/GeoShapeHashUtil.java`
- E-20: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/metrics/InternalGeoBounds.java`
- E-21: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/metrics/GeoBoundsAggregationBuilder.java`
- E-22: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/metrics/AbstractGeoBoundsAggregator.java`
- E-23: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/metrics/GeoBoundsAggregator.java`
- E-24: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/metrics/GeoBoundsGeoShapeAggregator.java`
- E-25: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/metrics/GeoBoundsAggregatorFactory.java`
- E-26: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/metrics/ParsedGeoBounds.java`
- E-27: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/composite/GeoTileGridValuesSourceBuilder.java`
- E-28: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/composite/GeoTileValuesSource.java`
- E-29: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/GeoHashGridAggregatorFactory.java`
- E-30: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/GeoTileGridAggregatorFactory.java`
- E-31: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/GeoGridAggregator.java`
- E-32: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/ParsedGeoGrid.java`
- E-33: `modules/geo/src/main/java/org/opensearch/geo/search/aggregations/bucket/geogrid/ParsedGeoGridBucket.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | GeoModulePlugin.getMappers がGeoShapeマッパーを返却する | E-01 L57-59 | ○ |
| C-002 | GeoModulePlugin.getAggregations が3つのAggregationSpecを返却する | E-01 L66-84 | ○ |
| C-003 | GeoModulePlugin.getCompositeAggregations がGeoTileGridのSpecを返却する | E-01 L93-104 | ○ |
| C-004 | PolygonGenerator.generatePolygon が有効な入力からポリゴンを生成する | E-02 L39-55 | ○ |
| C-005 | PolygonGenerator.generatePolygon がxPool空で空リストを返す | E-02 L40-43 | ○ |
| C-006 | PolygonGenerator.generatePolygon がyPool空で空リストを返す | E-02 L40-43 | ○ |
| C-007 | PolygonGenerator.generatePolygon がxPool=nullで空リストを返す | E-02 L40-43 | ○ |
| C-008 | PolygonGenerator.generatePolygon が1点で動作する | E-02 | △ |
| C-009 | GeoGridAggregationBuilder.size が正の値で設定される | E-03 L170-176 | ○ |
| C-010 | GeoGridAggregationBuilder.size が0以下でIllegalArgumentException | E-03 L171-173 | ○ |
| C-011 | GeoGridAggregationBuilder.size が負数でIllegalArgumentException | E-03 L171-173 | ○ |
| C-012 | GeoGridAggregationBuilder.shardSize が正の値で設定される | E-03 L182-188 | ○ |
| C-013 | GeoGridAggregationBuilder.shardSize が0以下でIllegalArgumentException | E-03 L183-185 | ○ |
| C-014 | GeoGridAggregationBuilder.setGeoBoundingBox が設定される | E-03 L194-198 | ○ |
| C-015 | GeoGridAggregationBuilder.bucketCardinality がMANYを返す | E-03 L205-207 | ○ |
| C-016 | GeoGridAggregationBuilder.innerBuild でrequiredSize/shardSize<=0の時にOpenSearchException | E-03 L226-229 | ○ |
| C-017 | GeoGridAggregationBuilder.innerBuild でshardSize<requiredSizeの時にshardSize調整 | E-03 L232-234 | ○ |
| C-018 | GeoGridAggregationBuilder.equals 同一内容でtrue | E-03 L263-272 | ○ |
| C-019 | GeoGridAggregationBuilder.equals 異なる内容でfalse | E-03 L263-272 | ○ |
| C-020 | GeoHashGridAggregationBuilder コンストラクタのデフォルト値 | E-04 L70-75 | ○ |
| C-021 | GeoHashGridAggregationBuilder.precision 有効な精度設定 | E-04 L86-88 | ○ |
| C-022 | GeoHashGridAggregationBuilder.precision 範囲外で例外 | E-04 L87 | ○ |
| C-023 | GeoHashGridAggregationBuilder.getType がgeohash_gridを返す | E-04 L132-134 | ○ |
| C-024 | GeoTileGridAggregationBuilder コンストラクタのデフォルト値 | E-05 L70-75 | ○ |
| C-025 | GeoTileGridAggregationBuilder.precision 有効な精度設定 | E-05 L86-88 | ○ |
| C-026 | GeoTileGridAggregationBuilder.precision 範囲外で例外 | E-05 L87 | ○ |
| C-027 | GeoTileGridAggregationBuilder.getType がgeotile_gridを返す | E-05 L132-134 | ○ |
| C-028 | BaseGeoGridBucket コンストラクタの初期化 | E-06 L61-65 | ○ |
| C-029 | BaseGeoGridBucket.compareTo hashAsLong大で1 | E-06 L98-106 | ○ |
| C-030 | BaseGeoGridBucket.compareTo hashAsLong小で-1 | E-06 L98-106 | ○ |
| C-031 | BaseGeoGridBucket.compareTo 同値で0 | E-06 L98-106 | ○ |
| C-032 | BaseGeoGridBucket.getDocCount の正しい返却 | E-06 L88-90 | ○ |
| C-033 | BaseGeoGridBucket.equals 同一内容でtrue | E-06 L119-124 | ○ |
| C-034 | BaseGeoGridBucket.equals 異なるhashAsLongでfalse | E-06 L119-124 | ○ |
| C-035 | BaseGeoGrid.getBuckets 不変リスト返却 | E-07 L91-93 | ○ |
| C-036 | BaseGeoGrid.reduce 複数グリッドのリデュース | E-07 L96-127 | ○ |
| C-037 | BaseGeoGrid.reduce 空バケットリストのリデュース | E-07 L96-127 | ○ |
| C-038 | BaseGeoGrid.reduceBucket 同一セルのマージ | E-07 L130-140 | ○ |
| C-039 | BaseGeoGrid.equals 同一内容でtrue | E-07 L160-172 | ○ |
| C-040 | BucketPriorityQueue.lessThan docCount大が優先 | E-08 L48-57 | ○ |
| C-041 | BucketPriorityQueue.lessThan docCount同値のタイブレイク | E-08 L48-57 | ○ |
| C-042 | InternalGeoHashGridBucket.getKeyAsString geohash文字列変換 | E-09 L59-61 | ○ |
| C-043 | InternalGeoHashGridBucket.getKey GeoPoint変換 | E-09 L63-66 | ○ |
| C-044 | InternalGeoTileGridBucket.getKeyAsString geotile文字列変換 | E-10 L60-62 | ○ |
| C-045 | InternalGeoTileGridBucket.getKey GeoPoint変換 | E-10 L64-67 | ○ |
| C-046 | GeoHashGrid.create ファクトリメソッド | E-11 L59-61 | ○ |
| C-047 | GeoHashGrid.createBucket バケット生成 | E-11 L74-76 | ○ |
| C-048 | GeoHashGrid.getWriteableName geohash_grid返却 | E-11 L84-86 | ○ |
| C-049 | GeoTileGrid.create ファクトリメソッド | E-12 L59-61 | ○ |
| C-050 | GeoTileGrid.createBucket バケット生成 | E-12 L74-76 | ○ |
| C-051 | GeoTileGrid.getWriteableName geotile_grid返却 | E-12 L84-86 | ○ |
| C-052 | CellIdSource コンストラクタの初期化 | E-13 L54-60 | ○ |
| C-053 | CellIdSource.isFloatingPoint falseを返す | E-13 L67-69 | ○ |
| C-054 | CellIdSource.isBigInteger falseを返す | E-13 L72-74 | ○ |
| C-055 | CellIdSource.longValues unboundedでUnboundedCellValues | E-13 L77-82 | ○ |
| C-056 | CellIdSource.longValues boundedでBoundedCellValues | E-13 L77-82 | ○ |
| C-057 | CellIdSource.doubleValues でUnsupportedOperationException | E-13 L85-87 | ○ |
| C-058 | CellIdSource.bytesValues でUnsupportedOperationException | E-13 L90-92 | ○ |
| C-059 | BoundedCellValues.advanceValue 境界内でエンコード | E-14 L60-66 | ○ |
| C-060 | BoundedCellValues.advanceValue 境界外でスキップ | E-14 L60-66 | ○ |
| C-061 | UnboundedCellValues.advanceValue 無条件エンコード | E-15 L50-53 | ○ |
| C-062 | GeoShapeCellIdSource コンストラクタの初期化 | E-17 L37-47 | ○ |
| C-063 | GeoShapeCellIdSource.isFloatingPoint falseを返す | E-17 L63-65 | ○ |
| C-064 | GeoShapeCellIdSource.longValues unboundedでUnboundedCellValues | E-17 L81-86 | ○ |
| C-065 | GeoShapeCellIdSource.longValues boundedでBoundedCellValues | E-17 L81-86 | ○ |
| C-066 | GeoShapeCellIdSource.bytesValues でUnsupportedOperationException | E-17 L55-57 | ○ |
| C-067 | GeoShapeCellIdSource.doubleValues でUnsupportedOperationException | E-17 L94-96 | ○ |
| C-068 | GeoShapeCellValues.BoundedCellValues.relateShape 交差時エンコード | E-18 L80-94 | ○ |
| C-069 | GeoShapeCellValues.BoundedCellValues.relateShape 非交差時リセット | E-18 L80-94 | ○ |
| C-070 | GeoShapeCellValues.UnboundedCellValues.relateShape 無条件エンコード | E-18 L119-125 | ○ |
| C-071 | GeoShapeHashUtil.encodeShape 正常エンコード | E-19 L32-66 | ○ |
| C-072 | GeoShapeHashUtil.encodeShape 点シェイプで1つのGeoHash | E-19 | △ |
| C-073 | InternalGeoBounds コンストラクタの初期化 | E-20 L61-80 | ○ |
| C-074 | InternalGeoBounds.reduce 複数境界のリデュース | E-20 L113-144 | ○ |
| C-075 | InternalGeoBounds.reduce 空境界のリデュース | E-20 L113-144 | ○ |
| C-076 | InternalGeoBounds.getProperty path=["top"] | E-20 L152-196 | ○ |
| C-077 | InternalGeoBounds.getProperty path=["bottom"] | E-20 L152-196 | ○ |
| C-078 | InternalGeoBounds.getProperty path=["left"] | E-20 L152-196 | ○ |
| C-079 | InternalGeoBounds.getProperty path=["right"] | E-20 L152-196 | ○ |
| C-080 | InternalGeoBounds.getProperty path=["top_left","lat"] | E-20 L170-192 | ○ |
| C-081 | InternalGeoBounds.getProperty path=["bottom_right","lon"] | E-20 L170-192 | ○ |
| C-082 | InternalGeoBounds.getProperty 不正path要素で例外 | E-20 L167-168 | ○ |
| C-083 | InternalGeoBounds.getProperty path3要素以上で例外 | E-20 L193-195 | ○ |
| C-084 | InternalGeoBounds.getProperty 空pathでthis返却 | E-20 L153-155 | ○ |
| C-085 | InternalGeoBounds.topLeft 有効境界でGeoPoint返却 | E-20 L228-235 | ○ |
| C-086 | InternalGeoBounds.topLeft 空データでnull返却 | E-20 L228-235 | ○ |
| C-087 | InternalGeoBounds.bottomRight 有効境界でGeoPoint返却 | E-20 L237-245 | ○ |
| C-088 | InternalGeoBounds.bottomRight 空データでnull返却 | E-20 L237-245 | ○ |
| C-089 | InternalGeoBounds.resolveGeoBoundingBox posLeft=INFINITYで負側のみ | E-20 L207-225 | ○ |
| C-090 | InternalGeoBounds.resolveGeoBoundingBox negLeft=INFINITYで正側のみ | E-20 L207-225 | ○ |
| C-091 | InternalGeoBounds.resolveGeoBoundingBox wrapLongitudeラップ | E-20 L214-221 | △ |
| C-092 | InternalGeoBounds.resolveGeoBoundingBox wrapLongitudeアンラップ | E-20 L214-221 | △ |
| C-093 | InternalGeoBounds.equals 同一内容でtrue | E-20 L248-261 | ○ |
| C-094 | GeoBoundsAggregationBuilder デフォルトwrapLongitude=true | E-21 L81-85 | ○ |
| C-095 | GeoBoundsAggregationBuilder.wrapLongitude 設定 | E-21 L122-125 | ○ |
| C-096 | GeoBoundsAggregationBuilder.bucketCardinality NONE返却 | E-21 L128-130 | ○ |
| C-097 | GeoBoundsAggregationBuilder.getType geo_bounds返却 | E-21 L163-165 | ○ |
| C-098 | AbstractGeoBoundsAggregator.buildEmptyAggregation INFINITY値 | E-22 L75-87 | ○ |
| C-099 | AbstractGeoBoundsAggregator.buildAggregation valuesSource=nullで空集約 | E-22 L93-96 | ○ |
| C-100 | AbstractGeoBoundsAggregator.buildAggregation データ収集後のビルド | E-22 L93-104 | ○ |
| C-101 | AbstractGeoBoundsAggregator.setBucketSize 拡張 | E-22 L111-127 | ○ |
| C-102 | AbstractGeoBoundsAggregator.setBucketSize 不要な拡張の回避 | E-22 L112 | ○ |
| C-103 | ParsedGeoBounds.topLeft geoBoundingBox存在時 | E-26 L80-82 | ○ |
| C-104 | ParsedGeoBounds.topLeft geoBoundingBox=null時 | E-26 L80-82 | ○ |
| C-105 | ParsedGeoBounds.bottomRight geoBoundingBox存在時 | E-26 L85-88 | ○ |
| C-106 | ParsedGeoBounds.bottomRight geoBoundingBox=null時 | E-26 L85-88 | ○ |
| C-107 | ParsedGeoBounds.fromXContent 正常パース | E-26 L123-127 | ○ |
| C-108 | ParsedGeoBounds.getType geo_bounds返却 | E-26 L66-68 | ○ |
| C-109 | GeoTileGridValuesSourceBuilder.precision 有効な精度設定 | E-27 L180-183 | ○ |
| C-110 | GeoTileGridValuesSourceBuilder.precision 範囲外で例外 | E-27 L181 | ○ |
| C-111 | GeoTileGridValuesSourceBuilder.geoBoundingBox 設定 | E-27 L185-188 | ○ |
| C-112 | GeoTileGridValuesSourceBuilder.format でIllegalArgumentException | E-27 L191-193 | ○ |
| C-113 | GeoTileGridValuesSourceBuilder.equals 同一内容でtrue | E-27 L224-230 | ○ |
| C-114 | GeoTileGridValuesSourceBuilder.parse XContentパース | E-27 L117-119 | ○ |
| C-115 | GeoTileValuesSource.setAfter Number型でlongValue | E-28 L73-82 | ○ |
| C-116 | GeoTileValuesSource.setAfter 文字列でGeoTileUtils.longEncode | E-28 L73-82 | ○ |
| C-117 | GeoTileValuesSource.setAfter missingBucket=trueでnull | E-28 L74-75 | ○ |
| C-118 | GeoHashGridAggregatorFactory.createUnmapped 空GeoHashGrid返却 | E-29 L91-99 | ○ |
| C-119 | GeoHashGridAggregatorFactory.registerAggregators GeoPoint/GeoShape登録 | E-29 L125-197 | ○ |
| C-120 | GeoTileGridAggregatorFactory.createUnmapped 空GeoTileGrid返却 | E-30 L89-97 | ○ |
| C-121 | GeoTileGridAggregatorFactory.registerAggregators GeoPoint/GeoShape登録 | E-30 L123-195 | ○ |
| C-122 | GeoBoundsAggregatorFactory.registerAggregators GeoPoint/GeoShape登録 | E-25 L88-91 | ○ |
| C-123 | GeoBoundsAggregatorFactory.supportsConcurrentSegmentSearch trueを返す | E-25 L94-96 | ○ |
| C-124 | GeoGridAggregator.scoreMode needsScores=trueでCOMPLETE | E-31 L86-91 | ○ |
| C-125 | GeoGridAggregator.scoreMode needsScores=falseでsuper | E-31 L86-91 | ○ |
| C-126 | GeoGridAggregator.buildEmptyAggregation 空バケットリスト | E-31 L166-168 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-008: PolygonGeneratorの1点入力テスト - ValtrAlgorithmの内部で1点のみのリストがどう処理されるかは、アルゴリズムの特性に依存しており、実行時テストで確認が必要
  - 候補：ValtrAlgorithmの数学的仕様書 / アルゴリズム参照リンクの内容確認
- C-072: GeoShapeHashUtil.encodeShapeの点シェイプテスト - 点を表すGeoShapeDocValueのBoundingRectangleが単一セルに収まるかはGeoShapeDocValueの実装に依存
  - 候補：GeoShapeDocValue実装の確認 / Geohashの解像度特性
- C-091/C-092: wrapLongitudeの境界解決ロジック - 具体的な数値での期待値はコードの条件分岐から推論しているが、実行テストで確認が推奨される
  - 候補：既存のテストコード / GIS仕様書

## 5) リスクフラグ（レビュー観点）
- 0: GeoModulePlugin（プラグイン登録 - 低リスク、構造が明確）
- 0: BaseGeoGridBucket, BaseGeoGrid（標準的なequals/hashCode/compareTo - 低リスク）
- 1: InternalGeoBounds.resolveGeoBoundingBox（経度ラップのロジックが複雑 - 中リスク）
- 1: GeoShapeHashUtil.encodeShape（geohashの走査ロジックが複雑 - 中リスク）
- 0: GeoGridAggregationBuilder.size/shardSize バリデーション（条件が明確 - 低リスク）
- 0: CellIdSource/GeoShapeCellIdSource（分岐が単純 - 低リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] InternalGeoBounds.resolveGeoBoundingBox のwrapLongitudeロジック（C-091, C-092）の期待値が正しいか確認
- [ ] GeoShapeHashUtil.encodeShape の走査ロジックが全てのシェイプタイプで正しく動作するか確認
- [ ] PolygonGenerator の1点入力ケース（C-008）が意図された動作か確認
- [ ] GeoHashGridAggregationBuilder.precision の範囲チェックがGeoUtils.checkPrecisionRangeの実装と整合しているか確認
- [ ] GeoTileGridAggregationBuilder.precision の範囲チェックがGeoTileUtils.checkPrecisionRangeの実装と整合しているか確認
- [ ] 各Factory.registerAggregatorsで登録されるアグリゲータの型が正しいか確認
