---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 148
  claims_with_evidence: 145
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：modules-ingest-common 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：145 / 148、根拠なし：3
- 優先レビュー（高）
  1. **C-113 ScriptProcessor.execute 正常系**：スクリプト実行の具体的な検証結果はScriptService依存のため実行時確認が必要
  2. **C-114 ScriptProcessor precompiledScript**：プリコンパイルスクリプトの動作はScriptService依存
  3. **C-042 DateProcessor カスタム出力フォーマット**：出力フォーマットの具体的な検証はDateFormatter実装依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/AbstractStringProcessor.java`
- E-02: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/AppendProcessor.java`
- E-03: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/ConvertProcessor.java`
- E-04: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/CsvProcessor.java`
- E-05: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/CsvParser.java`
- E-06: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/DateProcessor.java`
- E-07: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/DateFormat.java`
- E-08: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/DateIndexNameProcessor.java`
- E-09: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/DissectProcessor.java`
- E-10: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/DotExpanderProcessor.java`
- E-11: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/FailProcessor.java`
- E-12: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/ForEachProcessor.java`
- E-13: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/GrokProcessor.java`
- E-14: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/GsubProcessor.java`
- E-15: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/JsonProcessor.java`
- E-16: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/JoinProcessor.java`
- E-17: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/KeyValueProcessor.java`
- E-18: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/RemoveProcessor.java`
- E-19: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/RemoveByPatternProcessor.java`
- E-20: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/RenameProcessor.java`
- E-21: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/SetProcessor.java`
- E-22: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/SortProcessor.java`
- E-23: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/SplitProcessor.java`
- E-24: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/ScriptProcessor.java`
- E-25: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/BytesProcessor.java`
- E-26: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/LowercaseProcessor.java`
- E-27: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/UppercaseProcessor.java`
- E-28: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/TrimProcessor.java`
- E-29: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/URLDecodeProcessor.java`
- E-30: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/HtmlStripProcessor.java`
- E-31: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/CopyProcessor.java`
- E-32: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/FingerprintProcessor.java`
- E-33: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/CommunityIdProcessor.java`
- E-34: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/IngestCommonModulePlugin.java`
- E-35: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/FailProcessorException.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractStringProcessor.execute: 文字列フィールドを正常に処理できること | E-01 (L75-117) | ○ |
| C-02 | AbstractStringProcessor.execute: リスト型フィールドの各要素を処理できること | E-01 (L85-104) | ○ |
| C-03 | AbstractStringProcessor.execute: nullでignoreMissing=falseの場合に例外 | E-01 (L81-83) | ○ |
| C-04 | AbstractStringProcessor.execute: nullでignoreMissing=trueの場合にそのまま返却 | E-01 (L79-80) | ○ |
| C-05 | AbstractStringProcessor.execute: 非String型で例外 | E-01 (L109-111) | ○ |
| C-06 | AbstractStringProcessor.execute: リスト内非String要素で例外 | E-01 (L91-101) | ○ |
| C-07 | AppendProcessor.execute: 既存フィールドに値を追加 | E-02 (L74-76) | ○ |
| C-08 | AppendProcessor.execute: 存在しないフィールドに新規リスト作成 | E-02 (L74-76) | ○ |
| C-09 | AppendProcessor.execute: allowDuplicates=falseで重複不可 | E-02 (L75) | ○ |
| C-10 | AppendProcessor.execute: スカラーからリストへの変換 | E-02 (L74-76) | ○ |
| C-11 | ConvertProcessor: 文字列をIntegerに変換 | E-03 (L56-68) | ○ |
| C-12 | ConvertProcessor: 16進数変換 | E-03 (L60-61) | ○ |
| C-13 | ConvertProcessor: Long変換 | E-03 (L71-82) | ○ |
| C-14 | ConvertProcessor: Double変換 | E-03 (L84-92) | ○ |
| C-15 | ConvertProcessor: Float変換 | E-03 (L94-102) | ○ |
| C-16 | ConvertProcessor: Boolean変換 | E-03 (L104-115) | ○ |
| C-17 | ConvertProcessor: String変換 | E-03 (L117-120) | ○ |
| C-18 | ConvertProcessor: IP変換 | E-03 (L122-134) | ○ |
| C-19 | ConvertProcessor: Integer変換失敗 | E-03 (L64-66) | ○ |
| C-20 | ConvertProcessor: Boolean変換失敗 | E-03 (L112) | ○ |
| C-21 | ConvertProcessor: IP変換失敗 | E-03 (L131) | ○ |
| C-22 | ConvertProcessor: AUTO型自動判定 | E-03 (L136-157) | ○ |
| C-23 | ConvertProcessor: リスト変換 | E-03 (L223-228) | ○ |
| C-24 | ConvertProcessor: nullでignoreMissing=false | E-03 (L219-220) | ○ |
| C-25 | ConvertProcessor.Type.fromString: 不正型文字列 | E-03 (L167-178) | ○ |
| C-26 | CsvProcessor.execute: 基本CSVパース | E-04 (L93-106), E-05 | ○ |
| C-27 | CsvProcessor.execute: クォート付きCSVパース | E-04, E-05 (L162-169) | ○ |
| C-28 | CsvProcessor.execute: 空ヘッダー | E-04 (L94-96) | ○ |
| C-29 | CsvProcessor.execute: nullでignoreMissing=false | E-04 (L101-102) | ○ |
| C-30 | CsvProcessor.execute: trim機能 | E-04 (L66), E-05 (L127-130) | ○ |
| C-31 | CsvProcessor.execute: カスタムセパレータ | E-04 (L67) | ○ |
| C-32 | CsvParser.process: 閉じられていないクォート | E-05 (L109) | ○ |
| C-33 | CsvParser.process: 未クォートフィールド内改行 | E-05 (L144) | ○ |
| C-34 | CsvParser.process: emptyValue設定 | E-05 (L220-222) | ○ |
| C-35 | CsvParser.process: フィールド数不足 | E-05 (L224) | ○ |
| C-36 | DateProcessor: ISO8601パース | E-06 (L116-141), E-07 (L59-68) | ○ |
| C-37 | DateProcessor: Unixパース | E-06, E-07 (L71-74) | ○ |
| C-38 | DateProcessor: UnixMsパース | E-06, E-07 (L77-80) | ○ |
| C-39 | DateProcessor: カスタムフォーマット | E-06, E-07 (L98-143) | ○ |
| C-40 | DateProcessor: パース失敗 | E-06 (L135-136) | ○ |
| C-41 | DateProcessor: タイムゾーン | E-06 (L107-108) | ○ |
| C-42 | DateProcessor: カスタム出力フォーマット | E-06 (L103-104) | ○ |
| C-43 | DateFormat.fromString: ISO8601 | E-07 (L149-150) | ○ |
| C-44 | DateFormat.fromString: UNIX | E-07 (L151-152) | ○ |
| C-45 | DateFormat.fromString: デフォルトJava | E-07 (L157-158) | ○ |
| C-46 | DateFormat.Tai64n: TAI64Nパース | E-07 (L83-96) | ○ |
| C-47 | DateIndexNameProcessor: インデックス名生成 | E-08 (L86-131) | ○ |
| C-48 | DateIndexNameProcessor: パース失敗 | E-08 (L106-107) | ○ |
| C-49 | DissectProcessor: 基本Dissect | E-09 (L63-71) | ○ |
| C-50 | DissectProcessor: nullでignoreMissing=false | E-09 (L67-68) | ○ |
| C-51 | DissectProcessor: ignoreMissing=true | E-09 (L65-66) | ○ |
| C-52 | DotExpanderProcessor: ドット展開 | E-10 (L57-94) | ○ |
| C-53 | DotExpanderProcessor: 既存オブジェクトへの追記 | E-10 (L69-71) | ○ |
| C-54 | DotExpanderProcessor: パスの一部がスカラーで例外 | E-10 (L82-83) | ○ |
| C-55 | DotExpanderProcessor.Factory: ドットなしフィールド | E-10 (L120-121) | ○ |
| C-56 | DotExpanderProcessor.Factory: ドット始まりフィールド | E-10 (L123-124) | ○ |
| C-57 | FailProcessor: FailProcessorException | E-11 (L64-65), E-35 | ○ |
| C-58 | ForEachProcessor: リスト各要素処理 | E-12 (L82-93) | ○ |
| C-59 | ForEachProcessor: nullでignoreMissing=false | E-12 (L87-88) | ○ |
| C-60 | ForEachProcessor: ignoreMissing=true | E-12 (L85-86) | ○ |
| C-61 | ForEachProcessor: 同期executeでUnsupportedOperation | E-12 (L128-129) | ○ |
| C-62 | GrokProcessor: Grokマッチ | E-13 (L87-113) | ○ |
| C-63 | GrokProcessor: マッチ失敗 | E-13 (L98) | ○ |
| C-64 | GrokProcessor: nullでignoreMissing=false | E-13 (L92-93) | ○ |
| C-65 | GrokProcessor: traceMatch | E-13 (L103-111) | ○ |
| C-66 | GrokProcessor.combinePatterns: 複数パターン結合 | E-13 (L140-163) | ○ |
| C-67 | GrokProcessor.combinePatterns: 単一パターン | E-13 (L158-159) | ○ |
| C-68 | GsubProcessor.process: 正規表現置換 | E-14 (L75-76) | ○ |
| C-69 | GsubProcessor.process: 複数箇所置換 | E-14 (L76) | ○ |
| C-70 | GsubProcessor.process: マッチなし | E-14 (L76) | ○ |
| C-71 | JsonProcessor: JSONパース基本 | E-15 (L128-133) | ○ |
| C-72 | JsonProcessor: addToRoot | E-15 (L129-130) | ○ |
| C-73 | JsonProcessor.apply: 配列パース | E-15 (L105-106) | ○ |
| C-74 | JsonProcessor.apply: プリミティブパース | E-15 (L97-98) | ○ |
| C-75 | JsonProcessor.apply: nullパース | E-15 (L84, L95-96) | ○ |
| C-76 | JsonProcessor.apply: 不正JSON | E-15 (L111-113) | ○ |
| C-77 | JsonProcessor.apply(Map): 非Map値のルート追加 | E-15 (L123) | ○ |
| C-78 | JoinProcessor: 基本Join | E-16 (L76-83) | ○ |
| C-79 | JoinProcessor: null例外 | E-16 (L78-79) | ○ |
| C-80 | JoinProcessor: 単一要素 | E-16 (L81) | ○ |
| C-81 | KeyValueProcessor: 基本KV処理 | E-17 (L256-259) | ○ |
| C-82 | KeyValueProcessor: includeKeys | E-17 (L123-135) | ○ |
| C-83 | KeyValueProcessor: excludeKeys | E-17 (L123-135) | ○ |
| C-84 | KeyValueProcessor: stripBrackets | E-17 (L161-163) | ○ |
| C-85 | KeyValueProcessor: 欠損フィールド | E-17 (L170-178) | ○ |
| C-86 | KeyValueProcessor: targetField | E-17 (L140-149) | ○ |
| C-87 | RemoveProcessor: フィールド削除 | E-18 (L97-133) | ○ |
| C-88 | RemoveProcessor: excludeFields | E-18 (L136-160) | ○ |
| C-89 | RemoveProcessor: _indexフィールド保護 | E-18 (L113-117) | ○ |
| C-90 | RemoveProcessor: 存在しないフィールド | E-18 (L102-109) | ○ |
| C-91 | RemoveProcessor: ignoreMissing | E-18 (L103-104) | ○ |
| C-92 | RemoveProcessor: 外部バージョン時のID保護 | E-18 (L119-131) | ○ |
| C-93 | RemoveByPatternProcessor: パターン削除 | E-19 (L66-84) | ○ |
| C-94 | RemoveByPatternProcessor: excludeFieldPatterns | E-19 (L86-96) | ○ |
| C-95 | RemoveByPatternProcessor: メタデータ保護 | E-19 (L77) | ○ |
| C-96 | RenameProcessor: 基本リネーム | E-20 (L89-121) | ○ |
| C-97 | RenameProcessor: ターゲット重複 | E-20 (L107-108) | ○ |
| C-98 | RenameProcessor: overrideTarget | E-20 (L107) | ○ |
| C-99 | RenameProcessor: 欠損ソース | E-20 (L92-99) | ○ |
| C-100 | SetProcessor: 基本Set | E-21 (L94-98) | ○ |
| C-101 | SetProcessor: override=true | E-21 (L95-96) | ○ |
| C-102 | SetProcessor: override=false | E-21 (L95) | ○ |
| C-103 | SetProcessor: ignoreEmptyValue | E-21 (L96) | ○ |
| C-104 | SortProcessor: 昇順ソート | E-22 (L110-127) | ○ |
| C-105 | SortProcessor: 降順ソート | E-22 (L121-122) | ○ |
| C-106 | SortProcessor: null例外 | E-22 (L113-114) | ○ |
| C-107 | SortOrder.fromString: 不正方向 | E-22 (L81) | ○ |
| C-108 | SortOrder.fromString: null値 | E-22 (L73-74) | ○ |
| C-109 | SplitProcessor: 基本Split | E-23 (L98-111) | ○ |
| C-110 | SplitProcessor: nullでignoreMissing=false | E-23 (L103-104) | ○ |
| C-111 | SplitProcessor: preserveTrailing | E-23 (L107) | ○ |
| C-112 | SplitProcessor: セパレータ未検出 | E-23 (L107) | ○ |
| C-113 | ScriptProcessor: 基本Script実行 | E-24 (L97-111) | △ |
| C-114 | ScriptProcessor: precompiledScript | E-24 (L99-103) | △ |
| C-115 | BytesProcessor: 基本Bytes変換 | E-25 (L51-52) | ○ |
| C-116 | BytesProcessor: MB変換 | E-25 (L51-52) | ○ |
| C-117 | BytesProcessor: 不正入力 | E-25 (L52) | ○ |
| C-118 | LowercaseProcessor: 小文字変換 | E-26 | ○ |
| C-119 | UppercaseProcessor: 大文字変換 | E-27 | ○ |
| C-120 | TrimProcessor: トリム | E-28 | ○ |
| C-121 | URLDecodeProcessor: URLデコード | E-29 | ○ |
| C-122 | HtmlStripProcessor: HTMLストリップ | E-30 (L51-67) | ○ |
| C-123 | HtmlStripProcessor: HTMLタグなしショートカット | E-30 (L53-55) | ○ |
| C-124 | CopyProcessor: 基本コピー | E-31 (L75-107) | ○ |
| C-125 | CopyProcessor: removeSource | E-31 (L103-105) | ○ |
| C-126 | CopyProcessor: 欠損ソース | E-31 (L78-85) | ○ |
| C-127 | CopyProcessor: ターゲット重複 | E-31 (L100) | ○ |
| C-128 | CopyProcessor: 同一パス | E-31 (L92-93) | ○ |
| C-129 | FingerprintProcessor: 基本ハッシュ生成 | E-32 (L105-173) | ○ |
| C-130 | FingerprintProcessor: excludeFields | E-32 (L121-125) | ○ |
| C-131 | FingerprintProcessor: ネストMapフラット化 | E-32 (L142-155, L197-208) | ○ |
| C-132 | FingerprintProcessor: 欠損フィールド | E-32 (L133-138) | ○ |
| C-133 | FingerprintProcessor: MD5ハッシュ | E-32 (L167-170) | ○ |
| C-134 | HashMethod.fromMethodName: 有効メソッド | E-32 (L226-240) | ○ |
| C-135 | HashMethod.fromMethodName: 不正メソッド | E-32 (L237-238) | ○ |
| C-136 | CommunityIdProcessor: TCP CommunityID | E-33 (L138-237) | ○ |
| C-137 | CommunityIdProcessor: UDP CommunityID | E-33 (L138-237) | ○ |
| C-138 | CommunityIdProcessor: ICMP CommunityID | E-33 (L180-210) | ○ |
| C-139 | CommunityIdProcessor: IPフォーマット不一致 | E-33 (L156-157) | ○ |
| C-140 | CommunityIdProcessor: 不正プロトコル番号 | E-33 (L267-268) | ○ |
| C-141 | CommunityIdProcessor: ignoreMissing | E-33 (L142-143, L280-282) | ○ |
| C-142 | Protocol.fromProtocolName: TCP解決 | E-33 (L575-585) | ○ |
| C-143 | Protocol.fromProtocolName: IPv6-ICMP解決 | E-33 (L577-578) | ○ |
| C-144 | Protocol.fromProtocolName: 不正名でnull | E-33 (L582-583) | ○ |
| C-145 | IngestCommonModulePlugin.getProcessors: 全プロセッサ登録 | E-34 (L89-127) | ○ |
| C-146 | filterForAllowlistSetting: 許可リストフィルタ | E-34 (L163-184) | ○ |
| C-147 | filterForAllowlistSetting: 不正許可リスト | E-34 (L172-180) | ○ |
| C-148 | filterForAllowlistSetting: 許可リスト未設定 | E-34 (L164-165) | △ |

## 4) 不足情報（Unknown / Missing）
- C-113, C-114: ScriptProcessorのテストケースは、スクリプト実行がScriptServiceに依存するため、具体的な入出力の検証にはモック設定が必要。ソースコード上ではexecuteメソッドの流れは確認できるが、スクリプト実行結果の詳細はScriptServiceの実装に依存する。
  - 候補：ScriptServiceのモック定義 / IngestScriptの具体的なテストスクリプト / スクリプト実行結果の検証方法
- C-148: filterForAllowlistSettingの許可リスト未設定時のデフォルト動作については、PROCESSORS_ALLOWLIST_SETTING.exists()がfalseを返す場合のMap.copyOf(map)の動作確認が必要。コード上は明確だが実行時の設定環境に依存する部分がある。
  - 候補：Settings.EMPTY での動作確認 / デフォルト設定値の検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - AbstractStringProcessor, AppendProcessor, ConvertProcessor, JoinProcessor, SortProcessor, SplitProcessor, BytesProcessor, LowercaseProcessor, UppercaseProcessor, TrimProcessor, URLDecodeProcessor, HtmlStripProcessor のテストケースはソースコードから直接導出可能
- 0: 低リスク - CsvProcessor, CsvParser, DissectProcessor, DotExpanderProcessor, FailProcessor のテストケースもソースコードの分岐を網羅
- 1: 中リスク - ScriptProcessor のテストケースはScriptServiceとの統合が必要であり、モック構成の妥当性確認が必要
- 0: 低リスク - CommunityIdProcessor のテストケースはプロトコル解決、IP解決、ポート解決の各パスを網羅
- 0: 低リスク - FingerprintProcessor のテストケースはハッシュ生成ロジックの各パスを網羅

## 6) レビュアーチェックリスト（最小）
- [ ] ScriptProcessor (C-113, C-114) のテストケースについてScriptServiceモックの設計が妥当か確認
- [ ] ConvertProcessor の AUTO型 (C-22) について、変換優先順序（Boolean > Integer > Long > Float > Double > String）がテストケースで十分にカバーされているか確認
- [ ] CommunityIdProcessor (C-136-C-144) についてICMPv6タイプマッピングの網羅性を確認
- [ ] RemoveProcessor (C-87-C-92) のメタデータフィールド保護ロジックが全メタデータフィールドをカバーしているか確認
- [ ] FingerprintProcessor (C-129-C-135) のハッシュ一貫性（同一入力から同一出力）のテストケース追加を検討
- [ ] IngestCommonModulePlugin (C-145-C-148) で登録される全プロセッサタイプの網羅性を確認
