---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 93
  claims_with_evidence: 91
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：modules-ingest-geoip 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：91 / 93、根拠なし：2
- 優先レビュー（高）
  1. **UT-GEO-054（ストリームスキップ失敗テスト）**：スキップ失敗のシナリオはコード上存在するが、実際のテスト条件の再現方法が要確認
  2. **UT-GEO-053（UTF-8文字列型チェック）**：タイプフラグ不正のテストファイル作成方法が要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/ingest-geoip/src/main/java/org/opensearch/ingest/geoip/GeoIpProcessor.java` - GeoIpProcessorクラス（execute、retrieveCityGeoData、retrieveCountryGeoData、retrieveAsnGeoData、Property enum、Factory内部クラス）
- E-02: `modules/ingest-geoip/src/main/java/org/opensearch/ingest/geoip/DatabaseReaderLazyLoader.java` - DatabaseReaderLazyLoaderクラス（getDatabaseType、get、close、コンストラクタ）
- E-03: `modules/ingest-geoip/src/main/java/org/opensearch/ingest/geoip/IngestGeoIpModulePlugin.java` - IngestGeoIpModulePluginクラス（getProcessors、loadDatabaseReaders、filterForAllowlistSetting、close、GeoIpCacheインナークラス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-GEO-001: 文字列IPアドレスからCity情報を取得できること | E-01 (L126-166, L172-177, L221-304) | ○ |
| C-02 | UT-GEO-002: 文字列IPアドレスからCountry情報を取得できること | E-01 (L126-166, L178-182, L307-349) | ○ |
| C-03 | UT-GEO-003: 文字列IPアドレスからASN情報を取得できること | E-01 (L126-166, L184-189, L352-392) | ○ |
| C-04 | UT-GEO-004: IPアドレスのリストから全件のgeoデータを取得できること | E-01 (L140-161) | ○ |
| C-05 | UT-GEO-005: firstOnly=trueの場合に最初の結果のみ返却されること | E-01 (L152-155) | ○ |
| C-06 | UT-GEO-006: ignoreMissing=trueでnullの場合にドキュメントがそのまま返却 | E-01 (L129-130) | ○ |
| C-07 | UT-GEO-007: GeoIPデータが空の場合にtargetFieldが設定されない | E-01 (L137-139, L175-177) | ○ |
| C-08 | UT-GEO-008: ignoreMissing=falseでnullの場合にIllegalArgumentException | E-01 (L131-132) | ○ |
| C-09 | UT-GEO-009: StringでもListでもない場合にIllegalArgumentException | E-01 (L162-163) | ○ |
| C-10 | UT-GEO-010: リスト内にString以外の要素がある場合にIllegalArgumentException | E-01 (L144-145) | ○ |
| C-11 | UT-GEO-011: 未対応DBタイプの場合にOpenSearchParseException | E-01 (L191-194) | ○ |
| C-12 | UT-GEO-012: IPリストが空の場合にtargetFieldが設定されない | E-01 (L141-161) | ○ |
| C-13 | UT-GEO-013: IPリストが1件の場合に正常処理 | E-01 (L140-161) | ○ |
| C-14 | UT-GEO-014: City応答から全プロパティが取得できること | E-01 (L240-302) | ○ |
| C-15 | UT-GEO-015: countryIsoCodeがnullの場合にcountry_iso_codeが含まれない | E-01 (L246-249) | ○ |
| C-16 | UT-GEO-016: latitude/longitudeがnullの場合にlocationが含まれない | E-01 (L292-299) | ○ |
| C-17 | UT-GEO-017: region_iso_codeの複合nullチェック | E-01 (L266-271) | ○ |
| C-18 | UT-GEO-018: Country応答から全プロパティ取得 | E-01 (L322-347) | ○ |
| C-19 | UT-GEO-019: CountryResponseのcountryNameがnullの場合 | E-01 (L335-338) | ○ |
| C-20 | UT-GEO-020: ASN応答から全プロパティ取得 | E-01 (L368-391) | ○ |
| C-21 | UT-GEO-021: asnがnullの場合 | E-01 (L375-377) | ○ |
| C-22 | UT-GEO-022: networkがnullの場合 | E-01 (L385-387) | ○ |
| C-23 | UT-GEO-023: getTypeがgeoipを返す | E-01 (L75, L200-202) | ○ |
| C-24 | UT-GEO-024: getFieldアクセサ | E-01 (L204-206) | ○ |
| C-25 | UT-GEO-025: getTargetFieldアクセサ | E-01 (L208-210) | ○ |
| C-26 | UT-GEO-026: getPropertiesアクセサ | E-01 (L216-218) | ○ |
| C-27 | UT-GEO-027: isIgnoreMissingアクセサ | E-01 (L121-123) | ○ |
| C-28 | UT-GEO-028: City DBデフォルトプロパティでFactory create | E-01 (L395-405, L458-461) | ○ |
| C-29 | UT-GEO-029: Country DBデフォルトプロパティでFactory create | E-01 (L406-408, L462-463) | ○ |
| C-30 | UT-GEO-030: ASN DBデフォルトプロパティでFactory create | E-01 (L409-411, L464-465) | ○ |
| C-31 | UT-GEO-031: カスタムプロパティでFactory create | E-01 (L448-457) | ○ |
| C-32 | UT-GEO-032: カスタムtargetField指定 | E-01 (L434) | ○ |
| C-33 | UT-GEO-033: ignore_missingオプション | E-01 (L437) | ○ |
| C-34 | UT-GEO-034: first_onlyオプション | E-01 (L438) | ○ |
| C-35 | UT-GEO-035: 存在しないdatabase_fileでエラー | E-01 (L440-443) | ○ |
| C-36 | UT-GEO-036: 不正プロパティ名でエラー | E-01 (L451-454) | ○ |
| C-37 | UT-GEO-037: 未対応DBタイプでproperties未指定エラー | E-01 (L466-472) | ○ |
| C-38 | UT-GEO-038: target_fieldデフォルト値 | E-01 (L434) | ○ |
| C-39 | UT-GEO-039: database_fileデフォルト値 | E-01 (L435) | ○ |
| C-40 | UT-GEO-040: City DBタイプでparseProperty正常 | E-01 (L539-560) | ○ |
| C-41 | UT-GEO-041: Country DBタイプでparseProperty正常 | E-01 (L539-560) | ○ |
| C-42 | UT-GEO-042: ASN DBタイプでparseProperty正常 | E-01 (L539-560) | ○ |
| C-43 | UT-GEO-043: 大文字小文字非依存のパース | E-01 (L550) | ○ |
| C-44 | UT-GEO-044: CityDBにASN固有プロパティ指定でエラー | E-01 (L551-553) | ○ |
| C-45 | UT-GEO-045: 存在しないプロパティ名でエラー | E-01 (L549-558) | ○ |
| C-46 | UT-GEO-046: 未対応DBタイプでvalidPropertiesが空 | E-01 (L540-547) | ○ |
| C-47 | UT-GEO-047: databasePathがnullでNPE | E-02 (L67) | ○ |
| C-48 | UT-GEO-048: loaderがnullでNPE | E-02 (L68) | ○ |
| C-49 | UT-GEO-049: 有効なmmdbからDBタイプ読み取り | E-02 (L82-141) | ○ |
| C-50 | UT-GEO-050: DBタイプのキャッシュ動作 | E-02 (L83-85, L64) | ○ |
| C-51 | UT-GEO-051: ファイルサイズ512以下でIOException | E-02 (L87-88) | ○ |
| C-52 | UT-GEO-052: マーカー未検出でIOException | E-02 (L124-125) | ○ |
| C-53 | UT-GEO-053: UTF-8文字列でないタイプでIOException | E-02 (L131-132) | △ |
| C-54 | UT-GEO-054: ストリームスキップ失敗でIOException | E-02 (L94-95) | △ |
| C-55 | UT-GEO-055: 初回呼び出しでDatabaseReaderロード | E-02 (L151-161) | ○ |
| C-56 | UT-GEO-056: 2回呼び出しで同一インスタンス返却 | E-02 (L152-154, L62) | ○ |
| C-57 | UT-GEO-057: loaderがIOExceptionスローで伝播 | E-02 (L155) | ○ |
| C-58 | UT-GEO-058: closeでDatabaseReader閉じ | E-02 (L164-166) | ○ |
| C-59 | UT-GEO-059: 未ロード状態のclose安全性 | E-02 (L164-166) | ○ |
| C-60 | UT-GEO-060: ファイルサイズ512バイト境界値 | E-02 (L87: fileSize <= 512) | ○ |
| C-61 | UT-GEO-061: ファイルサイズ513バイト境界値 | E-02 (L87: fileSize <= 512) | ○ |
| C-62 | UT-GEO-062: getSettings返却値 | E-03 (L85-87) | ○ |
| C-63 | UT-GEO-063: getProcessorsでgeoipファクトリ返却 | E-03 (L90-106) | ○ |
| C-64 | UT-GEO-064: getProcessors二重呼び出しエラー | E-03 (L91-93) | ○ |
| C-65 | UT-GEO-065: デフォルト3DBロード | E-03 (L125-155, L80) | ○ |
| C-66 | UT-GEO-066: カスタムmmdbファイル追加ロード | E-03 (L139-153) | ○ |
| C-67 | UT-GEO-067: デフォルトDB不在でIOException | E-03 (L169-176, L126) | ○ |
| C-68 | UT-GEO-068: 設定ディレクトリ不在で正常動作 | E-03 (L139) | ○ |
| C-69 | UT-GEO-069: 設定ディレクトリにデフォルトDB重複でIOException | E-03 (L127, L169-176) | ○ |
| C-70 | UT-GEO-070: 返却Mapの不変性 | E-03 (L154) | ○ |
| C-71 | UT-GEO-071: close時にreaderが全閉じ | E-03 (L184-188) | ○ |
| C-72 | UT-GEO-072: 未初期化状態のclose安全性 | E-03 (L185) | ○ |
| C-73 | UT-GEO-073: allowlist未設定で全プロセッサ返却 | E-03 (L191-193) | ○ |
| C-74 | UT-GEO-074: allowlistにgeoip含むフィルタリング | E-03 (L194, L208-211) | ○ |
| C-75 | UT-GEO-075: 空allowlistで空Map返却 | E-03 (L208-211) | ○ |
| C-76 | UT-GEO-076: 不正allowlist値でIllegalArgumentException | E-03 (L196-207) | ○ |
| C-77 | UT-GEO-077: 正のmaxSizeでキャッシュ初期化 | E-03 (L224-229) | ○ |
| C-78 | UT-GEO-078: maxSize=0でキャッシュ初期化 | E-03 (L225-226, L78) | ○ |
| C-79 | UT-GEO-079: 負のmaxSizeでIllegalArgumentException | E-03 (L225-227) | ○ |
| C-80 | UT-GEO-080: キャッシュミス時のretrieveFunction呼び出し | E-03 (L231-246) | ○ |
| C-81 | UT-GEO-081: キャッシュヒット時の動作 | E-03 (L240-241) | ○ |
| C-82 | UT-GEO-082: 異なるresponseTypeで別エントリキャッシュ | E-03 (L238, L261-269) | ○ |
| C-83 | UT-GEO-083: get正常取得 | E-03 (L249-252) | ○ |
| C-84 | UT-GEO-084: get未キャッシュでnull | E-03 (L249-252) | ○ |
| C-85 | UT-GEO-085: CacheKey equals同一 | E-03 (L273-277) | ○ |
| C-86 | UT-GEO-086: CacheKey equals異なるIP | E-03 (L273-277) | ○ |
| C-87 | UT-GEO-087: CacheKey equals異なるresponseType | E-03 (L273-277) | ○ |
| C-88 | UT-GEO-088: CacheKey equalsのnull比較 | E-03 (L275) | ○ |
| C-89 | UT-GEO-089: CacheKey hashCode一貫性 | E-03 (L281-283) | ○ |
| C-90 | UT-GEO-090: CACHE_SIZEデフォルト値1000 | E-03 (L78) | ○ |
| C-91 | UT-GEO-091: CACHE_SIZE=0が受理される | E-03 (L78) | ○ |
| C-92 | UT-GEO-092: CACHE_SIZE負値でエラー | E-03 (L78) | ○ |
| C-93 | UT-GEO-093: AddressNotFoundRuntimeExceptionのcause設定 | E-01 (L493-498) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-53（UT-GEO-053）：タイプフラグが2以外のバイナリファイルを作成してテストする必要があるが、テスト用のmmdbバイナリ構造の詳細仕様が本ソースコード外にある（MaxMind DBフォーマット仕様）
  - 候補：MaxMind DB File Format Specification / テスト用mmdbファイルの手動作成
- C-54（UT-GEO-054）：InputStream.skip()が期待値より少ないバイト数を返すシナリオの再現方法は、モックまたはカスタムInputStreamの使用が必要
  - 候補：カスタムInputStream実装 / Mockitoによるモック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースはソースコードの分岐・条件に直接対応しており、テスト観点の網羅性は高い
- 1: 中リスク - UT-GEO-053, UT-GEO-054はテスト実装時にバイナリファイル構造やストリーム動作のモック設計が必要

## 6) レビュアーチェックリスト（最小）
- [ ] GeoIpProcessor.executeの全分岐（String/List/それ以外/ignoreMissing）がテストケースで網羅されているか確認
- [ ] retrieveCityGeoData/retrieveCountryGeoData/retrieveAsnGeoDataの各Propertyのnullチェック分岐が網羅されているか確認
- [ ] Property.parsePropertyのDB別有効プロパティセットの境界がテストされているか確認
- [ ] DatabaseReaderLazyLoader.getDatabaseTypeのバイナリパース処理の全エラーパスが網羅されているか確認
- [ ] GeoIpCacheのキャッシュヒット/ミス/CacheKeyのequals/hashCodeの一貫性が確認されているか
- [ ] filterForAllowlistSettingの全分岐（未設定/有効/空/不正値）が網羅されているか確認
- [ ] loadDatabaseReadersのassertDatabaseExistenceの双方向チェック（存在すべき/存在すべきでない）が網羅されているか確認
