---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 73
  claims_with_evidence: 71
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：modules-ingest-user-agent 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：71 / 73、根拠なし：2
- 優先レビュー（高）
  1. **C-47（キャッシュヒット検証）**：キャッシュヒット時に同一オブジェクト参照が返るかはCache実装依存で要確認
  2. **C-60（キャッシュサイズ設定反映）**：CACHE_SIZE_SETTINGの内部反映をテストする方法が間接的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/ingest-user-agent/src/main/java/org/opensearch/ingest/useragent/UserAgentProcessor.java` (行57-417)
- E-02: `modules/ingest-user-agent/src/main/java/org/opensearch/ingest/useragent/IngestUserAgentModulePlugin.java` (行57-158)
- E-03: `modules/ingest-user-agent/src/main/java/org/opensearch/ingest/useragent/UserAgentCache.java` (行41-78)
- E-04: `modules/ingest-user-agent/src/main/java/org/opensearch/ingest/useragent/UserAgentParser.java` (行50-323)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ECSモードでUA文字列を解析し各プロパティが出力される | E-01 (行107-171) | ○ |
| C-02 | 非ECSモードでUA文字列を解析しレガシー形式で出力される | E-01 (行172-237) | ○ |
| C-03 | ignoreMissing=trueでフィールド欠損時にドキュメントがそのまま返る | E-01 (行97-98) | ○ |
| C-04 | ignoreMissing=falseでフィールドnull時にIllegalArgumentException | E-01 (行99-101) | ○ |
| C-05 | ECSモードでNAMEプロパティのみ指定時にnameのみ出力 | E-01 (行109-119, プロパティループ構造) | ○ |
| C-06 | ECSモードVERSION出力でmajor.minor.patch.build形式 | E-01 (行122-135) | ○ |
| C-07 | VERSION指定時にmajorのみの場合major文字列のみ出力 | E-01 (行123-134, if分岐) | ○ |
| C-08 | VERSION指定時にmajorがnullならversionキー未出力 | E-01 (行123, if条件) | ○ |
| C-09 | ECSモードOS情報がMap(name, version, full)で出力 | E-01 (行137-158) | ○ |
| C-10 | ECSモードOS情報null時にosキー未出力 | E-01 (行138, if条件) | ○ |
| C-11 | ECSモードDEVICEプロパティでdevice.nameがMap出力 | E-01 (行161-168) | ○ |
| C-12 | ECSモードデバイスnull時にdevice.name="Other" | E-01 (行165-166) | ○ |
| C-13 | ECSモードORIGINALプロパティで元文字列出力 | E-01 (行111-112) | ○ |
| C-14 | ECSモードuserAgent名null時にname="Other" | E-01 (行115-118) | ○ |
| C-15 | 非ECSモードMAJOR/MINOR/PATCH/BUILD個別出力 | E-01 (行183-202) | ○ |
| C-16 | 非ECSモードOS_NAME/OS_MAJOR/OS_MINOR出力 | E-01 (行211-227) | ○ |
| C-17 | 非ECSモードOSプロパティでフルOS名文字列出力 | E-01 (行203-210, 244-272) | ○ |
| C-18 | buildFullOSNameで全バージョン付きOS名組み立て | E-01 (行244-272) | ○ |
| C-19 | buildFullOSNameでバージョンnull時にOS名のみ | E-01 (行251, if条件) | ○ |
| C-20 | buildFullOSNameでoperatingSystem null時にnull返却 | E-01 (行245-246) | ○ |
| C-21 | buildFullOSNameでname null時にnull返却 | E-01 (行245) | ○ |
| C-22 | getType()が"user_agent"を返す | E-01 (行61, 275-277) | ○ |
| C-23 | Factory.createで有効設定からProcessor生成 | E-01 (行308-360) | ○ |
| C-24 | Factory.createでproperties指定時に指定分のみセット | E-01 (行338-346) | ○ |
| C-25 | Factory.createでproperties省略時に全プロパティ | E-01 (行347-348) | ○ |
| C-26 | Factory.createで不在regex_file指定時に例外 | E-01 (行328-335) | ○ |
| C-27 | Factory.createで不正プロパティ名指定時に例外 | E-01 (行343-344) | ○ |
| C-28 | ignoreMissingデフォルトfalse | E-01 (行324) | ○ |
| C-29 | ecsデフォルトtrue | E-01 (行325) | ○ |
| C-30 | parsePropertyで小文字入力がenumに変換される | E-01 (行400-401) | ○ |
| C-31 | parsePropertyで大文字入力がenumに変換される | E-01 (行401) | ○ |
| C-32 | parsePropertyで不正名称時にIllegalArgumentException | E-01 (行407-414) | ○ |
| C-33 | 非推奨プロパティ指定時にdeprecation warning | E-01 (行402-404) | ○ |
| C-34 | UserAgentCacheコンストラクタでキャッシュ生成 | E-03 (行44-46) | ○ |
| C-35 | キャッシュサイズ0でインスタンス生成 | E-03 (行44-46), E-02 (行68, 0が下限) | ○ |
| C-36 | putしたエントリがgetで取得可能 | E-03 (行48-54) | ○ |
| C-37 | 存在しないキーでnull返却 | E-03 (行48-49, Cache.get仕様) | ○ |
| C-38 | 異なるパーサー名で別エントリ | E-03 (行56-76, CompositeCacheKeyのequals) | ○ |
| C-39 | CompositeCacheKey equals同一キーでtrue | E-03 (行66-69) | ○ |
| C-40 | CompositeCacheKey equals異なるキーでfalse | E-03 (行66-69) | ○ |
| C-41 | CompositeCacheKey equals型不一致でfalse | E-03 (行67, instanceof) | ○ |
| C-42 | CompositeCacheKey hashCode一貫性 | E-03 (行74-76) | ○ |
| C-43 | UserAgentParser有効YAMLでパーサー初期化 | E-04 (行58-67) | ○ |
| C-44 | 空YAMLでOpenSearchParseException | E-04 (行129-131) | ○ |
| C-45 | パーサー設定なしYAMLでOpenSearchParseException | E-04 (行129-131) | ○ |
| C-46 | 既知UA文字列の正しいパース結果 | E-04 (行196-210) | ○ |
| C-47 | 2回目呼び出しでキャッシュからDetails返却 | E-04 (行197-198) | △ |
| C-48 | 認識できないUA文字列でnullフィールドのDetails | E-04 (行200-204, findMatchがnull返却時) | ○ |
| C-49 | 空文字列UA処理 | E-04 (行196-210, Matcher挙動依存) | ○ |
| C-50 | regex_flag "i"でCASE_INSENSITIVEフラグ | E-04 (行134-141) | ○ |
| C-51 | regex_flag nullでフラグなし | E-04 (行139) | ○ |
| C-52 | getName()でコンストラクタ設定名返却 | E-04 (行56, 192-194) | ○ |
| C-53 | UserAgentSubpattern.matchでVersionedName返却 | E-04 (行276-321) | ○ |
| C-54 | nameReplacement $1でグループ置換 | E-04 (行287-288) | ○ |
| C-55 | nameReplacement $1なしで固定名使用 | E-04 (行289-290) | ○ |
| C-56 | v1-v4 Replacementでバージョン置換 | E-04 (行296-318) | ○ |
| C-57 | パターン不一致でnull返却 | E-04 (行280-281) | ○ |
| C-58 | nameがnullの場合にnull返却 | E-04 (行320) | ○ |
| C-59 | getProcessorsでuser_agentプロセッサ返却 | E-02 (行75-95) | ○ |
| C-60 | CACHE_SIZE_SETTING反映 | E-02 (行65-70, 84) | △ |
| C-61 | allowlist未設定で全プロセッサ返却 | E-02 (行98-99) | ○ |
| C-62 | allowlistにuser_agent含む場合のフィルタ | E-02 (行101-118) | ○ |
| C-63 | allowlistに不在プロセッサでIllegalArgumentException | E-02 (行103-114) | ○ |
| C-64 | 空allowlistで空Map返却 | E-02 (行115-118) | ○ |
| C-65 | createUserAgentParsersでデフォルトパーサー登録 | E-02 (行121-129) | ○ |
| C-66 | configディレクトリYMLファイルが追加パーサー登録 | E-02 (行131-149) | ○ |
| C-67 | configディレクトリ不在時にデフォルトのみ | E-02 (行131, if条件) | ○ |
| C-68 | 返却MapがunmodifiableであるcreateUserAgentParsers | E-02 (行151) | ○ |
| C-69 | getSettingsで2つのSetting返却 | E-02 (行155-157) | ○ |
| C-70 | readParserConfigurations不正配列構造で例外 | E-04 (行147-148) | ○ |
| C-71 | readParserConfigurations配列内非オブジェクトで例外 | E-04 (行152-153) | ○ |
| C-72 | Detailsコンストラクタで3フィールド保持 | E-04 (行225-234) | ○ |
| C-73 | VersionedNameコンストラクタで5フィールド保持 | E-04 (行237-251) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-47: キャッシュヒット時に「同一オブジェクト参照」が返るかはOpenSearchのCacheクラスの内部実装に依存。テスト時にはキャッシュのget呼び出し回数をモックで検証する方が適切な可能性がある。
  - 候補：`org.opensearch.common.cache.Cache` の実装仕様 / テストコード
- C-60: CACHE_SIZE_SETTINGの値がUserAgentCacheに正しく渡されるかは統合テスト寄りの検証。単体テストではSettingの読み取り部分のみ確認可能。
  - 候補：`IngestUserAgentModulePluginTests` / 統合テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストケースの大部分はソースコードの条件分岐・メソッド定義から直接導出されており、根拠が明確
- 1: 中リスク - キャッシュ動作の検証（C-47, C-60）はCache実装への依存があり、モック戦略の検討が必要
- 0: 低リスク - 非推奨プロパティのdeprecation warning検証（C-33）はDeprecationLoggerの動作確認方法に依存

## 6) レビュアーチェックリスト（最小）
- [ ] ECSモード/非ECSモードの全プロパティ分岐がテストケースで網羅されているか
- [ ] UserAgentProcessor.execute()のnull/ignoreMissingの組み合わせが十分か
- [ ] buildFullOSNameの各バージョン段階（major, minor, patch, build）の境界値が網羅されているか
- [ ] UserAgentSubpattern.matchの名前置換パターン（$1展開/固定名/null）が網羅されているか
- [ ] IngestUserAgentModulePlugin.filterForAllowlistSettingの各分岐（未設定/一致/不在/空）が網羅されているか
- [ ] UserAgentParser.readParserConfigurationsの不正YAML構造パターンが十分か
- [ ] CompositeCacheKeyのequals/hashCodeの契約（対称性・推移性・一貫性）が検証されているか
