---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：modules-lang-expression 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **C-028（ExpressionScoreScript inner execute 異常系）**：inner classの動作は実行時コンテキスト依存で根拠が間接的
  2. **C-029（ExpressionScoreScript inner setDocument 異常系）**：IO障害条件の設定はテスト環境依存で根拠が間接的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/lang-expression/src/main/java/org/opensearch/script/expression/ExpressionScriptEngine.java`
- E-02: `modules/lang-expression/src/main/java/org/opensearch/script/expression/ExpressionModulePlugin.java`
- E-03: `modules/lang-expression/src/main/java/org/opensearch/script/expression/ExpressionScoreScript.java`
- E-04: `modules/lang-expression/src/main/java/org/opensearch/script/expression/ExpressionAggregationScript.java`
- E-05: `modules/lang-expression/src/main/java/org/opensearch/script/expression/ExpressionFieldScript.java`
- E-06: `modules/lang-expression/src/main/java/org/opensearch/script/expression/ExpressionNumberSortScript.java`
- E-07: `modules/lang-expression/src/main/java/org/opensearch/script/expression/ExpressionTermSetQueryScript.java`
- E-08: `modules/lang-expression/src/main/java/org/opensearch/script/expression/FieldDataValueSource.java`
- E-09: `modules/lang-expression/src/main/java/org/opensearch/script/expression/FieldDataBasedDoubleValuesSource.java`
- E-10: `modules/lang-expression/src/main/java/org/opensearch/script/expression/NumericField.java`
- E-11: `modules/lang-expression/src/main/java/org/opensearch/script/expression/DateField.java`
- E-12: `modules/lang-expression/src/main/java/org/opensearch/script/expression/DateObject.java`
- E-13: `modules/lang-expression/src/main/java/org/opensearch/script/expression/GeoField.java`
- E-14: `modules/lang-expression/src/main/java/org/opensearch/script/expression/DateMethodValueSource.java`
- E-15: `modules/lang-expression/src/main/java/org/opensearch/script/expression/DateObjectValueSource.java`
- E-16: `modules/lang-expression/src/main/java/org/opensearch/script/expression/GeoLatitudeValueSource.java`
- E-17: `modules/lang-expression/src/main/java/org/opensearch/script/expression/GeoLongitudeValueSource.java`
- E-18: `modules/lang-expression/src/main/java/org/opensearch/script/expression/GeoEmptyValueSource.java`
- E-19: `modules/lang-expression/src/main/java/org/opensearch/script/expression/EmptyMemberValueSource.java`
- E-20: `modules/lang-expression/src/main/java/org/opensearch/script/expression/CountMethodValueSource.java`
- E-21: `modules/lang-expression/src/main/java/org/opensearch/script/expression/ReplaceableConstDoubleValues.java`
- E-22: `modules/lang-expression/src/main/java/org/opensearch/script/expression/PerThreadReplaceableConstDoubleValueSource.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | getTypeが"expression"を返す | E-01 (L80, L168-170) | ○ |
| C-002 | 有効な式がコンパイルされる | E-01 (L172-188) | ○ |
| C-003 | 不正な式でScriptExceptionに変換 | E-01 (L180-182) | ○ |
| C-004 | 未サポートContextでIllegalArgumentException | E-01 (L184-186) | ○ |
| C-005 | getSupportedContextsがContext一覧を返す | E-01 (L191-193) | ○ |
| C-006 | convertToScriptExceptionの変換ロジック | E-01 (L408-421) | ○ |
| C-007 | convertToScriptExceptionの非ParseExceptionケース | E-01 (L412-418) | ○ |
| C-008 | doc['field']形式の数値フィールド解決 | E-01 (L423-509) | ○ |
| C-009 | docで始まらない変数でParseException | E-01 (L425-427) | ○ |
| C-010 | フィールド名不足でParseException | E-01 (L428-430) | ○ |
| C-011 | 存在しないフィールドでParseException | E-01 (L469-471) | ○ |
| C-012 | 非対応フィールドタイプでParseException | E-01 (L506) | ○ |
| C-013 | GeoPointフィールドのlat変数解決 | E-01 (L475-481), E-13 | ○ |
| C-014 | DateフィールドのgetYear解決 | E-01 (L482-497), E-11 | ○ |
| C-015 | Date .date.yearアクセス解決 | E-01 (L483-489), E-12 | ○ |
| C-016 | 不正な変数フォーマットでIllegalArgumentException | E-01 (L459-463) | ○ |
| C-017 | 数値型パラメータのバインド | E-01 (L514-521) | ○ |
| C-018 | 非数値型パラメータでParseException | E-01 (L522-523) | ○ |
| C-019 | BucketAggregationScript正常実行 | E-01 (L195-240) | ○ |
| C-020 | BucketAggregation存在しない変数名 | E-01 (L207-215) | ○ |
| C-021 | BucketAggregation非Number型パラメータ | E-01 (L217-226) | ○ |
| C-022 | _score変数付きソートスクリプト | E-01 (L242-267) | ○ |
| C-023 | _value変数付き集計スクリプト | E-01 (L294-331) | ○ |
| C-024 | ExpressionModulePlugin.getScriptEngine | E-02 (L46-48) | ○ |
| C-025 | ExpressionScoreScript.needs_score true | E-03 (L56-65) | ○ |
| C-026 | ExpressionScoreScript.needs_score false | E-03 (L56-65) | ○ |
| C-027 | ExpressionScoreScript.newInstance正常生成 | E-03 (L68-101) | ○ |
| C-028 | ExpressionScoreScript inner execute異常系 | E-03 (L84-89) | △ |
| C-029 | ExpressionScoreScript inner setDocument異常系 | E-03 (L93-99) | △ |
| C-030 | ExpressionAggregationScript.needs_score | E-04 (L66-69) | ○ |
| C-031 | ExpressionAggregationScript.newInstance正常 | E-04 (L72-117) | ○ |
| C-032 | setNextAggregationValue Number型 | E-04 (L106-114) | ○ |
| C-033 | setNextAggregationValue specialValue null | E-04 (L108) | ○ |
| C-034 | setNextAggregationValue 非Number型 | E-04 (L111-113) | ○ |
| C-035 | ExpressionFieldScript.newInstance正常 | E-05 (L55-79) | ○ |
| C-036 | ExpressionFieldScript inner execute異常系 | E-05 (L62-67) | ○ |
| C-037 | ExpressionNumberSortScript.needs_score | E-06 (L100-103) | ○ |
| C-038 | ExpressionNumberSortScript.newInstance正常 | E-06 (L65-98) | ○ |
| C-039 | ExpressionNumberSortScript inner execute異常系 | E-06 (L81-86) | ○ |
| C-040 | ExpressionTermSetQueryScript.newInstance正常 | E-07 (L63-86) | ○ |
| C-041 | ExpressionTermSetQueryScript inner execute異常系 | E-07 (L69-75) | ○ |
| C-042 | NumericField.getVariable value | E-10 (L64-65) | ○ |
| C-043 | NumericField.getVariable empty | E-10 (L66-67) | ○ |
| C-044 | NumericField.getVariable length | E-10 (L68-69) | ○ |
| C-045 | NumericField.getVariable 不正変数名 | E-10 (L70-74) | ○ |
| C-046 | NumericField.getMethod getValue | E-10 (L79-80) | ○ |
| C-047 | NumericField.getMethod min | E-10 (L85-86) | ○ |
| C-048 | NumericField.getMethod max | E-10 (L87-88) | ○ |
| C-049 | NumericField.getMethod avg | E-10 (L89-90) | ○ |
| C-050 | NumericField.getMethod median | E-10 (L91-92) | ○ |
| C-051 | NumericField.getMethod sum | E-10 (L93-94) | ○ |
| C-052 | NumericField.getMethod count | E-10 (L95-96) | ○ |
| C-053 | NumericField.getMethod 不正メソッド名 | E-10 (L97-99) | ○ |
| C-054 | DateField.getVariable value | E-11 (L74-75) | ○ |
| C-055 | DateField.getVariable empty | E-11 (L76-77) | ○ |
| C-056 | DateField.getVariable 不正変数名 | E-11 (L80-81) | ○ |
| C-057 | DateField.getMethod getYear | E-11 (L105-106) | ○ |
| C-058 | DateField.getMethod getMonth | E-11 (L107-108) | ○ |
| C-059 | DateField.getMethod getDayOfMonth | E-11 (L109-110) | ○ |
| C-060 | DateField.getMethod 不正メソッド名 | E-11 (L117-118) | ○ |
| C-061 | DateObject.getVariable year | E-12 (L119-120) | ○ |
| C-062 | DateObject.getVariable dayOfMonth | E-12 (L91-92) | ○ |
| C-063 | DateObject.getVariable hourOfDay | E-12 (L99-100) | ○ |
| C-064 | DateObject.getVariable 不正変数名 | E-12 (L125-128) | ○ |
| C-065 | DateObject.getMethod getYear | E-12 (L164-165) | ○ |
| C-066 | DateObject.getMethod 不正メソッド名 | E-12 (L170-173) | ○ |
| C-067 | GeoField.getVariable lat | E-13 (L59-60) | ○ |
| C-068 | GeoField.getVariable lon | E-13 (L61-62) | ○ |
| C-069 | GeoField.getVariable empty | E-13 (L57-58) | ○ |
| C-070 | GeoField.getVariable 不正変数名 | E-13 (L63-64) | ○ |
| C-071 | GeoField.getMethod getLat | E-13 (L71-72) | ○ |
| C-072 | GeoField.getMethod getLon | E-13 (L73-74) | ○ |
| C-073 | GeoField.getMethod isEmpty | E-13 (L69-70) | ○ |
| C-074 | GeoField.getMethod 不正メソッド名 | E-13 (L75-77) | ○ |
| C-075 | FieldDataValueSource.equals 同一パラメータ true | E-08 (L59-67) | ○ |
| C-076 | FieldDataValueSource.equals 異なるMode false | E-08 (L59-67) | ○ |
| C-077 | FieldDataValueSource.equals null false | E-08 (L61) | ○ |
| C-078 | FieldDataValueSource.hashCode 一貫性 | E-08 (L70-75) | ○ |
| C-079 | FieldDataValueSource.toString形式 | E-08 (L95-97) | ○ |
| C-080 | FieldDataBasedDoubleValuesSource.needsScores false | E-09 (L51-54) | ○ |
| C-081 | FieldDataBasedDoubleValuesSource.rewrite this | E-09 (L56-59) | ○ |
| C-082 | FieldDataBasedDoubleValuesSource null NPE | E-09 (L46) | ○ |
| C-083 | ReplaceableConstDoubleValues初期値0.0 | E-21 (L42) | ○ |
| C-084 | ReplaceableConstDoubleValues setValue/doubleValue | E-21 (L44-51) | ○ |
| C-085 | ReplaceableConstDoubleValues advanceExact true | E-21 (L53-56) | ○ |
| C-086 | ReplaceableConstDoubleValues MAX_VALUE境界 | E-21 (L44-51) | ○ |
| C-087 | ReplaceableConstDoubleValues NaN境界 | E-21 (L44-51) | ○ |
| C-088 | PerThread同一スレッド同一オブジェクト | E-22 (L59-61) | ○ |
| C-089 | PerThread異なるスレッド異なるオブジェクト | E-22 (L52, L59-61) | ○ |
| C-090 | PerThread.needsScores false | E-22 (L63-66) | ○ |
| C-091 | PerThread.setValueのスレッド固有値設定 | E-22 (L88-94) | ○ |
| C-092 | PerThread.equals自身true | E-22 (L79-81) | ○ |
| C-093 | PerThread.equals異なるインスタンスfalse | E-22 (L79-81) | ○ |
| C-094 | PerThread.isCacheable false | E-22 (L101-104) | ○ |
| C-095 | PerThread.rewrite this | E-22 (L106-109) | ○ |
| C-096 | DateMethodValueSource.equals同一true | E-14 (L88-97) | ○ |
| C-097 | DateMethodValueSource.equals異なるcalendarType false | E-14 (L95) | ○ |
| C-098 | DateMethodValueSource.hashCode一貫性 | E-14 (L100-106) | ○ |
| C-099 | DateMethodValueSource null methodName NPE | E-14 (L57) | ○ |
| C-100 | DateMethodValueSource.toString形式 | E-14 (L83-85) | ○ |
| C-101 | DateObjectValueSource.equals同一true | E-15 (L94-100) | ○ |
| C-102 | DateObjectValueSource.equals異なるmethodName false | E-15 (L100) | ○ |
| C-103 | DateObjectValueSource.hashCode一貫性 | E-15 (L103-108) | ○ |
| C-104 | GeoLatitudeValueSource.equals同一true | E-16 (L75-81) | ○ |
| C-105 | GeoLatitudeValueSource.equals null false | E-16 (L77) | ○ |
| C-106 | GeoLatitudeValueSource.hashCode一貫性 | E-16 (L70-72) | ○ |
| C-107 | GeoLatitudeValueSource.toString形式 | E-16 (L84-86) | ○ |
| C-108 | GeoLongitudeValueSource.equals同一true | E-17 (L75-82) | ○ |
| C-109 | GeoLongitudeValueSource.toString形式 | E-17 (L84-87) | ○ |
| C-110 | GeoEmptyValueSource.equals同一true | E-18 (L75-81) | ○ |
| C-111 | GeoEmptyValueSource.equals null false | E-18 (L77) | ○ |
| C-112 | GeoEmptyValueSource.toString形式 | E-18 (L83-86) | ○ |
| C-113 | EmptyMemberValueSource.equals同一true | E-19 (L75-83) | ○ |
| C-114 | EmptyMemberValueSource.equals null false | E-19 (L77) | ○ |
| C-115 | EmptyMemberValueSource.toString形式 | E-19 (L85-88) | ○ |
| C-116 | CountMethodValueSource.equals同一true | E-20 (L70-75) | ○ |
| C-117 | CountMethodValueSource.equals異なるfieldData false | E-20 (L74) | ○ |
| C-118 | CountMethodValueSource.hashCode一貫性 | E-20 (L82-85) | ○ |
| C-119 | CountMethodValueSource.toString形式 | E-20 (L77-80) | ○ |
| C-120 | PerThread.toString SimpleName形式 | E-22 (L97-99) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-028, C-029：inner class内のexecute/setDocumentメソッドの異常系テストは、IOExceptionやその他の例外が発生する条件の再現がテスト環境に依存するため、具体的なモックの設定方法が根拠として不足している
  - 候補：既存テストコード / Lucene DoubleValuesのモック戦略 / テストフレームワークの使用方法

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードから直接読み取れるテストケースが大多数であり、ロジック解析の正確性は高い
- 1: 中リスク - inner classの異常系テスト（C-028, C-029）はモック環境の設計に依存する。レビュー時にテスト実装の実現可能性を確認する必要がある
- 0: 低リスク - フィールドタイプ別のgetVariable/getMethodのswitchロジックは網羅的に検証されている

## 6) レビュアーチェックリスト（最小）
- [ ] ExpressionScriptEngine.compileメソッドのテストケース（UT-EXP-002〜004）が主要なコンテキストを網羅しているか確認
- [ ] getDocValueSourceのフィールドタイプ別分岐（Geo/Date/Numeric）が全パス網羅されているか確認
- [ ] inner classの異常系テスト（UT-EXP-028, 029等）のモック戦略が実装可能か確認
- [ ] PerThreadReplaceableConstDoubleValueSourceのマルチスレッドテスト（UT-EXP-088, 089）の並行性テスト設計が適切か確認
- [ ] DateObject/DateFieldの全変数・全メソッドの網羅性を確認（特にDateObjectは18個の変数・18個のメソッドがあるが代表的なもののみ記載）
