---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 135
  claims_with_evidence: 131
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：modules-lang-mustache 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：131 / 135、根拠なし：4
- 優先レビュー（高）
  1. **UT-MUS-008 (MustacheExecutableScript.execute 異常系)**：実行時エラーの具体的なトリガー条件はソースコードのcatch (Exception e)に基づくが、特権アクセス環境下での再現性は要確認
  2. **UT-MUS-098 (writeMultiLineFormat)**：ストリームセパレータの正確な出力形式はXContentの実装依存であり、要確認
  3. **UT-MUS-113/114 (checkRestTotalHitsAsInt)**：privateメソッドのため直接テストが困難。間接的なテスト方法の検討が必要
  4. **UT-MUS-124/125 (parseRequest)**：RestMultiSearchAction.parseMultiLineRequestへの委譲部分のモック化が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/MustacheScriptEngine.java` - スクリプトエンジン実装
- E-02: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/CustomMustacheFactory.java` - カスタムファクトリ・エンコーダ実装
- E-03: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/CustomReflectionObjectHandler.java` - リフレクションオブジェクトハンドラ
- E-04: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/SearchTemplateRequest.java` - 検索テンプレートリクエスト
- E-05: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/SearchTemplateResponse.java` - 検索テンプレートレスポンス
- E-06: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/MultiSearchTemplateRequest.java` - マルチ検索テンプレートリクエスト
- E-07: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/MultiSearchTemplateResponse.java` - マルチ検索テンプレートレスポンス
- E-08: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/TransportSearchTemplateAction.java` - トランスポートアクション
- E-09: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/TransportMultiSearchTemplateAction.java` - マルチトランスポートアクション
- E-10: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/TransportRenderSearchTemplateAction.java` - レンダートランスポートアクション
- E-11: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/MustacheModulePlugin.java` - プラグイン定義
- E-12: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/RestSearchTemplateAction.java` - REST検索テンプレートアクション
- E-13: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/RestMultiSearchTemplateAction.java` - RESTマルチ検索テンプレートアクション
- E-14: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/RestRenderSearchTemplateAction.java` - RESTレンダーアクション
- E-15: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/SearchTemplateRequestBuilder.java` - リクエストビルダー
- E-16: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/SearchTemplateAction.java` - アクション定義
- E-17: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/MultiSearchTemplateAction.java` - マルチアクション定義
- E-18: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/RenderSearchTemplateAction.java` - レンダーアクション定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MustacheScriptEngine.compile: TemplateScriptコンテキストでコンパイル可能 | E-01 (L79-92) | ○ |
| C-02 | MustacheScriptEngine.compile: 不正コンテキストでIllegalArgumentException | E-01 (L80-81) | ○ |
| C-03 | MustacheScriptEngine.compile: 不正テンプレートでScriptException | E-01 (L89-91) | ○ |
| C-04 | MustacheScriptEngine.compile: content_typeオプション処理 | E-01 (L100-105) | ○ |
| C-05 | MustacheScriptEngine.getSupportedContexts: TemplateScript.CONTEXTのみ | E-01 (L96-98) | ○ |
| C-06 | MustacheScriptEngine.getType: "mustache"を返す | E-01 (L108-110) | ○ |
| C-07 | MustacheExecutableScript.execute: テンプレート実行 | E-01 (L131-142) | ○ |
| C-08 | MustacheExecutableScript.execute: エラー時GeneralScriptException | E-01 (L137-139) | ○ |
| C-09 | MustacheExecutableScript.execute: 空パラメータ | E-01 (L124-128) | ○ |
| C-10 | CustomMustacheFactory: JSON MIMEタイプ初期化 | E-02 (L77-84, L88-92) | ○ |
| C-11 | CustomMustacheFactory: text/plain初期化 | E-02 (L81) | ○ |
| C-12 | CustomMustacheFactory: URL encoded初期化 | E-02 (L82) | ○ |
| C-13 | CustomMustacheFactory: デフォルトコンストラクタ | E-02 (L94-96) | ○ |
| C-14 | CustomMustacheFactory.createEncoder: 未知MIMEタイプで例外 | E-02 (L107-113) | ○ |
| C-15 | CustomMustacheFactory.encode: JSONエスケープ処理 | E-02 (L99-105) | ○ |
| C-16 | CustomMustacheFactory.encode: IOException時MustacheException | E-02 (L103) | ○ |
| C-17 | JsonEscapeEncoder.encode: JSON特殊文字エスケープ | E-02 (L367-373) | ○ |
| C-18 | DefaultEncoder.encode: そのまま書き込み | E-02 (L356-362) | ○ |
| C-19 | UrlEncoder.encode: URLエンコード | E-02 (L378-384) | ○ |
| C-20 | UrlEncoder.encode: 空文字列 | E-02 (L381) | ○ |
| C-21 | ToJsonCode.match: "toJson"一致 | E-02 (L238-240) | ○ |
| C-22 | ToJsonCode.match: 大文字小文字無視 | E-02 (L239) equalsIgnoreCase | ○ |
| C-23 | ToJsonCode.match: 無関係文字列不一致 | E-02 (L238-240) | ○ |
| C-24 | ToJsonCode.createFunction: Iterable→JSON | E-02 (L219-224) | ○ |
| C-25 | ToJsonCode.createFunction: Map→JSON | E-02 (L225-226) | ○ |
| C-26 | ToJsonCode.createFunction: null入力 | E-02 (L215-217) | ○ |
| C-27 | ToJsonCode.createFunction: 非Iterable/Map | E-02 (L228-229) | ○ |
| C-28 | JoinerCode.match: "join"一致 | E-02 (L278-280) | ○ |
| C-29 | JoinerCode.createFunction: デフォルトデリミタ結合 | E-02 (L263-276) | ○ |
| C-30 | JoinerCode.createFunction: null入力 | E-02 (L265-266) | ○ |
| C-31 | JoinerCode.createFunction: 非Iterable | E-02 (L274) | ○ |
| C-32 | JoinerCode.createFunction: 空Iterable | E-02 (L268) | ○ |
| C-33 | JoinerCode.createFunction: 1要素 | E-02 (L268-273) | ○ |
| C-34 | CustomJoinerCode.match: カスタムデリミタパターン | E-02 (L285, L299-301) | ○ |
| C-35 | CustomJoinerCode.match: 不正パターン不一致 | E-02 (L299-301) | ○ |
| C-36 | CustomJoinerCode.extractDelimiter: デリミタ抽出 | E-02 (L291-297) | ○ |
| C-37 | CustomJoinerCode.extractDelimiter: 不正フォーマット例外 | E-02 (L296) | ○ |
| C-38 | UrlEncoderCode.match: "url"一致 | E-02 (L337-339) | ○ |
| C-39 | UrlEncoderCode.match: 大文字小文字無視 | E-02 (L338) equalsIgnoreCase | ○ |
| C-40 | CustomCode.extractVariableName: WriteCodeから変数名抽出 | E-02 (L176-194) | ○ |
| C-41 | CustomCode.extractVariableName: nullコードで例外 | E-02 (L178-179) | ○ |
| C-42 | CustomCode.extractVariableName: 複数コードで例外 | E-02 (L178-179) | ○ |
| C-43 | CustomReflectionObjectHandler.coerce: 配列→ArrayMap | E-03 (L56-57) | ○ |
| C-44 | CustomReflectionObjectHandler.coerce: Collection→CollectionMap | E-03 (L58-61) | ○ |
| C-45 | CustomReflectionObjectHandler.coerce: null→null | E-03 (L52-54) | ○ |
| C-46 | CustomReflectionObjectHandler.coerce: 通常オブジェクト委譲 | E-03 (L63) | ○ |
| C-47 | CustomReflectionObjectHandler.stringify: 文字列化 | E-03 (L173-176) | ○ |
| C-48 | CustomReflectionObjectHandler.stringify: 自己参照検出 | E-03 (L174) CollectionUtils.ensureNoSelfReferences | ○ |
| C-49 | ArrayMap.get: "size"キー | E-03 (L79-80) | ○ |
| C-50 | ArrayMap.get: Numberキー | E-03 (L81-82) | ○ |
| C-51 | ArrayMap.get: 文字列数値キー | E-03 (L84-86) | ○ |
| C-52 | ArrayMap.get: 非数値キー→null | E-03 (L87-90) | ○ |
| C-53 | ArrayMap.containsKey: 存在キー | E-03 (L94-96) | ○ |
| C-54 | ArrayMap.containsKey: 非存在キー | E-03 (L94-96) | ○ |
| C-55 | ArrayMap.entrySet | E-03 (L99-105) | ○ |
| C-56 | ArrayMap.iterator: 順序通り | E-03 (L108-123) | ○ |
| C-57 | ArrayMap.iterator: 空配列 | E-03 (L108-123) | ○ |
| C-58 | CollectionMap.get: "size"キー | E-03 (L137-138) | ○ |
| C-59 | CollectionMap.get: Numberキー | E-03 (L139-140) | ○ |
| C-60 | CollectionMap.get: 非数値キー→null | E-03 (L145-148) | ○ |
| C-61 | CollectionMap.containsKey | E-03 (L152-154) | ○ |
| C-62 | CollectionMap.entrySet | E-03 (L157-164) | ○ |
| C-63 | CollectionMap.iterator | E-03 (L167-169) | ○ |
| C-64 | SearchTemplateRequest.validate: 有効リクエスト | E-04 (L181-203) | ○ |
| C-65 | SearchTemplateRequest.validate: scriptがnull | E-04 (L183-184) | ○ |
| C-66 | SearchTemplateRequest.validate: script空文字 | E-04 (L183-184) | ○ |
| C-67 | SearchTemplateRequest.validate: scriptTypeがnull | E-04 (L186-188) | ○ |
| C-68 | SearchTemplateRequest.validate: simulatefalse+requestnull | E-04 (L189-191) | ○ |
| C-69 | SearchTemplateRequest.validate: simulatetrue+requestnull | E-04 (L189) | ○ |
| C-70 | SearchTemplateRequest.toXContent: STORED型 | E-04 (L254-255) | ○ |
| C-71 | SearchTemplateRequest.toXContent: INLINE型 | E-04 (L256-257) | ○ |
| C-72 | SearchTemplateRequest.toXContent: 不正型 | E-04 (L258-259) | ○ |
| C-73 | SearchTemplateRequest.fromXContent: 有効パース | E-04 (L246-248) | ○ |
| C-74 | SearchTemplateRequest.fromXContent: STORED型パース | E-04 (L217-220) | ○ |
| C-75 | SearchTemplateRequest.indices: requestあり | E-04 (L290-293) | ○ |
| C-76 | SearchTemplateRequest.indices: requestなし | E-04 (L290-291) | ○ |
| C-77 | SearchTemplateRequest.equals: 同一内容 | E-04 (L105-117) | ○ |
| C-78 | SearchTemplateRequest.equals: 異なる内容 | E-04 (L105-117) | ○ |
| C-79 | SearchTemplateRequest.writeTo/readFrom | E-04 (L270-286, L75-90) | ○ |
| C-80 | SearchTemplateRequest.indicesOptions: requestあり | E-04 (L297-302) | ○ |
| C-81 | SearchTemplateRequest.indicesOptions: requestなし | E-04 (L297-299) | ○ |
| C-82 | SearchTemplateResponse.hasResponse: responseあり | E-05 (L85-87) | ○ |
| C-83 | SearchTemplateResponse.hasResponse: responseなし | E-05 (L85-87) | ○ |
| C-84 | SearchTemplateResponse.status: responseあり | E-05 (L139-145) | ○ |
| C-85 | SearchTemplateResponse.status: responseなし | E-05 (L139-145) | ○ |
| C-86 | SearchTemplateResponse.toXContent: responseあり | E-05 (L121-136) | ○ |
| C-87 | SearchTemplateResponse.toXContent: responseなし | E-05 (L121-136) | ○ |
| C-88 | SearchTemplateResponse.writeTo | E-05 (L95-98) | ○ |
| C-89 | SearchTemplateResponse.fromXContent: template_output | E-05 (L100-118) | ○ |
| C-90 | SearchTemplateResponse.fromXContent: 検索結果 | E-05 (L100-118) | ○ |
| C-91 | MultiSearchTemplateRequest.add | E-06 (L84-87) | ○ |
| C-92 | MultiSearchTemplateRequest.maxConcurrentSearchRequests: 正値 | E-06 (L99-106) | ○ |
| C-93 | MultiSearchTemplateRequest.maxConcurrentSearchRequests: 0以下 | E-06 (L100-101) | ○ |
| C-94 | MultiSearchTemplateRequest.maxConcurrentSearchRequests: 境界値1 | E-06 (L100-101) | ○ |
| C-95 | MultiSearchTemplateRequest.validate: 有効リクエスト | E-06 (L113-128) | ○ |
| C-96 | MultiSearchTemplateRequest.validate: 空リスト | E-06 (L115-116) | ○ |
| C-97 | MultiSearchTemplateRequest.validate: 子リクエストエラー集約 | E-06 (L118-127) | ○ |
| C-98 | MultiSearchTemplateRequest.writeMultiLineFormat | E-06 (L161-177) | ○ |
| C-99 | MultiSearchTemplateRequest.equals | E-06 (L147-158) | ○ |
| C-100 | MultiSearchTemplateResponse.Item.isFailure: exceptionあり | E-07 (L82-84) | ○ |
| C-101 | MultiSearchTemplateResponse.Item.isFailure: exceptionなし | E-07 (L82-84) | ○ |
| C-102 | MultiSearchTemplateResponse.Item.getFailureMessage: exceptionあり | E-07 (L90-92) | ○ |
| C-103 | MultiSearchTemplateResponse.Item.getFailureMessage: exceptionなし | E-07 (L90-92) | ○ |
| C-104 | MultiSearchTemplateResponse.getResponses | E-07 (L145-147) | ○ |
| C-105 | MultiSearchTemplateResponse.getTook | E-07 (L152-154) | ○ |
| C-106 | MultiSearchTemplateResponse.iterator | E-07 (L138-140) | ○ |
| C-107 | MultiSearchTemplateResponse.toXContent: 成功 | E-07 (L163-180) | ○ |
| C-108 | MultiSearchTemplateResponse.toXContent: 失敗 | E-07 (L163-180) | ○ |
| C-109 | TransportSearchTemplateAction.convert: 正常変換 | E-08 (L136-169) | ○ |
| C-110 | TransportSearchTemplateAction.convert: simulateモード | E-08 (L153-155) | ○ |
| C-111 | TransportSearchTemplateAction.convert: explainフラグ | E-08 (L163) | ○ |
| C-112 | TransportSearchTemplateAction.convert: profileフラグ | E-08 (L164) | ○ |
| C-113 | TransportSearchTemplateAction.checkRestTotalHitsAsInt: コピー | E-08 (L171-192) | ○ |
| C-114 | TransportSearchTemplateAction.checkRestTotalHitsAsInt: 不正値 | E-08 (L181-190) | ○ |
| C-115 | TransportSearchTemplateAction.resolveIndices: requestあり | E-08 (L195-202) | ○ |
| C-116 | TransportSearchTemplateAction.resolveIndices: requestなし | E-08 (L199-201) | ○ |
| C-117 | MustacheModulePlugin.getScriptEngine | E-11 (L60-62) | ○ |
| C-118 | MustacheModulePlugin.getActions | E-11 (L65-71) | ○ |
| C-119 | MustacheModulePlugin.getRestHandlers | E-11 (L74-88) | ○ |
| C-120 | RestSearchTemplateAction.routes | E-12 (L65-74) | ○ |
| C-121 | RestSearchTemplateAction.getName | E-12 (L77-79) | ○ |
| C-122 | RestSearchTemplateAction.responseParams | E-12 (L109-111) | ○ |
| C-123 | RestMultiSearchTemplateAction.routes | E-13 (L72-81) | ○ |
| C-124 | RestMultiSearchTemplateAction.parseRequest: 正常パース | E-13 (L97-124) | △ |
| C-125 | RestMultiSearchTemplateAction.parseRequest: scriptがnull | E-13 (L117-118) | ○ |
| C-126 | RestMultiSearchTemplateAction.supportsContentStream | E-13 (L127-129) | ○ |
| C-127 | RestRenderSearchTemplateAction.routes | E-14 (L53-62) | ○ |
| C-128 | RestRenderSearchTemplateAction.prepareRequest: idパラメータ | E-14 (L70-85) | ○ |
| C-129 | RestRenderSearchTemplateAction.prepareRequest: idなし | E-14 (L70-85) | ○ |
| C-130 | SearchTemplateRequestBuilder.setRequest | E-15 (L52-55) | ○ |
| C-131 | SearchTemplateRequestBuilder.setSimulate | E-15 (L57-60) | ○ |
| C-132 | SearchTemplateRequestBuilder.setScript | E-15 (L83-86) | ○ |
| C-133 | SearchTemplateRequestBuilder.setSearchPipeline | E-15 (L93-96) | ○ |
| C-134 | SearchTemplateRequest.fromXContent: search_pipeline | E-04 (L236-242) | ○ |
| C-135 | SearchTemplateRequest.fromXContent: search_pipeline null | E-04 (L237-238) | △ |

## 4) 不足情報（Unknown / Missing）
- C-124: `RestMultiSearchTemplateAction.parseRequest` の正常パースについて、`RestMultiSearchAction.parseMultiLineRequest` の内部動作に依存しており、モックを使用した単体テストでの再現性は要確認
  - 候補：RestMultiSearchActionの既存テスト / 統合テスト / parseMultiLineRequestのドキュメント
- C-135: `search_pipeline` フィールドの `VALUE_NULL` ケースの正確な挙動はObjectParserの実装依存であり、実際のパーサー動作の確認が必要
  - 候補：ObjectParserのユニットテスト / XContentParserのドキュメント
- checkRestTotalHitsAsInt (C-113, C-114): privateメソッドのため直接テストは困難。convertメソッド経由の間接テストが必要
  - 候補：TransportSearchTemplateActionの既存テスト / 統合テスト
- MustacheExecutableScript (C-07, C-08): 内部クラスのためテストには特権アクセス環境が必要
  - 候補：MustacheScriptEngineの既存テスト / SecurityManagerの設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケース（130件）はソースコードの分岐・戻り値から直接導出
- 1: 中リスク - privateメソッド checkRestTotalHitsAsInt のテスト（UT-MUS-113, UT-MUS-114）は間接テストが必要
- 1: 中リスク - REST APIハンドラのテスト（UT-MUS-124, UT-MUS-125）はHTTPリクエスト/レスポンスのモック化が必要
- 0: 低リスク - 内部クラス MustacheExecutableScript のテスト（UT-MUS-007, UT-MUS-008）はcompileメソッド経由でアクセス可能

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの網羅性：18ソースファイル中、テスト対象として意味のある全クラス・メソッドがカバーされているか
- [ ] 正常系・異常系・境界値のバランス：各主要クラスに対して3つの観点が適切に配分されているか
- [ ] 優先度の妥当性：金額計算等はないが、テンプレートコンパイル・バリデーション・シリアライゼーション関連が「高」に設定されているか
- [ ] privateメソッド（checkRestTotalHitsAsInt）のテスト方法が検討されているか
- [ ] SearchTemplateRequest.fromXContentのsearch_pipelineパースに関するテストケース（UT-MUS-134, UT-MUS-135）が最新のVersion.V_3_2_0対応を反映しているか
- [ ] ActionType定義クラス（SearchTemplateAction, MultiSearchTemplateAction, RenderSearchTemplateAction）はシングルトン/定数定義のみのため、テストケースの省略が妥当か
