---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 154
  claims_with_evidence: 148
  claims_without_evidence: 6
confidence_derived: 0.96
---

# 根拠レポート：modules-lang-painless 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：148 / 154、根拠なし：6
- 優先レビュー（高）
  1. **PainlessScriptEngine.buildCompilerSettings**：privateメソッドのためテスト方法に要確認
  2. **PainlessScriptEngine.convertToScriptException**：privateメソッドの挙動をどう検証するか
  3. **Operation列挙値**：列挙値の具体的なシンボル対応はOperation.javaを未精読のため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/lang-painless/src/main/java/org/opensearch/painless/Utility.java` - charToString, StringTochar メソッド
- E-02: `modules/lang-painless/src/main/java/org/opensearch/painless/Location.java` - コンストラクタ, createError, computeSourceName メソッド
- E-03: `modules/lang-painless/src/main/java/org/opensearch/painless/CompilerSettings.java` - 全getter/setter, RegexEnabled enum, asMap メソッド
- E-04: `modules/lang-painless/src/main/java/org/opensearch/painless/AnalyzerCaster.java` - getLegalCast, constCast, promoteNumeric, promoteAdd, promoteXor, promoteEquality, promoteConditional
- E-05: `modules/lang-painless/src/main/java/org/opensearch/painless/Def.java` - defTo系変換メソッド, lookup系メソッド, listIndexNormalize, mapIndexNormalize
- E-06: `modules/lang-painless/src/main/java/org/opensearch/painless/DefMath.java` - lookupUnary, lookupBinary, lookupGeneric, dynamicCast, getNumber, cast
- E-07: `modules/lang-painless/src/main/java/org/opensearch/painless/api/LimitedCharSequence.java` - コンストラクタ, charAt, length, subSequence, snippet
- E-08: `modules/lang-painless/src/main/java/org/opensearch/painless/api/Json.java` - load, dump メソッド
- E-09: `modules/lang-painless/src/main/java/org/opensearch/painless/lookup/PainlessLookupUtility.java` - 型変換ユーティリティ全般
- E-10: `modules/lang-painless/src/main/java/org/opensearch/painless/symbol/FunctionTable.java` - LocalFunction, addFunction, getFunction, buildLocalFunctionKey
- E-11: `modules/lang-painless/src/main/java/org/opensearch/painless/PainlessScriptEngine.java` - getType, getSupportedContexts, buildCompilerSettings, compile
- E-12: `modules/lang-painless/src/main/java/org/opensearch/painless/Compiler.java` - createLoader, Loader内部クラス
- E-13: `modules/lang-painless/src/main/java/org/opensearch/painless/DefBootstrap.java` - bootstrap, PIC, MIC
- E-14: `modules/lang-painless/src/main/java/org/opensearch/painless/PainlessModulePlugin.java` - getSettings, getContexts
- E-15: `modules/lang-painless/src/main/java/org/opensearch/painless/FunctionRef.java` - create メソッド
- E-16: `modules/lang-painless/src/main/java/org/opensearch/painless/ScriptClassInfo.java` - コンストラクタ, MethodArgument
- E-17: `modules/lang-painless/src/main/java/org/opensearch/painless/PainlessExplainError.java` - getHeaders メソッド
- E-18: `modules/lang-painless/src/main/java/org/opensearch/painless/Operation.java` - 列挙型

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01~C-05 | Utility.charToString/StringTocharの正常系・異常系テストケース | E-01 | ○ |
| C-06~C-13 | Location.コンストラクタ/createError/computeSourceNameのテストケース | E-02 | ○ |
| C-14~C-24 | CompilerSettings.getter/setter/RegexEnabled.parseのテストケース | E-03 | ○ |
| C-25~C-42 | AnalyzerCaster.getLegalCast/constCast/promote系のテストケース | E-04 | ○ |
| C-43~C-78 | Def.defTo系変換/lookup系/indexNormalizeのテストケース | E-05 | ○ |
| C-79~C-91 | DefMath.lookupUnary/lookupBinary/dynamicCast/getNumberのテストケース | E-06 | ○ |
| C-92~C-100 | LimitedCharSequence全メソッドのテストケース | E-07 | ○ |
| C-101~C-107 | Json.load/dumpのテストケース | E-08 | ○ |
| C-108~C-127 | PainlessLookupUtility全ユーティリティメソッドのテストケース | E-09 | ○ |
| C-128~C-133 | FunctionTable/LocalFunctionのテストケース | E-10 | ○ |
| C-134~C-135 | PainlessScriptEngine.getType/getSupportedContexts | E-11 | ○ |
| C-136~C-139 | PainlessScriptEngine.buildCompilerSettingsのテストケース | E-11 | △ |
| C-140 | PainlessScriptEngine.convertToScriptExceptionのテストケース | E-11 | △ |
| C-141~C-142 | Compiler/Loaderのテストケース | E-12 | ○ |
| C-143~C-150 | DefBootstrap.bootstrap/PIC.checkClassのテストケース | E-13 | ○ |
| C-151~C-152 | PainlessModulePlugin.getSettings/getContextsのテストケース | E-14 | ○ |
| C-153 | Operation列挙値のテストケース | E-18 | △ |
| C-154 | PainlessExplainError.getHeadersのテストケース | E-17 | △ |

## 4) 不足情報（Unknown / Missing）
- PainlessScriptEngine.buildCompilerSettingsおよびconvertToScriptExceptionはprivateメソッドであり、直接のユニットテストが困難な場合がある。リフレクション経由またはcompileメソッド経由での間接テストが必要となる可能性がある。
  - 候補：PainlessScriptEngineTests / 統合テスト経由での検証
- Operation.javaの列挙値は未精読のため、具体的なシンボル値の確認が必要。
  - 候補：Operation.java を精読して列挙値を確認
- PainlessExplainError.getHeadersの具体的な戻り値構造はPainlessExplainError.javaの精読が必要。
  - 候補：PainlessExplainError.java を精読
- antlrパッケージ（Walker, EnhancedPainlessLexer等）およびirパッケージ（各IRNode実装）、phaseパッケージ（各Phase実装）は自動生成コードまたはVisitorパターンのツリー走査であり、個別の単体テストケースとしては抽出対象から除外した。これらは統合テスト（コンパイル全体フロー）でカバーされる想定。
  - 候補：既存のPainlessテストスイート / 統合テストで網羅

## 5) リスクフラグ（レビュー観点）
- 0: AnalyzerCaster, Def, DefMath, Utility, Location - ソースコードを精読し、全条件分岐を確認済み
- 0: PainlessLookupUtility, FunctionTable - ユーティリティメソッドの入出力を確認済み
- 0: LimitedCharSequence, Json - API公開メソッドを確認済み
- 1: PainlessScriptEngine - privateメソッドのテスト方法に注意。間接テストが必要な場合がある
- 1: DefBootstrap - 内部クラスPIC/MICの挙動はinvokedynamic経由で呼ばれるため、単体テストでの検証が困難な場合がある
- 0: CompilerSettings, PainlessModulePlugin - 公開APIが明確でテスト容易

## 6) レビュアーチェックリスト（最小）
- [ ] AnalyzerCaster.getLegalCastの全型変換パスが網羅されているか（boolean, byte, short, char, int, long, float, double, ボックス型、def型）
- [ ] Def.defTo系変換メソッドの暗黙変換と明示変換の境界が正しく検証されているか
- [ ] DefMathの各演算子（not, neg, plus, mul, div, rem, add, sub, and, or, xor, lsh, rsh, ush, eq, lt, lte, gt, gte）に対するテストが十分か（現在はlookup系メソッド経由のテストのみ）
- [ ] LimitedCharSequenceのCircuitBreakingException発生条件が正しいか
- [ ] PainlessScriptEngine.buildCompilerSettingsのprivateアクセスに対するテスト方法が適切か
- [ ] antlr/ir/phaseパッケージのコードが統合テストで十分にカバーされる想定が妥当か
- [ ] FunctionRef.createメソッドの各分岐（this参照、new参照、メソッド参照）に対するテストケースの追加を検討すべきか
