---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 165
  claims_with_evidence: 162
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：modules-mapper-extras 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：162 / 165、根拠なし：3
- 優先レビュー（高）
  1. **C-082 (UT-MPE-082)**：hasDocValues=falseでindexed=trueの場合のfieldNamesField生成条件。createFieldNamesFieldメソッドの呼び出し条件はコードから読み取れるが、実際のフィールド生成の挙動は基底クラスに依存
  2. **C-098, C-101 (UT-MPE-098, UT-MPE-101)**：phraseQuery/multiPhraseQueryのshingleField委譲テスト。shingleFieldForPositionsメソッドのロジックはコードから確認可能だが、実際のTokenStreamの状態に依存する部分がある
  3. **C-128 (UT-MPE-128)**：enablePositionIncrements=falseの場合のカウント動作。ストップワード付きアナライザの挙動は外部依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/mapper-extras/src/main/java/org/opensearch/index/mapper/MapperExtrasModulePlugin.java`
- E-02: `modules/mapper-extras/src/main/java/org/opensearch/index/mapper/RankFeatureFieldMapper.java`
- E-03: `modules/mapper-extras/src/main/java/org/opensearch/index/mapper/RankFeatureMetaFieldMapper.java`
- E-04: `modules/mapper-extras/src/main/java/org/opensearch/index/mapper/RankFeaturesFieldMapper.java`
- E-05: `modules/mapper-extras/src/main/java/org/opensearch/index/mapper/ScaledFloatFieldMapper.java`
- E-06: `modules/mapper-extras/src/main/java/org/opensearch/index/mapper/SearchAsYouTypeFieldMapper.java`
- E-07: `modules/mapper-extras/src/main/java/org/opensearch/index/mapper/TokenCountFieldMapper.java`
- E-08: `modules/mapper-extras/src/main/java/org/opensearch/index/query/RankFeatureQueryBuilder.java`
- E-09: `modules/mapper-extras/src/main/java/org/opensearch/index/query/RankFeatureQueryBuilders.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | MapperExtrasModulePlugin.getMappersが5つのマッパーを返す | E-01 (L49-57) | ○ |
| C-002 | getMappersの戻り値がunmodifiableMap | E-01 (L56) | ○ |
| C-003 | getMetadataMappersが_featureを返す | E-01 (L61) | ○ |
| C-004 | getQueriesがrank_featureクエリを返す | E-01 (L65-68) | ○ |
| C-005 | RankFeatureFieldMapper.Builderのデフォルトbuild | E-02 (L75-103) | ○ |
| C-006 | positiveScoreImpact=falseでのbuild | E-02 (L77-81) | ○ |
| C-007 | RankFeatureFieldType.typeNameが"rank_feature" | E-02 (L119-121) | ○ |
| C-008 | positiveScoreImpact=trueの取得 | E-02 (L123-125) | ○ |
| C-009 | positiveScoreImpact=falseの取得 | E-02 (L123-125) | ○ |
| C-010 | existsQueryがTermQuery返却 | E-02 (L128-130) | ○ |
| C-011 | fielddataBuilderがIllegalArgumentException | E-02 (L133-135) | ○ |
| C-012 | valueFetcher format=null正常 | E-02 (L138-148) | ○ |
| C-013 | valueFetcher format指定で例外 | E-02 (L139-141) | ○ |
| C-014 | termQueryがIllegalArgumentException | E-02 (L151-153) | ○ |
| C-015 | parseCreateField正の数値インデックス | E-02 (L180-203) | ○ |
| C-016 | positiveScoreImpact=falseで値反転 | E-02 (L198-199) | ○ |
| C-017 | VALUE_NULLスキップ | E-02 (L185-187) | ○ |
| C-018 | 同一フィールド複数値で例外 | E-02 (L192-196) | ○ |
| C-019 | externalValueのNumber変換 | E-02 (L182-184, L205-211) | ○ |
| C-020 | externalValueのString変換 | E-02 (L205-211) | ○ |
| C-021 | getMergeBuilder | E-02 (L219-221) | ○ |
| C-022 | RankFeatureMetaFieldType.typeName | E-03 (L63-65) | ○ |
| C-023 | valueFetcherがUnsupportedOperationException | E-03 (L68-70) | ○ |
| C-024 | existsQueryがUnsupportedOperationException | E-03 (L73-75) | ○ |
| C-025 | termQueryがUnsupportedOperationException | E-03 (L78-80) | ○ |
| C-026 | INSTANCEシングルトン | E-03 (L56-59) | ○ |
| C-027 | RankFeaturesFieldMapper.Builderのデフォルトbuild | E-04 (L61-91) | ○ |
| C-028 | RankFeaturesFieldType.typeName | E-04 (L106-108) | ○ |
| C-029 | positiveScoreImpactアクセサ | E-04 (L110-112) | ○ |
| C-030 | existsQueryがIllegalArgumentException | E-04 (L115-117) | ○ |
| C-031 | fielddataBuilderがIllegalArgumentException | E-04 (L120-122) | ○ |
| C-032 | termQueryがIllegalArgumentException | E-04 (L130-132) | ○ |
| C-033 | valueFetcherがSourceValueFetcher.identity | E-04 (L125-127) | ○ |
| C-034 | parseでJSONオブジェクトのフィーチャーマップ解析 | E-04 (L165-205) | ○ |
| C-035 | positiveScoreImpact=falseで値反転 | E-04 (L193-195) | ○ |
| C-036 | VALUE_NULLフィーチャースキップ | E-04 (L180-181) | ○ |
| C-037 | multi-fieldsで例外 | E-04 (L166-168) | ○ |
| C-038 | START_OBJECT以外で例外 | E-04 (L170-174) | ○ |
| C-039 | 重複フィーチャーで例外 | E-04 (L185-191) | ○ |
| C-040 | 不正トークンで例外 | E-04 (L197-203) | ○ |
| C-041 | ScaledFloatFieldMapper.Builderの正常build | E-05 (L91-184) | ○ |
| C-042 | scalingFactor=nullで例外 | E-05 (L107-109) | ○ |
| C-043 | scalingFactor=0で例外 | E-05 (L110-112) | ○ |
| C-044 | scalingFactor負数で例外 | E-05 (L110-112) | ○ |
| C-045 | scalingFactor=Infinityで例外 | E-05 (L110-112) | ○ |
| C-046 | scalingFactor=NaNで例外 | E-05 (L110-112) | ○ |
| C-047 | ScaledFloatFieldType.typeName | E-05 (L252-254) | ○ |
| C-048 | getScalingFactor | E-05 (L247-249) | ○ |
| C-049 | termQueryスケーリング | E-05 (L257-265) | ○ |
| C-050 | termQuery非インデックスで例外 | E-05 (L258) | ○ |
| C-051 | termsQueryスケーリング | E-05 (L268-285) | ○ |
| C-052 | rangeQueryスケーリング | E-05 (L288-312) | ○ |
| C-053 | rangeQuery lowerTerm=null | E-05 (L291-293) | ○ |
| C-054 | rangeQuery upperTerm=null | E-05 (L294-296) | ○ |
| C-055 | fielddataBuilder正常 | E-05 (L315-324) | ○ |
| C-056 | fielddataBuilder docValuesなしで例外 | E-05 (L316) | ○ |
| C-057 | valueFetcher format=null正常 | E-05 (L327-348) | ○ |
| C-058 | valueFetcher format指定で例外 | E-05 (L328-330) | ○ |
| C-059 | valueFetcher空文字列+nullValue | E-05 (L335-340) | ○ |
| C-060 | valueFetcher空文字列+nullValue未設定 | E-05 (L336-338) | ○ |
| C-061 | valueForDisplay long→double | E-05 (L351-356) | ○ |
| C-062 | valueForDisplay null | E-05 (L352-354) | ○ |
| C-063 | docValueFormat RAW | E-05 (L359-370) | ○ |
| C-064 | docValueFormat Decimal | E-05 (L367-369) | ○ |
| C-065 | docValueFormat timeZoneで例外 | E-05 (L360-364) | ○ |
| C-066 | encodePoint(Number)通常値 | E-05 (L216-228) | ○ |
| C-067 | encodePoint POSITIVE_INFINITY | E-05 (L220-221) | ○ |
| C-068 | encodePoint NEGATIVE_INFINITY | E-05 (L222-223) | ○ |
| C-069 | encodePoint(Object, boolean) roundUp | E-05 (L231-245) | ○ |
| C-070 | encodePoint(Object, boolean) roundDown | E-05 (L231-245) | ○ |
| C-071 | encodePoint roundUp Long.MAX_VALUE | E-05 (L233-235) | ○ |
| C-072 | encodePoint roundDown Long.MIN_VALUE | E-05 (L237-239) | ○ |
| C-073 | toDoubleValue | E-05 (L387-390) | ○ |
| C-074 | parseCreateField正常インデックス | E-05 (L454-514) | ○ |
| C-075 | parseCreateField nullValue代替 | E-05 (L461-462, L478-479) | ○ |
| C-076 | parseCreateField null値スキップ | E-05 (L461-462, L482-484) | ○ |
| C-077 | parseCreateField coerce空文字列 | E-05 (L463-464) | ○ |
| C-078 | parseCreateField ignoreMalformed=falseで例外 | E-05 (L466-474) | ○ |
| C-079 | parseCreateField ignoreMalformed=trueスキップ | E-05 (L469-470) | ○ |
| C-080 | parseCreateField NaN例外 | E-05 (L491-497) | ○ |
| C-081 | parseCreateField Infinity ignoreMalformed | E-05 (L491-494) | ○ |
| C-082 | parseCreateField fieldNamesField生成条件 | E-05 (L511-513) | △ |
| C-083 | parse(Object) Number変換 | E-05 (L527-538) | ○ |
| C-084 | parse(Object) BytesRef変換 | E-05 (L532-533) | ○ |
| C-085 | parse(Object) String変換 | E-05 (L534-535) | ○ |
| C-086 | getSupportedDataCubeDimensionType | E-05 (L176-178) | ○ |
| C-087 | isDataCubeMetricSupported | E-05 (L181-183) | ○ |
| C-088 | SearchAsYouTypeFieldMapper.Builder正常build | E-06 (L119-277) | ○ |
| C-089 | maxShingleSize=2 | E-06 (L133-151) | ○ |
| C-090 | maxShingleSize=4 | E-06 (L133-151) | ○ |
| C-091 | maxShingleSize=1で例外 | E-06 (L139-151) | ○ |
| C-092 | maxShingleSize=5で例外 | E-06 (L139-151) | ○ |
| C-093 | docValues=trueで例外 | E-06 (L127-131) | ○ |
| C-094 | SearchAsYouTypeFieldType.typeName | E-06 (L331-333) | ○ |
| C-095 | prefixQuery委譲 | E-06 (L346-359) | ○ |
| C-096 | prefixQuery prefixField=nullフォールバック | E-06 (L347-348) | ○ |
| C-097 | prefixQuery長さ範囲外フォールバック | E-06 (L347) | ○ |
| C-098 | phraseQuery shingleField委譲 | E-06 (L362-370) | △ |
| C-099 | phraseQuery slop>0フォールバック | E-06 (L364) | ○ |
| C-100 | phraseQuery トークン数1以下 | E-06 (L364) | ○ |
| C-101 | multiPhraseQuery shingleField委譲 | E-06 (L373-381) | △ |
| C-102 | phrasePrefixQuery shingleField委譲 | E-06 (L384-392) | ○ |
| C-103 | spanPrefixQuery FieldMaskingSpanQuery | E-06 (L395-397) | ○ |
| C-104 | spanPrefixQuery SpanMultiTermQueryWrapper | E-06 (L398-404) | ○ |
| C-105 | PrefixFieldType.termLengthWithinBounds正常 | E-06 (L425-427) | ○ |
| C-106 | termLengthWithinBounds下限境界 | E-06 (L425-427) | ○ |
| C-107 | termLengthWithinBounds上限境界 | E-06 (L425-427) | ○ |
| C-108 | termLengthWithinBounds上限超過 | E-06 (L425-427) | ○ |
| C-109 | PrefixFieldType.prefixQuery termQuery | E-06 (L430-447) | ○ |
| C-110 | PrefixFieldType.prefixQuery caseInsensitive | E-06 (L432-434) | ○ |
| C-111 | PrefixFieldType.prefixQuery AutomatonQuery | E-06 (L437-446) | ○ |
| C-112 | PrefixFieldType.existsQuery例外 | E-06 (L467-469) | ○ |
| C-113 | parseCreateFieldルート+サブフィールド | E-06 (L652-666) | ○ |
| C-114 | parseCreateField null値スキップ | E-06 (L654-656) | ○ |
| C-115 | getShingleFieldName 2gram | E-06 (L678-679) | ○ |
| C-116 | getShingleFieldName 3gram | E-06 (L678-679) | ○ |
| C-117 | iteratorサブフィールド含有 | E-06 (L700-707) | ○ |
| C-118 | withShingle | E-06 (L728-730) | ○ |
| C-119 | withShingleAndPrefix | E-06 (L732-734) | ○ |
| C-120 | ShingleFieldType.prefixQuery委譲 | E-06 (L568-581) | ○ |
| C-121 | ShingleFieldType.prefixQueryフォールバック | E-06 (L569) | ○ |
| C-122 | ShingleFieldType.phrasePrefixQuery slop=0 | E-06 (L593-603) | ○ |
| C-123 | ShingleFieldType.phrasePrefixQuery slop>0 | E-06 (L595) | ○ |
| C-124 | TokenCountFieldMapper.Builder正常build | E-07 (L61-116) | ○ |
| C-125 | TokenCountFieldMapper.Builder analyzer=null例外 | E-07 (L102-103) | ○ |
| C-126 | countPositions正常カウント | E-07 (L203-221) | ○ |
| C-127 | countPositions空文字列 | E-07 (L203-221) | ○ |
| C-128 | countPositions enablePositionIncrements=false | E-07 (L209-213) | ○ |
| C-129 | countPositions単一トークン | E-07 (L203-221) | ○ |
| C-130 | parseCreateFieldトークンカウント | E-07 (L169-192) | ○ |
| C-131 | parseCreateField nullValue代替 | E-07 (L177-183) | ○ |
| C-132 | parseCreateField null値スキップ | E-07 (L177-179) | ○ |
| C-133 | analyzerアクセサ | E-07 (L227-229) | ○ |
| C-134 | enablePositionIncrementsアクセサ | E-07 (L235-237) | ○ |
| C-135 | TokenCountFieldType.valueFetcher docValuesあり | E-07 (L133-138) | ○ |
| C-136 | TokenCountFieldType.valueFetcher docValuesなし | E-07 (L134-135) | ○ |
| C-137 | RankFeatureQueryBuilderコンストラクタ正常 | E-08 (L372-375) | ○ |
| C-138 | RankFeatureQueryBuilder field=null例外 | E-08 (L373) | ○ |
| C-139 | RankFeatureQueryBuilder scoreFunction=null例外 | E-08 (L374) | ○ |
| C-140 | getWriteableName | E-08 (L384-386) | ○ |
| C-141 | doToQuery RankFeatureFieldType | E-08 (L404-427) | ○ |
| C-142 | doToQuery RankFeaturesFieldType子フィールド | E-08 (L408-414) | ○ |
| C-143 | doToQuery未マッピングフィールド | E-08 (L416) | ○ |
| C-144 | doToQuery不正フィールドタイプ例外 | E-08 (L419-425) | ○ |
| C-145 | doEquals一致 | E-08 (L430-432) | ○ |
| C-146 | doEquals不一致 | E-08 (L430-432) | ○ |
| C-147 | doHashCode | E-08 (L435-437) | ○ |
| C-148 | Log.toQuery positiveScoreImpact=true | E-08 (L123-131) | ○ |
| C-149 | Log.toQuery positiveScoreImpact=false例外 | E-08 (L124-128) | ○ |
| C-150 | Log.equals | E-08 (L96-102) | ○ |
| C-151 | Saturation.toQuery pivot有り | E-08 (L198-204) | ○ |
| C-152 | Saturation.toQuery pivot=null | E-08 (L199-201) | ○ |
| C-153 | Saturation.equals | E-08 (L169-175) | ○ |
| C-154 | Sigmoid.toQuery | E-08 (L264-266) | ○ |
| C-155 | Sigmoid.equals | E-08 (L237-243) | ○ |
| C-156 | Linear.toQuery | E-08 (L308-310) | ○ |
| C-157 | Linear.equals | E-08 (L284-289) | ○ |
| C-158 | readScoreFunction不正ID | E-08 (L314-328) | ○ |
| C-159 | PARSERデフォルトSaturation | E-08 (L330-347) | ○ |
| C-160 | PARSER複数scoreFunction例外 | E-08 (L337) | ○ |
| C-161 | RankFeatureQueryBuilders.saturation(String, float) | E-09 (L44-46) | ○ |
| C-162 | RankFeatureQueryBuilders.saturation(String) | E-09 (L54-56) | ○ |
| C-163 | RankFeatureQueryBuilders.log | E-09 (L64-66) | ○ |
| C-164 | RankFeatureQueryBuilders.sigmoid | E-09 (L76-78) | ○ |
| C-165 | RankFeatureQueryBuilders.linear | E-09 (L85-87) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-082: `createFieldNamesField`メソッドの実装は基底クラス`FieldMapper`に存在するため、モジュール内のソースコードだけでは完全な挙動確認ができない
  - 候補: `server/src/main/java/org/opensearch/index/mapper/FieldMapper.java`
- C-098, C-101: `phraseQuery`/`multiPhraseQuery`のテストでは、実際のTokenStreamの状態（ギャップ有無等）が外部ファクターに依存する。`countPosition`メソッドと`hasGaps`メソッドの組み合わせに対する詳細テスト設計が必要
  - 候補: `TextFieldMapper.TextFieldType.hasGaps` / `CachingTokenFilter`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - MapperExtrasModulePlugin, RankFeatureMetaFieldMapper, RankFeatureQueryBuilders: シンプルな登録・ファクトリクラスで、ロジックが限定的
- 0: 低リスク - RankFeatureFieldMapper, RankFeaturesFieldMapper: フィールドマッパーとして標準的なパターンに従い、例外処理もコードから明確に読み取れる
- 1: 中リスク - ScaledFloatFieldMapper: 浮動小数点の精度問題（scalingFactor乗算後のroundによる精度損失）が存在し、テストケースの期待値設計に注意が必要
- 1: 中リスク - SearchAsYouTypeFieldMapper: サブフィールド構造が複雑で、shingleサイズによるクエリ委譲ロジックの正確性検証が重要
- 0: 低リスク - TokenCountFieldMapper: アナライザ依存のトークンカウントロジックはシンプルだが、外部アナライザの挙動に依存
- 0: 低リスク - RankFeatureQueryBuilder: スコア関数の各バリアントは明確に定義されており、条件分岐も限定的

## 6) レビュアーチェックリスト（最小）
- [ ] ScaledFloatFieldMapperのscalingFactor乗算における浮動小数点精度のテスト期待値が適切か確認
- [ ] SearchAsYouTypeFieldMapperのshingleFieldForPositionsメソッドの境界値テストが網羅されているか確認
- [ ] RankFeatureQueryBuilder.doToQueryのRankFeaturesFieldTypeサブフィールド解析（ドット区切り）の境界ケースが十分か確認
- [ ] TokenCountFieldMapperのcountPositionsメソッドにおけるenablePositionIncrements=false時の挙動が正しくテストされるか確認
- [ ] 各マッパーのparseCreateFieldメソッドにおけるexternalValueSet/nullValue/ignoreMalformedの組み合わせが網羅されているか確認
