---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：modules-opensearch-dashboards 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **C-24（null delegateのコンストラクタ動作）**：BaseRestHandler.Wrapperの親クラスのnullハンドリングが未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/opensearch-dashboards/src/main/java/org/opensearch/dashboards/OpenSearchDashboardsModulePlugin.java` - メインソースコード（181行）
- E-02: `modules/opensearch-dashboards/src/main/java/org/opensearch/dashboards/OpenSearchDashboardsModulePlugin.java:81-94` - OPENSEARCH_DASHBOARDS_INDEX_NAMES_SETTING定数定義
- E-03: `modules/opensearch-dashboards/src/main/java/org/opensearch/dashboards/OpenSearchDashboardsModulePlugin.java:96-104` - getSystemIndexDescriptorsメソッド
- E-04: `modules/opensearch-dashboards/src/main/java/org/opensearch/dashboards/OpenSearchDashboardsModulePlugin.java:106-149` - getRestHandlersメソッド
- E-05: `modules/opensearch-dashboards/src/main/java/org/opensearch/dashboards/OpenSearchDashboardsModulePlugin.java:151-154` - getSettingsメソッド
- E-06: `modules/opensearch-dashboards/src/main/java/org/opensearch/dashboards/OpenSearchDashboardsModulePlugin.java:156-180` - OpenSearchDashboardsWrappedRestHandler内部クラス

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト設定で5件のSystemIndexDescriptorが返却される | E-02, E-03 | ○ |
| C-02 | カスタム設定でシステムインデックス記述子がカスタマイズ可能 | E-02, E-03 | ○ |
| C-03 | SystemIndexDescriptorの説明文が"System index used by OpenSearch Dashboards" | E-03 (L101) | ○ |
| C-04 | 空リスト設定で空Collectionが返却される | E-02, E-03 | ○ |
| C-05 | 1件のみの設定で1件のDescriptorが返却される | E-02, E-03 | ○ |
| C-06 | 返却されるCollectionがunmodifiable | E-03 (L98: unmodifiableList) | ○ |
| C-07 | RESTハンドラが19件返却される | E-04 (L118-145: 19個のnew文) | ○ |
| C-08 | getRestHandlersの返却リストがunmodifiable | E-04 (L117: unmodifiableList) | ○ |
| C-09 | 全ハンドラがOpenSearchDashboardsWrappedRestHandler型 | E-04 (全エントリがnew OpenSearchDashboardsWrappedRestHandler) | ○ |
| C-10 | getSettingsが1件のSettingを返却 | E-05 (L153: singletonList) | ○ |
| C-11 | 返却リストサイズが1 | E-05 (L153: singletonList) | ○ |
| C-12 | 設定キーが"opensearch_dashboards.system_indices" | E-02 (L82) | ○ |
| C-13 | デフォルト値が5件のインデックスパターン | E-02 (L83-90) | ○ |
| C-14 | SettingのプロパティがNodeScope | E-02 (L93: Property.NodeScope) | ○ |
| C-15 | getName()に"opensearch_dashboards_"プレフィックスが付与される | E-06 (L164) | ○ |
| C-16 | 異なるdelegateでも正しいプレフィックス付き名前 | E-06 (L164) | ○ |
| C-17 | allowSystemIndexAccessByDefaultがtrueを返す | E-06 (L169: return true) | ○ |
| C-18 | routes()パスに/_opensearch_dashboardsプレフィックスが付与 | E-06 (L176) | ○ |
| C-19 | 複数ルートに全てプレフィックスが付与される | E-06 (L174-178: stream().map()) | ○ |
| C-20 | HTTPメソッドが保持される | E-06 (L176: route.getMethod()を使用) | ○ |
| C-21 | routes()の返却リストがunmodifiable | E-06 (L174: unmodifiableList) | ○ |
| C-22 | delegateのルートが空の場合に空リストが返却される | E-06 (L174-178: stream処理) | ○ |
| C-23 | delegateが正しく設定されること | E-06 (L158-159: super(delegate)) | ○ |
| C-24 | null delegateでNullPointerExceptionがスローされる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24: BaseRestHandler.Wrapperのコンストラクタでのnullチェック動作は、親クラスの実装に依存しており、本モジュール内のソースコードからは確認不可
  - 候補：`server/src/main/java/org/opensearch/rest/BaseRestHandler.java` / OpenSearchのテストコード / JavaDoc

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本モジュールは1ファイルのみで構成されており、全メソッドがソースコードから直接確認可能
- 1: 中リスク - getRestHandlersの返却数19件はソースコードのnew文をカウントして導出（将来の変更時に更新漏れの可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] getRestHandlersで返却されるハンドラ19件が実際のコードと一致しているか確認
- [ ] OPENSEARCH_DASHBOARDS_INDEX_NAMES_SETTINGのデフォルト値5件のパターンが正確か確認
- [ ] BaseRestHandler.Wrapperのnullハンドリング動作を親クラスの実装で確認
- [ ] OpenSearchDashboardsWrappedRestHandlerのroutes()でパスプレフィックスが正しく"/_opensearch_dashboards"であるか確認
