---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 161
  claims_with_evidence: 161
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：modules-parent-join 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：161 / 161、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースがソースコードに基づいて生成されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/parent-join/src/main/java/org/opensearch/join/mapper/ParentJoinFieldMapper.java` - joinフィールドマッパー本体（getMapper, checkIndexCompatibility, checkObjectOrNested, checkParentFields, hasParent, hasChild, getParentIdFieldMapper, mergeOptions, parse, parseCreateField, TypeParser, JoinFieldType）
- E-02: `modules/parent-join/src/main/java/org/opensearch/join/mapper/ParentIdFieldMapper.java` - 親IDフィールドマッパー（getParentName, getChildren, getParentFilter, getChildFilter, getChildrenFilter, parseCreateField, ParentIdFieldType）
- E-03: `modules/parent-join/src/main/java/org/opensearch/join/mapper/MetaJoinFieldMapper.java` - メタjoinフィールドマッパー（MetaJoinFieldType, getJoinField, existsQuery, parseCreateField, valueFetcher）
- E-04: `modules/parent-join/src/main/java/org/opensearch/join/query/HasChildQueryBuilder.java` - has_childクエリビルダー（コンストラクタ, minMaxChildren, ignoreUnmapped, doToQuery, fromXContent, doEquals, doRewrite, extractInnerHitBuilders, LateParsingQuery）
- E-05: `modules/parent-join/src/main/java/org/opensearch/join/query/HasParentQueryBuilder.java` - has_parentクエリビルダー（コンストラクタ, doToQuery, fromXContent, doEquals, doRewrite, extractInnerHitBuilders）
- E-06: `modules/parent-join/src/main/java/org/opensearch/join/query/ParentIdQueryBuilder.java` - parent_idクエリビルダー（コンストラクタ, ignoreUnmapped, doToQuery, fromXContent, doEquals）
- E-07: `modules/parent-join/src/main/java/org/opensearch/join/query/JoinQueryBuilders.java` - クエリビルダーファクトリ（hasChildQuery, hasParentQuery, parentId）
- E-08: `modules/parent-join/src/main/java/org/opensearch/join/query/ParentChildInnerHitContextBuilder.java` - innerHitコンテキストビルダー（doBuild, JoinFieldInnerHitSubContext.topDocs, getSortedDocValue）
- E-09: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/ChildrenAggregationBuilder.java` - childrenアグリゲーションビルダー（コンストラクタ, bucketCardinality, resolveConfig, parse, equals）
- E-10: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/ParentAggregationBuilder.java` - parentアグリゲーションビルダー（コンストラクタ, resolveConfig, parse, equals）
- E-11: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/ParentJoinAggregator.java` - 親結合アグリゲータ基底クラス（コンストラクタ, getLeafCollector, DenseCollectionStrategy, SparseCollectionStrategy）
- E-12: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/ChildrenAggregatorFactory.java` - childrenアグリゲータファクトリ（createUnmapped, doCreateInternal, supportsConcurrentSegmentSearch）
- E-13: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/ParentAggregatorFactory.java` - parentアグリゲータファクトリ（createUnmapped, doCreateInternal, supportsConcurrentSegmentSearch）
- E-14: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/ParentToChildrenAggregator.java` - 親から子へのアグリゲータ（buildEmptyAggregation）
- E-15: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/ChildrenToParentAggregator.java` - 子から親へのアグリゲータ（buildEmptyAggregation）
- E-16: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/InternalChildren.java` - 内部childrenアグリゲーション結果（getWriteableName, newAggregation）
- E-17: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/InternalParent.java` - 内部parentアグリゲーション結果（getWriteableName, newAggregation）
- E-18: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/JoinAggregationInspectionHelper.java` - アグリゲーション検査ヘルパー（hasValue）
- E-19: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/JoinAggregationBuilders.java` - アグリゲーションビルダーファクトリ（children, parent）
- E-20: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/ParsedChildren.java` - パース済みchildrenアグリゲーション（getType, fromXContent）
- E-21: `modules/parent-join/src/main/java/org/opensearch/join/aggregations/ParsedParent.java` - パース済みparentアグリゲーション（getType, fromXContent）
- E-22: `modules/parent-join/src/main/java/org/opensearch/join/ParentJoinModulePlugin.java` - プラグイン本体（getQueries, getAggregations, getMappers）
- E-23: `modules/parent-join/src/main/java/org/opensearch/join/spi/ParentJoinNamedXContentProvider.java` - XContentプロバイダ（getNamedXContentParsers）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ParentJoinFieldMapper.getMapper - joinフィールドが存在する場合にMapperが返却される | E-01 (L101-112) | ○ |
| C-02 | ParentJoinFieldMapper.getMapper - joinフィールドが存在しない場合にnullが返却される | E-01 (L105-107) | ○ |
| C-03 | checkIndexCompatibility - パーティション化インデックスでIllegalStateException | E-01 (L118-124) | ○ |
| C-04 | checkObjectOrNested - ネストパスでIllegalArgumentException | E-01 (L126-132) | ○ |
| C-05 | checkParentFields - 重複なしで正常終了 | E-01 (L134-147) | ○ |
| C-06 | checkParentFields - 重複子でIllegalArgumentException | E-01 (L134-147) | ○ |
| C-07 | hasParent - 登録済み親名でtrue | E-01 (L305-307) | ○ |
| C-08 | hasParent - 未登録親名でfalse | E-01 (L305-307) | ○ |
| C-09 | hasChild - 登録済み子名でtrue | E-01 (L312-314) | ○ |
| C-10 | hasChild - 未登録子名でfalse | E-01 (L312-314) | ○ |
| C-11 | getParentIdFieldMapper - isParent=trueで親名マッチ | E-01 (L320-329) | ○ |
| C-12 | getParentIdFieldMapper - isParent=falseで子名マッチ | E-01 (L320-329) | ○ |
| C-13 | getParentIdFieldMapper - 存在しない名前でnull | E-01 (L320-329) | ○ |
| C-14 | mergeOptions - 新しい子の追加マージ | E-01 (L332-367) | ○ |
| C-15 | mergeOptions - 親削除のコンフリクト | E-01 (L336-338) | ○ |
| C-16 | mergeOptions - 子削除のコンフリクト | E-01 (L355-358) | ○ |
| C-17 | mergeOptions - 子から親への変換防止 | E-01 (L343-346) | ○ |
| C-18 | parse - VALUE_STRINGトークンで親ドキュメント | E-01 (L401-403) | ○ |
| C-19 | parse - START_OBJECTトークンで子ドキュメント | E-01 (L380-400) | ○ |
| C-20 | parse - 不明join名でIllegalArgumentException | E-01 (L410-412) | ○ |
| C-21 | parse - 子ドキュメントでparent未指定 | E-01 (L415-417) | ○ |
| C-22 | parse - 子ドキュメントでrouting未指定 | E-01 (L418-420) | ○ |
| C-23 | parse - 不正トークンでIllegalStateException | E-01 (L405-406) | ○ |
| C-24 | parseCreateField - UnsupportedOperationException | E-01 (L370-372) | ○ |
| C-25 | TypeParser.parse - relations定義のパース | E-01 (L192-227) | ○ |
| C-26 | TypeParser.parse - eager_global_ordinalsオプション | E-01 (L204-206) | ○ |
| C-27 | TypeParser.parse - 単一子のパース | E-01 (L215-219) | ○ |
| C-28 | JoinFieldType.valueForDisplay - BytesRef変換 | E-01 (L252-258) | ○ |
| C-29 | JoinFieldType.valueForDisplay - null処理 | E-01 (L253-254) | ○ |
| C-30 | JoinFieldType.typeName - "join"返却 | E-01 (L237-238) | ○ |
| C-31 | ParentIdFieldMapper.getParentName | E-02 (L172-174) | ○ |
| C-32 | ParentIdFieldMapper.getChildren | E-02 (L183-185) | ○ |
| C-33 | ParentIdFieldMapper.getParentFilter | E-02 (L176-178) | ○ |
| C-34 | ParentIdFieldMapper.getChildFilter | E-02 (L187-189) | ○ |
| C-35 | ParentIdFieldMapper.getChildrenFilter - 複数子 | E-02 (L191-197) | ○ |
| C-36 | ParentIdFieldMapper.getChildrenFilter - 単一子 | E-02 (L191-197) | ○ |
| C-37 | ParentIdFieldMapper.parseCreateField - 正常系 | E-02 (L200-209) | ○ |
| C-38 | ParentIdFieldMapper.parseCreateField - 外部値未設定 | E-02 (L201-203) | ○ |
| C-39 | ParentIdFieldType.valueForDisplay - BytesRef変換 | E-02 (L140-146) | ○ |
| C-40 | ParentIdFieldType.valueForDisplay - null処理 | E-02 (L141-142) | ○ |
| C-41 | ParentIdFieldType.valueFetcher - UnsupportedOperationException | E-02 (L135-137) | ○ |
| C-42 | MetaJoinFieldMapper.fieldType | E-03 (L141-143) | ○ |
| C-43 | MetaJoinFieldType.getJoinField | E-03 (L126-128) | ○ |
| C-44 | MetaJoinFieldType.existsQuery | E-03 (L131-133) | ○ |
| C-45 | MetaJoinFieldMapper.parseCreateField | E-03 (L154-156) | ○ |
| C-46 | MetaJoinFieldType.valueFetcher | E-03 (L113-115) | ○ |
| C-47 | HasChildQueryBuilder - 正常コンストラクタ | E-04 (L113-131) | ○ |
| C-48 | HasChildQueryBuilder - type=null | E-04 (L125) | ○ |
| C-49 | HasChildQueryBuilder - query=null | E-04 (L126) | ○ |
| C-50 | minMaxChildren - 正常設定 | E-04 (L162-178) | ○ |
| C-51 | minMaxChildren - 負のminChildren | E-04 (L163-165) | ○ |
| C-52 | minMaxChildren - 負のmaxChildren | E-04 (L169-171) | ○ |
| C-53 | minMaxChildren - max<min | E-04 (L172-174) | ○ |
| C-54 | minMaxChildren - min=0 deprecation | E-04 (L166-168) | ○ |
| C-55 | ignoreUnmapped設定 | E-04 (L235-241) | ○ |
| C-56 | ignoreUnmapped+innerHitBuilder連動 | E-04 (L237-239) | ○ |
| C-57 | doToQuery - 正常系LateParsingQuery | E-04 (L329-372) | ○ |
| C-58 | doToQuery - allowExpensiveQueries=false | E-04 (L330-334) | ○ |
| C-59 | doToQuery - joinフィールド未定義+ignoreUnmapped=false | E-04 (L337-342) | ○ |
| C-60 | doToQuery - joinフィールド未定義+ignoreUnmapped=true | E-04 (L338-340) | ○ |
| C-61 | doToQuery - childタイプ未定義+ignoreUnmapped=false | E-04 (L362-370) | ○ |
| C-62 | fromXContent - 正常パース | E-04 (L269-321) | ○ |
| C-63 | fromXContent - 未知フィールド | E-04 (L290,308) | ○ |
| C-64 | doEquals - 等価 | E-04 (L503-511) | ○ |
| C-65 | doEquals - 非等価 | E-04 (L503-511) | ○ |
| C-66 | doRewrite - クエリ変更あり | E-04 (L519-534) | ○ |
| C-67 | doRewrite - クエリ変更なし | E-04 (L519-534) | ○ |
| C-68 | extractInnerHitBuilders - 追加 | E-04 (L537-555) | ○ |
| C-69 | extractInnerHitBuilders - 重複 | E-04 (L540-541) | ○ |
| C-70 | LateParsingQuery.equals - 等価 | E-04 (L458-469) | ○ |
| C-71 | LateParsingQuery.equals - 非等価 | E-04 (L458-469) | ○ |
| C-72 | LateParsingQuery.hashCode | E-04 (L472-474) | ○ |
| C-73 | LateParsingQuery.toString | E-04 (L477-479) | ○ |
| C-74 | HasParentQueryBuilder - 正常コンストラクタ | E-05 (L89-98) | ○ |
| C-75 | HasParentQueryBuilder - type=null | E-05 (L94) | ○ |
| C-76 | HasParentQueryBuilder - query=null | E-05 (L95) | ○ |
| C-77 | doToQuery - 正常系LateParsingQuery | E-05 (L178-221) | ○ |
| C-78 | doToQuery - allowExpensiveQueries=false | E-05 (L179-183) | ○ |
| C-79 | doToQuery - joinフィールド未定義+ignoreUnmapped=false | E-05 (L186-192) | ○ |
| C-80 | doToQuery - joinフィールド未定義+ignoreUnmapped=true | E-05 (L187-189) | ○ |
| C-81 | doToQuery - parentタイプ未定義+ignoreUnmapped=false | E-05 (L211-219) | ○ |
| C-82 | doToQuery - score=trueでScoreMode.Max | E-05 (L207) | ○ |
| C-83 | doToQuery - score=falseでScoreMode.None | E-05 (L207) | ○ |
| C-84 | fromXContent - 正常パース | E-05 (L238-283) | ○ |
| C-85 | fromXContent - 未知フィールド | E-05 (L258,272) | ○ |
| C-86 | doEquals - 等価 | E-05 (L291-297) | ○ |
| C-87 | doRewrite - クエリ変更あり | E-05 (L305-313) | ○ |
| C-88 | extractInnerHitBuilders - 追加 | E-05 (L316-334) | ○ |
| C-89 | extractInnerHitBuilders - 重複 | E-05 (L319-320) | ○ |
| C-90 | ParentIdQueryBuilder - 正常コンストラクタ | E-06 (L74-77) | ○ |
| C-91 | ignoreUnmapped設定 | E-06 (L109-112) | ○ |
| C-92 | doToQuery - 正常系BooleanQuery | E-06 (L170-198) | ○ |
| C-93 | doToQuery - allowExpensiveQueries=false | E-06 (L171-175) | ○ |
| C-94 | doToQuery - joinフィールド未定義+ignoreUnmapped=false | E-06 (L178-185) | ○ |
| C-95 | doToQuery - joinフィールド未定義+ignoreUnmapped=true | E-06 (L179-181) | ○ |
| C-96 | doToQuery - childタイプ未定義+ignoreUnmapped=false | E-06 (L187-193) | ○ |
| C-97 | fromXContent - 正常パース | E-06 (L133-167) | ○ |
| C-98 | fromXContent - 未知フィールド | E-06 (L156,159) | ○ |
| C-99 | doEquals - 等価 | E-06 (L201-203) | ○ |
| C-100 | JoinQueryBuilders.hasChildQuery | E-07 (L47-49) | ○ |
| C-101 | JoinQueryBuilders.hasParentQuery | E-07 (L59-61) | ○ |
| C-102 | JoinQueryBuilders.parentId | E-07 (L67-69) | ○ |
| C-103 | ChildrenAggregationBuilder - 正常コンストラクタ | E-09 (L73-79) | ○ |
| C-104 | ChildrenAggregationBuilder - childType=null | E-09 (L75-77) | ○ |
| C-105 | bucketCardinality - ONE | E-09 (L112-114) | ○ |
| C-106 | resolveConfig - 正常系 | E-09 (L136-158) | ○ |
| C-107 | resolveConfig - joinフィールド未定義 | E-09 (L140-144) | ○ |
| C-108 | resolveConfig - childタイプ未定義 | E-09 (L147-151) | ○ |
| C-109 | parse - 正常パース | E-09 (L166-196) | ○ |
| C-110 | parse - type未指定 | E-09 (L188-193) | ○ |
| C-111 | parse - 未知キー | E-09 (L177-181) | ○ |
| C-112 | equals - 等価 | E-09 (L199-210) | ○ |
| C-113 | equals - 非等価 | E-09 (L199-210) | ○ |
| C-114 | ParentAggregationBuilder - 正常コンストラクタ | E-10 (L73-79) | ○ |
| C-115 | ParentAggregationBuilder - childType=null | E-10 (L75-77) | ○ |
| C-116 | resolveConfig - 正常系 | E-10 (L136-150) | ○ |
| C-117 | resolveConfig - childタイプ未定義 | E-10 (L145-148) | ○ |
| C-118 | parse - 正常パース | E-10 (L158-188) | ○ |
| C-119 | parse - type未指定 | E-10 (L180-185) | ○ |
| C-120 | equals - 等価 | E-10 (L191-203) | ○ |
| C-121 | ParentJoinAggregator - maxOrd超過 | E-11 (L95-99) | ○ |
| C-122 | コンストラクタ - DenseCollectionStrategy選択 | E-11 (L105-108) | ○ |
| C-123 | コンストラクタ - SparseCollectionStrategy選択 | E-11 (L105-108) | ○ |
| C-124 | getLeafCollector - valuesSource=null | E-11 (L112-115) | ○ |
| C-125 | DenseCollectionStrategy.add/exists | E-11 (L206-229) | ○ |
| C-126 | DenseCollectionStrategy.exists - 未設定 | E-11 (L219-222) | ○ |
| C-127 | SparseCollectionStrategy.add/exists | E-11 (L237-258) | ○ |
| C-128 | SparseCollectionStrategy.exists - 未設定 | E-11 (L249-252) | ○ |
| C-129 | ChildrenAggregatorFactory.createUnmapped | E-12 (L77-84) | ○ |
| C-130 | ChildrenAggregatorFactory.doCreateInternal - 正常系 | E-12 (L87-113) | ○ |
| C-131 | ChildrenAggregatorFactory.doCreateInternal - 不正ValuesSource | E-12 (L95-99) | ○ |
| C-132 | ChildrenAggregatorFactory.supportsConcurrentSegmentSearch | E-12 (L122-124) | ○ |
| C-133 | ParentAggregatorFactory.createUnmapped | E-13 (L77-84) | ○ |
| C-134 | ParentAggregatorFactory.doCreateInternal - 正常系 | E-13 (L87-113) | ○ |
| C-135 | ParentAggregatorFactory.doCreateInternal - 不正ValuesSource | E-13 (L95-99) | ○ |
| C-136 | ParentAggregatorFactory.supportsConcurrentSegmentSearch | E-13 (L122-125) | ○ |
| C-137 | ParentToChildrenAggregator.buildEmptyAggregation | E-14 (L79-81) | ○ |
| C-138 | ChildrenToParentAggregator.buildEmptyAggregation | E-15 (L83-84) | ○ |
| C-139 | InternalChildren.getWriteableName | E-16 (L58-60) | ○ |
| C-140 | InternalChildren.newAggregation | E-16 (L63-65) | ○ |
| C-141 | InternalParent.getWriteableName | E-17 (L58-60) | ○ |
| C-142 | InternalParent.newAggregation | E-17 (L63-65) | ○ |
| C-143 | JoinAggregationInspectionHelper.hasValue(InternalParent) - true | E-18 (L40-42) | ○ |
| C-144 | JoinAggregationInspectionHelper.hasValue(InternalParent) - false | E-18 (L40-42) | ○ |
| C-145 | JoinAggregationInspectionHelper.hasValue(InternalChildren) - true | E-18 (L44-46) | ○ |
| C-146 | JoinAggregationInspectionHelper.hasValue(InternalChildren) - false | E-18 (L44-46) | ○ |
| C-147 | JoinAggregationBuilders.children | E-19 (L39-41) | ○ |
| C-148 | JoinAggregationBuilders.parent | E-19 (L46-48) | ○ |
| C-149 | ParsedChildren.getType | E-20 (L42-44) | ○ |
| C-150 | ParsedParent.getType | E-21 (L42-44) | ○ |
| C-151 | ParentJoinModulePlugin.getQueries | E-22 (L58-64) | ○ |
| C-152 | ParentJoinModulePlugin.getAggregations | E-22 (L67-74) | ○ |
| C-153 | ParentJoinModulePlugin.getMappers | E-22 (L77-79) | ○ |
| C-154 | ParentJoinNamedXContentProvider.getNamedXContentParsers | E-23 (L51-60) | ○ |
| C-155 | ParentChildInnerHitContextBuilder.doBuild - 正常系 | E-08 (L88-107) | ○ |
| C-156 | ParentChildInnerHitContextBuilder.doBuild - joinFieldMapper=null | E-08 (L102-106) | ○ |
| C-157 | JoinFieldInnerHitSubContext.topDocs - fetchChildInnerHits=true | E-08 (L128-191) | ○ |
| C-158 | JoinFieldInnerHitSubContext.topDocs - fetchChildInnerHits=false | E-08 (L128-191) | ○ |
| C-159 | JoinFieldInnerHitSubContext.topDocs - joinName=null | E-08 (L131-133) | ○ |
| C-160 | JoinFieldInnerHitSubContext.topDocs - parentIdFieldMapper=null | E-08 (L137-139) | ○ |
| C-161 | JoinFieldInnerHitSubContext.topDocs - size=0 | E-08 (L159-167) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全テストケースはソースコードの実装から直接導出されている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに明確な根拠を持つ
- 0: 低リスク - テスト観点（正常系/異常系/境界値）が網羅的にカバーされている
- 1: 中リスク - ParentJoinAggregator.beforeBuildingBucketsやJoinFieldInnerHitSubContext.topDocsなど、結合テストに近い複雑なメソッドは、モックの構築が困難な場合がある

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースNo.1-2: ParentJoinFieldMapper.getMapperのnull/非nullパスが正確にテストされているか
- [ ] テストケースNo.14-17: mergeOptionsのコンフリクト検出が全パターン網羅されているか
- [ ] テストケースNo.18-24: parse()の各トークンパターンとエラーケースが適切か
- [ ] テストケースNo.47-73: HasChildQueryBuilderの各メソッドのテスト観点が十分か
- [ ] テストケースNo.121-128: ParentJoinAggregatorのコレクション戦略選択とadd/existsの動作が正確にテストされているか
- [ ] テストケースNo.155-161: innerHitの各分岐パスが網羅されているか
