---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 153
  claims_with_evidence: 148
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：modules-percolator 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：148 / 153、根拠なし：5
- 優先レビュー（高）
  1. **UT-PRC-047 (doToQuery正常系)**: 統合的な動作のため実行環境依存の検証が必要
  2. **UT-PRC-074 (parse正常系)**: QueryShardContextの複雑な依存関係のため動作確認が必要
  3. **UT-PRC-096 (HighlightSubFetchPhase getProcessor正常系)**: ハイライト処理の統合的な動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/percolator/src/main/java/org/opensearch/percolator/BinaryRange.java`（89行）
- E-02: `modules/percolator/src/main/java/org/opensearch/percolator/PercolateQuery.java`（331行）
- E-03: `modules/percolator/src/main/java/org/opensearch/percolator/PercolateQueryBuilder.java`（679行）
- E-04: `modules/percolator/src/main/java/org/opensearch/percolator/PercolatorFieldMapper.java`（578行）
- E-05: `modules/percolator/src/main/java/org/opensearch/percolator/PercolatorHighlightSubFetchPhase.java`（168行）
- E-06: `modules/percolator/src/main/java/org/opensearch/percolator/PercolatorMatchedSlotSubFetchPhase.java`（175行）
- E-07: `modules/percolator/src/main/java/org/opensearch/percolator/PercolatorModulePlugin.java`（71行）
- E-08: `modules/percolator/src/main/java/org/opensearch/percolator/QueryAnalyzer.java`（716行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BinaryRangeコンストラクタが正しい長さのencodedRangeでオブジェクトを生成する | E-01 (L60-66) | ○ |
| C-02 | BinaryRangeコンストラクタが不正な長さでIllegalArgumentExceptionをスローする | E-01 (L62-63) | ○ |
| C-03 | newIntersectsQueryがINTERSECTSタイプのRangeFieldQueryを返却する | E-01 (L75-77) | ○ |
| C-04 | newRelationQueryが指定Relationタイプでクエリを生成する | E-01 (L79-86) | ○ |
| C-05 | PercolateQueryコンストラクタが全パラメータでオブジェクトを生成する | E-02 (L72-88) | ○ |
| C-06 | PercolateQueryコンストラクタがdocuments=nullでNPEをスローする | E-02 (L82) Objects.requireNonNull | ○ |
| C-07 | PercolateQueryコンストラクタがcandidateMatchesQuery=nullでNPEをスローする | E-02 (L83) Objects.requireNonNull | ○ |
| C-08 | rewriteがcandidateMatchesQuery変更時に新PercolateQueryを返却する | E-02 (L91-106) | ○ |
| C-09 | rewriteがcandidateMatchesQuery未変更時にthisを返却する | E-02 (L103-105) | ○ |
| C-10 | createWeightがスコア不要モードでWeightを生成する | E-02 (L109-213) | ○ |
| C-11 | createWeightがスコア必要モードでWeightを生成する | E-02 (L144-174) | ○ |
| C-12 | getNameが設定した名前を返却する | E-02 (L216-218) | ○ |
| C-13 | excludesNestedDocsがnonNestedDocsFilter!=nullでtrueを返却する | E-02 (L224-226) | ○ |
| C-14 | excludesNestedDocsがnonNestedDocsFilter=nullでfalseを返却する | E-02 (L224-226) | ○ |
| C-15 | getDocumentsが設定したdocumentsリストを返却する | E-02 (L228-230) | ○ |
| C-16 | equalsが同一インスタンスでtrueを返却する | E-02 (L254-256) | ○ |
| C-17 | equalsが異なるインスタンスでfalseを返却する | E-02 (L254-256) | ○ |
| C-18 | hashCodeがidentityHashCodeに基づく | E-02 (L260-262) | ○ |
| C-19 | toStringがPercolateQuery形式の文字列を返却する | E-02 (L265-272) | ○ |
| C-20 | ramBytesUsedが全ドキュメントの合計を返却する | E-02 (L275-281) | ○ |
| C-21 | ramBytesUsedが空documentsで0を返却する | E-02 (L275-281) | ○ |
| C-22 | visitがvisitLeafを呼ぶ | E-02 (L245-247) | ○ |
| C-23 | BaseScorerのiteratorがTwoPhaseIteratorのDocIdSetIteratorを返却する | E-02 (L298-299) | ○ |
| C-24 | BaseScorerのtwoPhaseIteratorがmatchCost=1000のTwoPhaseIteratorを返却する | E-02 (L303-315) | ○ |
| C-25 | BaseScorerのdocIDがapproximation.docID()を返却する | E-02 (L318-320) | ○ |
| C-26 | BaseScorerのgetMaxScoreがFloat.MAX_VALUEを返却する | E-02 (L325-327) | ○ |
| C-27 | PercolateQueryBuilder単一ドキュメントコンストラクタが正常動作する | E-03 (L144-146) | ○ |
| C-28 | PercolateQueryBuilderがfield=nullでIllegalArgumentExceptionをスローする | E-03 (L156-158) | ○ |
| C-29 | PercolateQueryBuilderがdocuments=nullでIllegalArgumentExceptionをスローする | E-03 (L159-161) | ○ |
| C-30 | インデックスドキュメント参照コンストラクタが正常動作する | E-03 (L183-209) | ○ |
| C-31 | indexedDocumentIndex=nullでIllegalArgumentExceptionがスローされる | E-03 (L194-196) | ○ |
| C-32 | indexedDocumentId=nullでIllegalArgumentExceptionがスローされる | E-03 (L197-199) | ○ |
| C-33 | setNameが名前を正しく設定する | E-03 (L272-275) | ○ |
| C-34 | doWriteToがStreamOutputにシリアライズする | E-03 (L278-313) | ○ |
| C-35 | doWriteToがdocumentSupplier非nullでIllegalStateExceptionをスローする | E-03 (L279-281) | ○ |
| C-36 | doXContentがXContentBuilderに正しくシリアライズする | E-03 (L316-357) | ○ |
| C-37 | doXContentがindex/idフィールドを出力する | E-03 (L338-354) | ○ |
| C-38 | fromXContentがXContentParserからパースする | E-03 (L409-411) | ○ |
| C-39 | doEqualsが同一パラメータでtrueを返却する | E-03 (L414-421) | ○ |
| C-40 | doEqualsが異なるfieldでfalseを返却する | E-03 (L414-421) | ○ |
| C-41 | doHashCodeがfield, documents等に基づくハッシュを返却する | E-03 (L424-426) | ○ |
| C-42 | getWriteableNameが"percolate"を返却する | E-03 (L429-431) | ○ |
| C-43 | doRewriteがdocuments非空でthisを返却する | E-03 (L435-436) | ○ |
| C-44 | doRewriteがsupplier.get()!=nullで新Builderを返却する | E-03 (L437-451) | ○ |
| C-45 | doRewriteがsupplier.get()==nullでthisを返却する | E-03 (L439-440) | ○ |
| C-46 | doRewriteがindexed document参照で非同期取得を登録する | E-03 (L453-484) | ○ |
| C-47 | doToQueryが正しいPercolateQueryを生成する | E-03 (L488-561) | △ |
| C-48 | doToQueryがallowExpensiveQueries=falseでOpenSearchExceptionをスローする | E-03 (L489-493) | ○ |
| C-49 | doToQueryがリライト前呼び出しでIllegalStateExceptionをスローする | E-03 (L498-500) | ○ |
| C-50 | doToQueryがdocuments空でIllegalStateExceptionをスローする | E-03 (L502-504) | ○ |
| C-51 | doToQueryがフィールド不存在でQueryShardExceptionをスローする | E-03 (L506-509) | ○ |
| C-52 | doToQueryがフィールド型不一致でQueryShardExceptionをスローする | E-03 (L511-516) | ○ |
| C-53 | createMultiDocumentSearcherが複数ドキュメントからIndexSearcherを生成する | E-03 (L580-595) | ○ |
| C-54 | createStoreが正しくQueryStoreを生成する | E-03 (L597-636) | ○ |
| C-55 | createStoreがbinaryDocValues=nullでnull返却関数を返す | E-03 (L603-605) | ○ |
| C-56 | wrapされたContextのgetIndexReaderがnullを返却する | E-03 (L641-644) | ○ |
| C-57 | getFieldがフィールド名を返却する | E-03 (L563-565) | ○ |
| C-58 | getDocumentsがドキュメントリストを返却する | E-03 (L567-569) | ○ |
| C-59 | Builder.buildがPercolatorFieldMapperを構築する | E-04 (L148-179) | ○ |
| C-60 | createExtractQueryFieldBuilderがKeywordFieldMapperを生成する | E-04 (L185-189) | ○ |
| C-61 | createQueryBuilderFieldBuilderがBinaryFieldMapperを生成する | E-04 (L191-194) | ○ |
| C-62 | createExtractedRangeFieldBuilderがRangeFieldMapperを生成する | E-04 (L196-206) | ○ |
| C-63 | createMinimumShouldMatchFieldがNumberFieldMapperを生成する | E-04 (L208-214) | ○ |
| C-64 | TypeParser.parseがBuilderを返却する | E-04 (L218-224) | ○ |
| C-65 | PercolatorFieldType.typeNameが"percolator"を返却する | E-04 (L241-243) | ○ |
| C-66 | PercolatorFieldType.termQueryがQueryShardExceptionをスローする | E-04 (L246-248) | ○ |
| C-67 | percolateQueryが単一ドキュメントでEXTRACTION_COMPLETEを使用する | E-04 (L255-284) | ○ |
| C-68 | percolateQueryが複数ドキュメントでMatchNoDocsQueryを使用する | E-04 (L274-278) | ○ |
| C-69 | percolateQueryがexcludeNestedDocuments=trueでフィルタを設定する | E-04 (L279-283) | ○ |
| C-70 | createCandidateQueryがCoveringQueryを使用する | E-04 (L286-322) | ○ |
| C-71 | createCandidateQueryがTermInSetQueryを使用する | E-04 (L311-316) | ○ |
| C-72 | extractTermsAndRangesがタームと範囲を抽出する | E-04 (L326-353) | ○ |
| C-73 | extractTermsAndRangesが空インデックスで空リストを返却する | E-04 (L326-353) | ○ |
| C-74 | parseがクエリをパースしフィールドを処理する | E-04 (L389-414) | △ |
| C-75 | parseが複数percolatorクエリでIllegalArgumentExceptionをスローする | E-04 (L391-396) | ○ |
| C-76 | processQueryがverified=trueでEXTRACTION_COMPLETEを設定する | E-04 (L465-466) | ○ |
| C-77 | processQueryがverified=falseでEXTRACTION_PARTIALを設定する | E-04 (L467-469) | ○ |
| C-78 | processQueryがUNKNOWNでEXTRACTION_FAILEDを設定する | E-04 (L442-445) | ○ |
| C-79 | processQueryがmatchAllDocs=true,verified=trueでFAILEDとCOMPLETEの両方を設定する | E-04 (L460-464) | ○ |
| C-80 | processQueryがrange抽出でBinaryRangeフィールドを追加する | E-04 (L453-457) | ○ |
| C-81 | configureContextがsetAllowUnmappedFields(false)を呼ぶ | E-04 (L488) | ○ |
| C-82 | configureContextがmapUnmappedFieldsAsString設定を反映する | E-04 (L489) | ○ |
| C-83 | verifyQueryが通常のクエリで例外をスローしない | E-04 (L530-556) | ○ |
| C-84 | verifyQueryがhas_childでIllegalArgumentExceptionをスローする | E-04 (L531-532) | ○ |
| C-85 | verifyQueryがhas_parentでIllegalArgumentExceptionをスローする | E-04 (L533-534) | ○ |
| C-86 | verifyQueryがBoolQuery内のhas_childを再帰検証する | E-04 (L535-542) | ○ |
| C-87 | verifyQueryがConstantScoreQuery内を再帰検証する | E-04 (L544-545) | ○ |
| C-88 | verifyQueryがBoostingQuery内を再帰検証する | E-04 (L548-550) | ○ |
| C-89 | verifyQueryがDisMaxQuery内を再帰検証する | E-04 (L551-555) | ○ |
| C-90 | encodeRangeが正しいバイト配列を生成する | E-04 (L558-576) | ○ |
| C-91 | encodeRangeがmin==maxで正しくエンコードする | E-04 (L558-576) | ○ |
| C-92 | parseCreateFieldがUnsupportedOperationExceptionをスローする | E-04 (L512-514) | ○ |
| C-93 | contentTypeが"percolator"を返却する | E-04 (L517-519) | ○ |
| C-94 | iteratorが5つのサブフィールドを含む | E-04 (L501-509) | ○ |
| C-95 | createQueryBuilderFieldがバイナリデータとして追加する | E-04 (L416-426) | ○ |
| C-96 | HighlightSubFetchPhase.getProcessorがハイライト設定あり時にProcessorを返却する | E-05 (L69-150) | △ |
| C-97 | HighlightSubFetchPhase.getProcessorがハイライトnullでnullを返却する | E-05 (L70-71) | ○ |
| C-98 | HighlightSubFetchPhase.getProcessorがPercolateQueryなしでnullを返却する | E-05 (L73-75) | ○ |
| C-99 | locatePercolatorQueryがPercolateQueryを抽出する | E-05 (L152-166) | ○ |
| C-100 | locatePercolatorQueryがquery=nullで空リストを返却する | E-05 (L153-155) | ○ |
| C-101 | locatePercolatorQueryがPercolateQuery未含有で空リストを返却する | E-05 (L152-166) | ○ |
| C-102 | MatchedSlotSubFetchPhase.getProcessorがPercolateQuery存在時にProcessorを返却する | E-06 (L72-118) | ○ |
| C-103 | MatchedSlotSubFetchPhase.getProcessorがPercolateQueryなしでnullを返却する | E-06 (L80-82) | ○ |
| C-104 | PercolateContext.fieldNameが単一クエリ時にプレフィックスのみを返却する | E-06 (L142-144) | ○ |
| C-105 | PercolateContext.fieldNameが複数クエリ時にクエリ名付き名を返却する | E-06 (L142-144) | ○ |
| C-106 | filterNestedDocsがrootDocsBySlot!=nullでBooleanQueryでラップする | E-06 (L146-154) | ○ |
| C-107 | filterNestedDocsがrootDocsBySlot==nullで入力をそのまま返却する | E-06 (L146-154) | ○ |
| C-108 | convertTopDocsToSlotsがrootDocsBySlot=nullでdocIdを直接返却する | E-06 (L157-163) | ○ |
| C-109 | convertTopDocsToSlotsがrootDocsBySlot指定時にバイナリサーチで変換する | E-06 (L157-163) | ○ |
| C-110 | buildRootDocsSlotsがBitSetからスロット配列を構築する | E-06 (L165-173) | ○ |
| C-111 | buildRootDocsSlotsが空BitSetで空配列を返却する | E-06 (L165-173) | ○ |
| C-112 | PercolatorModulePlugin.getQueriesがPercolateQueryBuilderのQuerySpecを返却する | E-07 (L51-53) | ○ |
| C-113 | PercolatorModulePlugin.getFetchSubPhasesが2つのFetchSubPhaseを返却する | E-07 (L56-58) | ○ |
| C-114 | PercolatorModulePlugin.getSettingsがINDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTINGを返却する | E-07 (L61-63) | ○ |
| C-115 | PercolatorModulePlugin.getMappersがpercolatorタイプを返却する | E-07 (L66-68) | ○ |
| C-116 | QueryAnalyzer.analyzeがTermQueryからタームを抽出する | E-08 (L103-107, L224-229) | ○ |
| C-117 | QueryAnalyzer.analyzeがBooleanQuery MUSTから全タームを抽出する | E-08 (L190-193) | ○ |
| C-118 | QueryAnalyzer.analyzeがBooleanQuery SHOULDからタームを抽出する | E-08 (L199-210) | ○ |
| C-119 | QueryAnalyzer.analyzeがMatchAllDocsQueryでmatchAllDocs=trueを返却する | E-08 (L216) | ○ |
| C-120 | QueryAnalyzer.analyzeがMatchNoDocsQueryでMATCH_NONEを返却する | E-08 (L217) | ○ |
| C-121 | QueryAnalyzer.analyzeがPointRangeQueryからRange抽出する | E-08 (L218, L253-274) | ○ |
| C-122 | QueryAnalyzer.analyzeがConstantScoreQuery内のクエリを分析する | E-08 (L109-122) verifiedQueriesにConstantScoreQuery含む | ○ |
| C-123 | QueryAnalyzer.analyzeがDisjunctionMaxQueryのサブクエリを分析する | E-08 (L109-122) verifiedQueriesにDisjunctionMaxQuery含む | ○ |
| C-124 | QueryAnalyzer.analyzeがMUST_NOT節を無視する | E-08 (L195-197) | ○ |
| C-125 | QueryAnalyzer.analyzeがTermInSetQueryから全タームを抽出する | E-08 (L233-249) | ○ |
| C-126 | QueryAnalyzer.analyzeがSynonymQueryからタームを抽出する | E-08 (L109-122) verifiedQueriesにSynonymQuery含む | ○ |
| C-127 | QueryAnalyzer.analyzeがFunctionScoreQuery minScore=nullでverified=trueとする | E-08 (L125-128) | ○ |
| C-128 | QueryAnalyzer.analyzeがFunctionScoreQuery minScore指定でverified=falseとする | E-08 (L125-128) | ○ |
| C-129 | QueryAnalyzer.analyzeがBoostQuery内を分析する | E-08 (L109-122) verifiedQueriesにBoostQuery含む | ○ |
| C-130 | QueryAnalyzer.analyzeが多次元PointRangeQueryでUNKNOWNを返却する | E-08 (L254-256) | ○ |
| C-131 | QueryAnalyzer.analyzeがlower>upperで空抽出を返却する | E-08 (L263-265) | ○ |
| C-132 | selectBestResultがresult1=nullでresult2を返却する | E-08 (L454-455) | ○ |
| C-133 | selectBestResultがresult2=nullでresult1を返却する | E-08 (L456-457) | ○ |
| C-134 | selectBestResultがresult1=matchAllDocsでresult2を返却する | E-08 (L458-463) | ○ |
| C-135 | selectBestResultが両方term抽出時に最短ターム長い方を選択する | E-08 (L502-509) | ○ |
| C-136 | selectBestResultが両方range抽出時に小さい範囲を選択する | E-08 (L486-500) | ○ |
| C-137 | Result コンストラクタがminimumShouldMatch>extractions.size()でIAEをスローする | E-08 (L564-567) | ○ |
| C-138 | Result.unverifyがverified=trueで新Resultを返却する | E-08 (L588-591) | ○ |
| C-139 | Result.unverifyがverified=falseでthisを返却する | E-08 (L588-594) | ○ |
| C-140 | Result.isUnknownが通常Resultでfalseを返却する | E-08 (L596-598) | ○ |
| C-141 | Result.isUnknownがUNKNOWNでtrueを返却する | E-08 (L604-608) | ○ |
| C-142 | Result.isMatchNoDocsがMATCH_NONEでtrueを返却する | E-08 (L621-625) | ○ |
| C-143 | Result.isMatchNoDocsがUNKNOWNでfalseを返却する | E-08 (L611-613) | ○ |
| C-144 | QueryExtraction(Term)コンストラクタが正しく構築する | E-08 (L634-637) | ○ |
| C-145 | QueryExtraction(Range)コンストラクタが正しく構築する | E-08 (L639-642) | ○ |
| C-146 | QueryExtraction.fieldがterm設定時にterm.field()を返却する | E-08 (L644-646) | ○ |
| C-147 | QueryExtraction.fieldがrange設定時にnullを返却する | E-08 (L644-646) | ○ |
| C-148 | QueryExtraction.equalsが同一term/rangeでtrueを返却する | E-08 (L657-662) | ○ |
| C-149 | QueryExtraction.hashCodeがterm/rangeに基づくハッシュを返却する | E-08 (L665-667) | ○ |
| C-150 | Range コンストラクタが全フィールドを設定する | E-08 (L682-688) | ○ |
| C-151 | Range.equalsが同一パラメータでtrueを返却する | E-08 (L691-698) | ○ |
| C-152 | Range.equalsが異なるfieldNameでfalseを返却する | E-08 (L691-698) | ○ |
| C-153 | Range.hashCodeがfieldName, lowerPoint, upperPointに基づく | E-08 (L701-707) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-47 (doToQuery正常系): doToQueryは多数の外部依存（MapperService, DocumentMapper, FieldNameAnalyzer, MemoryIndex）を持つため、単体テストでの完全検証にはモック環境が必要。テストケースの期待結果はコードロジックから推定。
  - 候補: 統合テスト / 既存テストスイートの参照
- C-74 (parse正常系): parseメソッドはQueryShardContext, XContentParser, DocumentMapper等の複雑な依存を持つため、動作確認にはフルセットアップ環境が必要。
  - 候補: 既存のPercolatorFieldMapperTests / 統合テスト
- C-96 (HighlightSubFetchPhase getProcessor正常系): ハイライト処理の統合的動作は、FetchContext, HighlightPhase, SourceLookup等の多段階依存に基づく。
  - 候補: PercolatorHighlightSubFetchPhaseTests / 統合テスト

## 5) リスクフラグ（レビュー観点）
- 0: BinaryRange, PercolateQuery, QueryAnalyzer内部クラス（Result, QueryExtraction, Range）のテストケース - ソースコードから直接導出可能で低リスク
- 1: PercolateQueryBuilder, PercolatorFieldMapperのテストケース - 外部依存が多く、テストのセットアップが複雑なため中リスク
- 1: PercolatorHighlightSubFetchPhase, PercolatorMatchedSlotSubFetchPhaseのテストケース - FetchContextとの統合的な動作に依存するため中リスク
- 0: PercolatorModulePluginのテストケース - プラグイン登録の確認で低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] PercolateQueryBuilder.doToQuery (UT-PRC-047) の期待結果が実際のPercolateQuery生成ロジックと整合しているか
- [ ] PercolatorFieldMapper.parse (UT-PRC-074) のテストケースがQueryShardContextのモック要件を正しく記載しているか
- [ ] QueryAnalyzer.analyze のテストケース (UT-PRC-116~131) が全てのクエリタイプを網羅しているか（SpanTermQuery, BlendedTermQuery等のverifiedQueriesも含む）
- [ ] processQuery (UT-PRC-076~080) のテストケースが全ての条件分岐（matchAllDocs, verified, range/term）をカバーしているか
- [ ] verifyQuery (UT-PRC-083~089) が全ての再帰パス（BoolQuery, ConstantScore, FunctionScore, Boosting, DisMax）を網羅しているか
