---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 137
  claims_with_evidence: 133
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：modules-rank-eval 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：133 / 137、根拠なし：4
- 優先レビュー（高）
  1. **UT-RKE-130〜134 (TransportRankEvalAction.doExecute)**: モック依存のため実際のメソッド呼び出しフローの詳細は推測を含む
  2. **UT-RKE-135〜136 (RankEvalActionListener.onResponse)**: 内部クラスの詳細動作は間接的な推測を含む
  3. **UT-RKE-065〜066 (EvaluationMetric.combine)**: インタフェースのデフォルト実装であり、実装クラスでのオーバーライド有無は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/PrecisionAtK.java`
- E-02: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RecallAtK.java`
- E-03: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/MeanReciprocalRank.java`
- E-04: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/DiscountedCumulativeGain.java`
- E-05: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/ExpectedReciprocalRank.java`
- E-06: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/EvaluationMetric.java`
- E-07: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RatedDocument.java`
- E-08: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RatedSearchHit.java`
- E-09: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/EvalQueryQuality.java`
- E-10: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalSpec.java`
- E-11: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalRequest.java`
- E-12: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalResponse.java`
- E-13: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RatedRequest.java`
- E-14: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalModulePlugin.java`
- E-15: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RestRankEvalAction.java`
- E-16: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalRequestBuilder.java`
- E-17: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalAction.java`
- E-18: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/MetricDetail.java`
- E-19: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RankEvalNamedXContentProvider.java`
- E-20: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/TransportRankEvalAction.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PrecisionAtK デフォルトコンストラクタが threshold=1, ignoreUnlabeled=false, k=10 で初期化される | E-01 (L108-109) | ○ |
| C-02 | PrecisionAtK コンストラクタで relevantRatingThreshold<0 の場合に IllegalArgumentException | E-01 (L93-94) | ○ |
| C-03 | PrecisionAtK コンストラクタで k<=0 の場合に IllegalArgumentException | E-01 (L96-97) | ○ |
| C-04 | PrecisionAtK.evaluate で ignoreUnlabeled=true の場合に未ラベルドキュメントが retrieved に含まれない | E-01 (L212-222) | ○ |
| C-05 | PrecisionAtK.evaluate で precision = relevantRetrieved / retrieved で計算 | E-01 (L224-227) | ○ |
| C-06 | RecallAtK デフォルトコンストラクタが threshold=1, k=10 で初期化される | E-02 (L93-95) | ○ |
| C-07 | RecallAtK コンストラクタで relevantRatingThreshold<0 の場合に IllegalArgumentException | E-02 (L83-85) | ○ |
| C-08 | RecallAtK コンストラクタで k<=0 の場合に IllegalArgumentException | E-02 (L86-88) | ○ |
| C-09 | RecallAtK.evaluate で recall = relevantRetrieved / relevant で計算 | E-02 (L183-193) | ○ |
| C-10 | MeanReciprocalRank デフォルトコンストラクタが threshold=1, k=10 で初期化される | E-03 (L70-72) | ○ |
| C-11 | MeanReciprocalRank コンストラクタで relevantRatingThreshold<0 の場合に IllegalArgumentException | E-03 (L91-93) | ○ |
| C-12 | MeanReciprocalRank コンストラクタで k<=0 の場合に IllegalArgumentException | E-03 (L94-96) | ○ |
| C-13 | MeanReciprocalRank.evaluate で最初の関連ドキュメントのランクの逆数を返す | E-03 (L128-141) | ○ |
| C-14 | DiscountedCumulativeGain デフォルトコンストラクタが normalize=false, unknownDocRating=null, k=10 | E-04 (L81-83) | ○ |
| C-15 | DCG計算式: (2^rating - 1) / log2(rank + 1) | E-04 (L175-185) | ○ |
| C-16 | normalize=true の場合に DCG/IDCG で NDCG が計算される | E-04 (L159-168) | ○ |
| C-17 | IDCG=0 の場合に result=0 | E-04 (L163-167) | ○ |
| C-18 | ExpectedReciprocalRank で probabilityOfRelevance = (2^rating - 1) / 2^maxRelevance | E-05 (L184-186) | ○ |
| C-19 | ExpectedReciprocalRank.evaluate で ratedHits が k 件に切り詰められる | E-05 (L148-150) | ○ |
| C-20 | EvaluationMetric.joinHitsWithRatings で SearchHit と RatedDocument が _index/_id でマッチングされる | E-06 (L72-86) | ○ |
| C-21 | EvaluationMetric.filterUnratedDocuments で rating が present でないヒットがフィルタされる | E-06 (L91-96) | ○ |
| C-22 | EvaluationMetric.combine がデフォルトで平均を計算する | E-06 (L102-104) | ○ |
| C-23 | DocumentKey コンストラクタで index が null/空の場合に IllegalArgumentException | E-07 (L161-163) | ○ |
| C-24 | DocumentKey コンストラクタで docId が null/空の場合に IllegalArgumentException | E-07 (L164-166) | ○ |
| C-25 | RankEvalSpec コンストラクタで metric が null の場合に NullPointerException | E-10 (L77) | ○ |
| C-26 | RankEvalSpec コンストラクタで ratedRequests が null/空の場合に IllegalArgumentException | E-10 (L78-81) | ○ |
| C-27 | RankEvalRequest.indices で null が渡された場合に NullPointerException | E-11 (L105) | ○ |
| C-28 | RankEvalRequest.validate で spec が null の場合に ValidationException | E-11 (L77-84) | ○ |
| C-29 | RatedRequest コンストラクタで query と params の両方指定時に IllegalArgumentException | E-13 (L136-139) | ○ |
| C-30 | RatedRequest コンストラクタで重複 DocumentKey がある場合に IllegalArgumentException | E-13 (L155-163) | ○ |
| C-31 | RatedRequest.validateEvaluatedQuery で suggest/aggregations/highlighter/explain/profile が禁止 | E-13 (L177-196) | ○ |
| C-32 | TransportRankEvalAction.doExecute で MultiSearchRequest が構築される | E-20 (L102-157) | ○ |
| C-33 | TransportRankEvalAction.doExecute でテンプレート使用時に scriptService.compile が呼ばれる | E-20 (L110-112) | ○ |
| C-34 | RankEvalActionListener.onResponse で失敗レスポンスが errors に追加される | E-20 (L191-197) | ○ |
| C-35 | TransportRankEvalAction.doExecute でテンプレート解決の IOException が errors に追加される（詳細フロー） | E-20 (L135-138) | △ |
| C-36 | TransportRankEvalAction.doExecute で summaryFields 空の場合に fetchSource(false) | E-20 (L148-149) | ○ |
| C-37 | RankEvalModulePlugin が 10 個の NamedWriteable を登録する | E-14 (L77-97) | ○ |
| C-38 | RestRankEvalAction が 4 つの Route を登録する | E-15 (L109-118) | ○ |
| C-39 | RankEvalActionListener.onResponse で metric.combine が呼ばれて統合スコアが計算される（内部動作の詳細） | E-20 (L200) | △ |
| C-40 | RankEvalActionListener.onFailure で listener.onFailure に例外が伝播される（内部動作の詳細） | E-20 (L203-205) | △ |
| C-41 | RankEvalNamedXContentProvider が 10 個の Entry を返す（数の正確性） | E-19 (L46-100) | △ |

## 4) 不足情報（Unknown / Missing）
- TransportRankEvalAction の内部動作に関するテストケース（UT-RKE-130〜137）は、モック依存のインテグレーション的なテストとなるため、実際のメソッド呼び出しシーケンスの完全な検証は単体テストの範囲を超える可能性がある
  - 候補：既存のテストコード（test ディレクトリ）を参照して実際のテストパターンを確認 / Javadoc・設計ドキュメントの参照
- RankEvalNamedXContentProvider の登録数 10 は手動カウントによるもので、コード変更時に追随が必要
  - 候補：コード内のリスト追加箇所を自動カウントするテストの追加

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メトリクス計算ロジック（PrecisionAtK, RecallAtK, MeanReciprocalRank, DiscountedCumulativeGain, ExpectedReciprocalRank）のテストケースはソースコードから直接導出されており、信頼性が高い
- 0: 低リスク - バリデーションロジック（コンストラクタの引数チェック、RatedRequest の入力検証）はソースコードのif文から直接対応づけ可能
- 1: 中リスク - TransportRankEvalAction のテストケースは、内部クラス RankEvalActionListener の動作を含み、モック設計が必要
- 0: 低リスク - equals/hashCode のテストケースは標準的なパターンであり、ソースコードの実装と直接対応

## 6) レビュアーチェックリスト（最小）
- [ ] メトリクス計算ロジック（DCG, NDCG, ERR, Precision, Recall, MRR）のテストケースが数学的に正しい期待値を含んでいるか
- [ ] 各メトリクスの unknownDocRating パラメータの挙動が正しくテストされているか
- [ ] RatedRequest のバリデーションテスト（UT-RKE-106〜115）がソースコードの全分岐をカバーしているか
- [ ] TransportRankEvalAction のテストケースがモック設計として妥当か（単体テストとして実装可能か）
- [ ] XContent ラウンドトリップテストが全シリアライズ可能クラスに対して用意されているか
