---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 142
  claims_with_evidence: 138
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：modules-reindex 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：138 / 142、根拠なし：4
- 優先レビュー（高）
  1. **UT-REI-022（メディアタイプ変換）**：CBOR形式への変換が実際に発生するケースの検証は外部依存の確認が必要
  2. **UT-REI-140/141（SSL hostname検証）**：SslConfiguration.getVerificationMode()の具体的な値はテスト実行時の設定に依存
  3. **UT-REI-138/139（拡張機能ロード）**：ExtensionLoaderのモック動作の正確性はテスト実装次第

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/reindex/src/main/java/org/opensearch/index/reindex/ReindexValidator.java` - バリデーションロジック（checkRemoteAllowlist, buildRemoteAllowlist, validateAgainstAliases, initialValidation）
- E-02: `modules/reindex/src/main/java/org/opensearch/index/reindex/Reindexer.java` - Reindexer本体（buildRestClient, AsyncIndexBySearchAction, buildRequest, copyRouting, ReindexScriptApplier）
- E-03: `modules/reindex/src/main/java/org/opensearch/index/reindex/TransportReindexAction.java` - TransportAction（doExecute, resolveIndices, REMOTE_CLUSTER_ALLOWLIST設定）
- E-04: `modules/reindex/src/main/java/org/opensearch/index/reindex/AbstractAsyncBulkByScrollAction.java` - 抽象基底クラス（accept, copyMetadata, start, onScrollResponse, prepareBulkRequest, onBulkResponse, OpType, IndexRequestWrapper, DeleteRequestWrapper, ScriptApplier）
- E-05: `modules/reindex/src/main/java/org/opensearch/index/reindex/BulkByScrollParallelizationHelper.java` - スライス並列化（sliceIntoSubRequests, initTaskState, executeSlicedAction, countSlicesBasedOnShards）
- E-06: `modules/reindex/src/main/java/org/opensearch/index/reindex/TransportRethrottleAction.java` - リスロットル処理（rethrottle, rethrottleParentTask, rethrottleChildTask）
- E-07: `modules/reindex/src/main/java/org/opensearch/index/reindex/AsyncDeleteByQueryAction.java` - DeleteByQuery実装（accept, buildRequest, copyMetadata）
- E-08: `modules/reindex/src/main/java/org/opensearch/index/reindex/TransportUpdateByQueryAction.java` - UpdateByQuery実装（AsyncIndexBySearchAction, buildRequest, UpdateByQueryScriptApplier）
- E-09: `modules/reindex/src/main/java/org/opensearch/index/reindex/RestReindexAction.java` - RESTハンドラ（buildRequest, getFilteredFields）
- E-10: `modules/reindex/src/main/java/org/opensearch/index/reindex/RestRethrottleAction.java` - リスロットルREST（prepareRequest）
- E-11: `modules/reindex/src/main/java/org/opensearch/index/reindex/AbstractBaseReindexRestHandler.java` - REST基底クラス（parseRequestsPerSecond, setMaxDocsValidateIdentical, setCommonOptions, parseSlices）
- E-12: `modules/reindex/src/main/java/org/opensearch/index/reindex/BulkIndexByScrollResponseContentListener.java` - レスポンスリスナー（buildResponse, getStatus）
- E-13: `modules/reindex/src/main/java/org/opensearch/index/reindex/remote/RemoteVersion.java` - バージョン管理（fromString, before, onOrAfter, compareTo, equals, hashCode）
- E-14: `modules/reindex/src/main/java/org/opensearch/index/reindex/remote/RemoteRequestBuilders.java` - リモートリクエスト構築（initialSearch, scroll, clearScroll）
- E-15: `modules/reindex/src/main/java/org/opensearch/index/reindex/remote/RemoteScrollableHitSource.java` - リモートスクロール（wrapExceptionToPreserveStatus, doStart, clearScroll, cleanup）
- E-16: `modules/reindex/src/main/java/org/opensearch/index/reindex/remote/RemoteResponseParsers.java` - レスポンスパーサー（ThrowableBuilder, HIT_PARSER, RESPONSE_PARSER）
- E-17: `modules/reindex/src/main/java/org/opensearch/index/reindex/ReindexModulePlugin.java` - プラグイン登録（getActions, getRestHandlers, loadExtensions）
- E-18: `modules/reindex/src/main/java/org/opensearch/index/reindex/ReindexSslConfig.java` - SSL設定（getStrategy, getSettings）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-REI-001~002) | ReindexValidator.initialValidationの正常系テストケース | E-01 (L78-93) | ○ |
| C-02 (UT-REI-003~005) | ReindexValidator.checkRemoteAllowlistの正常系・異常系 | E-01 (L95-105) | ○ |
| C-03 (UT-REI-006~008) | ReindexValidator.buildRemoteAllowlistの正常系・異常系 | E-01 (L111-127) | ○ |
| C-04 (UT-REI-009~011) | ReindexValidator.validateAgainstAliasesの正常系・異常系 | E-01 (L135-168) | ○ |
| C-05 (UT-REI-012~017) | Reindexer.buildRestClientの正常系・境界値 | E-02 (L186-251) | ○ |
| C-06 (UT-REI-018~022) | AsyncIndexBySearchAction.buildRequestの正常系 | E-02 (L367-420) | ○ |
| C-07 (UT-REI-022) | メディアタイプ変換がCBOR等で動作する | E-02 (L389-407) | △ |
| C-08 (UT-REI-023~027) | AsyncIndexBySearchAction.copyRoutingの各パターン | E-02 (L426-446) | ○ |
| C-09 (UT-REI-028~033) | ReindexScriptApplierの各メソッド | E-02 (L448-508) | ○ |
| C-10 (UT-REI-034~035) | TransportReindexAction.doExecuteのリモートリトライ設定 | E-03 (L123-142) | ○ |
| C-11 (UT-REI-036~039) | BulkByScrollParallelizationHelper.sliceIntoSubRequests | E-05 (L235-253) | ○ |
| C-12 (UT-REI-040~041) | AbstractAsyncBulkByScrollAction.accept | E-04 (L252-262) | ○ |
| C-13 (UT-REI-042~043) | copyMetadataとbuildScriptApplier | E-04 (L235-245, L212-215) | ○ |
| C-14 (UT-REI-044) | buildBackoffPolicy | E-04 (L579-581) | ○ |
| C-15 (UT-REI-045~046) | start()のキャンセルチェック | E-04 (L305-318) | ○ |
| C-16 (UT-REI-047~050) | onScrollResponseの各パターン | E-04 (L332-369) | ○ |
| C-17 (UT-REI-051~052) | prepareBulkRequestの各パターン | E-04 (L376-408) | ○ |
| C-18 (UT-REI-053~058) | onBulkResponseのカウンタ処理・障害ハンドリング | E-04 (L443-495) | ○ |
| C-19 (UT-REI-059~063) | OpType.fromStringの各パターン | E-04 (L912-926) | ○ |
| C-20 (UT-REI-064~068) | IndexRequestWrapper/DeleteRequestWrapperの各テスト | E-04 (L631-777) | ○ |
| C-21 (UT-REI-069~074) | ScriptApplier.applyの各パターン | E-04 (L808-898) | ○ |
| C-22 (UT-REI-075~079) | TransportRethrottleAction.rethrottleの各パターン | E-06 (L80-140) | ○ |
| C-23 (UT-REI-080~082) | AsyncDeleteByQueryActionの各メソッド | E-07 (L60-84) | ○ |
| C-24 (UT-REI-083~087) | TransportUpdateByQueryAction.AsyncIndexBySearchActionの各テスト | E-08 (L126-198) | ○ |
| C-25 (UT-REI-088~091) | RestReindexAction.buildRequestの各パターン | E-09 (L76-103) | ○ |
| C-26 (UT-REI-092~093) | RestRethrottleAction.prepareRequest | E-10 (L73-87) | ○ |
| C-27 (UT-REI-094~100) | parseRequestsPerSecondとsetMaxDocsValidateIdentical | E-11 (L155-184) | ○ |
| C-28 (UT-REI-101~104) | BulkIndexByScrollResponseContentListenerの各テスト | E-12 (L59-88) | ○ |
| C-29 (UT-REI-105~117) | RemoteVersionの各メソッド | E-13 (L43-149) | ○ |
| C-30 (UT-REI-118~125) | RemoteRequestBuildersの各メソッド | E-14 (L76-264) | ○ |
| C-31 (UT-REI-126~129) | RemoteScrollableHitSource.wrapExceptionToPreserveStatus | E-15 (L302-328) | ○ |
| C-32 (UT-REI-130~135) | RemoteResponseParsers.ThrowableBuilderの各テスト | E-16 (L226-292) | ○ |
| C-33 (UT-REI-136~139) | ReindexModulePluginの各メソッド | E-17 (L79-156) | ○ |
| C-34 (UT-REI-140~141) | ReindexSslConfig.getStrategy の hostname検証 | E-18 (L172-194) | △ |
| C-35 (UT-REI-142) | ReindexSslConfig.getSettings | E-18 (L104-109) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-REI-022（メディアタイプ変換）**: CBOR形式への実際の変換テストは、XContentBuilder/XContentParserの具体的な挙動に依存するため、実行環境でのエンドツーエンドテストが推奨される
  - 候補：XContentBuilderの単体テスト / MediaTypeRegistryのテスト
- **UT-REI-140/141（SSL設定）**: SslConfiguration.getVerificationMode()の戻り値はreindex.ssl.*設定に依存するため、テスト実行時に具体的な設定ファイルが必要
  - 候補：テスト用SSLキーストア / SslConfigurationLoaderのモック
- **UT-REI-138/139（拡張機能ロード）**: ExtensionLoaderの動作はPluginフレームワークに依存
  - 候補：ExtensionLoaderのモック / IntegrationTest
- **spi パッケージ（RemoteReindexExtension, ReindexRestInterceptorProvider）**: インターフェースのみのため単体テストケースの直接生成は不要だが、実装クラスのテストは拡張プラグイン側で実施が必要
  - 候補：拡張プラグインのテストスイート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストケースの大部分はソースコードの分岐・条件を直接参照しており、高い信頼度がある
- 1: 中リスク - SSL設定関連テスト（UT-REI-140/141）は環境依存の可能性がある。レビュー時に実行環境の前提条件を確認すること
- 0: 低リスク - RemoteVersion, RemoteRequestBuilders, RemoteResponseParsersのテストはコードの分岐を網羅的にカバーしている

## 6) レビュアーチェックリスト（最小）
- [ ] ReindexValidator のセキュリティ関連テストケース（UT-REI-005, 008, 010, 011）の期待結果が適切か確認
- [ ] copyRouting の全パターン（keep, discard, =prefix, null, invalid）がカバーされているか確認
- [ ] ScriptApplier のopType変更（noop, delete, invalid）のテストが十分か確認
- [ ] RemoteVersion のOpenSearch/Elasticsearch間のバージョン比較ロジックが正しいか確認
- [ ] SSL設定テスト（UT-REI-140/141）の前提条件が実行可能か確認
- [ ] RemoteRequestBuilders の各Elasticsearchバージョン互換テスト（5.0未満、2.1未満、2.0未満、6.3以降）の網羅性を確認
- [ ] TransportRethrottleAction のサブタスク分割計算（requestsPerSecond / runningSubtasks）の正確性を確認
