---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 153
  claims_with_evidence: 149
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：modules-search-pipeline-common 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：149 / 153、根拠なし：4
- 優先レビュー（高）
  1. **C-101〜C-103（SearchResponseUtil replaceHits InternalAggregations分岐）**：InternalAggregationsのインスタンス判定パスは実行時の型に依存し、テスト環境での再現が困難な可能性がある
  2. **C-137（TemporalRoutingSearchProcessor maxBuckets=100上限）**：ハードコードされた上限値であり、将来的に設定可能になるTODOがコードに存在する
  3. **C-010（ScriptRequestProcessor precompiledSearchScript=null時の動的コンパイル）**：テスト環境でのScriptService設定に依存
  4. **C-081（SearchRequestMap put型不一致時の例外）**：ClassCastExceptionがSearchRequestMapProcessingExceptionにラップされるかの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/FilterQueryRequestProcessor.java`
- E-02: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/ScriptRequestProcessor.java`
- E-03: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/OversampleRequestProcessor.java`
- E-04: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/RenameFieldResponseProcessor.java`
- E-05: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/TruncateHitsResponseProcessor.java`
- E-06: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/CollapseResponseProcessor.java`
- E-07: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/SortResponseProcessor.java`
- E-08: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/SplitResponseProcessor.java`
- E-09: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/SearchRequestMap.java`
- E-10: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/BasicMap.java`
- E-11: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/helpers/ContextUtils.java`
- E-12: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/helpers/SearchResponseUtil.java`
- E-13: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/SearchPipelineCommonModulePlugin.java`
- E-14: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/SearchRequestMapProcessingException.java`
- E-15: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/AclRoutingSearchProcessor.java`
- E-16: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/HierarchicalRoutingSearchProcessor.java`
- E-17: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/TemporalRoutingSearchProcessor.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | FilterQueryRequestProcessor.processRequestで既存クエリにフィルタが追加される | E-01 (L76-91) | ○ |
| C-002 | 既存クエリがnullの場合フィルタのみのBoolQueryが設定される | E-01 (L77-85) | ○ |
| C-003 | sourceがnullの場合新しいSearchSourceBuilderが作成される | E-01 (L86-88) | ○ |
| C-004 | getTypeが"filter_query"を返す | E-01 (L40, L50-52) | ○ |
| C-005 | Factory.createが正しく設定を読み取る | E-01 (L102-121) | ○ |
| C-006 | queryキーなしの場合IllegalArgumentException | E-01 (L111-113) | ○ |
| C-007 | ScriptRequestProcessor.processRequestがスクリプトを実行する | E-02 (L77-92) | ○ |
| C-008 | request=nullでIllegalArgumentException | E-02 (L79-81) | ○ |
| C-009 | request.source()=nullでIllegalArgumentException | E-02 (L79-81) | ○ |
| C-010 | precompiledSearchScript=nullでコンパイル実行 | E-02 (L83-88) | ○ |
| C-011 | ScriptRequestProcessor.getTypeが"script"を返す | E-02 (L46, L123-125) | ○ |
| C-012 | ScriptRequestProcessor.Factory.createが正しく生成 | E-02 (L163-197) | ○ |
| C-013 | 無効スクリプトでConfigurationException | E-02 (L188-195) | ○ |
| C-014 | OversampleがsizeをsampleFactorで乗算 | E-03 (L47-57) | ○ |
| C-015 | size=-1の場合DEFAULT_SIZEを使用 | E-03 (L50-52) | ○ |
| C-016 | source=nullで変更なし | E-03 (L48) | ○ |
| C-017 | sampleFactor=1.0でサイズ不変 | E-03 (L54) | ○ |
| C-018 | contextPrefix設定時にプレフィックス付きキーで保存 | E-03 (L53) | ○ |
| C-019 | Math.ceilで切り上げ | E-03 (L54) | ○ |
| C-020 | Oversample Factory正常生成 | E-03 (L66-81) | ○ |
| C-021 | sampleFactor<1.0で例外 | E-03 (L76-78) | ○ |
| C-022 | RenameFieldがDocumentFieldをリネーム | E-04 (L100-107) | ○ |
| C-023 | RenameFieldがソースマップをリネーム | E-04 (L109-126) | ○ |
| C-024 | フィールド欠損+ignoreMissing=falseでIllegalArgumentException | E-04 (L129-131) | ○ |
| C-025 | フィールド欠損+ignoreMissing=trueで正常 | E-04 (L129) | ○ |
| C-026 | RenameField.getTypeが"rename_field"を返す | E-04 (L40, L67-69) | ○ |
| C-027 | getOldFieldの動作 | E-04 (L75-77) | ○ |
| C-028 | getNewFieldの動作 | E-04 (L82-84) | ○ |
| C-029 | isIgnoreMissingの動作 | E-04 (L89-93) | ○ |
| C-030 | RenameField Factory正常生成 | E-04 (L148-159) | ○ |
| C-031 | TruncateHitsがtargetSizeで切り詰め | E-05 (L52-68) | ○ |
| C-032 | ヒット数がtargetSize以下で変更なし | E-05 (L64) | ○ |
| C-033 | targetSize未設定時にcontextからoriginal_size使用 | E-05 (L54-61) | ○ |
| C-034 | targetSize未設定+context値なしでIllegalStateException | E-05 (L57-59) | ○ |
| C-035 | targetSize=0で空配列 | E-05 (L64-67) | ○ |
| C-036 | hitsがnullでそのまま返却 | E-05 (L64) | ○ |
| C-037 | TruncateHits Factory正常生成 | E-05 (L74-93) | ○ |
| C-038 | targetSize負値で例外 | E-05 (L88-89) | ○ |
| C-039 | targetSize未設定で-1マーカー | E-05 (L83-85) | ○ |
| C-040 | Collapseが同一値を集約 | E-06 (L52-101) | ○ |
| C-041 | フィールドnullで"__missing__"扱い | E-06 (L76-80) | ○ |
| C-042 | 既collapse済みでIllegalStateException | E-06 (L55-59) | ○ |
| C-043 | 複数値でIllegalStateException | E-06 (L66-69) | ○ |
| C-044 | hits=nullでそのまま返却 | E-06 (L54, L103) | ○ |
| C-045 | sourceAsMapから値取得 | E-06 (L72-74) | ○ |
| C-046 | Collapse.getTypeが"collapse"を返す | E-06 (L37, L47-49) | ○ |
| C-047 | Collapse Factory正常生成 | E-06 (L109-118) | ○ |
| C-048 | 0件ヒットで空SearchHits | E-06 (L62-100) | ○ |
| C-049 | Sort昇順ソート | E-07 (L132-166, L168-173) | ○ |
| C-050 | Sort降順ソート | E-07 (L168-173) | ○ |
| C-051 | ソースマップListソート | E-07 (L143-162) | ○ |
| C-052 | targetField指定で別フィールド | E-07 (L141) | ○ |
| C-053 | null値でIllegalArgumentException | E-07 (L179-180) | ○ |
| C-054 | 非ComparableでIllegalArgumentException | E-07 (L181-183) | ○ |
| C-055 | Sort.getTypeが"sort"を返す | E-07 (L37, L127-129) | ○ |
| C-056〜058 | Sortのgetter各種 | E-07 (L106-124) | ○ |
| C-059 | SortOrder.fromString "asc" | E-07 (L70-81) | ○ |
| C-060 | SortOrder.fromString "desc" | E-07 (L70-81) | ○ |
| C-061 | SortOrder.fromString無効値 | E-07 (L80) | ○ |
| C-062 | SortOrder.fromString null | E-07 (L72-73) | ○ |
| C-063 | Sort Factory正常生成 | E-07 (L189-207) | ○ |
| C-064 | Split基本分割 | E-08 (L104-141) | ○ |
| C-065 | Splitソースマップ分割 | E-08 (L120-139) | ○ |
| C-066 | Split targetField指定 | E-08 (L118) | ○ |
| C-067 | 非文字列でIllegalArgumentException | E-08 (L114-115) | ○ |
| C-068 | nullフィールドでIllegalArgumentException | E-08 (L110-111) | ○ |
| C-069 | preserveTrailing=trueで末尾保持 | E-08 (L117) | ○ |
| C-070 | preserveTrailing=falseで末尾除去 | E-08 (L117) | ○ |
| C-071 | Split.getTypeが"split"を返す | E-08 (L35, L99-101) | ○ |
| C-072 | Split Factory正常生成 | E-08 (L147-159) | ○ |
| C-073〜076 | SearchRequestMap.get各プロパティ | E-09 (L52-81) | ○ |
| C-077 | SearchRequestMap.get非Stringキー | E-09 (L53-55) | ○ |
| C-078〜079 | SearchRequestMap.put各プロパティ | E-09 (L93-138) | ○ |
| C-080 | SearchRequestMap.put未サポートキー | E-09 (L127-133) | ○ |
| C-081 | SearchRequestMap.put型不一致 | E-09 (L135-137) | △ |
| C-082〜083 | SearchRequestMap.isEmpty | E-09 (L39-41) | ○ |
| C-084〜085 | BasicMap.containsKey | E-10 (L40-42) | ○ |
| C-086〜096 | BasicMap未サポート操作各種 | E-10 (L32-125) | ○ |
| C-097 | ContextUtils.applyContextPrefixプレフィックスあり | E-11 (L29-37) | ○ |
| C-098 | ContextUtils.applyContextPrefix null | E-11 (L31) | ○ |
| C-099 | ContextUtils.applyContextPrefix空文字 | E-11 (L31) | ○ |
| C-100 | SearchResponseUtil.replaceHits(SearchHits)正常系 | E-12 (L33-71) | ○ |
| C-101 | InternalAggregationsパス | E-12 (L35-47) | △ |
| C-102 | aggregations=nullパス | E-12 (L35) | △ |
| C-103 | 非InternalAggregationsパス | E-12 (L48-58) | △ |
| C-104 | SearchResponseUtil.replaceHits(SearchHit[])正常系 | E-12 (L79-92) | ○ |
| C-105 | hits=nullでIllegalStateException | E-12 (L80-82) | ○ |
| C-106 | Plugin.getRequestProcessors全プロセッサ | E-13 (L73-91) | ○ |
| C-107 | Plugin.getResponseProcessors全プロセッサ | E-13 (L95-112) | ○ |
| C-108 | allowlistフィルタリング | E-13 (L119-141) | ○ |
| C-109 | 不正allowlistでIllegalArgumentException | E-13 (L129-136) | ○ |
| C-110 | getSettingsが3つの設定を返す | E-13 (L58-64) | ○ |
| C-111 | getSearchPhaseResultsProcessors空マップ | E-13 (L115-117) | ○ |
| C-112〜113 | SearchRequestMapProcessingExceptionコンストラクタ | E-14 (L25-38) | ○ |
| C-114〜121 | AclRoutingSearchProcessor各テスト | E-15 (L32-157) | ○ |
| C-122〜131 | HierarchicalRoutingSearchProcessor各テスト | E-16 (L44-321) | ○ |
| C-132〜147 | TemporalRoutingSearchProcessor各テスト | E-17 (L48-419) | ○ |
| C-148〜153 | SearchRequestMap追加プロパティテスト | E-09 (L52-138) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-081: SearchRequestMap.putで型不一致（例: key="size", value="not_integer"）の場合、ClassCastExceptionが発生しcatchブロック(L135)でSearchRequestMapProcessingExceptionにラップされるが、実際のキャスト挙動はJVMの型変換に依存する
  - 候補：実際のテストコード実行による確認 / JDK仕様書
- C-101〜C-103: SearchResponseUtil.replaceHitsのInternalAggregations分岐判定について、テスト環境で非InternalAggregationsのAggregationsオブジェクトを作成する方法が不明確
  - 候補：OpenSearchのテストフレームワーク / モックライブラリ

## 5) リスクフラグ（レビュー観点）
- 0: BasicMapの未サポート操作テスト（C-086〜C-096） -- 単純なUnsupportedOperationExceptionのテストであり低リスク
- 0: getter/定数テスト（C-004, C-011, C-026, C-027〜029, C-046, C-055〜058, C-071, C-120, C-127, C-141） -- 単純な値返却で低リスク
- 1: SearchResponseUtil分岐テスト（C-101〜C-103） -- テスト環境でのモック構成に依存
- 1: TemporalRoutingSearchProcessorのバケット上限（C-137） -- ハードコード値であり将来変更可能性あり
- 1: ScriptRequestProcessorのスクリプト実行テスト（C-007, C-010, C-012, C-013） -- ScriptService依存
- 2: SearchRequestMap.putの型不一致（C-081） -- 例外ラップ挙動の検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] FilterQueryRequestProcessorのprocessRequestがBoolQueryBuilder(filter+must)を正しく構築するテストケースが網羅されているか
- [ ] OversampleRequestProcessorとTruncateHitsResponseProcessorの連携（contextを介したoriginal_size受け渡し）が正しくテストされているか
- [ ] CollapseResponseProcessorの二重collapse防止ロジックが正しくテストされているか
- [ ] SearchRequestMapの全サポートプロパティ（from, size, explain, version, seq_no_primary_term, track_scores, track_total_hits, min_score, terminate_after, profile）のget/putがテストされているか
- [ ] TemporalRoutingSearchProcessorの各粒度（HOUR, DAY, WEEK, MONTH）でのバケット生成が正しくテストされているか
- [ ] AclRoutingSearchProcessorのTermQuery/TermsQueryからのACL値抽出ロジックが正しくテストされているか
- [ ] HierarchicalRoutingSearchProcessorのPrefixQuery/WildcardQuery対応が正しくテストされているか
- [ ] SearchPipelineCommonModulePluginのallowlistフィルタリング動作（設定あり/なし/不正値）が網羅されているか
