---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 54
  claims_with_evidence: 52
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：modules-store-subdirectory 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：52 / 54、根拠なし：2
- 優先レビュー（高）
  1. **C-43 (addSubdirectoryFiles NoSuchFileException以外のIOException)**：visitFileFailed内の分岐に基づくが、実際のIOException発生パターンの網羅性が要確認
  2. **C-47 (深いネストパス解決)**：Path.ofの挙動に基づく推定であり、実際の制限値は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/store-subdirectory/src/main/java/org/opensearch/plugin/store/subdirectory/SubdirectoryAwareStore.java` - メインのStore実装クラス（360行）
- E-02: `modules/store-subdirectory/src/main/java/org/opensearch/plugin/store/subdirectory/SubdirectoryStorePlugin.java` - プラグイン定義クラス（111行）
- E-03: `modules/store-subdirectory/src/main/java/org/opensearch/plugin/store/subdirectory/package-info.java` - パッケージ情報（32行）
- E-04: `modules/store-subdirectory/src/test/java/org/opensearch/plugin/store/subdirectory/SubdirectoryStorePluginTests.java` - 既存テストクラス（参考）
- E-05: `modules/store-subdirectory/src/internalClusterTest/java/org/opensearch/plugin/store/subdirectory/SubdirectoryAwareRecoveryTests.java` - 既存統合テストクラス（参考）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SubdirectoryAwareStore 6引数コンストラクタでSubdirectoryAwareDirectoryが生成される | E-01 (L74-83) | ○ |
| C-02 | SubdirectoryAwareStore 7引数コンストラクタでDirectoryFactoryが設定される | E-01 (L96-114) | ○ |
| C-03 | getMetadataでサブディレクトリなしのメタデータ取得 | E-01 (L117-131) | ○ |
| C-04 | getMetadataでサブディレクトリ内セグメントファイルのメタデータ統合 | E-01 (L117-131, L139-170) | ○ |
| C-05 | getMetadataで非セグメントファイルのメタデータ取得 | E-01 (L127-128, L163-167) | ○ |
| C-06 | getMetadataでIOException発生時のエラー | E-01 (L117) throws IOException宣言 | ○ |
| C-07 | getMetadataでサブディレクトリファイル0件の場合 | E-01 (L144-154) ループが実行されないケース | ○ |
| C-08 | 複数サブディレクトリからのメタデータ統合 | E-01 (L158-160) forループで複数処理 | ○ |
| C-09 | loadSubdirectoryMetadataでのファイル分類ロジック | E-01 (L141-154) segments判定ロジック | ○ |
| C-10 | loadSubdirectoryMetadataでルートファイルスキップ | E-01 (L147) getParent()!=null条件 | ○ |
| C-11 | loadSubdirectoryMetadataで重複ファイルの非追加 | E-01 (L164) containsKey判定 | ○ |
| C-12 | loadMetadataFromSubdirectorySegmentsFileでのメタデータ読み込み | E-01 (L177-199) | ○ |
| C-13 | ファイルパスプレフィックスの付与 | E-01 (L221-229) pathPrefix.resolve | ○ |
| C-14 | 親ディレクトリなしパスで0返却 | E-01 (L183-185) parent==null判定 | ○ |
| C-15 | 存在しないサブディレクトリでIOException | E-01 (L190) FSDirectory.openによるIOException | ○ |
| C-16 | loadMetadataFromSegmentInfosのパスプレフィックス付与 | E-01 (L205-231) | ○ |
| C-17 | StoreFileMetadataフィールドの整合性 | E-01 (L222-228) コンストラクタ引数の転送 | ○ |
| C-18 | computeFileMetadataのchecksum計算 | E-01 (L240-251) CodecUtil.checksumEntireFile | ○ |
| C-19 | computeFileMetadataで存在しないファイルのIOException | E-01 (L242) FSDirectory.openによるIOException | ○ |
| C-20 | SubdirectoryAwareDirectoryコンストラクタ | E-01 (L270-273) | ○ |
| C-21 | openInputでサブディレクトリファイル開封 | E-01 (L276-278) parseFilePath経由 | ○ |
| C-22 | openInputでルートファイル開封 | E-01 (L276-278, L350-358) parseFilePathのルート分岐 | ○ |
| C-23 | openInputで存在しないファイルの例外 | E-01 (L276-278) delegate.openInputの例外伝播 | ○ |
| C-24 | createOutputでサブディレクトリファイル作成 | E-01 (L281-286) | ○ |
| C-25 | createOutputでディレクトリ自動作成 | E-01 (L284) Files.createDirectories | ○ |
| C-26 | createOutputでルートファイル作成 | E-01 (L281-286, L350-358) | ○ |
| C-27 | deleteFileでサブディレクトリファイル削除 | E-01 (L289-291) | ○ |
| C-28 | deleteFileでルートファイル削除 | E-01 (L289-291, L350-358) | ○ |
| C-29 | deleteFileで存在しないファイルの例外 | E-01 (L289-291) delegate.deleteFileの例外伝播 | ○ |
| C-30 | fileLengthでサブディレクトリファイルサイズ取得 | E-01 (L294-296) | ○ |
| C-31 | fileLengthでルートファイルサイズ取得 | E-01 (L294-296, L350-358) | ○ |
| C-32 | fileLengthで存在しないファイルの例外 | E-01 (L294-296) delegate.fileLengthの例外伝播 | ○ |
| C-33 | syncで複数ファイルのパス変換 | E-01 (L299-301) stream().map(parseFilePath) | ○ |
| C-34 | syncで空コレクション | E-01 (L299-301) 空のstreamは問題なし | ○ |
| C-35 | renameでサブディレクトリ間リネーム | E-01 (L304-306) | ○ |
| C-36 | renameでルートファイルリネーム | E-01 (L304-306, L350-358) | ○ |
| C-37 | listAllでルートとサブディレクトリの統合 | E-01 (L309-318) | ○ |
| C-38 | listAllで除外ディレクトリのフィルタリング | E-01 (L261, L331) EXCLUDED_SUBDIRECTORIES | ○ |
| C-39 | listAllでサブディレクトリなしの場合 | E-01 (L309-318) walkFileTreeが空の場合 | ○ |
| C-40 | listAllの結果ソート | E-01 (L317) .sorted() | ○ |
| C-41 | addSubdirectoryFilesでファイルツリー走査 | E-01 (L320-348) walkFileTree | ○ |
| C-42 | addSubdirectoryFilesでルートファイルスキップ | E-01 (L328) getParent()!=null条件 | ○ |
| C-43 | addSubdirectoryFilesでNoSuchFileExceptionスキップ | E-01 (L340-346) visitFileFailed | ○ |
| C-44 | addSubdirectoryFilesでその他IOException再スロー | E-01 (L345) throw e | △ |
| C-45 | parseFilePathでサブディレクトリパス解決 | E-01 (L350-354) getParent()!=null分岐 | ○ |
| C-46 | parseFilePathでルートファイルパス解決 | E-01 (L355-357) resolveIndex分岐 | ○ |
| C-47 | parseFilePathで深いネストパス解決 | E-01 (L350-354) Path.ofの挙動推定 | △ |
| C-48 | SubdirectoryStorePluginコンストラクタ | E-02 (L37-39) | ○ |
| C-49 | getStoreFactoriesでsubdirectory_store登録 | E-02 (L48-52) | ○ |
| C-50 | getStoreFactoriesの不変Map | E-02 (L51) Collections.unmodifiableMap | ○ |
| C-51 | getStoreFactoriesのMapサイズ1 | E-02 (L49-50) map.put1回のみ | ○ |
| C-52 | SubdirectoryStoreFactory.newStore(6引数) | E-02 (L73-83) | ○ |
| C-53 | SubdirectoryStoreFactory.newStore(7引数) | E-02 (L98-109) | ○ |
| C-54 | EXCLUDED_SUBDIRECTORIESの定数値 | E-01 (L261) Set.of定義 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-44: `visitFileFailed`メソッド内でNoSuchFileException以外のIOExceptionが実際にどのような条件で発生するかは、OS・ファイルシステムの実装依存であり、完全な網羅は困難
  - 候補：Permission denied / Disk I/O error / Corrupt filesystem
- C-47: Javaの`Path.of`が非常に深いネストのパスをどこまでサポートするかは、OS・ファイルシステムのパス長制限に依存
  - 候補：OS documentation / Java NIO Path specification

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SubdirectoryStorePlugin関連テスト（C-48〜C-54）は単純なファクトリパターンであり、ロジックの複雑さは低い
- 1: 中リスク - parseFilePathのパス解決ロジック（C-45〜C-47）はOS依存のパスセパレータの違いに注意が必要
- 1: 中リスク - addSubdirectoryFilesのIOException処理（C-43, C-44）は並行処理環境でのファイル削除タイミングに依存
- 0: 低リスク - getMetadata関連テスト（C-03〜C-08）はLuceneのSegmentInfos APIに依存するが、既存のStore基盤で十分にテストされている

## 6) レビュアーチェックリスト（最小）
- [ ] SubdirectoryAwareDirectoryのparseFilePathメソッドが、Windows/Linux/macOSの各OSでパスセパレータを正しく処理するか確認
- [ ] EXCLUDED_SUBDIRECTORIESの値（index/、translog/、_state/）が、OpenSearchの実際のシャードディレクトリ構造と一致するか確認
- [ ] getMetadataのtotalNumDocs計算で、通常セグメントとサブディレクトリセグメントのドキュメント数が二重カウントされないか確認
- [ ] computeFileMetadataで使用されるminimumIndexCompatibilityVersionが、実際のファイルのLuceneバージョンと互換性があるか確認
- [ ] createOutputでFiles.createDirectoriesが失敗した場合のエラーハンドリングが適切か確認
