---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：modules-systemd 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **C-25（Libsystemd.sd_notify unset_environment=1の動作）**：ネイティブ関数のため単体テストでの検証が困難。結合テスト観点。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `modules/systemd/src/main/java/org/opensearch/systemd/SystemdModulePlugin.java` - メインプラグインクラス（159行）
- E-02: `modules/systemd/src/main/java/org/opensearch/systemd/Libsystemd.java` - ネイティブライブラリラッパー（58行）
- E-03: `modules/systemd/src/test/java/org/opensearch/systemd/SystemdModulePluginTests.java` - 既存テストクラス（196行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | esSDNotify=nullの場合enabled=false | E-01 (L75-78), E-03 (L69-74) | ○ |
| C-02 | esSDNotify="true"の場合enabled=true | E-01 (L82), E-03 (L92-97) | ○ |
| C-03 | esSDNotify="false"の場合enabled=false | E-01 (L79-82), E-03 (L76-81) | ○ |
| C-04 | 不正な値でRuntimeExceptionスロー | E-01 (L79-81), E-03 (L83-90) | ○ |
| C-05 | 空文字列でRuntimeExceptionスロー | E-01 (L79-81) | ○ |
| C-06 | isEnabled()がtrueを返す | E-01 (L64-66) | ○ |
| C-07 | isEnabled()がfalseを返す | E-01 (L64-66), E-03 (L72) | ○ |
| C-08 | enabled=falseでextender=null・空リスト返却 | E-01 (L105-108), E-03 (L71-73) | ○ |
| C-09 | enabled=trueでextenderが設定される | E-01 (L116-121), E-03 (L172) | ○ |
| C-10 | 15秒間隔のスケジュールタスク登録 | E-01 (L116-121), E-03 (L65-66) | ○ |
| C-11 | EXTEND_TIMEOUT_USEC=30000000のsd_notify送信 | E-01 (L117) | ○ |
| C-12 | createComponents後にextender取得可能 | E-01 (L87-89), E-03 (L172) | ○ |
| C-13 | createComponents未実行時extender=null | E-01 (L85) | ○ |
| C-14 | sd_notifyがLibsystemd.sd_notifyに委譲 | E-01 (L125-129) | ○ |
| C-15 | onNodeStarted成功時READY=1送信・extenderキャンセル | E-01 (L137-144), E-03 (L92-97) | ○ |
| C-16 | onNodeStarted失敗時RuntimeExceptionスロー | E-01 (L138-141), E-03 (L99-107) | ○ |
| C-17 | enabled=falseでonNodeStartedがsd_notify未呼び出し | E-01 (L133-136), E-03 (L109-111) | ○ |
| C-18 | onNodeStartedでsd_notify戻り値0は成功 | E-01 (L138: rc < 0 のみ失敗) | ○ |
| C-19 | close成功時STOPPING=1送信 | E-01 (L152), E-03 (L121-127) | ○ |
| C-20 | close失敗時warningログ・例外なし | E-01 (L153-155), E-03 (L129-134) | ○ |
| C-21 | enabled=falseでcloseがsd_notify未呼び出し | E-01 (L149-151), E-03 (L137-139) | ○ |
| C-22 | closeでsd_notify戻り値0はwarningなし | E-01 (L153: rc < 0 のみwarning) | ○ |
| C-23 | Libsystemd.sd_notifyが正の値を返す | E-02 (L55-56: Javadoc) | ○ |
| C-24 | Libsystemd.sd_notifyが負の値を返す | E-02 (L55-56: Javadoc) | ○ |
| C-25 | unset_environment=1でNOTIFY_SOCKET解除 | E-02 (L51-53: Javadoc) | △ |
| C-26 | デフォルトコンストラクタがSystem.getenvを使用 | E-01 (L69-71) | ○ |
| C-27 | "True"（大文字混在）でRuntimeExceptionスロー | E-01 (L79: Boolean.TRUE.toString()="true"のみマッチ) | ○ |
| C-28 | "FALSE"（大文字）でRuntimeExceptionスロー | E-01 (L79: Boolean.FALSE.toString()="false"のみマッチ) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-25：`unset_environment=1`の動作はLibsystemdのJavadocに記載があるが、ネイティブ関数（JNA経由）のためJava単体テストでの検証が困難。実環境でのsystemd結合テストが必要。
  - 候補：systemd結合テスト / Linux環境での実行テスト / JNAモック化テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストケース全体の網羅性は高い。2ファイル・計6メソッドに対して28テストケースで主要パスをカバー。
- 1: 中リスク - Libsystemdはネイティブライブラリ呼び出しのため、単体テストでの完全な検証には限界がある。既存テスト（E-03）ではsd_notifyメソッドをオーバーライドしてモック化している。
- 0: 低リスク - SystemdModulePluginの条件分岐は全てソースコードから直接読み取れ、テストケースで網羅されている。

## 6) レビュアーチェックリスト（最小）
- [ ] Libsystemd.sd_notify（C-23〜C-25）のテストケースが結合テスト観点として妥当か確認
- [ ] SystemdModulePluginのコンストラクタ（C-01〜C-05）で全条件分岐がカバーされているか確認
- [ ] onNodeStarted（C-15〜C-18）とclose（C-19〜C-22）の戻り値境界条件（0, 正, 負）が正しいか確認
- [ ] 既存テストクラス（E-03）と生成テストケースの整合性を確認
