---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 163
  claims_with_evidence: 158
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：modules-transport-netty4 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：158 / 163、根拠なし：5
- 優先レビュー（高）
  1. **C-038, C-039（Netty4Transport constructor RecvByteBufAllocator選択）**：FixedRecvByteBufAllocator/AdaptiveRecvByteBufAllocatorの選択ロジックは実行時の設定に依存するため実際の動作確認が必要
  2. **C-140（HttpResponseHeadersFactories newHttp3Aware）**：Http3Utils.isHttp3Available()の実行時可用性に依存
  3. **C-157, C-159（CopyBytesSocketChannel doWrite/doReadBytes）**：ダイレクトバッファ最適化の内部動作は複雑でモック困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `modules/transport-netty4/src/main/java/org/opensearch/transport/SharedGroupFactory.java`
- E-02: `modules/transport-netty4/src/main/java/org/opensearch/transport/NettyAllocator.java`
- E-03: `modules/transport-netty4/src/main/java/org/opensearch/transport/NettyByteBufSizer.java`
- E-04: `modules/transport-netty4/src/main/java/org/opensearch/transport/Netty4ModulePlugin.java`
- E-05: `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/Netty4Transport.java`
- E-06: `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/Netty4TcpChannel.java`
- E-07: `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/Netty4TcpServerChannel.java`
- E-08: `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/Netty4MessageChannelHandler.java`
- E-09: `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/OpenSearchLoggingHandler.java`
- E-10: `modules/transport-netty4/src/main/java/org/opensearch/http/netty4/Netty4HttpRequest.java`
- E-11: `modules/transport-netty4/src/main/java/org/opensearch/http/netty4/Netty4HttpResponse.java`
- E-12: `modules/transport-netty4/src/main/java/org/opensearch/http/netty4/Netty4HttpChannel.java`
- E-13: `modules/transport-netty4/src/main/java/org/opensearch/http/netty4/Netty4HttpPipeliningHandler.java`
- E-14: `modules/transport-netty4/src/main/java/org/opensearch/http/netty4/Netty4HttpServerChannel.java`
- E-15: `modules/transport-netty4/src/main/java/org/opensearch/http/netty4/Netty4HttpRequestCreator.java`
- E-16: `modules/transport-netty4/src/main/java/org/opensearch/http/netty4/Netty4HttpResponseCreator.java`
- E-17: `modules/transport-netty4/src/main/java/org/opensearch/http/netty4/Netty4HttpRequestHandler.java`
- E-18: `modules/transport-netty4/src/main/java/org/opensearch/http/netty4/HttpResponseHeadersFactory.java`
- E-19: `modules/transport-netty4/src/main/java/org/opensearch/http/netty4/HttpResponseHeadersFactories.java`
- E-20: `modules/transport-netty4/src/main/java/org/opensearch/http/netty4/Netty4HttpServerTransport.java`
- E-21: `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/ssl/DualModeSslHandler.java`
- E-22: `modules/transport-netty4/src/main/java/org/opensearch/transport/netty4/ssl/SecureNetty4Transport.java`
- E-23: `modules/transport-netty4/src/main/java/org/opensearch/transport/CopyBytesSocketChannel.java`
- E-24: `modules/transport-netty4/src/main/java/org/opensearch/transport/CopyBytesServerSocketChannel.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | SharedGroupFactory constructorの正常初期化 | E-01 L59-74 | ○ |
| C-002 | SharedGroupFactory getSettingsの返却 | E-01 L76-78 | ○ |
| C-003 | SharedGroupFactory getTransportWorkerCountの返却 | E-01 L80-82 | ○ |
| C-004 | SharedGroupFactory getTransportGroupの返却 | E-01 L84-86 | ○ |
| C-005 | SharedGroupFactory getHttpGroup(httpWorkerCount=0) | E-01 L88-101 | ○ |
| C-006 | SharedGroupFactory getHttpGroup(httpWorkerCount>0)で専用グループ | E-01 L88-101 | ○ |
| C-007 | SharedGroupFactory getHttpGroupの複数回呼び出しでシングルトン | E-01 L92 | ○ |
| C-008 | SharedGroup shutdownの正常動作 | E-01 L156-159 | ○ |
| C-009 | SharedGroup shutdown二重呼び出し防止 | E-01 L157 (AtomicBoolean isOpen) | ○ |
| C-010 | SharedGroup getLowLevelGroupの返却 | E-01 L152-154 | ○ |
| C-011 | NettyAllocator getAllocator()の返却 | E-02 L166-168 | ○ |
| C-012 | NettyAllocator getAllocator(false)の返却 | E-02 L158-164 | ○ |
| C-013 | NettyAllocator getAllocator(true)のdelegate返却 | E-02 L159-160 | ○ |
| C-014 | NettyAllocator suggestedMaxAllocationSize | E-02 L170-172 | ○ |
| C-015 | NettyAllocator getAllocatorDescription | E-02 L174-176 | ○ |
| C-016 | NettyAllocator getChannelType | E-02 L178-184 | ○ |
| C-017 | NettyAllocator getServerChannelType | E-02 L186-192 | ○ |
| C-018 | NoDirectBuffers buffer()がヒープバッファ返却 | E-02 L244-246 | ○ |
| C-019 | NoDirectBuffers buffer(int)がヒープバッファ返却 | E-02 L249-251 | ○ |
| C-020 | NoDirectBuffers directBuffer()がUnsupportedOperationException | E-02 L289-291 | ○ |
| C-021 | NoDirectBuffers directBuffer(int)がUnsupportedOperationException | E-02 L294-296 | ○ |
| C-022 | NoDirectBuffers directBuffer(int,int)がUnsupportedOperationException | E-02 L299-301 | ○ |
| C-023 | NoDirectBuffers compositeBuffer()がヒープ返却 | E-02 L304-306 | ○ |
| C-024 | NoDirectBuffers compositeDirectBuffer()がUnsupportedOperationException | E-02 L324-326 | ○ |
| C-025 | NoDirectBuffers isDirectBufferPooled false | E-02 L334-337 | ○ |
| C-026 | NoDirectBuffers ioBuffer()がヒープ返却 | E-02 L259-261 | ○ |
| C-027 | NoDirectBuffers getDelegateの返却 | E-02 L344-346 | ○ |
| C-028 | NettyByteBufSizer decode capacity>=1024リサイズ | E-03 L46-55 | ○ |
| C-029 | NettyByteBufSizer decode capacity<1024そのまま | E-03 L46-55 | ○ |
| C-030 | NettyByteBufSizer decode 境界値capacity=1024 | E-03 L48 | ○ |
| C-031 | NettyByteBufSizer decode 境界値capacity=1023 | E-03 L48 | ○ |
| C-032 | NettyByteBufSizer decode readableBytes=0 | E-03 L47 | ○ |
| C-033 | Netty4ModulePlugin getSettingsの返却 | E-04 L80-91 | ○ |
| C-034 | Netty4ModulePlugin additionalSettingsのデフォルト | E-04 L94-101 | ○ |
| C-035 | Netty4ModulePlugin getTransportsの登録 | E-04 L104-127 | ○ |
| C-036 | Netty4ModulePlugin getHttpTransportsの登録 | E-04 L130-156 | ○ |
| C-037 | Netty4ModulePlugin getSharedGroupFactoryのシングルトン | E-04 L249-258 | ○ |
| C-038 | Netty4Transport constructor FixedRecvByteBufAllocator選択 | E-05 L146-148 | △ |
| C-039 | Netty4Transport constructor AdaptiveRecvByteBufAllocator選択 | E-05 L149-154 | △ |
| C-040 | Netty4Transport getServerChannelInitializer | E-05 L301-303 | ○ |
| C-041 | Netty4Transport getClientChannelInitializer | E-05 L305-307 | ○ |
| C-042 | Netty4Transport initiateChannel正常系 | E-05 L313-330 | ○ |
| C-043 | Netty4Transport initiateChannel異常系 | E-05 L321-324 | ○ |
| C-044 | Netty4Transport stopInternal | E-05 L342-348 | ○ |
| C-045 | Netty4TcpChannel constructor | E-06 L59-66 | ○ |
| C-046 | Netty4TcpChannel isServerChannel true | E-06 L120-122 | ○ |
| C-047 | Netty4TcpChannel isServerChannel false | E-06 L120-122 | ○ |
| C-048 | Netty4TcpChannel getProfile | E-06 L125-127 | ○ |
| C-049 | Netty4TcpChannel isOpen | E-06 L145-147 | ○ |
| C-050 | Netty4TcpChannel close | E-06 L115-117 | ○ |
| C-051 | Netty4TcpChannel getLocalAddress | E-06 L150-152 | ○ |
| C-052 | Netty4TcpChannel getRemoteAddress | E-06 L155-157 | ○ |
| C-053 | Netty4TcpChannel sendMessage正常系 | E-06 L160-166 | ○ |
| C-054 | Netty4TcpChannel sendMessageシャットダウン時 | E-06 L163-165 | ○ |
| C-055 | Netty4TcpChannel get正常系 | E-06 L170-178 | ○ |
| C-056 | Netty4TcpChannel get存在しないハンドラ | E-06 L170-178 | ○ |
| C-057 | Netty4TcpChannel addListener成功 | E-06 L73-87 | ○ |
| C-058 | Netty4TcpChannel addListener失敗 | E-06 L73-87 | ○ |
| C-059 | Netty4TcpChannel addListener Error | E-06 L79-82 | ○ |
| C-060 | Netty4TcpChannel addPromise成功 | E-06 L96-112 | ○ |
| C-061 | Netty4TcpChannel addPromise失敗 | E-06 L96-112 | ○ |
| C-062 | Netty4TcpServerChannel constructor | E-07 L48-51 | ○ |
| C-063 | Netty4TcpServerChannel getLocalAddress | E-07 L54-56 | ○ |
| C-064 | Netty4TcpServerChannel isOpen | E-07 L69-71 | ○ |
| C-065 | Netty4TcpServerChannel close | E-07 L59-61 | ○ |
| C-066 | Netty4MessageChannelHandler channelRead | E-08 L86-97 | ○ |
| C-067 | Netty4MessageChannelHandler exceptionCaught正常 | E-08 L100-111 | ○ |
| C-068 | Netty4MessageChannelHandler exceptionCaught Error | E-08 L106-107 | ○ |
| C-069 | Netty4MessageChannelHandler write | E-08 L114-120 | ○ |
| C-070 | Netty4MessageChannelHandler flush writable | E-08 L132-138 | ○ |
| C-071 | Netty4MessageChannelHandler flush非アクティブ | E-08 L148-157 | ○ |
| C-072 | Netty4MessageChannelHandler channelInactive | E-08 L141-146 | ○ |
| C-073 | OpenSearchLoggingHandler constructor | E-09 L41-43 | ○ |
| C-074 | OpenSearchLoggingHandler channelReadComplete | E-09 L46-49 | ○ |
| C-075 | Netty4HttpRequest method GET | E-10 L125-127 | ○ |
| C-076 | Netty4HttpRequest method POST | E-10 L129-130 | ○ |
| C-077 | Netty4HttpRequest method 全メソッド | E-10 L125-155 | ○ |
| C-078 | Netty4HttpRequest method 未知メソッド | E-10 L155 | ○ |
| C-079 | Netty4HttpRequest uri | E-10 L159-161 | ○ |
| C-080 | Netty4HttpRequest content | E-10 L164-167 | ○ |
| C-081 | Netty4HttpRequest release pooled=true | E-10 L170-174 | ○ |
| C-082 | Netty4HttpRequest release pooled=false | E-10 L171 | ○ |
| C-083 | Netty4HttpRequest release二重呼び出し | E-10 L171 (AtomicBoolean) | ○ |
| C-084 | Netty4HttpRequest releaseAndCopy pooled=true | E-10 L177-202 | ○ |
| C-085 | Netty4HttpRequest releaseAndCopy pooled=false | E-10 L179-181 | ○ |
| C-086 | Netty4HttpRequest getHeaders | E-10 L205-207 | ○ |
| C-087 | Netty4HttpRequest strictCookies Cookie存在 | E-10 L210-219 | ○ |
| C-088 | Netty4HttpRequest strictCookies Cookie不在 | E-10 L211-218 | ○ |
| C-089 | Netty4HttpRequest protocolVersion HTTP/1.0 | E-10 L222-223 | ○ |
| C-090 | Netty4HttpRequest protocolVersion HTTP/1.1 | E-10 L225-226 | ○ |
| C-091 | Netty4HttpRequest protocolVersion 未知 | E-10 L232 | ○ |
| C-092 | Netty4HttpRequest removeHeader | E-10 L237-260 | ○ |
| C-093 | Netty4HttpRequest createResponse | E-10 L263-267 | ○ |
| C-094 | Netty4HttpRequest getInboundException存在 | E-10 L270-272 | ○ |
| C-095 | Netty4HttpRequest getInboundException不在 | E-10 L106-122 | ○ |
| C-096 | HttpHeadersMap size | E-10 L296-298 | ○ |
| C-097 | HttpHeadersMap isEmpty | E-10 L300-302 | ○ |
| C-098 | HttpHeadersMap containsKey存在 | E-10 L305-307 | ○ |
| C-099 | HttpHeadersMap containsKey不正型 | E-10 L306 | ○ |
| C-100 | HttpHeadersMap put UnsupportedOperationException | E-10 L320-322 | ○ |
| C-101 | HttpHeadersMap remove UnsupportedOperationException | E-10 L325-327 | ○ |
| C-102 | HttpHeadersMap clear UnsupportedOperationException | E-10 L335-337 | ○ |
| C-103 | Netty4HttpResponse constructor | E-11 L49-52 | ○ |
| C-104 | Netty4HttpResponse addHeader | E-11 L55-57 | ○ |
| C-105 | Netty4HttpResponse containsHeader存在 | E-11 L60-62 | ○ |
| C-106 | Netty4HttpResponse containsHeader不在 | E-11 L60-62 | ○ |
| C-107 | Netty4HttpResponse requestHeaders | E-11 L64-66 | ○ |
| C-108 | Netty4HttpChannel constructor | E-12 L65-82 | ○ |
| C-109 | Netty4HttpChannel sendResponse | E-12 L85-87 | ○ |
| C-110 | Netty4HttpChannel getLocalAddress | E-12 L90-96 | ○ |
| C-111 | Netty4HttpChannel getRemoteAddress | E-12 L99-111 | ○ |
| C-112 | Netty4HttpChannel getRemoteAddress QUIC対応 | E-12 L99-111 | ○ |
| C-113 | Netty4HttpChannel isOpen | E-12 L119-121 | ○ |
| C-114 | Netty4HttpChannel close | E-12 L124-126 | ○ |
| C-115 | Netty4HttpChannel get channelプロパティ | E-12 L138-141 | ○ |
| C-116 | Netty4HttpChannel get ssl_engineプロパティ | E-12 L143-153 | ○ |
| C-117 | Netty4HttpChannel get不在プロパティ | E-12 L155-165 | ○ |
| C-118 | Netty4HttpChannel inboundPipeline存在 | E-12 L128-130 | ○ |
| C-119 | Netty4HttpChannel inboundPipeline不在 | E-12 L65-67, L79 | ○ |
| C-120 | Netty4HttpPipeliningHandler channelRead | E-13 L69-73 | ○ |
| C-121 | Netty4HttpPipeliningHandler write順序保証 | E-13 L76-93 | ○ |
| C-122 | Netty4HttpPipeliningHandler write IllegalStateException | E-13 L86-92 | ○ |
| C-123 | Netty4HttpPipeliningHandler closeインフライト処理 | E-13 L96-110 | ○ |
| C-124 | Netty4HttpPipeliningHandler close空キュー | E-13 L99 | ○ |
| C-125 | Netty4HttpServerChannel constructor | E-14 L49-52 | ○ |
| C-126 | Netty4HttpServerChannel getLocalAddress | E-14 L55-57 | ○ |
| C-127 | Netty4HttpServerChannel isOpen | E-14 L65-67 | ○ |
| C-128 | Netty4HttpServerChannel close | E-14 L60-62 | ○ |
| C-129 | Netty4HttpRequestCreator decode正常 | E-15 L53-67 | ○ |
| C-130 | Netty4HttpRequestCreator decodeデコード失敗 | E-15 L54-63 | ○ |
| C-131 | Netty4HttpRequestCreator decodeデコード失敗Error | E-15 L57-59 | ○ |
| C-132 | Netty4HttpResponseCreator encode小レスポンス | E-16 L68-80 | ○ |
| C-133 | Netty4HttpResponseCreator encode大レスポンス分割 | E-16 L71-79 | ○ |
| C-134 | Netty4HttpRequestHandler channelRead0 | E-17 L56-67 | ○ |
| C-135 | Netty4HttpRequestHandler channelRead0例外時リリース | E-17 L62-65 | ○ |
| C-136 | Netty4HttpRequestHandler exceptionCaught | E-17 L70-78 | ○ |
| C-137 | Netty4HttpRequestHandler exceptionCaught Error | E-17 L73-74 | ○ |
| C-138 | HttpResponseHeadersFactories newDefault | E-19 L111-118 | ○ |
| C-139 | HttpResponseHeadersFactories newHttp2Aware | E-19 L89-91 | ○ |
| C-140 | HttpResponseHeadersFactories newHttp3Aware有効 | E-19 L99-105 | △ |
| C-141 | HttpResponseHeadersFactories newHttp3Aware無効 | E-19 L103-104 | ○ |
| C-142 | Netty4HttpServerTransport constructor | E-20 L214-253 | ○ |
| C-143 | Netty4HttpServerTransport settings | E-20 L255-257 | ○ |
| C-144 | Netty4HttpServerTransport onException ReadTimeout | E-20 L352-358 | ○ |
| C-145 | Netty4HttpServerTransport onException一般 | E-20 L356-357 | ○ |
| C-146 | Netty4HttpServerTransport configureServerChannelHandler | E-20 L360-362 | ○ |
| C-147 | Netty4HttpServerTransport createHeaderVerifier | E-20 L580-583 | ○ |
| C-148 | Netty4HttpServerTransport createDecompressor | E-20 L590-592 | ○ |
| C-149 | DualModeSslHandler decode DualModeハンドシェイク | E-21 L68-79 | ○ |
| C-150 | DualModeSslHandler decode TLS検出 | E-21 L82-84 | ○ |
| C-151 | DualModeSslHandler decode 非TLS | E-21 L86-88 | ○ |
| C-152 | DualModeSslHandler decode バッファ不足 | E-21 L70-72 | ○ |
| C-153 | SecureNetty4Transport onException DecoderException | E-22 L107-122 | ○ |
| C-154 | SecureNetty4Transport onException 無効チャネル | E-22 L118-120 | ○ |
| C-155 | SecureNetty4Transport getServerChannelInitializer | E-22 L125-127 | ○ |
| C-156 | SecureNetty4Transport getClientChannelInitializer | E-22 L130-132 | ○ |
| C-157 | CopyBytesSocketChannel doWrite | E-23 L94-132 | △ |
| C-158 | CopyBytesSocketChannel doWrite空バッファ | E-23 L97-101 | ○ |
| C-159 | CopyBytesSocketChannel doReadBytes | E-23 L135-147 | △ |
| C-160 | CopyBytesSocketChannel doReadBytes 0以下 | E-23 L143-145 | ○ |
| C-161 | CopyBytesServerSocketChannel doReadMessages接続あり | E-24 L67-86 | ○ |
| C-162 | CopyBytesServerSocketChannel doReadMessages接続なし | E-24 L71 | ○ |
| C-163 | CopyBytesServerSocketChannel doReadMessages例外 | E-24 L75-83 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-038, C-039: Netty4Transportコンストラクタ内のRecvByteBufAllocator選択ロジックは設定値に依存しており、テスト時のSettings設定方法によって動作が変わる可能性がある
  - 候補：既存テストコードの確認 / Netty4Transport設定のデフォルト値調査
- C-140: Http3Utils.isHttp3Available()はクラスパスに依存するランタイムチェックであり、テスト環境でのHTTP/3可用性が不明
  - 候補：Http3Utils実装の確認 / テスト環境のクラスパス構成確認
- C-157, C-159: CopyBytesSocketChannelのdoWrite/doReadBytesはNIO SocketChannel操作を含み、モック化が困難な低レベル処理
  - 候補：既存のCopyBytesSocketChannelテストコード確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケース（getter/setter、基本的な状態確認、例外処理）はソースコードから直接確認可能
- 1: 中リスク - ネットワーク関連テスト（C-042, C-053, C-109）はNettyのモック/エンベデッドチャネルが必要
- 1: 中リスク - SSL関連テスト（C-149-C-156）はSSL設定の準備が必要
- 1: 中リスク - CopyBytesSocketChannel（C-157-C-160）はNIOレベルの操作をテストする必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] SharedGroupFactoryのgetHttpGroupテスト(C-005, C-006)がhttpWorkerCount=0と>0の両方をカバーしているか確認
- [ ] NoDirectBuffersの全directBuffer系メソッド(C-020-C-022, C-024)がUnsupportedOperationExceptionをスローするテストが正しいか確認
- [ ] Netty4HttpRequestのmethod()テスト(C-075-C-078)が全HTTPメソッド(GET/POST/PUT/DELETE/HEAD/OPTIONS/PATCH/TRACE/CONNECT)をカバーしているか確認
- [ ] Netty4TcpChannelのaddListener/addPromise静的メソッドのテスト(C-057-C-061)がSuccess/Failure/Errorの3パターンをカバーしているか確認
- [ ] Netty4HttpPipeliningHandlerの順序保証テスト(C-121)の入力パターンが十分か確認
- [ ] DualModeSslHandlerのdecode(C-149-C-152)がTLS/非TLS/DualMode/バッファ不足の4パターンをカバーしているか確認
- [ ] CopyBytesSocketChannelのdoWrite/doReadBytesテスト(C-157-C-160)が実行可能な方法でモック化されているか確認
