---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 117
  claims_with_evidence: 112
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：plugins-analysis-icu 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：112 / 117、根拠なし：5
- 優先レビュー（高）
  1. **C-062**：IcuTransformTokenFilterFactory で不正ID指定時の例外型が推測（Transliterator.getInstanceのJavadocに依存）
  2. **C-029**：不正UnicodeSetパターンの例外型が推測
  3. **C-073-075**：IndexableBinaryStringTools のラウンドトリップテストは実装詳細に基づく推測
  4. **C-034**：バッファリサイズの動作はencodedLengthとtermBuffer.lengthの比較ロジックに依存
  5. **C-039**：外部ルールファイル読み込みはファイルI/Oに依存するため実行時環境に左右される

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/analysis-icu/src/main/java/org/opensearch/plugin/analysis/icu/AnalysisICUPlugin.java`
- E-02: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuFoldingTokenFilterFactory.java`
- E-03: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuAnalyzerProvider.java`
- E-04: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuTokenizerFactory.java`
- E-05: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuNormalizerCharFilterFactory.java`
- E-06: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuNormalizerTokenFilterFactory.java`
- E-07: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/ICUCollationKeyFilter.java`
- E-08: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuCollationTokenFilterFactory.java`
- E-09: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuTransformTokenFilterFactory.java`
- E-10: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IndexableBinaryStringTools.java`
- E-11: `plugins/analysis-icu/src/main/java/org/opensearch/index/mapper/ICUCollationKeywordFieldMapper.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | getCharFiltersがicu_normalizerキーを返す | E-01 L65-67 singletonMap("icu_normalizer", ...) | ○ |
| C-002 | getTokenFiltersが4つのキーを返す | E-01 L70-77 extra.put()x4 | ○ |
| C-003 | getAnalyzersがicu_analyzerキーを返す | E-01 L80-82 singletonMap("icu_analyzer", ...) | ○ |
| C-004 | getTokenizersがicu_tokenizerキーを返す | E-01 L85-87 singletonMap("icu_tokenizer", ...) | ○ |
| C-005 | getMappersがicu_collation_keywordを返す | E-01 L90-92 CONTENT_TYPE定数使用 | ○ |
| C-006 | getNamedWriteablesがCOLLATE_FORMATを返す | E-01 L95-103 | ○ |
| C-007 | IcuFoldingTokenFilterFactoryデフォルト生成 | E-02 L65-68 ICU_FOLDING_NORMALIZER使用 | ○ |
| C-008 | unicodeSetFilter指定でFilteredNormalizer2使用 | E-06 L63-72 wrapWithUnicodeSetFilter | ○ |
| C-009 | create()でICUNormalizer2Filter生成 | E-02 L71-73 | ○ |
| C-010 | IcuAnalyzerProviderデフォルト設定 | E-03 L53-54 settings.get("method", "nfkc_cf"), settings.get("mode", "compose") | ○ |
| C-011 | decomposeモード設定 | E-03 L55-63 "compose"/"decompose"分岐 | ○ |
| C-012 | 不正mode時IllegalArgumentException | E-03 L55-58 条件分岐で例外スロー | ○ |
| C-013 | Analyzer構成要素の確認 | E-03 L69-83 initReader/createComponents | ○ |
| C-014 | IcuTokenizerFactoryデフォルト（rule_files未指定） | E-04 L62-65, L77-94 ruleFiles空ならnull返却 | ○ |
| C-015 | rule_files指定でカスタムconfig | E-04 L82-113 パース・BreakIterator生成 | ○ |
| C-016 | 不正rule_filesフォーマットで例外 | E-04 L84-85 colonPos==-1チェック | ○ |
| C-017 | コロン後空文字で例外 | E-04 L84 colonPos==length-1チェック | ○ |
| C-018 | config未設定時デフォルトICUTokenizer | E-04 L68-74 config==nullチェック | ○ |
| C-019 | config設定時カスタムICUTokenizer | E-04 L72 new ICUTokenizer(config) | ○ |
| C-020 | IcuNormalizerCharFilterFactoryデフォルト | E-05 L55-59 settings.get("name", "nfkc_cf"), mode判定 | ○ |
| C-021 | decompose mode設定 | E-05 L57 "decompose"分岐 | ○ |
| C-022 | 不正mode時composeフォールバック | E-05 L57-59 compose/decompose以外はcompose | ○ |
| C-023 | create()でICUNormalizer2CharFilter生成 | E-05 L69-71 | ○ |
| C-024 | IcuNormalizerTokenFilterFactoryデフォルト | E-06 L53 settings.get("name", "nfkc_cf") | ○ |
| C-025 | カスタムmethod指定 | E-06 L53 settings.get("name", ...) | ○ |
| C-026 | create()でICUNormalizer2Filter生成 | E-06 L59-61 | ○ |
| C-027 | wrapWithUnicodeSetFilter未指定時元のNormalizer返却 | E-06 L64-71 unicodeSetFilter==null | ○ |
| C-028 | wrapWithUnicodeSetFilter指定時FilteredNormalizer2 | E-06 L65-69 | ○ |
| C-029 | 不正UnicodeSetパターンで例外 | E-06 L66 new UnicodeSet(unicodeSetFilter)の挙動推測 | △ |
| C-030 | ICUCollationKeyFilterコンストラクタでCollatorクローン | E-07 L93-101 collator.clone() | ○ |
| C-031 | incrementTokenでCollationKey変換 | E-07 L104-119 getRawCollationKey+encode | ○ |
| C-032 | 複数トークン連続処理 | E-07 L105 input.incrementToken()ループ | ○ |
| C-033 | 空TokenStreamでfalse返却 | E-07 L117 else return false | ○ |
| C-034 | バッファリサイズ動作 | E-07 L110-112 encodedLength > termBuffer.length | ○ |
| C-035 | IcuCollationTokenFilterFactoryデフォルト | E-08 L92-109 language==null時ULocale.ROOT | ○ |
| C-036 | language指定 | E-08 L92-106 language!=null分岐 | ○ |
| C-037 | language+country指定 | E-08 L96-101 country!=null分岐 | ○ |
| C-038 | language+country+variant指定 | E-08 L97-99 variant!=null分岐 | ○ |
| C-039 | rulesファイル指定でRuleBasedCollator | E-08 L71-90 rules!=null分岐 | ○ |
| C-040 | 不正rules内容で例外 | E-08 L81-89 RuleBasedCollator例外処理 | ○ |
| C-041 | strength=primary | E-08 L115-116 | ○ |
| C-042 | strength=secondary | E-08 L117-118 | ○ |
| C-043 | strength=tertiary | E-08 L119-120 | ○ |
| C-044 | strength=quaternary | E-08 L121-122 | ○ |
| C-045 | strength=identical | E-08 L123-124 | ○ |
| C-046 | 不正strength例外 | E-08 L125-127 | ○ |
| C-047 | decomposition=no | E-08 L133-134 | ○ |
| C-048 | decomposition=canonical | E-08 L135-136 | ○ |
| C-049 | 不正decomposition例外 | E-08 L137-139 | ○ |
| C-050 | alternate=shifted | E-08 L146-147 | ○ |
| C-051 | alternate=non-ignorable | E-08 L148-149 | ○ |
| C-052 | 不正alternate例外 | E-08 L150-152 | ○ |
| C-053 | caseLevel=true | E-08 L155-158 | ○ |
| C-054 | caseFirst=lower | E-08 L162-163 | ○ |
| C-055 | caseFirst=upper | E-08 L164-165 | ○ |
| C-056 | 不正caseFirst例外 | E-08 L166-168 | ○ |
| C-057 | numeric=true | E-08 L171-174 | ○ |
| C-058 | create()でICUCollationKeyFilter生成 | E-08 L190-192 | ○ |
| C-059 | IcuTransformTokenFilterFactoryデフォルト | E-09 L50-53 id="Null", dir="forward" | ○ |
| C-060 | カスタムid指定 | E-09 L50 settings.get("id", "Null") | ○ |
| C-061 | dir=reverse | E-09 L51-52 | ○ |
| C-062 | 不正id指定で例外 | E-09 L53 Transliterator.getInstance挙動推測 | △ |
| C-063 | create()でICUTransformFilter生成 | E-09 L57-59 | ○ |
| C-064 | getEncodedLength計算式 | E-10 L82-83 (8L*inputLength+14L)/15L+1 | ○ |
| C-065 | getEncodedLength入力長0 | E-10 L82-83 計算結果=1 | ○ |
| C-066 | getEncodedLength入力長1 | E-10 L82-83 計算結果=2 | ○ |
| C-067 | getDecodedLength正常計算 | E-10 L94-103 | ○ |
| C-068 | getDecodedLength length=0 | E-10 L96-97 numChars<=0で0返却 | ○ |
| C-069 | getDecodedLength length=1 | E-10 L96-97 numChars=0で0返却 | ○ |
| C-070 | encode基本動作 | E-10 L118-157 | ○ |
| C-071 | encode空入力 | E-10 L120 inputLength>0チェック | ○ |
| C-072 | decode基本動作 | E-10 L172-222 | ○ |
| C-073 | ラウンドトリップテスト | E-10 encode/decodeの組合せ動作推測 | △ |
| C-074 | ヌルバイト配列ラウンドトリップ | E-10 encode/decodeの組合せ動作推測 | △ |
| C-075 | 最大バイト値配列ラウンドトリップ | E-10 encode/decodeの組合せ動作推測 | △ |
| C-076 | Builder.buildCollatorデフォルト | E-11 L389-413, L482 freeze() | ○ |
| C-077 | Builder.buildCollator language指定 | E-11 L398-409 | ○ |
| C-078 | Builder.buildCollator rules指定 | E-11 L391-395 | ○ |
| C-079 | Builder.buildCollator不正rules例外 | E-11 L394-395 | ○ |
| C-080 | Builder.buildCollator全strength値 | E-11 L416-430 | ○ |
| C-081 | Builder.buildCollator不正strength例外 | E-11 L427-429 | ○ |
| C-082 | Builder.buildCollator不正decomposition例外 | E-11 L438-440 | ○ |
| C-083 | Builder.buildCollator不正alternate例外 | E-11 L450-452 | ○ |
| C-084 | Builder.buildCollator不正caseFirst例外 | E-11 L464-466 | ○ |
| C-085 | Collatorがfrozen状態 | E-11 L482 collator.freeze() | ○ |
| C-086 | ignoreAbove正値 | E-11 L268-273 | ○ |
| C-087 | ignoreAbove負値例外 | E-11 L269-271 | ○ |
| C-088 | indexOptions DOCS以下 | E-11 L258-266 | ○ |
| C-089 | indexOptions positions不可 | E-11 L259-262 DOCS_AND_FREQS超過チェック | ○ |
| C-090 | typeName返却値 | E-11 L118-120 CONTENT_TYPE="icu_collation_keyword" | ○ |
| C-091 | indexedValueForSearch文字列入力 | E-11 L147-161 | ○ |
| C-092 | indexedValueForSearch BytesRef入力 | E-11 L151-153 instanceof BytesRef | ○ |
| C-093 | indexedValueForSearch null入力 | E-11 L148-149 | ○ |
| C-094 | fuzzyQuery UnsupportedOperationException | E-11 L164-173 | ○ |
| C-095 | prefixQuery UnsupportedOperationException | E-11 L176-179 | ○ |
| C-096 | wildcardQuery UnsupportedOperationException | E-11 L182-189 | ○ |
| C-097 | regexpQuery UnsupportedOperationException | E-11 L192-201 | ○ |
| C-098 | valueFetcher format未指定 | E-11 L123-138 | ○ |
| C-099 | valueFetcher format指定で例外 | E-11 L124-126 | ○ |
| C-100 | COLLATE_FORMAT.format | E-11 L213-218 | ○ |
| C-101 | COLLATE_FORMAT.parseBytesRef | E-11 L221-227 | ○ |
| C-102 | COLLATE_FORMAT.getWriteableName | E-11 L205-207 | ○ |
| C-103 | parseCreateField通常値 | E-11 L795-825 | ○ |
| C-104 | parseCreateField VALUE_NULL | E-11 L801-803 | ○ |
| C-105 | parseCreateField externalValue | E-11 L797-798 | ○ |
| C-106 | parseCreateField null時スキップ | E-11 L808-809 | ○ |
| C-107 | parseCreateField ignoreAbove超過スキップ | E-11 L808 value.length() > ignoreAbove | ○ |
| C-108 | mergeOptions同一Collator | E-11 L673-727 | ○ |
| C-109 | mergeOptions異なるCollator | E-11 L675-676 | ○ |
| C-110 | mergeOptions全パラメータ変更不可 | E-11 L678-724 | ○ |
| C-111 | contentType返却値 | E-11 L668-669 | ○ |
| C-112 | TypeParser基本動作 | E-11 L525-602 | ○ |
| C-113 | TypeParser全パラメータパース | E-11 L532-598 switchステートメント | ○ |
| C-114 | TypeParser null_value null例外 | E-11 L534-536 | ○ |
| C-115 | doXContentBody設定済みパラメータ出力 | E-11 L730-792 各if分岐 | ○ |
| C-116 | doXContentBody includeDefaults=true全出力 | E-11 L730-792 includeDefaults || 条件 | ○ |
| C-117 | docValueFormat返却値 | E-11 L231-233 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-029：UnicodeSetコンストラクタに不正パターンを渡した際の正確な例外型はICU4Jの実装に依存する。ソースコードからは例外がスローされることは分かるが、具体的な例外型はICU4JのJavadocを要確認。
  - 候補：IllegalArgumentException / ICU4JのIllegalIcuArgumentException
- C-062：Transliterator.getInstanceに不正IDを渡した場合の挙動はICU4Jの実装に依存する。
  - 候補：IllegalArgumentException / ICU4Jの内部例外
- C-073, C-074, C-075：IndexableBinaryStringToolsのエンコード/デコードのラウンドトリップ完全性は実装のビット操作ロジックに基づく推測であり、実行テストでの確認が望ましい。
  - 候補：既存テストコードの確認 / 手動でのバイト列変換検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - AnalysisICUPluginの登録メソッド群（C-001〜C-006）：ソースコードから直接確認可能
- 0: 低リスク - 各ファクトリのcreate()メソッド（C-009, C-023, C-026, C-058, C-063）：戻り値が明確
- 1: 中リスク - IcuCollationTokenFilterFactoryの多数の設定オプション（C-035〜C-057）：組合せテストが必要な可能性
- 1: 中リスク - ICUCollationKeywordFieldMapper.Builder.buildCollator（C-076〜C-085）：IcuCollationTokenFilterFactoryと類似ロジックだが独立実装
- 1: 中リスク - IndexableBinaryStringToolsのビット操作（C-064〜C-075）：エッジケースでの正確性要確認
- 2: 高リスク - 外部ライブラリ（ICU4J）への依存部分（C-029, C-062）：例外型の正確性が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] IcuCollationTokenFilterFactoryとICUCollationKeywordFieldMapper.BuilderのCollator生成ロジックが同等であることの確認
- [ ] IndexableBinaryStringToolsのencode/decodeラウンドトリップがエッジケース（0x00, 0xFF, 大きなバイト配列）で正しく動作するか
- [ ] ICU4J依存部分（UnicodeSet, Transliterator）の例外型の正確性確認
- [ ] IcuNormalizerCharFilterFactoryの不正mode処理（フォールバック）とIcuAnalyzerProviderの不正mode処理（例外スロー）の動作差異が意図的かの確認
- [ ] parseCreateFieldメソッドのnullValue/ignoreAbove/externalValueの組合せテストの網羅性確認
