---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 69
  claims_with_evidence: 67
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：plugins-analysis-kuromoji 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：67 / 69、根拠なし：2
- 優先レビュー（高）
  1. **C-24 (UT-KUR-024)**: nBestExamplesによるnBestCost計算の具体的な期待値が不明確
  2. **C-66 (UT-KUR-066)**: 空リスト時のAnalysis.parseWordListの戻り値がnullか空リストかソースコードからは間接的にしか判断できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/analysis-kuromoji/src/main/java/org/opensearch/plugin/analysis/kuromoji/AnalysisKuromojiPlugin.java`
- E-02: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/KuromojiTokenizerFactory.java`
- E-03: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/KuromojiAnalyzerProvider.java`
- E-04: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/KuromojiCompletionAnalyzerProvider.java`
- E-05: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/KuromojiCompletionFilterFactory.java`
- E-06: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/KuromojiBaseFormFilterFactory.java`
- E-07: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/KuromojiReadingFormFilterFactory.java`
- E-08: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/KuromojiKatakanaStemmerFactory.java`
- E-09: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/KuromojiNumberFilterFactory.java`
- E-10: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/KuromojiPartOfSpeechFilterFactory.java`
- E-11: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/KuromojiIterationMarkCharFilterFactory.java`
- E-12: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/JapaneseStopTokenFilterFactory.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-KUR-001: CharFilterマップにkuromoji_iteration_markが含まれること | E-01 (L62-64) | ○ |
| C-02 | UT-KUR-002: CharFilterマップのサイズが1であること | E-01 (L62-64, singletonMap使用) | ○ |
| C-03 | UT-KUR-003: TokenFilterマップに全7フィルタが含まれること | E-01 (L67-77) | ○ |
| C-04 | UT-KUR-004: TokenFilterマップのサイズが7であること | E-01 (L67-77, 7つのput呼び出し) | ○ |
| C-05 | UT-KUR-005: Tokenizerマップにkuromoji_tokenizerが含まれること | E-01 (L80-82) | ○ |
| C-06 | UT-KUR-006: Analyzerマップにkuromojiとkuromoji_completionが含まれること | E-01 (L85-90) | ○ |
| C-07 | UT-KUR-007: Analyzerマップのサイズが2であること | E-01 (L85-90, 2つのput呼び出し) | ○ |
| C-08 | UT-KUR-008: mode=searchでSEARCHモードが返却される | E-02 (L125-126) | ○ |
| C-09 | UT-KUR-009: mode=normalでNORMALモードが返却される | E-02 (L127-128) | ○ |
| C-10 | UT-KUR-010: mode=extendedでEXTENDEDモードが返却される | E-02 (L129-130) | ○ |
| C-11 | UT-KUR-011: mode未設定でデフォルトモードが返却される | E-02 (L122-123) | ○ |
| C-12 | UT-KUR-012: modeが大文字小文字を区別しない | E-02 (L125, equalsIgnoreCase使用) | ○ |
| C-13 | UT-KUR-013: 不正modeでデフォルトモードが返却される | E-02 (L121-133, else分岐なし) | ○ |
| C-14 | UT-KUR-014: user_dictionary_rulesで有効なルール指定時にUserDictionaryが返却される | E-02 (L91-119) | ○ |
| C-15 | UT-KUR-015: ユーザー辞書未指定時にnullが返却される | E-02 (L106-108) | ○ |
| C-16 | UT-KUR-016: user_dictionaryとuser_dictionary_rules同時指定で例外 | E-02 (L92-96) | ○ |
| C-17 | UT-KUR-017: 重複エントリで例外がスローされる | E-02 (L85-88) | ○ |
| C-18 | UT-KUR-018: 空CSV行で例外がスローされる | E-02 (L82-84) | ○ |
| C-19 | UT-KUR-019: デフォルト設定でファクトリが正常に初期化される | E-02 (L70-78) | ○ |
| C-20 | UT-KUR-020: discard_punctuation=falseが反映される | E-02 (L74) | ○ |
| C-21 | UT-KUR-021: discard_compound_token=trueが反映される | E-02 (L77) | ○ |
| C-22 | UT-KUR-022: nbest_cost設定が反映される | E-02 (L75) | ○ |
| C-23 | UT-KUR-023: Tokenizerインスタンスが正常に生成される | E-02 (L137-145) | ○ |
| C-24 | UT-KUR-024: nBestExamples指定時にnBestCostが計算される | E-02 (L140-142) | △ |
| C-25 | UT-KUR-025: デフォルト設定でAnalyzerProviderが初期化される | E-03 (L49-54) | ○ |
| C-26 | UT-KUR-026: カスタムストップワードが設定に反映される | E-03 (L51) | ○ |
| C-27 | UT-KUR-027: JapaneseAnalyzerインスタンスが返却される | E-03 (L58-60) | ○ |
| C-28 | UT-KUR-028: 同一インスタンスが毎回返却される | E-03 (L47, finalフィールド) | ○ |
| C-29 | UT-KUR-029: CompletionAnalyzerProviderが初期化される | E-04 (L22-27) | ○ |
| C-30 | UT-KUR-030: modeとuserDictionaryが設定から読み込まれる | E-04 (L24-25) | ○ |
| C-31 | UT-KUR-031: JapaneseCompletionAnalyzerインスタンスが返却される | E-04 (L30-32) | ○ |
| C-32 | UT-KUR-032: mode=indexでMode.INDEXが返却される | E-05 (L29-30) | ○ |
| C-33 | UT-KUR-033: mode=queryでMode.QUERYが返却される | E-05 (L31-32) | ○ |
| C-34 | UT-KUR-034: mode未設定でデフォルトMode.INDEXが返却される | E-05 (L35) | ○ |
| C-35 | UT-KUR-035: modeが大文字小文字を区別しない | E-05 (L29, equalsIgnoreCase使用) | ○ |
| C-36 | UT-KUR-036: 不正modeでデフォルトMode.INDEXが返却される | E-05 (L26-36) | ○ |
| C-37 | UT-KUR-037: JapaneseCompletionFilterインスタンスが生成される | E-05 (L39-41) | ○ |
| C-38 | UT-KUR-038: BaseFormFilterFactoryが初期化される | E-06 (L43-45) | ○ |
| C-39 | UT-KUR-039: JapaneseBaseFormFilterインスタンスが生成される | E-06 (L48-50) | ○ |
| C-40 | UT-KUR-040: デフォルトでuse_romajiがfalse | E-07 (L47) | ○ |
| C-41 | UT-KUR-041: use_romaji=trueが反映される | E-07 (L47) | ○ |
| C-42 | UT-KUR-042: JapaneseReadingFormFilterインスタンスが生成される | E-07 (L51-53) | ○ |
| C-43 | UT-KUR-043: デフォルトminimum_lengthが設定される | E-08 (L47) | ○ |
| C-44 | UT-KUR-044: カスタムminimum_length設定が反映される | E-08 (L47) | ○ |
| C-45 | UT-KUR-045: JapaneseKatakanaStemFilterインスタンスが生成される | E-08 (L51-53) | ○ |
| C-46 | UT-KUR-046: minimum_length=0の境界値 | E-08 (L47) | ○ |
| C-47 | UT-KUR-047: minimum_length=1の境界値 | E-08 (L47) | ○ |
| C-48 | UT-KUR-048: NumberFilterFactoryが初期化される | E-09 (L42-44) | ○ |
| C-49 | UT-KUR-049: JapaneseNumberFilterインスタンスが生成される | E-09 (L47-49) | ○ |
| C-50 | UT-KUR-050: デフォルトストップタグが使用される | E-10 (L50-57) | ○ |
| C-51 | UT-KUR-051: カスタムstoptags設定が反映される | E-10 (L52-54) | ○ |
| C-52 | UT-KUR-052: JapanesePartOfSpeechStopFilterインスタンスが生成される | E-10 (L61-63) | ○ |
| C-53 | UT-KUR-053: デフォルトでnormalize_kanjiとnormalize_kanaがデフォルト値 | E-11 (L49-50) | ○ |
| C-54 | UT-KUR-054: normalize_kanji=falseが反映される | E-11 (L49) | ○ |
| C-55 | UT-KUR-055: normalize_kana=falseが反映される | E-11 (L50) | ○ |
| C-56 | UT-KUR-056: JapaneseIterationMarkCharFilterインスタンスが生成される | E-11 (L54-56) | ○ |
| C-57 | UT-KUR-057: デフォルトストップワードがデフォルトセットに設定される | E-12 (L62-69) | ○ |
| C-58 | UT-KUR-058: カスタムストップワード設定が反映される | E-12 (L62-69) | ○ |
| C-59 | UT-KUR-059: ignore_case=trueが反映される | E-12 (L60) | ○ |
| C-60 | UT-KUR-060: stopwords=_japanese_でデフォルトセットが使用される | E-12 (L50) | ○ |
| C-61 | UT-KUR-061: remove_trailing=true(デフォルト)でStopFilterが返却される | E-12 (L73-76) | ○ |
| C-62 | UT-KUR-062: remove_trailing=falseでSuggestStopFilterが返却される | E-12 (L76-78) | ○ |
| C-63 | UT-KUR-063: ストップワードセットが返却される | E-12 (L81-83) | ○ |
| C-64 | UT-KUR-064: ignore_caseデフォルトでfalseが返却される | E-12 (L60, L85-87) | ○ |
| C-65 | UT-KUR-065: ignore_case=trueでtrueが返却される | E-12 (L60, L85-87) | ○ |
| C-66 | UT-KUR-066: 空stoptags時にデフォルトが使用される | E-10 (L52-57) | △ |
| C-67 | UT-KUR-067: nbest_costのデフォルト値が-1 | E-02 (L75) | ○ |
| C-68 | UT-KUR-068: discard_punctuationのデフォルトがtrue | E-02 (L74) | ○ |
| C-69 | UT-KUR-069: discard_compound_tokenのデフォルトがfalse | E-02 (L77) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-24**: `JapaneseTokenizer.calcNBestCost` はLuceneの内部メソッドであり、具体的な計算ロジックの詳細がOpenSearchソースコード内にない。nBestExamples指定時にnBestCostが更新されることはE-02 L140-142から確認できるが、具体的な期待値を決定するにはLuceneのソースコードを参照する必要がある。
  - 候補：Luceneの `JapaneseTokenizer` ソースコード / Lucene JavaDoc
- **C-66**: `Analysis.parseWordList` に空リストを渡した場合の戻り値（nullか空リストか）が、このモジュール内のソースコードだけでは確定できない。E-10 L52-57のコード上、wordListがnullの場合にデフォルトが使用されるが、空リストの場合にデフォルトが使用されるかは `Analysis.parseWordList` の実装に依存する。
  - 候補：`server/src/main/java/org/opensearch/index/analysis/Analysis.java` の `parseWordList` メソッド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プラグイン登録テスト（C-01〜C-07）：単純なMap生成であり信頼性が高い
- 0: 低リスク - フィルタファクトリのcreateメソッド（C-37〜C-56）：Luceneクラスへの委譲のみ
- 1: 中リスク - ユーザー辞書関連テスト（C-14〜C-18）：ファイルI/O、CSV解析を含むため実行環境依存の可能性
- 1: 中リスク - nBestCost計算（C-24）：Lucene内部APIの動作に依存

## 6) レビュアーチェックリスト（最小）
- [ ] UT-KUR-016: user_dictionaryとuser_dictionary_rulesの排他制御が正しく検証されているか
- [ ] UT-KUR-017〜018: ユーザー辞書のバリデーション（重複・空行）テストの入力値が妥当か
- [ ] UT-KUR-024: nBestExamplesによるコスト計算テストの期待結果をLuceneソースコードで確認
- [ ] UT-KUR-061〜062: remove_trailing設定によるStopFilter/SuggestStopFilterの分岐が正しくカバーされているか
- [ ] UT-KUR-066: Analysis.parseWordListの空リスト時の動作をAnalysis.javaのソースで確認
- [ ] 全テストケースの前提条件（IndexSettings, Environment等のモック）が実現可能か確認
