---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：plugins-analysis-nori 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **C-15 (UT-NOR-015)**：不正な辞書ルールのエラーハンドリング - UserDictionary.openの内部挙動に依存
  2. **C-27 (UT-NOR-027)**：不正なPOSタグの挙動 - POS.resolveTagの内部実装に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/analysis-nori/src/main/java/org/opensearch/plugin/analysis/nori/AnalysisNoriPlugin.java` - プラグインクラス（getTokenFilters, getTokenizers, getAnalyzersメソッド定義）
- E-02: `plugins/analysis-nori/src/main/java/org/opensearch/index/analysis/NoriTokenizerFactory.java` - トークナイザファクトリ（コンストラクタ, getMode, getUserDictionary, createメソッド定義）
- E-03: `plugins/analysis-nori/src/main/java/org/opensearch/index/analysis/NoriAnalyzerProvider.java` - アナライザプロバイダ（コンストラクタ, getメソッド定義）
- E-04: `plugins/analysis-nori/src/main/java/org/opensearch/index/analysis/NoriPartOfSpeechStopFilterFactory.java` - 品詞フィルタファクトリ（コンストラクタ, create, resolvePOSListメソッド定義）
- E-05: `plugins/analysis-nori/src/main/java/org/opensearch/index/analysis/NoriReadingFormFilterFactory.java` - 読みフォームフィルタファクトリ（コンストラクタ, createメソッド定義）
- E-06: `plugins/analysis-nori/src/main/java/org/opensearch/index/analysis/NoriNumberFilterFactory.java` - 数値フィルタファクトリ（コンストラクタ, createメソッド定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-NOR-001: getTokenFiltersが3種類のトークンフィルタを返す | E-01 (L55-61: HashMap に3つのputが確認可能) | ○ |
| C-02 | UT-NOR-002: getTokenizersがnori_tokenizerを返す | E-01 (L64-65: singletonMapで返却) | ○ |
| C-03 | UT-NOR-003: getAnalyzersがnoriを返す | E-01 (L69-70: singletonMapで返却) | ○ |
| C-04 | UT-NOR-004: デフォルト設定でファクトリ生成 | E-02 (L60-65: コンストラクタ定義) | ○ |
| C-05 | UT-NOR-005: discard_punctuation=falseのカスタマイズ | E-02 (L64: settings.getAsBoolean("discard_punctuation", true)) | ○ |
| C-06 | UT-NOR-006: decompound_mode未指定でデフォルト | E-02 (L89-96: DEFAULT_DECOMPOUNDフォールバック) | ○ |
| C-07 | UT-NOR-007: decompound_mode=none解釈 | E-02 (L93: valueOf(modeSetting.toUpperCase)) | ○ |
| C-08 | UT-NOR-008: decompound_mode小文字での大文字変換 | E-02 (L93: toUpperCase(Locale.ENGLISH)) | ○ |
| C-09 | UT-NOR-009: decompound_mode=mixed解釈 | E-02 (L93: valueOf呼び出し) | ○ |
| C-10 | UT-NOR-010: 不正decompound_modeでIllegalArgumentException | E-02 (L93: Enum.valueOfが不正値で例外をスロー) | ○ |
| C-11 | UT-NOR-011: 辞書オプション未指定でnull返却 | E-02 (L73-77: ruleListがnullまたは空の場合null返却) | ○ |
| C-12 | UT-NOR-012: user_dictionary_rules指定でUserDictionary返却 | E-02 (L73-82: parseWordList後にUserDictionary.open呼び出し) | ○ |
| C-13 | UT-NOR-013: 両辞書オプション同時指定でIllegalArgumentException | E-02 (L68-72: 排他チェックの条件分岐) | ○ |
| C-14 | UT-NOR-014: 空リストでnull返却 | E-02 (L75-77: ruleList.isEmpty()チェック) | ○ |
| C-15 | UT-NOR-015: 不正辞書ルールでOpenSearchException | E-02 (L83-86: IOExceptionキャッチ) | △ |
| C-16 | UT-NOR-016: createでKoreanTokenizerインスタンス返却 | E-02 (L99-107: new KoreanTokenizer呼び出し) | ○ |
| C-17 | UT-NOR-017: デフォルト設定でアナライザプロバイダ生成 | E-03 (L52-58: コンストラクタ定義) | ○ |
| C-18 | UT-NOR-018: カスタムdecompound_mode反映 | E-03 (L54: NoriTokenizerFactory.getMode(settings)) | ○ |
| C-19 | UT-NOR-019: カスタムstoptags反映 | E-03 (L56-57: parseWordList + resolvePOSList) | ○ |
| C-20 | UT-NOR-020: stoptags未指定でデフォルト使用 | E-03 (L57: tagList != null三項演算子) | ○ |
| C-21 | UT-NOR-021: getでKoreanAnalyzer返却 | E-03 (L62-63: return analyzer) | ○ |
| C-22 | UT-NOR-022: デフォルト設定でフィルタファクトリ生成 | E-04 (L49-53: コンストラクタ定義) | ○ |
| C-23 | UT-NOR-023: カスタムstoptags設定 | E-04 (L51-52: parseWordList + resolvePOSList) | ○ |
| C-24 | UT-NOR-024: createでKoreanPartOfSpeechStopFilter生成 | E-04 (L56-58: new KoreanPartOfSpeechStopFilter) | ○ |
| C-25 | UT-NOR-025: resolvePOSListで有効タグリスト変換 | E-04 (L60-66: forループでPOS.resolveTag呼び出し) | ○ |
| C-26 | UT-NOR-026: resolvePOSListで1件リスト変換 | E-04 (L60-66: ループ処理は件数非依存) | ○ |
| C-27 | UT-NOR-027: 不正タグでエラー | E-04 (L63: POS.resolveTag内部挙動に依存) | △ |
| C-28 | UT-NOR-028: 重複タグの除去 | E-04 (L61: HashSetによる重複排除) | ○ |
| C-29 | UT-NOR-029: ReadingFormFilterFactory初期化 | E-05 (L42-44: コンストラクタ定義) | ○ |
| C-30 | UT-NOR-030: createでKoreanReadingFormFilter生成 | E-05 (L47-49: new KoreanReadingFormFilter) | ○ |
| C-31 | UT-NOR-031: NumberFilterFactory初期化 | E-06 (L43-45: コンストラクタ定義) | ○ |
| C-32 | UT-NOR-032: createでKoreanNumberFilter生成 | E-06 (L48-50: new KoreanNumberFilter) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-15: `UserDictionary.open()`が不正なルール文字列に対してIOExceptionをスローするかどうかは、Luceneの内部実装に依存する。OpenSearchExceptionへの変換ロジック自体はコードで確認できるが、IOExceptionが実際に発生する条件は外部ライブラリの挙動による
  - 候補：Lucene KoreanTokenizer のソースコード / UserDictionary.openのJavadoc
- C-27: `POS.resolveTag()`が不正な文字列に対してどのような例外をスローするかは、Luceneの内部実装に依存する
  - 候補：Lucene POS.resolveTag のソースコード / Javadoc

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - AnalysisNoriPlugin（単純なMap返却のみ）
- 0: 低リスク - NoriReadingFormFilterFactory, NoriNumberFilterFactory（設定なしの単純ラッパー）
- 1: 中リスク - NoriTokenizerFactory.getUserDictionary（外部ファイル読み込み・例外処理あり）
- 1: 中リスク - NoriPartOfSpeechStopFilterFactory.resolvePOSList（Lucene内部APIへの依存）

## 6) レビュアーチェックリスト（最小）
- [ ] C-15: UserDictionary.openが不正ルールでIOExceptionをスローすることを実機確認
- [ ] C-27: POS.resolveTagが不正タグ文字列で例外をスローすることを実機確認
- [ ] 全テストケースのテストID（UT-NOR-001〜032）が重複していないこと
- [ ] 各テストケースの優先度が適切に設定されていること（金額計算やセキュリティ関連は高）
- [ ] NoriTokenizerFactory.getUserDictionaryのuser_dictionary（ファイルパス指定）ケースのテストが十分か確認
