---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 112
  claims_with_evidence: 110
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：plugins-analysis-phonetic 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：110 / 112、根拠なし：2
- 優先レビュー（高）
  1. **C-095（getRelativeValueの同一音声判定）**：ウムラウト展開後の一致は実装から推測されるが、実際の出力値は実行確認が必要
  2. **C-057（非strictモードで6文字以上）**：入力文字列によっては6文字以下になる可能性があり、期待結果の表現が曖昧

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/analysis-phonetic/src/main/java/org/opensearch/plugin/analysis/AnalysisPhoneticPlugin.java`（プラグインクラス、getTokenFiltersメソッド）
- E-02: `plugins/analysis-phonetic/src/main/java/org/opensearch/index/analysis/PhoneticTokenFilterFactory.java`（ファクトリクラス、コンストラクタ・create・getSynonymFilter）
- E-03: `plugins/analysis-phonetic/src/main/java/org/opensearch/index/analysis/phonetic/Nysiis.java`（NYSIISエンコーダ、encode・nysiis・clean・isStrict）
- E-04: `plugins/analysis-phonetic/src/main/java/org/opensearch/index/analysis/phonetic/KoelnerPhonetik.java`（コルナー音声エンコーダ、encode・getRelativeValue・substitute・partition・getVariations）
- E-05: `plugins/analysis-phonetic/src/main/java/org/opensearch/index/analysis/phonetic/HaasePhonetik.java`（Haase音声エンコーダ、getPatterns・getReplacements・getCode）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | phoneticトークンフィルタが登録される | E-01 (L47-49: singletonMap("phonetic", ...)) | ○ |
| C-002 | 返却Mapのサイズが1 | E-01 (L48: singletonMap使用) | ○ |
| C-003 | PhoneticTokenFilterFactoryが生成可能 | E-01 (L48: PhoneticTokenFilterFactory::new) | ○ |
| C-004 | デフォルトエンコーダがmetaphone | E-02 (L79: settings.get("encoder", "metaphone")) | ○ |
| C-005 | encoder=metaphoneでMetaphone設定 | E-02 (L80-81) | ○ |
| C-006 | encoder=soundexでSoundex設定 | E-02 (L82-83) | ○ |
| C-007 | encoder=caverphone1でCaverphone1設定 | E-02 (L84-85) | ○ |
| C-008 | encoder=caverphone2でCaverphone2設定 | E-02 (L86-87) | ○ |
| C-009 | encoder=caverphoneでCaverphone2設定 | E-02 (L88-89) | ○ |
| C-010 | encoder=refined_soundexでRefinedSoundex設定 | E-02 (L90) | ○ |
| C-011 | encoder=refinedSoundexでRefinedSoundex設定 | E-02 (L90) | ○ |
| C-012 | encoder=cologneでColognePhonetic設定 | E-02 (L92-93) | ○ |
| C-013 | encoder=double_metaphoneでnull encoder設定 | E-02 (L94-96) | ○ |
| C-014 | encoder=doubleMetaphoneでnull encoder設定 | E-02 (L94) | ○ |
| C-015 | max_code_lenカスタム設定 | E-02 (L96: settings.getAsInt("max_code_len", 4)) | ○ |
| C-016 | encoder=bmでBeiderMorse設定 | E-02 (L97-117) | ○ |
| C-017 | encoder=beider_morseでBeiderMorse設定 | E-02 (L98) | ○ |
| C-018 | encoder=beidermorseでBeiderMorse設定 | E-02 (L99) | ○ |
| C-019 | bm rule_type=exactでRuleType.EXACT設定 | E-02 (L105-106) | ○ |
| C-020 | bm name_type=ASHKENAZIでNameType.ASHKENAZI | E-02 (L113-114) | ○ |
| C-021 | bm name_type=SEPHARDICでNameType.SEPHARDIC | E-02 (L115-116) | ○ |
| C-022 | bm languageset設定 | E-02 (L101: settings.getAsList("languageset")) | ○ |
| C-023 | encoder=koelnerphonetikでKoelnerPhonetik設定 | E-02 (L118-119) | ○ |
| C-024 | encoder=haasephonetikでHaasePhonetik設定 | E-02 (L120-121) | ○ |
| C-025 | encoder=nysiisでNysiis設定 | E-02 (L122-123) | ○ |
| C-026 | encoder=daitch_mokotoffでisDaitchMokotoff=true | E-02 (L124-126) | ○ |
| C-027 | replace=false設定 | E-02 (L77: settings.getAsBoolean("replace", true)) | ○ |
| C-028 | replaceデフォルトtrue | E-02 (L77: デフォルト値true) | ○ |
| C-029 | 不明エンコーダでIllegalArgumentException | E-02 (L127-128) | ○ |
| C-030 | bm不正rule_typeでIllegalArgumentException | E-02 (L107-108) | ○ |
| C-031 | エンコーダ名大文字小文字非依存 | E-02 (L80: equalsIgnoreCase使用) | ○ |
| C-032 | MetaphoneでPhoneticFilter生成 | E-02 (L148-149) | ○ |
| C-033 | DoubleMetaphoneでDoubleMetaphoneFilter生成 | E-02 (L145-146) | ○ |
| C-034 | bmでBeiderMorseFilter生成 | E-02 (L138-143) | ○ |
| C-035 | bm languageset付きBeiderMorseFilter | E-02 (L140-142) | ○ |
| C-036 | DaitchMokotoffでDaitchMokotoffSoundexFilter生成 | E-02 (L135-136) | ○ |
| C-037 | replace=trueでinject=false | E-02 (L149: !replace) | ○ |
| C-038 | replace=falseでinject=true | E-02 (L149: !replace) | ○ |
| C-039 | getSynonymFilterでIllegalArgumentException | E-02 (L155-157) | ○ |
| C-040 | デフォルトコンストラクタでstrict=true | E-03 (L189-191: this(true)) | ○ |
| C-041 | strict=falseでインスタンス生成 | E-03 (L202-204) | ○ |
| C-042 | encode(Object)でString正常エンコード | E-03 (L219-224) | ○ |
| C-043 | encode(Object)で非StringにEncoderException | E-03 (L220-221) | ○ |
| C-044 | encode(String)正常エンコード | E-03 (L234-236) | ○ |
| C-045 | nysiis null入力でnull返却 | E-03 (L255-257) | ○ |
| C-046 | nysiis 空文字列で空文字列返却 | E-03 (L262-264: clean後length==0) | ○ |
| C-047 | MAC先頭パターン変換 | E-03 (L268) | ○ |
| C-048 | KN先頭パターン変換 | E-03 (L269) | ○ |
| C-049 | K先頭パターン変換 | E-03 (L270) | ○ |
| C-050 | PH先頭パターン変換 | E-03 (L271) | ○ |
| C-051 | PF先頭パターン変換 | E-03 (L271: PAT_PH_PF) | ○ |
| C-052 | SCH先頭パターン変換 | E-03 (L272) | ○ |
| C-053 | 末尾EEパターン変換 | E-03 (L276) | ○ |
| C-054 | 末尾IEパターン変換 | E-03 (L276: PAT_EE_IE) | ○ |
| C-055 | 末尾DTパターン変換 | E-03 (L277: PAT_DT_ETC) | ○ |
| C-056 | strictモードで最大6文字 | E-03 (L323: Math.min(TRUE_LENGTH, ...)) | ○ |
| C-057 | 非strictモードで6文字以上の可能性 | E-03 (L323: isStrict条件分岐) | △ |
| C-058 | 末尾S除去 | E-03 (L303-304) | ○ |
| C-059 | 末尾AY→Y変換 | E-03 (L311-313) | ○ |
| C-060 | 末尾A除去 | E-03 (L317-319) | ○ |
| C-061 | 数字除去エンコード | E-03 (L326-342: clean関数) | ○ |
| C-062 | 小文字→大文字変換エンコード | E-03 (L339-341: toUpperCase) | ○ |
| C-063 | clean基本動作 | E-03 (L326-342) | ○ |
| C-064 | clean null入力 | E-03 (L327) | ○ |
| C-065 | clean 空文字列 | E-03 (L327) | ○ |
| C-066 | clean 非アルファベット除去 | E-03 (L334: Character.isLetter) | ○ |
| C-067 | isStrict true | E-03 (L244-246) | ○ |
| C-068 | isStrict false | E-03 (L244-246) | ○ |
| C-069 | 1文字入力エンコード | E-03 (L287: ループ条件i < len) | ○ |
| C-070 | KoelnerPhonetikデフォルトコンストラクタ | E-04 (L73-75) | ○ |
| C-071 | KoelnerPhonetik primaryモード | E-04 (L77-79) | ○ |
| C-072 | KoelnerPhonetik encode(Object) | E-04 (L112-115) | ○ |
| C-073 | KoelnerPhonetik encode(String)基本 | E-04 (L118-129) | ○ |
| C-074 | KoelnerPhonetik encode null入力 | E-04 (L119) | ○ |
| C-075 | ウムラウト展開 | E-04 (L287-289: expandUmlauts) | ○ |
| C-076 | 母音先頭で0マッピング | E-04 (L220-229: case A/E/I/J/Y/O/U, getCode()='0') | ○ |
| C-077 | BPが1マッピング | E-04 (L234-235) | ○ |
| C-078 | DTが2マッピング（非CSZ） | E-04 (L237-239) | ○ |
| C-079 | DTが8マッピング（CSZ後続） | E-04 (L239: csz.contains(next) ? '8') | ○ |
| C-080 | FVWが3マッピング | E-04 (L241-245) | ○ |
| C-081 | GKQが4マッピング | E-04 (L246-249) | ○ |
| C-082 | Lが5マッピング | E-04 (L264-265) | ○ |
| C-083 | MNが6マッピング | E-04 (L267-269) | ○ |
| C-084 | Rが7マッピング | E-04 (L271-272) | ○ |
| C-085 | SZが8マッピング | E-04 (L274-277) | ○ |
| C-086 | Xが48マッピング（非CKQ前） | E-04 (L262: !ckq.contains(prev) ? "48") | ○ |
| C-087 | Xが8マッピング（CKQ前） | E-04 (L262) | ○ |
| C-088 | PHが33マッピング | E-04 (L232: next == 'H' ? "33") | ○ |
| C-089 | 先頭CでAHKLOQRUX前4マッピング | E-04 (L252-253) | ○ |
| C-090 | 先頭Cでそれ以外前8マッピング | E-04 (L252-253) | ○ |
| C-091 | 連続同一コード除去 | E-04 (L291-307: removeSequences) | ○ |
| C-092 | H無視 | E-04 (L278-279: case 'H': break) | ○ |
| C-093 | primaryモード単一コード | E-04 (L151-152: if(!primary)分岐) | ○ |
| C-094 | 非primaryモードアンダースコア区切り | E-04 (L122-128) | ○ |
| C-095 | getRelativeValue同一音声で1.0 | E-04 (L99-110) | △ |
| C-096 | getRelativeValue異なる音声で0.0 | E-04 (L99-110) | ○ |
| C-097 | getPatterns返却値 | E-04 (L87-89) | ○ |
| C-098 | getReplacements返却値 | E-04 (L91-93) | ○ |
| C-099 | getCode返却値 | E-04 (L95-97) | ○ |
| C-100 | KoelnerPhonetik空文字列 | E-04 (L291-294: removeSequences null/empty check) | ○ |
| C-101 | KoelnerPhonetik 1文字入力 | E-04 (L211-284) | ○ |
| C-102 | KoelnerPhonetik特殊文字処理 | E-04 (L153: split pattern) | ○ |
| C-103 | HaasePhonetik getPatterns | E-05 (L69-71) | ○ |
| C-104 | HaasePhonetik getReplacements | E-05 (L73-75) | ○ |
| C-105 | HaasePhonetik getCode '9' | E-05 (L79-81) | ○ |
| C-106 | HaasePhonetik基本エンコード | E-05 (KoelnerPhonetikを継承, L51) | ○ |
| C-107 | HaasePhonetik OWN→AUN変換 | E-05 (L53-54, L66) | ○ |
| C-108 | HaasePhonetik SCH→CH変換 | E-05 (L59, L66) | ○ |
| C-109 | HaasePhonetik 先頭CH→SCH変換 | E-05 (L62, L66) | ○ |
| C-110 | HaasePhonetik母音先頭9マッピング | E-05 (L79-81: getCode()='9'), E-04 (L228) | ○ |
| C-111 | HaasePhonetik null入力 | E-04 (L119: 親クラスのnullチェック) | ○ |
| C-112 | HaasePhonetikパターン/リプレースメント配列長一致 | E-05 (L53-66: 配列定義) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-057: 非strictモードでの出力長は入力に依存するため、特定の入力文字列で6文字以上になることの保証が難しい。実行確認が必要。
  - 候補：長い入力文字列での実行テスト / NYSIISアルゴリズム仕様書
- C-095: getRelativeValueで「Mueller」と「Muller」のウムラウト展開後のコード一致はexpandUmlauts処理に依存するが、実際の出力値は実行確認が必要。
  - 候補：実行テスト / KoelnerPhonetikの動作検証

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストケースの大半はソースコードの分岐・処理に直接対応しており、根拠が明確
- 1: 中リスク - PhoneticTokenFilterFactoryのcreateメソッドは返却されるフィルタの型をテストするが、実際のトークン処理結果までは検証しない（結合テストレベル）
- 0: 低リスク - Nysiis, KoelnerPhonetik, HaasePhonetikのエンコード結果は入力に対する出力値であり、静的解析で確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] PhoneticTokenFilterFactoryの全エンコーダ名バリエーション（13種）が網羅されているか
- [ ] BeiderMorseのrule_type/name_type/languagesetの組み合わせが十分か
- [ ] Nysiisの全変換ルール（先頭6パターン、末尾3パターン、中間8パターン）がカバーされているか
- [ ] KoelnerPhonetikの全文字マッピング（0-8）がカバーされているか
- [ ] HaasePhonetikの12個のパターン置換が十分にテストされているか（代表的なもののみテスト）
- [ ] 期待結果が具体的な値ではなく挙動レベルの記述であるため、実装時に具体値を確定する必要がある
