---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 34
  claims_with_evidence: 32
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：plugins-analysis-smartcn 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：32 / 34、根拠なし：2
- 優先レビュー（高）
  1. **C-25 (UT-SMC-025)**: SmartChineseStopTokenFilterFactory.create にnull TokenStreamを渡した場合の挙動 - ソースコードにnullチェックの記述なし
  2. **C-32 (UT-SMC-032)**: SmartChineseNoOpTokenFilterFactory.create にnull TokenStreamを渡した場合の挙動 - ソースコード上はnullをそのまま返す推測だが明示的なドキュメントなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/analysis-smartcn/src/main/java/org/opensearch/plugin/analysis/smartcn/AnalysisSmartChinesePlugin.java` - プラグインクラス（getTokenFilters, getTokenizers, getAnalyzersメソッド定義）
- E-02: `plugins/analysis-smartcn/src/main/java/org/opensearch/index/analysis/SmartChineseAnalyzerProvider.java` - アナライザプロバイダ（コンストラクタ、getメソッド定義）
- E-03: `plugins/analysis-smartcn/src/main/java/org/opensearch/index/analysis/SmartChineseStopTokenFilterFactory.java` - ストップトークンフィルタファクトリ（コンストラクタ、createメソッド、ignore_case/remove_trailing/stopWords設定）
- E-04: `plugins/analysis-smartcn/src/main/java/org/opensearch/index/analysis/SmartChineseTokenizerTokenizerFactory.java` - トークナイザファクトリ（コンストラクタ、createメソッド）
- E-05: `plugins/analysis-smartcn/src/main/java/org/opensearch/index/analysis/SmartChineseNoOpTokenFilterFactory.java` - No-opトークンフィルタファクトリ（コンストラクタ、createメソッド）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getTokenFiltersがsmartcn_stopとsmartcn_wordキーを含むMapを返す | E-01 (L54-59) | ○ |
| C-02 | smartcn_stopがSmartChineseStopTokenFilterFactoryを生成する | E-01 (L56) | ○ |
| C-03 | smartcn_wordがSmartChineseNoOpTokenFilterFactoryを生成する | E-01 (L58) | ○ |
| C-04 | getTokenFiltersの返却Mapサイズが2 | E-01 (L55-59) | ○ |
| C-05 | getTokenizersがsmartcn_tokenizerとsmartcn_sentenceキーを含むMapを返す | E-01 (L63-68) | ○ |
| C-06 | smartcn_tokenizerがSmartChineseTokenizerTokenizerFactoryを生成する | E-01 (L65) | ○ |
| C-07 | smartcn_sentenceがSmartChineseTokenizerTokenizerFactoryを生成する | E-01 (L67) | ○ |
| C-08 | getTokenizersの返却Mapサイズが2 | E-01 (L64-68) | ○ |
| C-09 | getAnalyzersがsmartcnキーを含むMapを返す | E-01 (L73) | ○ |
| C-10 | smartcnがSmartChineseAnalyzerProviderを生成する | E-01 (L73) | ○ |
| C-11 | getAnalyzersの返却Mapサイズが1 | E-01 (L73: singletonMap) | ○ |
| C-12 | SmartChineseAnalyzerProviderコンストラクタが正常に動作する | E-02 (L44-48) | ○ |
| C-13 | get()がSmartChineseAnalyzerインスタンスを返す | E-02 (L51-53) | ○ |
| C-14 | get()が同一インスタンスを返す | E-02 (L42, L47: フィールドに保存) | ○ |
| C-15 | アナライザがデフォルトストップワードセットを使用する | E-02 (L47: getDefaultStopSet()) | ○ |
| C-16 | SmartChineseStopTokenFilterFactoryコンストラクタがデフォルト設定で動作する | E-03 (L58-70) | ○ |
| C-17 | ignore_case=trueの設定が反映される | E-03 (L60) | ○ |
| C-18 | ignore_caseのデフォルト値がfalse | E-03 (L60: getAsBoolean("ignore_case", false)) | ○ |
| C-19 | remove_trailing=falseの設定が反映される | E-03 (L61) | ○ |
| C-20 | remove_trailingのデフォルト値がtrue | E-03 (L61: getAsBoolean("remove_trailing", true)) | ○ |
| C-21 | カスタムストップワードが設定される | E-03 (L62-69: Analysis.parseWords) | ○ |
| C-22 | _smartcn_指定でデフォルトストップワードセットが使用される | E-03 (L50: NAMED_STOP_WORDS) | ○ |
| C-23 | removeTrailing=trueでStopFilterが返される | E-03 (L74-75) | ○ |
| C-24 | removeTrailing=falseでSuggestStopFilterが返される | E-03 (L76-78) | ○ |
| C-25 | null TokenStreamを渡した場合の挙動 | **根拠なし** | △ |
| C-26 | ストップワードによるフィルタリングが正しく動作する | E-03 (L73-79) | ○ |
| C-27 | SmartChineseTokenizerTokenizerFactoryコンストラクタが正常に動作する | E-04 (L43-45) | ○ |
| C-28 | create()がHMMChineseTokenizerを返す | E-04 (L48-50) | ○ |
| C-29 | create()が呼び出しごとに新しいインスタンスを返す | E-04 (L49: new HMMChineseTokenizer()) | ○ |
| C-30 | SmartChineseNoOpTokenFilterFactoryコンストラクタが正常に動作する | E-05 (L42-44) | ○ |
| C-31 | create()が入力TokenStreamをそのまま返す | E-05 (L47-49) | ○ |
| C-32 | null TokenStreamを渡した場合にnullが返る | **根拠なし** | △ |
| C-33 | AnalysisPluginインターフェースを実装している | E-01 (L52: implements AnalysisPlugin) | ○ |
| C-34 | Pluginクラスを継承している | E-01 (L52: extends Plugin) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-25, C-32: null入力に対する挙動はソースコードに明示的なnullチェックが記述されておらず、実際の動作はLuceneライブラリ側の実装に依存する。テスト実行時に確認が必要。
  - 候補：Lucene StopFilter/SuggestStopFilterのJavadoc / Luceneソースコード / 実行時テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プラグイン登録系のテストケース（C-01〜C-11, C-33, C-34）はソースコードから直接確認可能
- 0: 低リスク - コンストラクタ・設定値系のテストケース（C-12〜C-22, C-27, C-30）はソースコードの設定値から直接確認可能
- 0: 低リスク - create()メソッドの条件分岐テスト（C-23, C-24, C-28, C-29, C-31）はソースコードのロジックから直接確認可能
- 1: 中リスク - null入力テスト（C-25, C-32）はLuceneライブラリの内部動作に依存するため、実行時確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] UT-SMC-025: SmartChineseStopTokenFilterFactory.createにnull入力した場合の期待結果が正しいか確認（Lucene依存）
- [ ] UT-SMC-032: SmartChineseNoOpTokenFilterFactory.createにnull入力した場合の期待結果が正しいか確認（コード上はnull返却と推測）
- [ ] ストップワード関連テスト（UT-SMC-021, UT-SMC-022, UT-SMC-026）: カスタムストップワード設定とフィルタリング動作の入力値・期待結果が妥当か確認
- [ ] 全テストケースのテストID（UT-SMC-001〜034）が連番で欠番がないことを確認
