---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 33
  claims_with_evidence: 31
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：plugins-analysis-stempel 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：31 / 33、根拠なし：2
- 優先レビュー（高）
  1. **UT-STE-015（null TokenStream入力時のPolishStemTokenFilterFactory動作）**：Lucene内部の挙動に依存し、NullPointerExceptionが確実にスローされるかは実行時確認が必要
  2. **UT-STE-024（null TokenStream入力時のPolishStopTokenFilterFactory動作）**：同上、Lucene内部実装依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/analysis-stempel/src/main/java/org/opensearch/plugin/analysis/stempel/AnalysisStempelPlugin.java` - プラグインクラス（getTokenFilters, getAnalyzersメソッド定義）
- E-02: `plugins/analysis-stempel/src/main/java/org/opensearch/index/analysis/pl/PolishAnalyzerProvider.java` - PolishAnalyzerのプロバイダ（コンストラクタ、getメソッド定義）
- E-03: `plugins/analysis-stempel/src/main/java/org/opensearch/index/analysis/pl/PolishStemTokenFilterFactory.java` - ステミングフィルタファクトリ（コンストラクタ、createメソッド定義）
- E-04: `plugins/analysis-stempel/src/main/java/org/opensearch/index/analysis/pl/PolishStopTokenFilterFactory.java` - ストップワードフィルタファクトリ（コンストラクタ、create、stopWords、ignoreCaseメソッド定義、設定項目 ignore_case / remove_trailing / stopwords）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getTokenFiltersがpolish_stemとpolish_stopを含むMapを返す | E-01 L52-56 | ○ |
| C-02 | getTokenFiltersの返却Mapサイズが2 | E-01 L53-56 | ○ |
| C-03 | polish_stemのプロバイダがPolishStemTokenFilterFactoryを生成 | E-01 L54, E-03 | ○ |
| C-04 | polish_stopのプロバイダがPolishStopTokenFilterFactoryを生成 | E-01 L55, E-04 | ○ |
| C-05 | getAnalyzersがpolishキーを含むMapを返す | E-01 L60-62 | ○ |
| C-06 | getAnalyzersの返却Mapサイズが1 | E-01 L61 | ○ |
| C-07 | polishのプロバイダがPolishAnalyzerProviderを生成 | E-01 L61, E-02 | ○ |
| C-08 | PolishAnalyzerProviderのコンストラクタが正常動作 | E-02 L45-49 | ○ |
| C-09 | PolishAnalyzerがデフォルトストップワードで初期化 | E-02 L48 | ○ |
| C-10 | get()がPolishAnalyzerインスタンスを返す | E-02 L52-54 | ○ |
| C-11 | get()が同一インスタンスを返す | E-02 L43,52-54 | ○ |
| C-12 | PolishStemTokenFilterFactoryのコンストラクタが正常動作 | E-03 L46-48 | ○ |
| C-13 | create()がStempelFilterを返す | E-03 L51-53 | ○ |
| C-14 | ポーランド語テキストが正しくステミングされる | E-03 L52 | ○ |
| C-15 | null TokenStreamでNullPointerExceptionがスロー（Stem） | **根拠なし** | △ |
| C-16 | デフォルト設定でignoreCase=false、removeTrailing=true | E-04 L62-63 | ○ |
| C-17 | ignore_case=true設定の反映 | E-04 L62 | ○ |
| C-18 | remove_trailing=false設定の反映 | E-04 L63,69-73 | ○ |
| C-19 | カスタムストップワード設定の反映 | E-04 L64 | ○ |
| C-20 | 名前付きストップワード_polish_の使用 | E-04 L52 | ○ |
| C-21 | removeTrailing=trueでStopFilterが返却される | E-04 L69-70 | ○ |
| C-22 | removeTrailing=falseでSuggestStopFilterが返却される | E-04 L71-72 | ○ |
| C-23 | ストップワードが正しくフィルタリングされる | E-04 L69-70 | ○ |
| C-24 | null TokenStreamでNullPointerExceptionがスロー（Stop） | **根拠なし** | △ |
| C-25 | stopWords()がデフォルトストップワードセットを返す | E-04 L76-78 | ○ |
| C-26 | stopWords()がカスタムストップワードを返す | E-04 L64,76-78 | ○ |
| C-27 | ignoreCase()がデフォルトでfalseを返す | E-04 L62,80-82 | ○ |
| C-28 | ignoreCase()がtrue設定時にtrueを返す | E-04 L62,80-82 | ○ |
| C-29 | 空ストップワードで全トークンが出力される | E-04 L64,69-70 | ○ |
| C-30 | 空TokenStreamで空の結果が返る（Stem） | E-03 L51-53 | ○ |
| C-31 | 空TokenStreamで空の結果が返る（Stop） | E-04 L68-73 | ○ |
| C-32 | AnalysisPluginインターフェースの実装 | E-01 L50 | ○ |
| C-33 | Pluginクラスの継承 | E-01 L50 | ○ |

## 4) 不足情報（Unknown / Missing）
- null入力時の挙動（C-15, C-24）はLucene内部のStempelFilter / StopFilter / SuggestStopFilterの実装に依存しており、ソースコードからは明示的なnullチェックが確認できない
  - 候補：Lucene StempelFilterのソースコード / StopFilterのソースコード / 実行時テスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モジュール全体がシンプルなプラグイン登録・ファクトリパターンであり、ビジネスロジックの複雑性は低い
- 1: 中リスク - null入力時の挙動はLucene内部実装に依存するため、実行時テストで確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] UT-STE-015, UT-STE-024のnull入力テストが実行時に期待通り動作するか確認
- [ ] PolishAnalyzer.getDefaultStopSet()のストップワード内容が期待通りか確認
- [ ] PolishAnalyzer.getDefaultTable()のステミングテーブルが正しくロードされるか確認
- [ ] カスタムストップワード設定時のAnalysis.parseWordsの挙動が期待通りか確認
- [ ] テストケースの網羅性が実際のプロジェクト要件を満たしているか確認
