---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 97
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：plugins-cache-ehcache 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：97 / 100、根拠なし：3
- 優先レビュー（高）
  1. **UT-ECH-008（getSettingListForCacheType null入力）**：CACHE_TYPE_MAPはHashMapで実装されており、nullキーでのget()はnullを返すためIllegalArgumentExceptionがスローされるが、CacheType.values()にnullは含まれないためMapにnullキーエントリは存在しない。動作は正しいが、nullを明示的にチェックするコードはない
  2. **UT-ECH-025（並行アクセスの整合性）**：CompletableFutureMapによる並行制御の動作は推論に基づく。実際のマルチスレッドテストが必要
  3. **UT-ECH-098（closeCache例外耐性）**：removeCacheの例外キャッチ後にデクリメント処理が続行されることはコードから確認できるが、全例外パターンの網羅性は要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/cache-ehcache/src/main/java/org/opensearch/cache/EhcacheCachePlugin.java` - プラグインクラス（getCacheFactoryMap, getSettings, getName）
- E-02: `plugins/cache-ehcache/src/main/java/org/opensearch/cache/EhcacheDiskCacheSettings.java` - 設定クラス（定数定義、getSettingListForCacheType、CACHE_TYPE_MAP）
- E-03: `plugins/cache-ehcache/src/main/java/org/opensearch/cache/store/disk/EhcacheDiskCache.java` - メインキャッシュ実装（get, put, computeIfAbsent, invalidate, invalidateAll, keys, count, close, stats, コンストラクタ、内部クラス）
- E-04: `plugins/cache-ehcache/src/main/java/org/opensearch/cache/store/disk/EhcacheDiskCacheManager.java` - キャッシュマネージャ（getCacheManager, doesCacheManagerExist, createCache, closeCache）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-ECH-001: getCacheFactoryMapがEhcacheDiskCacheFactoryを含むMapを返す | E-01 (L37-39) | ○ |
| C-02 | UT-ECH-002: 返却Mapサイズが1 | E-01 (L38: Map.of で1エントリ) | ○ |
| C-03 | UT-ECH-003: getSettingsが全設定リストを返す | E-01 (L42-49), E-02 (L197) | ○ |
| C-04 | UT-ECH-004: 設定リストが空でない | E-01 (L42-49), E-02 (L173-192) | ○ |
| C-05 | UT-ECH-005: getNameが"EhcachePlugin"を返す | E-01 (L29, L53-55) | ○ |
| C-06 | UT-ECH-006: getSettingListForCacheTypeが有効なCacheTypeで設定Mapを返す | E-02 (L220-232) | ○ |
| C-07 | UT-ECH-007: 返却Mapに全設定キーが含まれる | E-02 (L173-192, L203-213) | ○ |
| C-08 | UT-ECH-008: nullのCacheTypeでIllegalArgumentException | E-02 (L221-229) | △ |
| C-09 | UT-ECH-009: CACHE_TYPE_MAPに全CacheTypeのエントリが存在 | E-02 (L203-213) | ○ |
| C-10 | UT-ECH-010: DEFAULT_CACHE_SIZE_IN_BYTES == 1073741824L | E-02 (L30) | ○ |
| C-11 | UT-ECH-011: getで存在キーの値が返る | E-03 (L294-310) | ○ |
| C-12 | UT-ECH-012: ヒット時にincrementHits | E-03 (L305) | ○ |
| C-13 | UT-ECH-013: ミス時にincrementMisses | E-03 (L307) | ○ |
| C-14 | UT-ECH-014: nullキーでIllegalArgumentException | E-03 (L295-297) | ○ |
| C-15 | UT-ECH-015: CacheLoadingExceptionでOpenSearchException | E-03 (L301-303) | ○ |
| C-16 | UT-ECH-016: putで格納 | E-03 (L318-324) | ○ |
| C-17 | UT-ECH-017: 値がシリアライズされて格納 | E-03 (L320, L652-654) | ○ |
| C-18 | UT-ECH-018: CacheWritingExceptionでOpenSearchException | E-03 (L321-323) | ○ |
| C-19 | UT-ECH-019: computeIfAbsentでキャッシュヒット時に値返却 | E-03 (L334-348) | ○ |
| C-20 | UT-ECH-020: computeIfAbsentでミス時にloaderで値ロード | E-03 (L339-341, L350-401) | ○ |
| C-21 | UT-ECH-021: computeIfAbsentヒット時にincrementHits | E-03 (L343) | ○ |
| C-22 | UT-ECH-022: computeIfAbsentミス時にincrementMisses | E-03 (L345) | ○ |
| C-23 | UT-ECH-023: loaderがnull返却時にExecutionException | E-03 (L379-382) | ○ |
| C-24 | UT-ECH-024: loader例外時にExecutionException | E-03 (L375-378) | ○ |
| C-25 | UT-ECH-025: 並行リクエストの整合性 | E-03 (L350-401, completableFutureMap) | △ |
| C-26 | UT-ECH-026: invalidateでエントリ削除 | E-03 (L408-421) | ○ |
| C-27 | UT-ECH-027: dropStatsForDimensionsでdimensions削除 | E-03 (L410-412) | ○ |
| C-28 | UT-ECH-028: key.key==nullでremoveスキップ | E-03 (L413-415) | ○ |
| C-29 | UT-ECH-029: CacheWritingExceptionでRuntimeException | E-03 (L416-419) | ○ |
| C-30 | UT-ECH-030: invalidateAllでclear | E-03 (L425) | ○ |
| C-31 | UT-ECH-031: invalidateAllで統計リセット | E-03 (L426) | ○ |
| C-32 | UT-ECH-032: keysでイテレート可能 | E-03 (L434-436) | ○ |
| C-33 | UT-ECH-033: 空キャッシュで空Iterable | E-03 (L434-436) | ○ |
| C-34 | UT-ECH-034: countが正しい値を返す | E-03 (L444-446) | ○ |
| C-35 | UT-ECH-035: 空キャッシュでcount==0 | E-03 (L444-446) | ○ |
| C-36 | UT-ECH-036: closeでcloseCacheが呼ばれる | E-03 (L455-457) | ○ |
| C-37 | UT-ECH-037: statsで統計情報返却 | E-03 (L465-467) | ○ |
| C-38 | UT-ECH-038: keyType==nullでNPE | E-03 (L138) | ○ |
| C-39 | UT-ECH-039: valueType==nullでNPE | E-03 (L139) | ○ |
| C-40 | UT-ECH-040: expireAfterAccess==nullでNPE | E-03 (L140) | ○ |
| C-41 | UT-ECH-041: maxWeightInBytes<=MINIMUM_MAX_SIZE_IN_BYTESでIAE | E-03 (L142-144) | ○ |
| C-42 | UT-ECH-042: maxWeightInBytes==102400でIAE | E-03 (L142: <= 比較) | ○ |
| C-43 | UT-ECH-043: maxWeightInBytes==102401で正常 | E-03 (L142: <= 比較) | ○ |
| C-44 | UT-ECH-044: cacheType==nullでNPE | E-03 (L145) | ○ |
| C-45 | UT-ECH-045: storagePath==nullでIAE | E-03 (L152-154) | ○ |
| C-46 | UT-ECH-046: storagePath空文字でIAE | E-03 (L152-154) | ○ |
| C-47 | UT-ECH-047: diskCacheAlias==nullでデフォルト名 | E-03 (L146-150) | ○ |
| C-48 | UT-ECH-048: diskCacheAlias空文字でデフォルト名 | E-03 (L146-150) | ○ |
| C-49 | UT-ECH-049: threadPoolAlias==nullでデフォルト名 | E-03 (L170-174) | ○ |
| C-50 | UT-ECH-050: statsTrackingEnabled==trueでDefaultCacheStatsHolder | E-03 (L185-188) | ○ |
| C-51 | UT-ECH-051: statsTrackingEnabled==falseでNoopCacheStatsHolder | E-03 (L189-191) | ○ |
| C-52 | UT-ECH-052: hasNextで要素ありならtrue | E-03 (L483-485) | ○ |
| C-53 | UT-ECH-053: hasNextで要素なしならfalse | E-03 (L483-485) | ○ |
| C-54 | UT-ECH-054: nextでキー返却 | E-03 (L488-493) | ○ |
| C-55 | UT-ECH-055: next末尾でNoSuchElementException | E-03 (L489-491) | ○ |
| C-56 | UT-ECH-056: removeで要素削除 | E-03 (L496-498) | ○ |
| C-57 | UT-ECH-057: CREATEDでitems/sizeインクリメント | E-03 (L524-528) | ○ |
| C-58 | UT-ECH-058: EVICTEDでremovalListener/統計更新 | E-03 (L529-537) | ○ |
| C-59 | UT-ECH-059: REMOVEDでremovalListener/統計更新 | E-03 (L538-545) | ○ |
| C-60 | UT-ECH-060: EXPIREDでremovalListener/統計更新 | E-03 (L546-553) | ○ |
| C-61 | UT-ECH-061: UPDATEDでsizeInBytes差分更新 | E-03 (L554-558) | ○ |
| C-62 | UT-ECH-062: KeySerializerWrapper.serializeでByteBuffer返却 | E-03 (L590-592) | ○ |
| C-63 | UT-ECH-063: KeySerializerWrapper.readでICacheKey返却 | E-03 (L595-599) | ○ |
| C-64 | UT-ECH-064: KeySerializerWrapper.equalsで同一キーtrue | E-03 (L602-606) | ○ |
| C-65 | UT-ECH-065: KeySerializerWrapper.equalsで異なるキーfalse | E-03 (L602-606) | ○ |
| C-66 | UT-ECH-066: ByteArrayWrapperSerializer.serializeでByteBuffer返却 | E-03 (L628-630) | ○ |
| C-67 | UT-ECH-067: ByteArrayWrapperSerializer.readでByteArrayWrapper返却 | E-03 (L633-637) | ○ |
| C-68 | UT-ECH-068: ByteArrayWrapperSerializer.equalsで同一true | E-03 (L640-644) | ○ |
| C-69 | UT-ECH-069: ByteArrayWrapperSerializer.equalsで異なるfalse | E-03 (L640-644) | ○ |
| C-70 | UT-ECH-070: ByteArrayWrapper.equalsで同一true | E-03 (L905-911) | ○ |
| C-71 | UT-ECH-071: ByteArrayWrapper.equalsで異なるfalse | E-03 (L905-911) | ○ |
| C-72 | UT-ECH-072: ByteArrayWrapper.equalsでnullはfalse | E-03 (L906) | ○ |
| C-73 | UT-ECH-073: ByteArrayWrapper.equalsで異なるクラスfalse | E-03 (L906) | ○ |
| C-74 | UT-ECH-074: ByteArrayWrapper.hashCodeの一貫性 | E-03 (L914-916) | ○ |
| C-75 | UT-ECH-075: 空byte配列の等価性 | E-03 (L905-911, Arrays.equals) | ○ |
| C-76 | UT-ECH-076: Factoryでキャッシュ作成 | E-03 (L690-746) | ○ |
| C-77 | UT-ECH-077: keySerializer型不正でIAE | E-03 (L694-699) | ○ |
| C-78 | UT-ECH-078: valueSerializer型不正でIAE | E-03 (L701-706) | ○ |
| C-79 | UT-ECH-079: storagePathフォールバック | E-03 (L708-714) | ○ |
| C-80 | UT-ECH-080: config.maxSizeInBytes優先 | E-03 (L732-738) | ○ |
| C-81 | UT-ECH-081: config.segmentCount優先 | E-03 (L739-744) | ○ |
| C-82 | UT-ECH-082: getCacheNameが"ehcache_disk"を返す | E-03 (L749-751, L681) | ○ |
| C-83 | UT-ECH-083: config.cacheAlias優先 | E-03 (L715-718) | ○ |
| C-84 | UT-ECH-084: getCacheManagerで新規作成 | E-04 (L79-94) | ○ |
| C-85 | UT-ECH-085: getCacheManagerで既存再利用 | E-04 (L87: computeIfAbsent) | ○ |
| C-86 | UT-ECH-086: doesCacheManagerExistでtrue | E-04 (L101-103) | ○ |
| C-87 | UT-ECH-087: doesCacheManagerExistでfalse | E-04 (L101-103) | ○ |
| C-88 | UT-ECH-088: createCacheでキャッシュ作成 | E-04 (L115-163) | ○ |
| C-89 | UT-ECH-089: createCacheで参照カウンタインクリメント | E-04 (L151) | ○ |
| C-90 | UT-ECH-090: createCacheでcacheType==nullでIAE | E-04 (L120-131) | ○ |
| C-91 | UT-ECH-091: createCacheでdiskCacheAlias==nullでIAE | E-04 (L120-131) | ○ |
| C-92 | UT-ECH-092: createCacheでcacheConfigurationBuilder==nullでIAE | E-04 (L120-131) | ○ |
| C-93 | UT-ECH-093: createCacheでcacheManager不在でIAE | E-04 (L132-134) | ○ |
| C-94 | UT-ECH-094: closeCacheで正常クローズ | E-04 (L172-220) | ○ |
| C-95 | UT-ECH-095: 最後のキャッシュでマネージャもクローズ | E-04 (L194-215) | ○ |
| C-96 | UT-ECH-096: 最後のクローズでディスクデータ削除 | E-04 (L202-214) | ○ |
| C-97 | UT-ECH-097: cacheManager不在で何もしない | E-04 (L173-176) | ○ |
| C-98 | UT-ECH-098: removeCacheの例外後もデクリメント継続 | E-04 (L180-192) | △ |
| C-99 | UT-ECH-099: Builder.setCacheTypeでBuilderが返る | E-03 (L788-791) | ○ |
| C-100 | UT-ECH-100: Builder.buildでEhcacheDiskCache作成 | E-03 (L883-886) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-08 (UT-ECH-008)**: getSettingListForCacheTypeメソッドはCACHE_TYPE_MAP.get(cacheType)でnullチェックを行い、nullの場合にIllegalArgumentExceptionをスローする。しかし、CacheTypeがnullの場合、HashMap.get(null)はnullを返すため、結果的にIAEがスローされるが、これはnull専用のバリデーションではなく、「見つからない場合」の処理に依存している
  - 候補: CacheType enum定義 / HashMap.get(null) のJava仕様
- **C-25 (UT-ECH-025)**: 並行アクセス時の動作はcompletableFutureMapとConcurrentHashMap.putIfAbsentの動作に基づく推論。実際のマルチスレッド環境での検証が必要
  - 候補: JDK ConcurrentHashMap仕様 / CompletableFutureの並行動作仕様
- **C-98 (UT-ECH-098)**: removeCacheがtry-catch内にあり、例外キャッチ後にデクリメント処理が続行される。ただし、全ての例外型（RuntimeException含む）がキャッチされるかの完全な検証は未実施
  - 候補: Ehcache APIドキュメント / PersistentCacheManager.removeCache の例外仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - EhcacheCachePlugin（プラグイン登録、設定取得）：シンプルな委譲処理
- 0: 低リスク - EhcacheDiskCacheSettings（設定定義、定数）：宣言的な定義
- 1: 中リスク - EhcacheDiskCache（get, put, invalidate等）：Ehcacheの内部動作に依存
- 2: 高リスク - EhcacheDiskCache.computeIfAbsent：CompletableFutureによる並行制御が複雑
- 1: 中リスク - EhcacheDiskCacheManager（ライフサイクル管理）：参照カウントによるリソース管理
- 1: 中リスク - ByteArrayWrapper / Serializer系：byte配列の等価性比較に依存

## 6) レビュアーチェックリスト（最小）
- [ ] UT-ECH-008: nullのCacheTypeでの動作が意図通りか確認（HashMap.get(null)への依存が許容されるか）
- [ ] UT-ECH-025: 並行アクセステストが実際のマルチスレッド環境で正しく動作するか確認
- [ ] UT-ECH-041-043: MINIMUM_MAX_SIZE_IN_BYTES (102400) の境界値テストが正確か確認（<= 比較）
- [ ] UT-ECH-057-061: EhCacheEventListenerの各イベントタイプのテストケースが全イベントタイプを網羅しているか確認
- [ ] UT-ECH-094-098: EhcacheDiskCacheManagerのcloseCache内の例外処理パスが全て検証されているか確認
- [ ] コンストラクタのバリデーションテスト（UT-ECH-038-051）が全てのObjects.requireNonNullに対応しているか確認
