---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 57
  claims_with_evidence: 55
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：plugins-crypto-kms 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：55 / 57、根拠なし：2
- 優先レビュー（高）
  1. **C-23 (UT-CKM-023)**：不正なプロキシホスト名でURISyntaxExceptionが発生するかはURI仕様に依存し、実際のテストでの検証が必要
  2. **C-55 (UT-CKM-055)**：setDefaultAwsProfilePathのシステムプロパティ操作はセキュリティマネージャとの相互作用があり、テスト環境での再現性に注意

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsClientSettings.java` (L121-L167: loadCredentials)
- E-02: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsClientSettings.java` (L170-L187: getClientSettings)
- E-03: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsClientSettings.java` (L189-L226: getMetadataSettings)
- E-04: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsClientSettings.java` (L236-L257: equals/hashCode)
- E-05: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsClientSettings.java` (L34-L65: Setting定義)
- E-06: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsService.java` (L245-L272: createMasterKeyProvider)
- E-07: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsService.java` (L120-L134: buildProxyConfiguration)
- E-08: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsService.java` (L136-L149: buildOverrideConfiguration/buildRetryPolicy)
- E-09: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsService.java` (L151-L154: buildCredentials)
- E-10: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsService.java` (L156-L176: client)
- E-11: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsService.java` (L184-L201: settings)
- E-12: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsService.java` (L208-L225: refreshAndClearCache/releaseCachedClients)
- E-13: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsService.java` (L234-L243: setDefaultAwsProfilePath)
- E-14: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsMasterKeyProvider.java` (L27-L84: 全メソッド)
- E-15: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/CredentialProviderFactory.java` (L25-L67: 全メソッド)
- E-16: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/CryptoKmsPlugin.java` (L26-L87: 全メソッド)
- E-17: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/AmazonKmsClientReference.java` (L19-L24: コンストラクタ)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | loadCredentials: アクセスキーとシークレットキーでAwsBasicCredentials生成 | E-01 (L157-L159) | ○ |
| C-02 | loadCredentials: 3項目でAwsSessionCredentials生成 | E-01 (L160-L162) | ○ |
| C-03 | loadCredentials: キー未設定時にnull返却 | E-01 (L127-L137) | ○ |
| C-04 | loadCredentials: セッショントークンのみでSettingsException | E-01 (L128-L135) | ○ |
| C-05 | loadCredentials: シークレットキーのみでSettingsException | E-01 (L140-L147) | ○ |
| C-06 | loadCredentials: アクセスキーのみでSettingsException | E-01 (L148-L154) | ○ |
| C-07 | getClientSettings: 全設定項目の正しい読み込み | E-02 (L170-L187) | ○ |
| C-08 | getClientSettings: デフォルト値での生成 | E-02, E-05 | ○ |
| C-09 | getMetadataSettings: 設定オーバーライド | E-03 (L189-L226) | ○ |
| C-10 | getMetadataSettings: 空設定での既存値保持 | E-03 (L228-L233) | ○ |
| C-11 | getMetadataSettings: 認証情報のオーバーライド | E-03 (L190-L191) | ○ |
| C-12 | equals: 同一設定の等価性 | E-04 (L236-L252) | ○ |
| C-13 | equals: 異なる設定の非等価性 | E-04 (L236-L252) | ○ |
| C-14 | equals: null比較 | E-04 (L240-L242) | ○ |
| C-15 | hashCode: 同一設定の一貫性 | E-04 (L255-L257) | ○ |
| C-16 | createMasterKeyProvider: 正常生成 | E-06 (L245-L272) | ○ |
| C-17 | createMasterKeyProvider: key_arn未設定でIllegalArgumentException | E-06 (L248-L250) | ○ |
| C-18 | createMasterKeyProvider: encryption_contextのパース | E-06 (L252-L264) | ○ |
| C-19 | createMasterKeyProvider: 不正形式でIllegalArgumentException | E-06 (L259-L261) | ○ |
| C-20 | createMasterKeyProvider: 空encryption_contextで空Map | E-06 (L263) | ○ |
| C-21 | buildProxyConfiguration: プロキシ設定の構築 | E-07 (L121-L128) | ○ |
| C-22 | buildProxyConfiguration: プロキシ未設定時のデフォルト | E-07 (L131-L133) | ○ |
| C-23 | buildProxyConfiguration: 不正プロキシホスト名でSdkException | E-07 (L128-L130) | △ |
| C-24 | buildRetryPolicy: リトライ回数10 | E-08 (L147-L148) | ○ |
| C-25 | buildOverrideConfiguration: リトライポリシー含有 | E-08 (L137) | ○ |
| C-26 | buildCredentials: 静的認証情報でStaticCredentialsProvider | E-09, E-15 | ○ |
| C-27 | buildCredentials: null認証情報でInstanceProfile | E-09, E-15 | ○ |
| C-28 | client: 初回呼び出しでの生成とキャッシュ | E-10 (L156-L176) | ○ |
| C-29 | client: 2回目でキャッシュ取得 | E-10 (L159-L163) | ○ |
| C-30 | settings: 初回呼び出しでの生成とキャッシュ | E-11 (L184-L201) | ○ |
| C-31 | settings: 2回目でキャッシュ取得 | E-11 (L187-L190) | ○ |
| C-32 | refreshAndClearCache: キャッシュクリアと設定更新 | E-12 (L208-L214) | ○ |
| C-33 | close: キャッシュクライアントの解放 | E-12 (L227-L230) | ○ |
| C-34 | generateDataPair: 正常生成 | E-14 (L45-L58) | ○ |
| C-35 | generateDataPair: KMSエラーの伝播 | E-14 (L47-L57) | ○ |
| C-36 | decryptKey: 正常復号 | E-14 (L61-L69) | ○ |
| C-37 | decryptKey: 復号エラーの伝播 | E-14 (L62-L69) | ○ |
| C-38 | getKeyId: keyArn返却 | E-14 (L73-L75) | ○ |
| C-39 | getEncryptionContext: コンテキスト返却 | E-14 (L78-L80) | ○ |
| C-40 | close: 空実装の確認 | E-14 (L83) | ○ |
| C-41 | createAwsCredentialsProvider: 静的認証情報 | E-15 (L58-L62) | ○ |
| C-42 | createAwsCredentialsProvider: nullでInstanceProfile | E-15 (L63-L66) | ○ |
| C-43 | type: 'aws-kms'返却 | E-16 (L27, L54-L56) | ○ |
| C-44 | getSettings: 12個のSetting項目 | E-16 (L59-L74) | ○ |
| C-45 | createKeyProvider: MasterKeyProvider生成 | E-16 (L49-L51) | ○ |
| C-46 | reload: 設定更新 | E-16 (L77-L81) | ○ |
| C-47 | close: KmsServiceクローズ | E-16 (L84-L86) | ○ |
| C-48 | AmazonKmsClientReference: コンストラクタ | E-17 (L21-L23) | ○ |
| C-49 | AmazonKmsClientReference: 参照カウント0でclose | E-17 (L22) | ○ |
| C-50 | getMetadataSettings: 部分的オーバーライド | E-03 (L195-L199) | ○ |
| C-51 | getClientSettings: endpoint小文字変換 | E-05 (L49) | ○ |
| C-52 | getClientSettings: region小文字変換 | E-05 (L52) | ○ |
| C-53 | createMasterKeyProvider: encryption_contextのトリム | E-06 (L258) | ○ |
| C-54 | createMasterKeyProvider: 単一エントリのパース | E-06 (L256-L258) | ○ |
| C-55 | setDefaultAwsProfilePath: 未設定時のパス設定 | E-13 (L235-L238) | △ |
| C-56 | setDefaultAwsProfilePath: 既存設定の保護 | E-13 (L235-L242) | ○ |
| C-57 | close: 空キャッシュのclose | E-12 (L216-L225) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-23: URISyntaxExceptionの発生条件について、JavaのURIコンストラクタの仕様に依存する。特定の不正文字列パターンで必ずURISyntaxExceptionが発生するかは、URI実装の仕様確認が必要
  - 候補：Java URI仕様書 / AWS SDK ProxyConfiguration仕様
- C-55: setDefaultAwsProfilePathはstaticメソッドでシステムプロパティを操作するため、テスト環境でのセキュリティマネージャ設定や他テストとの競合に注意が必要
  - 候補：OpenSearchテストフレームワークのセキュリティ設定 / テスト用システムプロパティ管理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - equals/hashCode、getKeyId、getEncryptionContext、close等のシンプルなメソッドのテストケース
- 1: 中リスク - プロキシ設定、キャッシュ動作、設定オーバーライドのテストケース。モック設定の複雑さに注意
- 2: 高リスク - loadCredentialsの認証情報バリデーション、createMasterKeyProviderのencryption_contextパース。セキュリティに直結する処理のため、テストケースの網羅性を重点確認すべき

## 6) レビュアーチェックリスト（最小）
- [ ] loadCredentialsの全分岐（正常系3パターン、異常系3パターン）が網羅されているか
- [ ] createMasterKeyProviderのencryption_contextパース処理の境界値テストが十分か
- [ ] KMSクライアントのモック方式（AmazonKmsClientReference経由）が既存テストと整合しているか
- [ ] キャッシュの並行アクセスに関するテストケースの追加が必要か検討
- [ ] setDefaultAwsProfilePathのテストがテスト環境のセキュリティ制約下で実行可能か確認
- [ ] C-23（不正プロキシURL）のテストが実際にURISyntaxExceptionを再現できる入力値か確認
